/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
#define DATASIZE 256

uint8_t master_rxbuff[256] = {0};
uint8_t master_txbuff[256] = {
    0x03, 0x13, 0x06, 0x06, 0x08, 0x08, 0x04, 0x04,
    0x06, 0x06, 0x0C, 0x0C, 0x05, 0x05, 0x03, 0x03,
    0x07, 0x07, 0x0B, 0x0B, 0x0F, 0x0F, 0xFE, 0xFE,
    0xF0, 0xF0, 0xF7, 0xF7, 0xF9, 0xF9, 0xF8, 0xF8,
    0xF3, 0xF3, 0xE5, 0xE5, 0xE4, 0xE4, 0xE3, 0xE3,
    0xE5, 0xE5, 0xE5, 0xE5, 0xE7, 0xE7, 0xE5, 0xE5,
    0xE3, 0xE3, 0xE7, 0xE7, 0xF0, 0xF0, 0xF4, 0xF4,
    0xF8, 0xF8, 0xF3, 0xF3, 0xF2, 0xF2, 0x26, 0x26,
    0x1C, 0x1C, 0x21, 0x21, 0x56, 0x56, 0x4D, 0x4D,
    0x58, 0x58, 0x5B, 0x5B, 0x45, 0x45, 0x53, 0x53,
    0x23, 0x23, 0xFB, 0xFB, 0x0E, 0x0E, 0xFA, 0xFA,
    0xF8, 0xF8, 0xEF, 0xEF, 0xE3, 0xE3, 0x18, 0x18,
    0x15, 0x15, 0x13, 0x13, 0x54, 0x54, 0x7C, 0x7C,
    0x82, 0x82, 0x88, 0x88, 0x7A, 0x7A, 0x87, 0x87,
    0x7B, 0x7B, 0x5A, 0x5A, 0x44, 0x44, 0x38, 0x38,
    0x21, 0x21, 0x1B, 0x1B, 0xC8, 0xC8, 0x3C, 0x3C,
    0xFE, 0xFE, 0xEB, 0xEB, 0xAD, 0xAD, 0x3E, 0x3E,
    0x15, 0x15, 0xDC, 0xDC, 0xAE, 0xAE, 0x73, 0x73,
    0x93, 0x93, 0xAE, 0xAE, 0xEB, 0xEB, 0x01, 0x01,
    0xF8, 0xF8, 0xF3, 0xF3, 0xF2, 0xF2, 0x26, 0x26,
    0x1C, 0x1C, 0x21, 0x21, 0x56, 0x56, 0x4D, 0x4D,
    0x58, 0x58, 0x5B, 0x5B, 0x45, 0x45, 0x53, 0x53,
    0x23, 0x23, 0xFB, 0xFB, 0x0E, 0x0E, 0xFA, 0xFA,
    0xF8, 0xF8, 0xEF, 0xEF, 0xE3, 0xE3, 0x18, 0x18,
    0x15, 0x15, 0x13, 0x13, 0x54, 0x54, 0x7C, 0x7C,
    0x82, 0x82, 0x88, 0x88, 0x7A, 0x7A, 0x87, 0x87,
    0x7B, 0x7B, 0x5A, 0x5A, 0x44, 0x44, 0x38, 0x38,
    0x21, 0x21, 0x1B, 0x1B, 0xC8, 0xC8, 0x3C, 0x3C,
    0xFE, 0xFE, 0xEB, 0xEB, 0xAD, 0xAD, 0x3E, 0x3E,
    0x15, 0x15, 0xDC, 0xDC, 0xAE, 0xAE, 0x73, 0x73,
    0x93, 0x93, 0xAE, 0xAE, 0xEB, 0xEB, 0x01, 0x01,
    0x58, 0x58, 0x5B, 0x5B, 0x45, 0x45, 0x53, 0x53
};
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_spi1_init();

    /* user code [local 2] begin */

    /* user code [local 2] end */

    while(1){
    /* user code [local 3] begin */
    	hal_spi_receive_poll(&spi1_info, master_rxbuff, DATASIZE, 6000);
    /* user code [local 3] end */
    }
}
/* user code [global 1] begin */

/* user code [global 1] end */	
