/*
    \file  main.c*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    hal_rcu_clk_struct rcu_clk_parameter;
    hal_rcu_osci_struct rcu_osci_parameter;
    hal_rcu_periphclk_struct rcu_periphclk_parameter;

    msd_system_init();
    msd_clock_init();

    /* user code [local 1] begin */
    gd_eval_com_init(EVAL_COM);
    hal_sys_timesource_init(SYS_TIMEBASE_SOURCE_SYSTICK);
    /* user code [local 1] end */
    
    msd_gpio_init();

    /* user code [local 2] begin */

    HAL_DEBUGE("\r\nCK_SYS is %d", hals_rcu_clock_freq_get(CK_SYS));

    hal_sys_basetick_delay_ms(500);

    rcu_osci_parameter.hxtal.need_configure = ENABLE;
    rcu_osci_parameter.hxtal.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.need_configure = ENABLE;
    rcu_osci_parameter.irc8m.state = RCU_OSC_ON;
    rcu_osci_parameter.irc8m.adjust_value = 0;
    rcu_osci_parameter.pll.need_configure = ENABLE;
    rcu_osci_parameter.pll.state = RCU_OSC_ON;
    rcu_osci_parameter.pll.pll_source = RCU_PLL_SRC_IRC8M_DIV2;
    rcu_osci_parameter.pll.pll_mul = RCU_PLL_MULT8;
    if(HAL_ERR_NONE != hal_rcu_osci_config(&rcu_osci_parameter)){
        while(1);
    }
    rcu_clk_parameter.clock_type = RCU_CLKTYPE_SYSCLK | RCU_CLKTYPE_AHBCLK | RCU_CLKTYPE_APB1CLK | RCU_CLKTYPE_APB2CLK | RCU_CLKTYPE_CK48MCLK;
    rcu_clk_parameter.sysclk_source = RCU_SYSCLK_SRC_PLL;
    rcu_clk_parameter.ahbclk_divider = RCU_SYSCLK_AHBDIV1;
    rcu_clk_parameter.apb1clk_divider = RCU_AHBCLK_APB1DIV4;
    rcu_clk_parameter.apb2clk_divider = RCU_AHBCLK_APB2DIV2;
    rcu_clk_parameter.ck48mclk_source = RCU_USB_CK48MSRC_PLL48M;
    if(HAL_ERR_NONE != hal_rcu_clock_config(&rcu_clk_parameter)){
        while(1);
    }

    hal_sys_basetick_delay_ms(500);
    gd_eval_com_init(EVAL_COM);
    HAL_DEBUGE("\r\nCK_SYS is %d", hals_rcu_clock_freq_get(CK_SYS));
    /* user code [local 2] end */

  while(1){
    /* user code [local 3] begin */
    /* user code [local 3] end */

  }
}
/* user code [global 1] begin */

/* user code [global 1] end */
