/*
    \file  main.c
*/
/*
    Copyright (c) 2023, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this 
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice, 
       this list of conditions and the following disclaimer in the documentation 
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors 
       may be used to endorse or promote products derived from this software without 
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY 
OF SUCH DAMAGE.
*/
#include "gd32f3x0_hal.h"
#include "gd32f3x0_hal_init.h"
/* user code [global 0] begin */
#include "gd32f3x0r_hal_eval.h"
uint8_t watchdog_flag;
extern hal_adc_dev_struct adc_info;

void adc_irq_config(void);
void adc_irq_watchdog(void *ptr);
/* user code [global 0] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
    msd_clock_init();
    /* user code [local 1] begin */

    /* user code [local 1] end */
    msd_gpio_init();
    msd_adc_init();

    /* user code [local 2] begin */
    gd_eval_com_init(EVAL_COM);
    /* print message through EVAL_COM */
    printf("\r\n ADC routine channel watchdog demo! \r\n");

    /* configuration adc interrupt */
    adc_irq_config();
    /* start ADC routine channel */
    hal_adc_start(&adc_info);
    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */
        /* basetick delay for 2ms */
        hal_sys_basetick_delay_ms(2);
        if(1 == watchdog_flag) {
            watchdog_flag = 0;
        } else {
            printf("\r\n ADC routine channel watchdog event don't occur! \r\n");
        }

        /* basetick delay for 2000ms */
        hal_sys_basetick_delay_ms(2000);
        /* enable ADC routine sequence software trigger */
        hal_adc_routine_software_trigger_enable(&adc_info);
        /* user code [local 3] end */
    }
}
/* user code [global 1] begin */
/*!
\brief      configuration adc interrupt
\param[in]  none
\param[out] none
\retval     none
*/
void adc_irq_config(void)
{
    hal_adc_irq_struct adc_irq_parameter;
    hal_adc_struct_init(HAL_ADC_IRQ_STRUCT, &adc_irq_parameter);

    adc_irq_parameter.adc_watchdog_handle = adc_irq_watchdog;
    hal_adc_watchdog_interrupt_enable(&adc_info, &adc_irq_parameter);
}

/*!
\brief      adc watchdog interrupt
\param[in]  ptr
\param[out] none
\retval     none
*/
void adc_irq_watchdog(void *ptr)
{
    watchdog_flag = 1;
    printf("\r\n ADC routine channel watchdog event occurs! \r\n");
}
/* user code [global 1] end */	
