[#ftl]
[#if Peripherals?contains("ENET1") == true]
hal_enet_init_struct enet1_init_parameter;

[#if ENET1_Mode == "MII Full Duplex" || ENET1_Mode == "MII Half Duplex"]
hal_syscfg_enet_phy_interface_config(ENET1, SYSCFG_ENET_PHY_MII);
[#elseif ENET1_Mode == "RMII"]
hal_syscfg_enet_phy_interface_config(ENET1, SYSCFG_ENET_PHY_RMII);
[/#if]

hal_enet_struct_init(HAL_ENET_INIT_STRUCT, &enet1_init_parameter);
hal_enet_struct_init(HAL_ENET_DEV_STRUCT, &enet1_info);

[#if ENET1_AdvanceConfiguration_AutoNegotiation == "Disable"]
	[#if ENET1_AdvanceConfiguration_DuplexMode == "Full Duplex" && ENET1_AdvanceConfiguration_Speed == "10 Mbit/s"]
	enet1_init_parameter.phy_mode = ENET_10M_FULLDUPLEX;
	[#elseif ENET1_AdvanceConfiguration_DuplexMode == "Full Duplex" && ENET1_AdvanceConfiguration_Speed == "100 Mbit/s"]
	enet1_init_parameter.phy_mode = ENET_100M_FULLDUPLEX;
	[#elseif ENET1_AdvanceConfiguration_DuplexMode == "Half Duplex" && ENET1_AdvanceConfiguration_Speed == "10 Mbit/s"]
	enet1_init_parameter.phy_mode = ENET_10M_HALFDUPLEX;
	[#elseif ENET1_AdvanceConfiguration_DuplexMode == "Half Duplex" && ENET1_AdvanceConfiguration_Speed == "100 Mbit/s"]
	enet1_init_parameter.phy_mode = ENET_100M_HALFDUPLEX;
	[/#if]
[#elseif ENET1_AdvanceConfiguration_AutoNegotiation == "Enable"]
enet1_init_parameter.phy_mode = ENET_AUTO_NEGOTIATION;
[/#if]
[#if ENET1_GeneralConfiguration_DescriptorPattern == "Normal Descriptor Pattern"]
enet1_init_parameter.descriptor_pattern = ENET_NORMAL_DESCRIPTOR;
[#else]
enet1_init_parameter.descriptor_pattern = ENET_ENHANCED_DESCRIPTOR;
[/#if]
[#if ENET1_GeneralConfiguration_FrameReceived  == "Drop Broadcast Frame"]
enet1_init_parameter.frame_received = ENET_BROADCAST_FRAMES_DROP;
[#elseif ENET1_GeneralConfiguration_FrameReceived == "Receive All Frame"]
enet1_init_parameter.frame_received = ENET_RECEIVEALL;
[#elseif ENET1_GeneralConfiguration_FrameReceived ==  "Promiscuous Mode"]
enet1_init_parameter.frame_received = ENET_PROMISCUOUS_MODE;
[#elseif ENET1_GeneralConfiguration_FrameReceived == "Receive Broadcast Frame"]
enet1_init_parameter.frame_received = ENET_BROADCAST_FRAMES_PASS;
[/#if]
hal_enet_init(&enet1_info,ENET1,&enet1_init_parameter);
[/#if]
