[#ftl]
[#if Peripherals?contains("ENET0") == true]
hal_enet_init_struct enet0_init_parameter;

[#if ENET0_Mode == "MII Full Duplex" || ENET0_Mode == "MII Half Duplex"]
hal_syscfg_enet_phy_interface_config(ENET0, SYSCFG_ENET_PHY_MII);
[#elseif ENET0_Mode == "RMII"]
hal_syscfg_enet_phy_interface_config(ENET0, SYSCFG_ENET_PHY_RMII);
[/#if]

hal_enet_struct_init(HAL_ENET_INIT_STRUCT, &enet0_init_parameter);
hal_enet_struct_init(HAL_ENET_DEV_STRUCT, &enet0_info);

[#if ENET0_AdvanceConfiguration_AutoNegotiation == "Disable"]
	[#if ENET0_AdvanceConfiguration_DuplexMode == "Full Duplex" && ENET0_AdvanceConfiguration_Speed == "10 Mbit/s"]
	enet0_init_parameter.phy_mode = ENET_10M_FULLDUPLEX;
	[#elseif ENET0_AdvanceConfiguration_DuplexMode == "Full Duplex" && ENET0_AdvanceConfiguration_Speed == "100 Mbit/s"]
	enet0_init_parameter.phy_mode = ENET_100M_FULLDUPLEX;
	[#elseif ENET0_AdvanceConfiguration_DuplexMode == "Half Duplex" && ENET0_AdvanceConfiguration_Speed == "10 Mbit/s"]
	enet0_init_parameter.phy_mode = ENET_10M_HALFDUPLEX;
	[#elseif ENET0_AdvanceConfiguration_DuplexMode == "Half Duplex" && ENET0_AdvanceConfiguration_Speed == "100 Mbit/s"]
	enet0_init_parameter.phy_mode = ENET_100M_HALFDUPLEX;
	[/#if]
[#elseif ENET0_AdvanceConfiguration_AutoNegotiation == "Enable"]
enet0_init_parameter.phy_mode = ENET_AUTO_NEGOTIATION;
[/#if]
[#if ENET0_GeneralConfiguration_DescriptorPattern == "Normal Descriptor Pattern"]
enet0_init_parameter.descriptor_pattern = ENET_NORMAL_DESCRIPTOR;
[#else]
enet0_init_parameter.descriptor_pattern = ENET_ENHANCED_DESCRIPTOR;
[/#if]
[#if ENET0_GeneralConfiguration_FrameReceived  == "Drop Broadcast Frame"]
enet0_init_parameter.frame_received = ENET_BROADCAST_FRAMES_DROP;
[#elseif ENET0_GeneralConfiguration_FrameReceived == "Receive All Frame"]
enet0_init_parameter.frame_received = ENET_RECEIVEALL;
[#elseif ENET0_GeneralConfiguration_FrameReceived ==  "Promiscuous Mode"]
enet0_init_parameter.frame_received = ENET_PROMISCUOUS_MODE;
[#elseif ENET0_GeneralConfiguration_FrameReceived == "Receive Broadcast Frame"]
enet0_init_parameter.frame_received = ENET_BROADCAST_FRAMES_PASS;
[/#if]
hal_enet_init(&enet0_info,ENET0,&enet0_init_parameter);
[/#if]

