[#ftl]
[#-- V1.2.0 --]
/*!
    \file    gd32h7xx_libopt.h
    \brief   HAL library optional for GD32H7xx

    \version 2025-09-30, V1.0.0, HAL firmware for GD32H7xx
*/

/*
    Copyright (c) 2024, GigaDevice Semiconductor Inc.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#ifndef GD32H7XX_LIBOPT_H
#define GD32H7XX_LIBOPT_H

/* if set, flash operation (write and eraser) will reserve original data located
   in out of targeted scope */
#define FLASH_OPER_RESERVE_ORIGINAL_DATA        (0U)
/* if set, the parameters check will be implemented in function */
#define HAL_PARAMETER_CHECK                     (0U)
/* if set, print debug message according to level of marco 'HAL_DEBUG_PRINTF_LEVEL'
   and halt code according to level of marco 'HAL_DEBUG_HALT_LEVEL' */
#define HAL_DEBUG                               (0U)

#if (1 == HAL_DEBUG)
#define HAL_DEBUG_PRINTF                        printf
#define HAL_DEBUG_PRINTF_LEVEL                  HAL_DEBUG_LVL_ALL
#define HAL_DEBUG_HALT_LEVEL                    HAL_DEBUG_LVL_NONE

#define HAL_DEBUG_UART                          USART0
#define HAL_DEBUG_EXTRA_DO
#endif /* 1 == HAL_DEBUG */

/* define value of high speed crystal oscillator (HXTAL) in Hz */
[#if HXTAL != ""]
#define HAL_HXTAL_VALUE                         ((uint32_t)${HXTAL})
[#else]
#define HAL_HXTAL_VALUE                         ((uint32_t)25000000)
[/#if]
/*!< HXTAL state change timeout (in ms) */
[#if RCU_ResetAndClockAdjustParameters_HXTALStartupTimeoutValue ??== true]
#define HAL_HXTAL_TIMEOUT                       ((uint32_t)${RCU_ResetAndClockAdjustParameters_HXTALStartupTimeoutValue})
[#else]
#define HAL_HXTAL_TIMEOUT                       ((uint32_t)100)
[/#if]
/* define value of low speed crystal oscillator (LXTAL)in Hz */
[#if LXTAL != ""]
#define HAL_LXTAL_VALUE                         ((uint32_t)${LXTAL})
[#else]
#define HAL_LXTAL_VALUE                         ((uint32_t)32768)
[/#if]
/*!< LXTAL state change timeout (in ms) */
[#if RCU_ResetAndClockAdjustParameters_LXTALStartupTimeoutValue ??== true]
#define HAL_LXTAL_TIMEOUT                       ((uint32_t)${RCU_ResetAndClockAdjustParameters_LXTALStartupTimeoutValue})
[#else]
#define HAL_LXTAL_TIMEOUT                       ((uint32_t)5000)
[/#if]

/* define I2S_CKIN frequency in Hz */
[#if RCU_AudioClockInput ??== true]
[#if RCU_AudioClockInput == "Enable"]
#define I2S_CKIN_VALUE                          ((uint32_t)${I2S_CKIN})
[#else]
#define I2S_CKIN_VALUE                          ((uint32_t)0x00000000)
[/#if]
[/#if]

/* Systick Interrupt Master Priority  */
[#if SYS_TimebaseSource == "Systick"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_SystemTickTimer_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER0"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER0UpdateInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER1"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER1GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER2"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER2GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER3"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER3GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER4"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER4GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER5"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER5GlobalInterruptAndDACUnderrunErrorInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER6"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER6GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER7"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER7UpdateInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER14"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER14GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER15"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER15GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER16"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER16GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER22"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER22GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER23"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER23GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER30"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER30GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER31"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER31GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER40"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER40GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER41"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER41GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER42"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER42GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER43"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER43GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER44"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER44GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER50"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER50GlobalInterrupt_PreemptionPriority}U)
[#elseif SYS_TimebaseSource == "TIMER51"]
#define SYSTICK_IRQ_MASTER_PRIORITY             (${NVIC_TIMER51GlobalInterrupt_PreemptionPriority}U)
[/#if]

[#if gd32h7xx_libopt0 ??== true]
/* define ENET enhance mode */
#define SELECT_DESCRIPTORS_ENHANCED_MODE        (1U)
[/#if]
/*!< ethernet receive buffer size */
[#if ENET0_DescriptorConfiguration_RxBufferSize ??== true || ENET1_DescriptorConfiguration_RxBufferSize ??== true]
[#if ENET0_DescriptorConfiguration_RxBufferSize ??== true && ENET1_DescriptorConfiguration_RxBufferSize ??== true]
#define ENET_RXBUF_SIZE                         (${ENET0_DescriptorConfiguration_RxBufferSize}U)
[#elseif ENET0_DescriptorConfiguration_RxBufferSize ??== true && ENET1_DescriptorConfiguration_RxBufferSize ??== false]
#define ENET_RXBUF_SIZE                         (${ENET0_DescriptorConfiguration_RxBufferSize}U)
[#elseif ENET0_DescriptorConfiguration_RxBufferSize ??== false && ENET1_DescriptorConfiguration_RxBufferSize ??== true]
#define ENET_RXBUF_SIZE                         (${ENET1_DescriptorConfiguration_RxBufferSize}U)
[/#if]
[#else]
#define ENET_RXBUF_SIZE                         1524U
[/#if]
/*!< ethernet transmit buffer size */
[#if ENET0_DescriptorConfiguration_TxBufferSize ??== true || ENET1_DescriptorConfiguration_TxBufferSize ??== true]
[#if ENET0_DescriptorConfiguration_TxBufferSize ??== true && ENET1_DescriptorConfiguration_TxBufferSize ??== true]
#define ENET_TXBUF_SIZE                         (${ENET0_DescriptorConfiguration_TxBufferSize}U)
[#elseif ENET0_DescriptorConfiguration_TxBufferSize ??== true && ENET1_DescriptorConfiguration_TxBufferSize ??== false]
#define ENET_TXBUF_SIZE                         (${ENET0_DescriptorConfiguration_TxBufferSize}U)
[#elseif ENET0_DescriptorConfiguration_TxBufferSize ??== false && ENET1_DescriptorConfiguration_TxBufferSize ??== true]
#define ENET_TXBUF_SIZE                         (${ENET1_DescriptorConfiguration_TxBufferSize}U)
[/#if]
[#else]
#define ENET_TXBUF_SIZE                         (1524U)
[/#if]

[#if gd32h7xx_libopt1 ??== true]
#define USE_USBHS0_DEVICE
[/#if]
[#if gd32h7xx_libopt2 ??== true]
#define USE_USBHS1_DEVICE
[/#if]
[#if gd32h7xx_libopt3 ??== true]
#define USE_USBHS0_HOST_MSC
[/#if]
[#if gd32h7xx_libopt4 ??== true]
#define USE_USBHS1_HOST_MSC
[/#if]
[#if gd32h7xx_libopt5 ??== true]
#define USE_USBHS0_HOST_HID
[/#if]
[#if gd32h7xx_libopt6 ??== true]
#define USE_USBHS1_HOST_HID
[/#if]
[#if gd32h7xx_libopt9 ??== true]
#define HS0_DEFINITION_COMPLETE
[/#if]

#include "gd32h7xx_hal_sys.h"
#include "gd32h7xx_hal_syscfg.h"
#include "gd32h7xx_hal_dma.h"
#include "gd32h7xx_hal_nvic.h"
#include "gd32h7xx_hal_rcu.h"
#include "gd32h7xx_hal_exti.h"
#include "gd32h7xx_hal_adc.h"
#include "gd32h7xx_hal_can.h"
#include "gd32h7xx_hal_cau.h"
#include "gd32h7xx_hal_cmp.h"
#include "gd32h7xx_hal_cpdm.h"
#include "gd32h7xx_hal_crc.h"
#include "gd32h7xx_hal_ctc.h"
#include "gd32h7xx_hal_dac.h"
#include "gd32h7xx_hal_dci.h"
#include "gd32h7xx_hal_edout.h"
#include "gd32h7xx_hal_efuse.h"
#include "gd32h7xx_hal_enet.h"
#include "gd32h7xx_hal_exmc_com.h"
#include "gd32h7xx_hal_exmc_nor.h"
#include "gd32h7xx_hal_exmc_sram.h"
#include "gd32h7xx_hal_exmc_nand.h"
#include "gd32h7xx_hal_exmc_sdram.h"
#include "gd32h7xx_hal_fac.h"
#include "gd32h7xx_hal_fmc.h"
#include "gd32h7xx_hal_fwdgt.h"
#include "gd32h7xx_hal_gpio.h"
#include "gd32h7xx_hal_trng.h"
#include "gd32h7xx_hal_hau.h"
#include "gd32h7xx_hal_hpdf.h"
#include "gd32h7xx_hal_hwsem.h"
#include "gd32h7xx_hal_i2c_com.h"
#include "gd32h7xx_hal_i2c.h"
#include "gd32h7xx_hal_spi.h"
#include "gd32h7xx_hal_i2s.h"
#include "gd32h7xx_hal_ipa.h"
#include "gd32h7xx_hal_irda.h"
#include "gd32h7xx_hal_lpdts.h"
#include "gd32h7xx_hal_mdio.h"
#include "gd32h7xx_hal_mdma.h"
#include "gd32h7xx_hal_ospi.h"
#include "gd32h7xx_hal_ospim.h"
#include "gd32h7xx_hal_pmu.h"
#include "gd32h7xx_hal_rameccmu.h"
#include "gd32h7xx_hal_rspdif.h"
#include "gd32h7xx_hal_rtc.h"
#include "gd32h7xx_hal_rtdec.h"
#include "gd32h7xx_hal_sai.h"
#include "gd32h7xx_hal_sdio_com.h"
#include "gd32h7xx_hal_sdio_sdcard.h"
#include "gd32h7xx_hal_sdio_emmc.h"
#include "gd32h7xx_hal_smartcard.h"
#include "gd32h7xx_hal_smbus.h"
#include "gd32h7xx_hal_tli.h"
#include "gd32h7xx_hal_timer.h"
#include "gd32h7xx_hal_tmu.h"
#include "gd32h7xx_hal_trigsel.h"
#include "gd32h7xx_hal_uart.h"
#include "gd32h7xx_hal_usart_com.h"
#include "gd32h7xx_hal_usrt.h"
#include "gd32h7xx_hal_vref.h"
#include "gd32h7xx_hal_wwdgt.h"
[#if gd32h7xx_libopt1 ??== true]
#include "hs0_usbd_conf.h"
[/#if]
[#if gd32h7xx_libopt2 ??== true]
#include "hs1_usbd_conf.h"
[/#if]
[#if gd32h7xx_libopt7 ??== true]
#include "hs0_usbh_conf.h"
[/#if]
[#if gd32h7xx_libopt8 ??== true]
#include "hs1_usbh_conf.h"
[/#if]

#endif /* GD32H7XX_LIBOPT_H */
