[#ftl]
[#-- V1.0.9 --]
/*
    \file  gd32g5x3_it.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32g5x3_it.h"
#include "gd32g5x3.h"
#include "gd32g5x3_init.h"

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define SRAM_ECC_ERROR_HANDLE(s) \
    do {                         \
    } while(1)
#define FLASH_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

[#if NVIC_NonMaskableInterrupt ??== true && NVIC_NonMaskableInterrupt_Enabled == "TRUE"]
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */

    if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_TCMSRAMECCME)) {
        SRAM_ECC_ERROR_HANDLE("TCMSRAM multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_SRAM1ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM1 multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_SRAM0ECCME)) {
        SRAM_ECC_ERROR_HANDLE("SRAM0 multi-bits non-correction ECC error\r\n");
    } else if(SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_FLASHECC)) {
        FLASH_ECC_ERROR_HANDLE("FLASH ECC error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error or NMI pin error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

[/#if]
[#if NVIC_HardfaultInterrupt ??== true && NVIC_HardfaultInterrupt_Enabled == "TRUE"]
/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
    while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_MemoryManagementInterrupt ??== true && NVIC_MemoryManagementInterrupt_Enabled == "TRUE"]
/*!
    \brief      Memory Management Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MemManage_Handler(void)
{
    /* user code [MemManage_IRQn local 0] begin */

    /* user code [MemManage_IRQn local 0] end */
    while(1) {
        /* user code [MemManage_IRQn local 1] begin */

        /* user code [MemManage_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_PrefetchFaultMemoryAccessFault ??== true && NVIC_PrefetchFaultMemoryAccessFault_Enabled == "TRUE"]
/*!
    \brief      Pre-fetch Fault,Memory Access Fault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void BusFault_Handler(void)
{
    /* user code [BusFault_IRQn local 0] begin */

    /* user code [BusFault_IRQn local 0] end */
    while(1) {
        /* user code [BusFault_IRQn local 1] begin */

        /* user code [BusFault_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_UndefinedInstructionOrIllegalState ??== true && NVIC_UndefinedInstructionOrIllegalState_Enabled == "TRUE"]
/*!
    \brief      Undefined Instruction Or Illegal State Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none

*/
void UsageFault_Handler(void)
{
    /* user code [UsageFault_IRQn local 0] begin */

    /* user code [UsageFault_IRQn local 0] end */
    while(1) {
        /* user code [UsageFault_IRQn local 1] begin */

        /* user code [UsageFault_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_SystemServiceCallViaSWIInstruction ??== true && NVIC_SystemServiceCallViaSWIInstruction_Enabled == "TRUE"]
/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */
    while(1) {
        /* user code [SVC_IRQn local 1] begin */

        /* user code [SVC_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_DebugMonitorInterrupt ??== true && NVIC_DebugMonitorInterrupt_Enabled == "TRUE"]
/*!
    \brief      Debug Monitor Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DebugMon_Handler(void)
{
    /* user code [DebugMon_IRQn local 0] begin */

    /* user code [DebugMon_IRQn local 0] end */
    while(1) {
        /* user code [DebugMon_IRQn local 1] begin */

        /* user code [DebugMon_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_PendableRequestForSystemService ??== true && NVIC_PendableRequestForSystemService_Enabled == "TRUE"]
/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */
    while(1) {
        /* user code [PendSV_IRQn local 1] begin */

        /* user code [PendSV_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_SystemTickTimer ??== true && NVIC_SystemTickTimer_Enabled == "TRUE"]
/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

[/#if]
[#if NVIC_WindowWatchdogInterrupt ??== true && NVIC_WindowWatchdogInterrupt_Enabled == "TRUE"]
/*!
    \brief      WWDGT Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void WWDGT_IRQHandler(void)
{
    /* user code [WWDGT_IRQn local 0] begin */

    /* user code [WWDGT_IRQn local 0] end */

    /* user code [WWDGT_IRQn local 1] begin */

    /* user code [WWDGT_IRQn local 1] end */
}

[/#if]
[#if NVIC_LVDVAVDVOVDVUVDThroughEXTILineDetectionInterrupt ??== true && NVIC_LVDVAVDVOVDVUVDThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      LVD_VAVD_VOVD_VUVD Through Exti Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void LVD_VAVD_VOVD_VUVD_IRQHandler(void)
{
    /* user code [LVD_VAVD_VOVD_VUVD_IRQn local 0] begin */

    /* user code [LVD_VAVD_VOVD_VUVD_IRQn local 0] end */

    /* user code [LVD_VAVD_VOVD_VUVD_IRQn local 1] begin */

    /* user code [LVD_VAVD_VOVD_VUVD_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCTamperAndTimestampFromEXTIInterruptLXTALClockStuckInterrupt ??== true && NVIC_RTCTamperAndTimestampFromEXTIInterruptLXTALClockStuckInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Tamper And Timestamp From EXTI Interrupt,LXTAL Clock Stuck Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TAMPER_IRQHandler(void)
{
    /* user code [TAMPER_IRQn local 0] begin */

    /* user code [TAMPER_IRQn local 0] end */

    /* user code [TAMPER_IRQn local 1] begin */

    /* user code [TAMPER_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCWakeupFromEXTIInterrupt ??== true && NVIC_RTCWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_WKUP_IRQHandler(void)
{
    /* user code [RTC_WKUP_IRQn local 0] begin */

    /* user code [RTC_WKUP_IRQn local 0] end */

    /* user code [RTC_WKUP_IRQn local 1] begin */

    /* user code [RTC_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_FMCGlobalInterrupt ??== true && NVIC_FMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FMC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FMC_IRQHandler(void)
{
    /* user code [FMC_IRQn local 0] begin */

    /* user code [FMC_IRQn local 0] end */

    /* user code [FMC_IRQn local 1] begin */

    /* user code [FMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_RCUGlobalInterrupt ??== true && NVIC_RCUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      RCU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RCU_IRQHandler(void)
{
    /* user code [RCU_IRQn local 0] begin */

    /* user code [RCU_IRQn local 0] end */

    /* user code [RCU_IRQn local 1] begin */

    /* user code [RCU_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine0Interrupt ??== true && NVIC_EXTILine0Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI0_IRQHandler(void)
{
    /* user code [EXTI0_IRQn local 0] begin */

    /* user code [EXTI0_IRQn local 0] end */

    /* user code [EXTI0_IRQn local 1] begin */

    /* user code [EXTI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1Interrupt ??== true && NVIC_EXTILine1Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI1_IRQHandler(void)
{
    /* user code [EXTI1_IRQn local 0] begin */

    /* user code [EXTI1_IRQn local 0] end */

    /* user code [EXTI1_IRQn local 1] begin */

    /* user code [EXTI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine2Interrupt ??== true && NVIC_EXTILine2Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI2_IRQHandler(void)
{
    /* user code [EXTI2_IRQn local 0] begin */

    /* user code [EXTI2_IRQn local 0] end */

    /* user code [EXTI2_IRQn local 1] begin */

    /* user code [EXTI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine3Interrupt ??== true && NVIC_EXTILine3Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI3_IRQHandler(void)
{
    /* user code [EXTI3_IRQn local 0] begin */

    /* user code [EXTI3_IRQn local 0] end */

    /* user code [EXTI3_IRQn local 1] begin */

    /* user code [EXTI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine4Interrupt ??== true && NVIC_EXTILine4Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI4_IRQHandler(void)
{
    /* user code [EXTI4_IRQn local 0] begin */

    /* user code [EXTI4_IRQn local 0] end */

    /* user code [EXTI4_IRQn local 1] begin */

    /* user code [EXTI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel0GlobalInterrupt ??== true && NVIC_DMA0Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel0_IRQHandler(void)
{
    /* user code [DMA0_Channel0_IRQn local 0] begin */

    /* user code [DMA0_Channel0_IRQn local 0] end */

    /* user code [DMA0_Channel0_IRQn local 1] begin */

    /* user code [DMA0_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel1GlobalInterrupt ??== true && NVIC_DMA0Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel1_IRQHandler(void)
{
    /* user code [DMA0_Channel1_IRQn local 0] begin */

    /* user code [DMA0_Channel1_IRQn local 0] end */

    /* user code [DMA0_Channel1_IRQn local 1] begin */

    /* user code [DMA0_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel2GlobalInterrupt ??== true && NVIC_DMA0Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel2_IRQHandler(void)
{
    /* user code [DMA0_Channel2_IRQn local 0] begin */

    /* user code [DMA0_Channel2_IRQn local 0] end */

    /* user code [DMA0_Channel2_IRQn local 1] begin */

    /* user code [DMA0_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel3GlobalInterrupt ??== true && NVIC_DMA0Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel3_IRQHandler(void)
{
    /* user code [DMA0_Channel3_IRQn local 0] begin */

    /* user code [DMA0_Channel3_IRQn local 0] end */

    /* user code [DMA0_Channel3_IRQn local 1] begin */

    /* user code [DMA0_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel4GlobalInterrupt ??== true && NVIC_DMA0Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel4_IRQHandler(void)
{
    /* user code [DMA0_Channel4_IRQn local 0] begin */

    /* user code [DMA0_Channel4_IRQn local 0] end */

    /* user code [DMA0_Channel4_IRQn local 1] begin */

    /* user code [DMA0_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel5GlobalInterrupt ??== true && NVIC_DMA0Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel5_IRQHandler(void)
{
    /* user code [DMA0_Channel5_IRQn local 0] begin */

    /* user code [DMA0_Channel5_IRQn local 0] end */

    /* user code [DMA0_Channel5_IRQn local 1] begin */

    /* user code [DMA0_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel6GlobalInterrupt ??== true && NVIC_DMA0Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel6_IRQHandler(void)
{
    /* user code [DMA0_Channel6_IRQn local 0] begin */

    /* user code [DMA0_Channel6_IRQn local 0] end */

    /* user code [DMA0_Channel6_IRQn local 1] begin */

    /* user code [DMA0_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADC0AndADC1GlobalInterrupt ??== true && NVIC_ADC0AndADC1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC0 And ADC1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC0_1_IRQHandler(void)
{
    /* user code [ADC0_1_IRQn local 0] begin */

    /* user code [ADC0_1_IRQn local 0] end */

    /* user code [ADC0_1_IRQn local 1] begin */

    /* user code [ADC0_1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine59Interrupt ??== true && NVIC_EXTILine59Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI5_9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI5_9_IRQHandler(void)
{
    /* user code [EXTI5_9_IRQn local 0] begin */

    /* user code [EXTI5_9_IRQn local 0] end */

    /* user code [EXTI5_9_IRQn local 1] begin */

    /* user code [EXTI5_9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0BreakInterrupt ??== true && NVIC_TIMER0BreakInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Break Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_BRK_IRQHandler(void)
{
    /* user code [TIMER0_BRK_IRQn local 0] begin */

    /* user code [TIMER0_BRK_IRQn local 0] end */

    /* user code [TIMER0_BRK_IRQn local 1] begin */

    /* user code [TIMER0_BRK_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0UpdateInterrupt ??== true && NVIC_TIMER0UpdateInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Update Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_UP_IRQHandler(void)
{
    /* user code [TIMER0_UP_IRQn local 0] begin */

    /* user code [TIMER0_UP_IRQn local 0] end */

    /* user code [TIMER0_UP_IRQn local 1] begin */

    /* user code [TIMER0_UP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0TriggerCommutationDirectionChangeIndexInterrupt ??== true && NVIC_TIMER0TriggerCommutationDirectionChangeIndexInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Trigger,Commutation,Direction Change,Index Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_TRG_CMT_IDX_IRQHandler(void)
{
    /* user code [TIMER0_TRG_CMT_IDX_IRQn local 0] begin */

    /* user code [TIMER0_TRG_CMT_IDX_IRQn local 0] end */

    /* user code [TIMER0_TRG_CMT_IDX_IRQn local 1] begin */

    /* user code [TIMER0_TRG_CMT_IDX_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER0ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_Channel_IRQHandler(void)
{
    /* user code [TIMER0_Channel_IRQn local 0] begin */

    /* user code [TIMER0_Channel_IRQn local 0] end */

    /* user code [TIMER0_Channel_IRQn local 1] begin */

    /* user code [TIMER0_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER1GlobalInterrupt ??== true && NVIC_TIMER1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER1_IRQHandler(void)
{
    /* user code [TIMER1_IRQn local 0] begin */

    /* user code [TIMER1_IRQn local 0] end */

    /* user code [TIMER1_IRQn local 1] begin */

    /* user code [TIMER1_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2GlobalInterrupt ??== true && NVIC_TIMER2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_IRQHandler(void)
{
    /* user code [TIMER2_IRQn local 0] begin */

    /* user code [TIMER2_IRQn local 0] end */

    /* user code [TIMER2_IRQn local 1] begin */

    /* user code [TIMER2_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER3GlobalInterrupt ??== true && NVIC_TIMER3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_IRQHandler(void)
{
    /* user code [TIMER3_IRQn local 0] begin */

    /* user code [TIMER3_IRQn local 0] end */

    /* user code [TIMER3_IRQn local 1] begin */

    /* user code [TIMER3_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0EventAndWakeupFromEXTIInterrupt ??== true && NVIC_I2C0EventAndWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Event And Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_EV_WKUP_IRQHandler(void)
{
    /* user code [I2C0_EV_WKUP_IRQn local 0] begin */

    /* user code [I2C0_EV_WKUP_IRQn local 0] end */

    /* user code [I2C0_EV_WKUP_IRQn local 1] begin */

    /* user code [I2C0_EV_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0ErrorInterrupt ??== true && NVIC_I2C0ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_ER_IRQHandler(void)
{
    /* user code [I2C0_ER_IRQn local 0] begin */

    /* user code [I2C0_ER_IRQn local 0] end */

    /* user code [I2C0_ER_IRQn local 1] begin */

    /* user code [I2C0_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1EventAndWakeupFromEXTIInterrupt ??== true && NVIC_I2C1EventAndWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Event And Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_EV_WKUP_IRQHandler(void)
{
    /* user code [I2C1_EV_WKUP_IRQn local 0] begin */

    /* user code [I2C1_EV_WKUP_IRQn local 0] end */

    /* user code [I2C1_EV_WKUP_IRQn local 1] begin */

    /* user code [I2C1_EV_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1ErrorInterrupt ??== true && NVIC_I2C1ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_ER_IRQHandler(void)
{
    /* user code [I2C1_ER_IRQn local 0] begin */

    /* user code [I2C1_ER_IRQn local 0] end */

    /* user code [I2C1_ER_IRQn local 1] begin */

    /* user code [I2C1_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI0GlobalInterrupt ??== true && NVIC_SPI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI0_IRQHandler(void)
{
    /* user code [SPI0_IRQn local 0] begin */

    /* user code [SPI0_IRQn local 0] end */

    /* user code [SPI0_IRQn local 1] begin */

    /* user code [SPI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI1GlobalInterrupt ??== true && NVIC_SPI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI1_IRQHandler(void)
{
    /* user code [SPI1_IRQn local 0] begin */

    /* user code [SPI1_IRQn local 0] end */

    /* user code [SPI1_IRQn local 1] begin */

    /* user code [SPI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART0GlobalAndWakeupInterruptFromEXTIInterrupt ??== true && NVIC_USART0GlobalAndWakeupInterruptFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART0 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART0_IRQHandler(void)
{
    /* user code [USART0_IRQn local 0] begin */

    /* user code [USART0_IRQn local 0] end */

    /* user code [USART0_IRQn local 1] begin */

    /* user code [USART0_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART1GlobalAndWakeupInterruptFromEXTIInterrupt ??== true && NVIC_USART1GlobalAndWakeupInterruptFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART1 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART1_IRQHandler(void)
{
    /* user code [USART1_IRQn local 0] begin */

    /* user code [USART1_IRQn local 0] end */

    /* user code [USART1_IRQn local 1] begin */

    /* user code [USART1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART2GlobalAndWakeupInterruptFromEXTIInterrupt ??== true && NVIC_USART2GlobalAndWakeupInterruptFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART2 Global And Wakeup Interrupt From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART2_IRQHandler(void)
{
    /* user code [USART2_IRQn local 0] begin */

    /* user code [USART2_IRQn local 0] end */

    /* user code [USART2_IRQn local 1] begin */

    /* user code [USART2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1015Interrupt ??== true && NVIC_EXTILine1015Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI10_15 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI10_15_IRQHandler(void)
{
    /* user code [EXTI10_15_IRQn local 0] begin */

    /* user code [EXTI10_15_IRQn local 0] end */

    /* user code [EXTI10_15_IRQn local 1] begin */

    /* user code [EXTI10_15_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCAlarmFromEXTIInterrupt ??== true && NVIC_RTCAlarmFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Alarm From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_Alarm_IRQHandler(void)
{
    /* user code [RTC_Alarm_IRQn local 0] begin */

    /* user code [RTC_Alarm_IRQn local 0] end */

    /* user code [RTC_Alarm_IRQn local 1] begin */

    /* user code [RTC_Alarm_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7BreakTransitionErrorAndIndexErrorInterrupt  ??== true && NVIC_TIMER7BreakTransitionErrorAndIndexErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Break,Transition Error And Index Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_BRK_TRS_IDX_IRQHandler(void)
{
    /* user code [TIMER7_BRK_TRS_IDX_IRQn local 0] begin */

    /* user code [TIMER7_BRK_TRS_IDX_IRQn local 0] end */

    /* user code [TIMER7_BRK_TRS_IDX_IRQn local 1] begin */

    /* user code [TIMER7_BRK_TRS_IDX_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7UpdateInterrupt ??== true && NVIC_TIMER7UpdateInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Update Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_UP_IRQHandler(void)
{
    /* user code [TIMER7_UP_IRQn local 0] begin */

    /* user code [TIMER7_UP_IRQn local 0] end */

    /* user code [TIMER7_UP_IRQn local 1] begin */

    /* user code [TIMER7_UP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7TriggerCommutationDirectionChangeAndIndexInterrupt ??== true && NVIC_TIMER7TriggerCommutationDirectionChangeAndIndexInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Trigger,Commutation,Direction Change And Index Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_TRG_CMT_IDX_IRQHandler(void)
{
    /* user code [TIMER7_TRG_CMT_IDX_IRQn local 0] begin */

    /* user code [TIMER7_TRG_CMT_IDX_IRQn local 0] end */

    /* user code [TIMER7_TRG_CMT_IDX_IRQn local 1] begin */

    /* user code [TIMER7_TRG_CMT_IDX_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER7ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_Channel_IRQHandler(void)
{
    /* user code [TIMER7_Channel_IRQn local 0] begin */

    /* user code [TIMER7_Channel_IRQn local 0] end */

    /* user code [TIMER7_Channel_IRQn local 1] begin */

    /* user code [TIMER7_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADC2GlobalInterrupt ??== true && NVIC_ADC2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC2_IRQHandler(void)
{
    /* user code [ADC2_IRQn local 0] begin */

    /* user code [ADC2_IRQn local 0] end */

    /* user code [ADC2_IRQn local 1] begin */

    /* user code [ADC2_IRQn local 1] end */
}

[/#if]
[#if NVIC_SYSCFGGlobalInterrupt ??== true && NVIC_SYSCFGGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SYSCFG Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SYSCFG_IRQHandler(void)
{
    /* user code [SYSCFG_IRQn local 0] begin */

    /* user code [SYSCFG_IRQn local 0] end */

    /* user code [SYSCFG_IRQn local 1] begin */

    /* user code [SYSCFG_IRQn local 1] end */
}

[/#if]
[#if NVIC_LPTIMERGlobalAndWakeupInterrupt ??== true && NVIC_LPTIMERGlobalAndWakeupInterrupt_Enabled == "TRUE"]
/*!
    \brief      LPTIMER Global And Wakeup Interrupt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void LPTIMER_IRQHandler(void)
{
    /* user code [LPTIMER_IRQn local 0] begin */

    /* user code [LPTIMER_IRQn local 0] end */

    /* user code [LPTIMER_IRQn local 1] begin */

    /* user code [LPTIMER_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER4GlobalInterrupt ??== true && NVIC_TIMER4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER4_IRQHandler(void)
{
    /* user code [TIMER4_IRQn local 0] begin */

    /* user code [TIMER4_IRQn local 0] end */

    /* user code [TIMER4_IRQn local 1] begin */

    /* user code [TIMER4_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI2GlobalInterrupt ??== true && NVIC_SPI2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI2_IRQHandler(void)
{
    /* user code [SPI2_IRQn local 0] begin */

    /* user code [SPI2_IRQn local 0] end */

    /* user code [SPI2_IRQn local 1] begin */

    /* user code [SPI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART3GlobalInterrupt ??== true && NVIC_UART3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART3_IRQHandler(void)
{
    /* user code [UART3_IRQn local 0] begin */

    /* user code [UART3_IRQn local 0] end */

    /* user code [UART3_IRQn local 1] begin */

    /* user code [UART3_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART4GlobalInterrupt ??== true && NVIC_UART4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART4_IRQHandler(void)
{
    /* user code [UART4_IRQn local 0] begin */

    /* user code [UART4_IRQn local 0] end */

    /* user code [UART4_IRQn local 1] begin */

    /* user code [UART4_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER5GlobalInterruptAndDAC02UnderrunErrorInterrupt ??== true && NVIC_TIMER5GlobalInterruptAndDAC02UnderrunErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER5 Global Interrupt And DAC0/2 Underrun Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER5_DAC0_2_UDR_IRQHandler(void)
{
    /* user code [TIMER5_DAC0_2_UDR_IRQn local 0] begin */

    /* user code [TIMER5_DAC0_2_UDR_IRQn local 0] end */

    /* user code [TIMER5_DAC0_2_UDR_IRQn local 1] begin */

    /* user code [TIMER5_DAC0_2_UDR_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER6GlobalInterruptAndDAC13UnderrunErrorInterrupt ??== true && NVIC_TIMER6GlobalInterruptAndDAC13UnderrunErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER6 Global Interrupt And DAC1/3 Underrun Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER6_DAC1_3_UDR_IRQHandler(void)
{
    /* user code [TIMER6_DAC1_3_UDR_IRQn local 0] begin */

    /* user code [TIMER6_DAC1_3_UDR_IRQn local 0] end */

    /* user code [TIMER6_DAC1_3_UDR_IRQn local 1] begin */

    /* user code [TIMER6_DAC1_3_UDR_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel0GlobalInterrupt ??== true && NVIC_DMA1Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel0_IRQHandler(void)
{
    /* user code [DMA1_Channel0_IRQn local 0] begin */

    /* user code [DMA1_Channel0_IRQn local 0] end */

    /* user code [DMA1_Channel0_IRQn local 1] begin */

    /* user code [DMA1_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel1GlobalInterrupt ??== true && NVIC_DMA1Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel1_IRQHandler(void)
{
    /* user code [DMA1_Channel1_IRQn local 0] begin */

    /* user code [DMA1_Channel1_IRQn local 0] end */

    /* user code [DMA1_Channel1_IRQn local 1] begin */

    /* user code [DMA1_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel2GlobalInterrupt ??== true && NVIC_DMA1Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel2_IRQHandler(void)
{
    /* user code [DMA1_Channel2_IRQn local 0] begin */

    /* user code [DMA1_Channel2_IRQn local 0] end */

    /* user code [DMA1_Channel2_IRQn local 1] begin */

    /* user code [DMA1_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel3GlobalInterrupt ??== true && NVIC_DMA1Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel3_IRQHandler(void)
{
    /* user code [DMA1_Channel3_IRQn local 0] begin */

    /* user code [DMA1_Channel3_IRQn local 0] end */

    /* user code [DMA1_Channel3_IRQn local 1] begin */

    /* user code [DMA1_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel4GlobalInterrupt ??== true && NVIC_DMA1Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel4_IRQHandler(void)
{
    /* user code [DMA1_Channel4_IRQn local 0] begin */

    /* user code [DMA1_Channel4_IRQn local 0] end */

    /* user code [DMA1_Channel4_IRQn local 1] begin */

    /* user code [DMA1_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADC3GlobalInterrupt ??== true && NVIC_ADC3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC3_IRQHandler(void)
{
    /* user code [ADC3_IRQn local 0] begin */

    /* user code [ADC3_IRQn local 0] end */

    /* user code [ADC3_IRQn local 1] begin */

    /* user code [ADC3_IRQn local 1] end */
}

[/#if]
[#if NVIC_VUVD1VOVD1Interrupt ??== true && NVIC_VUVD1VOVD1Interrupt_Enabled == "TRUE"]
/*!
    \brief      VUVD1_VOVD1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void VUVD1_VOVD1_IRQHandler (void)
{
    /* user code [VUVD1_VOVD1_IRQn local 0] begin */

    /* user code [VUVD1_VOVD1_IRQn local 0] end */

    /* user code [VUVD1_VOVD1_IRQn local 1] begin */

    /* user code [VUVD1_VOVD1_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMP0123InterruptFromEXTI ??== true && NVIC_CMP0123InterruptFromEXTI_Enabled == "TRUE"]
/*!
    \brief      CMP0_3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP0_3_IRQHandler(void)
{
    /* user code [CMP0_3_IRQn local 0] begin */

    /* user code [CMP0_3_IRQn local 0] end */

    /* user code [CMP0_3_IRQn local 1] begin */

    /* user code [CMP0_3_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMP4567InterruptFromEXTI ??== true && NVIC_CMP4567InterruptFromEXTI_Enabled == "TRUE"]
/*!
    \brief      CMP4_7 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP4_7_IRQHandler(void)
{
    /* user code [CMP4_7_IRQn local 0] begin */

    /* user code [CMP4_7_IRQn local 0] end */

    /* user code [CMP4_7_IRQn local 1] begin */

    /* user code [CMP4_7_IRQn local 1] end */
}

[/#if]
[#if NVIC_CMPGlobalInterrupt ??== true && NVIC_CMPGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      CMP Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CMP_IRQHandler(void)
{
    /* user code [CMP_IRQn local 0] begin */

    /* user code [CMP_IRQn local 0] end */

    /* user code [CMP_IRQn local 1] begin */

    /* user code [CMP_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt0 ??== true && NVIC_HRTIMERInterrupt0_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ0_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ0_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ0_IRQn local 0] end */

    /* user code [HRTIMER_IRQ0_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ0_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt1 ??== true && NVIC_HRTIMERInterrupt1_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ1_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ1_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ1_IRQn local 0] end */

    /* user code [HRTIMER_IRQ1_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ1_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt2 ??== true && NVIC_HRTIMERInterrupt2_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ2_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ2_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ2_IRQn local 0] end */

    /* user code [HRTIMER_IRQ2_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ2_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt3 ??== true && NVIC_HRTIMERInterrupt3_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ3_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ3_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ3_IRQn local 0] end */

    /* user code [HRTIMER_IRQ3_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ3_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt4 ??== true && NVIC_HRTIMERInterrupt4_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ4_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ4_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ4_IRQn local 0] end */

    /* user code [HRTIMER_IRQ4_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ4_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt5 ??== true && NVIC_HRTIMERInterrupt5_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ5_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ5_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ5_IRQn local 0] end */

    /* user code [HRTIMER_IRQ5_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ5_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt6 ??== true && NVIC_HRTIMERInterrupt6_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ6_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ6_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ6_IRQn local 0] end */

    /* user code [HRTIMER_IRQ6_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ6_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt7 ??== true && NVIC_HRTIMERInterrupt7_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt7 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ7_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ7_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ7_IRQn local 0] end */

    /* user code [HRTIMER_IRQ7_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ7_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt8 ??== true && NVIC_HRTIMERInterrupt8_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt8 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ8_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ8_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ8_IRQn local 0] end */

    /* user code [HRTIMER_IRQ8_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ8_IRQn local 1] end */
}

[/#if]
[#if NVIC_HRTIMERInterrupt9 ??== true && NVIC_HRTIMERInterrupt9_Enabled == "TRUE"]
/*!
    \brief      HRTIMER Interrupt9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HRTIMER_IRQ9_IRQHandler(void)
{
    /* user code [HRTIMER_IRQ9_IRQn local 0] begin */

    /* user code [HRTIMER_IRQ9_IRQn local 0] end */

    /* user code [HRTIMER_IRQ9_IRQn local 1] begin */

    /* user code [HRTIMER_IRQ9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER19BreakTransitionErrorAndIndexErrorInterrupt ??== true && NVIC_TIMER19BreakTransitionErrorAndIndexErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER19 Break,Transition Error And Index Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER19_BRK_TRS_IDX_IRQHandler(void)
{
    /* user code [TIMER19_BRK_TRS_IDX_IRQn local 0] begin */

    /* user code [TIMER19_BRK_TRS_IDX_IRQn local 0] end */

    /* user code [TIMER19_BRK_TRS_IDX_IRQn local 1] begin */

    /* user code [TIMER19_BRK_TRS_IDX_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER19UpdateInterrupt ??== true && NVIC_TIMER19UpdateInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER19 Update Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER19_UP_IRQHandler(void)
{
    /* user code [TIMER19_UP_IRQn local 0] begin */

    /* user code [TIMER19_UP_IRQn local 0] end */

    /* user code [TIMER19_UP_IRQn local 1] begin */

    /* user code [TIMER19_UP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER19TriggerCommutationDirectionChangeAndIndexInterrupt ??== true &&NVIC_TIMER19TriggerCommutationDirectionChangeAndIndexInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER19 Trigger,Commutation,Direction Change And Index Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER19_TRG_CMT_IDX_IRQHandler(void)
{
    /* user code [TIMER19_TRG_CMT_IDX_IRQn local 0] begin */

    /* user code [TIMER19_TRG_CMT_IDX_IRQn local 0] end */

    /* user code [TIMER19_TRG_CMT_IDX_IRQn local 1] begin */

    /* user code [TIMER19_TRG_CMT_IDX_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER19ChannelCaptureCompareInterrupt ??== true && NVIC_TIMER19ChannelCaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER19 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER19_Channel_IRQHandler(void)
{
    /* user code [TIMER19_Channel_IRQn local 0] begin */

    /* user code [TIMER19_Channel_IRQn local 0] end */

    /* user code [TIMER19_Channel_IRQn local 1] begin */

    /* user code [TIMER19_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_FPUGlobalInterrupt ??== true && NVIC_FPUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FPU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FPU_IRQHandler(void)
{
    /* user code [FPU_IRQn local 0] begin */

    /* user code [FPU_IRQn local 0] end */

    /* user code [FPU_IRQn local 1] begin */

    /* user code [FPU_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2EventAndWakeupFromEXTIInterrupt ??== true && NVIC_I2C2EventAndWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Event And Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_EV_WKUP_IRQHandler (void)
{
    /* user code [I2C2_EV_WKUP_IRQn local 0] begin */

    /* user code [I2C2_EV_WKUP_IRQn local 0] end */

    /* user code [I2C2_EV_WKUP_IRQn local 1] begin */

    /* user code [I2C2_EV_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2ErrorInterrupt ??== true && NVIC_I2C2ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_ER_IRQHandler(void)
{
    /* user code [I2C2_ER_IRQn local 0] begin */

    /* user code [I2C2_ER_IRQn local 0] end */

    /* user code [I2C2_ER_IRQn local 1] begin */

    /* user code [I2C2_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAUGlobalInterrupt ??== true && NVIC_CAUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAU_IRQHandler(void)
{
    /* user code [CAU_IRQn local 0] begin */

    /* user code [CAU_IRQn local 0] end */

    /* user code [CAU_IRQn local 1] begin */

    /* user code [CAU_IRQn local 1] end */
}

[/#if]
[#if NVIC_TRNGGlobalInterrupt ??== true && NVIC_TRNGGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TRNG Global Interrupt Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TRNG_IRQHandler(void)
{
    /* user code [TRNG_IRQn local 0] begin */

    /* user code [TRNG_IRQn local 0] end */

    /* user code [TRNG_IRQn local 1] begin */

    /* user code [TRNG_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3EventAndWakeupFromEXTIInterrupt ??== true && NVIC_I2C3EventAndWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Event And Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_EV_WKUP_IRQHandler(void)
{
    /* user code [I2C3_EV_KWUP_IRQn local 0] begin */

    /* user code [I2C3_EV_KWUP_IRQn local 0] end */

    /* user code [I2C3_EV_WKUP_IRQn local 1] begin */

    /* user code [I2C3_EV_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3ErrorInterrupt ??== true && NVIC_I2C3ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_ER_IRQHandler(void)
{
    /* user code [I2C3_ER_IRQn local 0] begin */

    /* user code [I2C3_ER_IRQn local 0] end */

    /* user code [I2C3_ER_IRQn local 1] begin */

    /* user code [I2C3_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMAMUXOverrunInterrupt ??== true && NVIC_DMAMUXOverrunInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMAMUX Overrun Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMAMUX_OVR_IRQHandler(void)
{
    /* user code [DMAMUX_OVR_IRQn local 0] begin */

    /* user code [DMAMUX_OVR_IRQn local 0] end */

    /* user code [DMAMUX_OVR_IRQn local 1] begin */

    /* user code [DMAMUX_OVR_IRQn local 1] end */
}

[/#if]
[#if NVIC_QSPIGlobalInterrupt ??== true && NVIC_QSPIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      QSPI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void QSPI_IRQHandler(void)
{
    /* user code [QSPI_IRQn local 0] begin */

    /* user code [QSPI_IRQn local 0] end */

    /* user code [QSPI_IRQn local 1] begin */

    /* user code [QSPI_IRQn local 1] end */
}

[/#if]
[#if NVIC_FFTGlobalInterrupt ??== true && NVIC_FFTGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FFT Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FFT_IRQHandler(void)
{
    /* user code [FFT_IRQn local 0] begin */

    /* user code [FFT_IRQn local 0] end */

    /* user code [FFT_IRQn local 1] begin */

    /* user code [FFT_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel5GlobalInterrupt ??== true && NVIC_DMA1Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel5 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel5_IRQHandler(void)
{
    /* user code [DMA1_Channel5_IRQn local 0] begin */

    /* user code [DMA1_Channel5_IRQn local 0] end */

    /* user code [DMA1_Channel5_IRQn local 1] begin */

    /* user code [DMA1_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel6GlobalInterrupt ??== true && NVIC_DMA1Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel6 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel6_IRQHandler(void)
{
    /* user code [DMA1_Channel6_IRQn local 0] begin */

    /* user code [DMA1_Channel6_IRQn local 0] end */

    /* user code [DMA1_Channel6_IRQn local 1] begin */

    /* user code [DMA1_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_CLAGlobalInterrupt ??== true && NVIC_CLAGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      CLA Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CLA_IRQHandler(void)
{
    /* user code [CLA_IRQn local 0] begin */

    /* user code [CLA_IRQn local 0] end */

    /* user code [CLA_IRQn local 1] begin */

    /* user code [CLA_IRQn local 1] end */
}

[/#if]
[#if NVIC_TMUGlobalInterrupt ??== true && NVIC_TMUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TMU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TMU_IRQHandler(void)
{
    /* user code [TMU_IRQn local 0] begin */

    /* user code [TMU_IRQn local 0] end */

    /* user code [TMU_IRQn local 1] begin */

    /* user code [TMU_IRQn local 1] end */
}

[/#if]
[#if NVIC_FACGlobalInterrupt ??== true && NVIC_FACGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FAC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FAC_IRQHandler(void)
{
    /* user code [FAC_IRQn local 0] begin */

    /* user code [FAC_IRQn local 0] end */

    /* user code [FAC_IRQn local 1] begin */

    /* user code [FAC_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal0Interrupt ??== true && NVIC_HPDFGlobal0Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global 0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT0_IRQHandler(void)
{
    /* user code [HPDF_INT0_IRQn local 0] begin */

    /* user code [HPDF_INT0_IRQn local 0] end */

    /* user code [HPDF_INT0_IRQn local 1] begin */

    /* user code [HPDF_INT0_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal1Interrupt ??== true && NVIC_HPDFGlobal1Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global 1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT1_IRQHandler(void)
{
    /* user code [HPDF_INT1_IRQn local 0] begin */

    /* user code [HPDF_INT1_IRQn local 0] end */

    /* user code [HPDF_INT1_IRQn local 1] begin */

    /* user code [HPDF_INT1_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal2Interrupt ??== true && NVIC_HPDFGlobal2Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global 2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT2_IRQHandler(void)
{
    /* user code [HPDF_INT2_IRQn local 0] begin */

    /* user code [HPDF_INT2_IRQn local 0] end */

    /* user code [HPDF_INT2_IRQn local 1] begin */

    /* user code [HPDF_INT2_IRQn local 1] end */
}

[/#if]
[#if NVIC_HPDFGlobal3Interrupt ??== true && NVIC_HPDFGlobal3Interrupt_Enabled == "TRUE"]
/*!
    \brief      HPDF Global 3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HPDF_INT3_IRQHandler(void)
{
    /* user code [HPDF_INT3_IRQn local 0] begin */

    /* user code [HPDF_INT3_IRQn local 0] end */

    /* user code [HPDF_INT3_IRQn local 1] begin */

    /* user code [HPDF_INT3_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER14GlobalInterrupt ??== true && NVIC_TIMER14GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER14 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER14_IRQHandler(void)
{
    /* user code [TIMER14_IRQn local 0] begin */

    /* user code [TIMER14_IRQn local 0] end */

    /* user code [TIMER14_IRQn local 1] begin */

    /* user code [TIMER14_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER15GlobalInterrupt ??== true && NVIC_TIMER15GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER15 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER15_IRQHandler(void)
{
    /* user code [TIMER15_IRQn local 0] begin */

    /* user code [TIMER15_IRQn local 0] end */

    /* user code [TIMER15_IRQn local 1] begin */

    /* user code [TIMER15_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER16GlobalInterrupt ??== true && NVIC_TIMER16GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER16 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER16_IRQHandler(void)
{
    /* user code [TIMER16_IRQn local 0] begin */

    /* user code [TIMER16_IRQn local 0] end */

    /* user code [TIMER16_IRQn local 1] begin */

    /* user code [TIMER16_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN0WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_WKUP_IRQHandler(void)
{
    /* user code [CAN0_WKUP_IRQn local 0] begin */

    /* user code [CAN0_WKUP_IRQn local 0] end */

    /* user code [CAN0_WKUP_IRQn local 1] begin */

    /* user code [CAN0_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForMessageBuffer ??== true && NVIC_CAN0InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Message_IRQHandler(void)
{
    /* user code [CAN0_Message_IRQn local 0] begin */

    /* user code [CAN0_Message_IRQn local 0] end */

    /* user code [CAN0_Message_IRQn local 1] begin */

    /* user code [CAN0_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForBusOffBusOffDone ??== true && NVIC_CAN0InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Busoff_IRQHandler(void)
{
    /* user code [CAN0_Busoff_IRQn local 0] begin */

    /* user code [CAN0_Busoff_IRQn local 0] end */

    /* user code [CAN0_Busoff_IRQn local 1] begin */

    /* user code [CAN0_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForError ??== true && NVIC_CAN0InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_Error_IRQHandler(void)
{
    /* user code [CAN0_Error_IRQn local 0] begin */

    /* user code [CAN0_Error_IRQn local 0] end */

    /* user code [CAN0_Error_IRQn local 1] begin */

    /* user code [CAN0_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForErrorInFastTransmission ??== true && NVIC_CAN0InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_FastError_IRQHandler(void)
{
    /* user code [CAN0_FastError_IRQn local 0] begin */

    /* user code [CAN0_FastError_IRQn local 0] end */

    /* user code [CAN0_FastError_IRQn local 1] begin */

    /* user code [CAN0_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForTransmitWarning ??== true && NVIC_CAN0InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_TEC_IRQHandler(void)
{
    /* user code [CAN0_TEC_IRQn local 0] begin */

    /* user code [CAN0_TEC_IRQn local 0] end */

    /* user code [CAN0_TEC_IRQn local 1] begin */

    /* user code [CAN0_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0InterruptForReceiveWarning ??== true && NVIC_CAN0InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN0 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_REC_IRQHandler(void)
{
    /* user code [CAN0_REC_IRQn local 0] begin */

    /* user code [CAN0_REC_IRQn local 0] end */

    /* user code [CAN0_REC_IRQn local 1] begin */

    /* user code [CAN0_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN1WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_WKUP_IRQHandler(void)
{
    /* user code [CAN1_WKUP_IRQn local 0] begin */

    /* user code [CAN1_WKUP_IRQn local 0] end */

    /* user code [CAN1_WKUP_IRQn local 1] begin */

    /* user code [CAN1_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForMessageBuffer ??== true && NVIC_CAN1InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Message_IRQHandler(void)
{
    /* user code [CAN1_Message_IRQn local 0] begin */

    /* user code [CAN1_Message_IRQn local 0] end */

    /* user code [CAN1_Message_IRQn local 1] begin */

    /* user code [CAN1_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForBusOffBusOffDone ??== true && NVIC_CAN1InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Busoff_IRQHandler (void)
{
    /* user code [CAN1_Busoff_IRQn local 0] begin */

    /* user code [CAN1_Busoff_IRQn local 0] end */

    /* user code [CAN1_Busoff_IRQn local 1] begin */

    /* user code [CAN1_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForError ??== true && NVIC_CAN1InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_Error_IRQHandler (void)
{
    /* user code [CAN1_Error_IRQn local 0] begin */

    /* user code [CAN1_Error_IRQn local 0] end */

    /* user code [CAN1_Error_IRQn local 1] begin */

    /* user code [CAN1_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForErrorInFastTransmission ??== true && NVIC_CAN1InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_FastError_IRQHandler (void)
{
    /* user code [CAN1_FastError_IRQn local 0] begin */

    /* user code [CAN1_FastError_IRQn local 0] end */

    /* user code [CAN1_FastError_IRQn local 1] begin */

    /* user code [CAN1_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForTransmitWarning ??== true && NVIC_CAN1InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_TEC_IRQHandler(void)
{
    /* user code [CAN1_TEC_IRQn local 0] begin */

    /* user code [CAN1_TEC_IRQn local 0] end */

    /* user code [CAN1_TEC_IRQn local 1] begin */

    /* user code [CAN1_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1InterruptForReceiveWarning ??== true && NVIC_CAN1InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN1 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_REC_IRQHandler(void)
{
    /* user code [CAN1_REC_IRQn local 0] begin */

    /* user code [CAN1_REC_IRQn local 0] end */

    /* user code [CAN1_REC_IRQn local 1] begin */

    /* user code [CAN1_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2WakeupThroughEXTILineDetectionInterrupt ??== true && NVIC_CAN2WakeupThroughEXTILineDetectionInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN2 Wakeup Through EXTI Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_WKUP_IRQHandler(void)
{
    /* user code [CAN2_WKUP_IRQn local 0] begin */

    /* user code [CAN2_WKUP_IRQn local 0] end */

    /* user code [CAN2_WKUP_IRQn local 1] begin */

    /* user code [CAN2_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForMessageBuffer ??== true && NVIC_CAN2InterruptForMessageBuffer_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Message Buffer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Message_IRQHandler(void)
{
    /* user code [CAN2_Message_IRQn local 0] begin */

    /* user code [CAN2_Message_IRQn local 0] end */

    /* user code [CAN2_Message_IRQn local 1] begin */

    /* user code [CAN2_Message_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForBusOffBusOffDone ??== true && NVIC_CAN2InterruptForBusOffBusOffDone_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Bus Off / Bus Off Done Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Busoff_IRQHandler (void)
{
    /* user code [CAN2_Busoff_IRQn local 0] begin */

    /* user code [CAN2_Busoff_IRQn local 0] end */

    /* user code [CAN2_Busoff_IRQn local 1] begin */

    /* user code [CAN2_Busoff_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForError ??== true && NVIC_CAN2InterruptForError_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_Error_IRQHandler (void)
{
    /* user code [CAN2_Error_IRQn local 0] begin */

    /* user code [CAN2_Error_IRQn local 0] end */

    /* user code [CAN2_Error_IRQn local 1] begin */

    /* user code [CAN2_Error_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForErrorInFastTransmission ??== true && NVIC_CAN2InterruptForErrorInFastTransmission_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Error In Fast Transmission Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_FastError_IRQHandler(void)
{
    /* user code [CAN2_FastError_IRQn local 0] begin */

    /* user code [CAN2_FastError_IRQn local 0] end */

    /* user code [CAN2_FastError_IRQn local 1] begin */

    /* user code [CAN2_FastError_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForTransmitWarning ??== true && NVIC_CAN2InterruptForTransmitWarning_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Transmit Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_TEC_IRQHandler(void)
{
    /* user code [CAN2_TEC_IRQn local 0] begin */

    /* user code [CAN2_TEC_IRQn local 0] end */

    /* user code [CAN2_TEC_IRQn local 1] begin */

    /* user code [CAN2_TEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN2InterruptForReceiveWarning ??== true && NVIC_CAN2InterruptForReceiveWarning_Enabled == "TRUE"]
/*!
    \brief      CAN2 Interrupt For Receive Warning Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN2_REC_IRQHandler(void)
{
    /* user code [CAN2_REC_IRQn local 0] begin */

    /* user code [CAN2_REC_IRQn local 0] end */

    /* user code [CAN2_REC_IRQn local 1] begin */

    /* user code [CAN2_REC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0DECInterrupt ??== true && NVIC_TIMER0DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_DEC_IRQHandler(void)
{
    /* user code [TIMER0_DEC_IRQn local 0] begin */

    /* user code [TIMER0_DEC_IRQn local 0] end */

    /* user code [TIMER0_DEC_IRQn local 1] begin */

    /* user code [TIMER0_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER1DECInterrupt ??== true && NVIC_TIMER1DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER1 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER1_DEC_IRQHandler(void)
{
    /* user code [TIMER1_DEC_IRQn local 0] begin */

    /* user code [TIMER1_DEC_IRQn local 0] end */

    /* user code [TIMER1_DEC_IRQn local 1] begin */

    /* user code [TIMER1_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2DECInterrupt ??== true && NVIC_TIMER2DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_DEC_IRQHandler(void)
{
    /* user code [TIMER2_DEC_IRQn local 0] begin */

    /* user code [TIMER2_DEC_IRQn local 0] end */

    /* user code [TIMER2_DEC_IRQn local 1] begin */

    /* user code [TIMER2_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER3DECInterrupt ??== true && NVIC_TIMER3DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER3 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_DEC_IRQHandler(void)
{
    /* user code [TIMER3_DEC_IRQn local 0] begin */

    /* user code [TIMER3_DEC_IRQn local 0] end */

    /* user code [TIMER3_DEC_IRQn local 1] begin */

    /* user code [TIMER3_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER4DECInterrupt ??== true && NVIC_TIMER4DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER4 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER4_DEC_IRQHandler(void)
{
    /* user code [TIMER4_DEC_IRQn local 0] begin */

    /* user code [TIMER4_DEC_IRQn local 0] end */

    /* user code [TIMER4_DEC_IRQn local 1] begin */

    /* user code [TIMER4_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7DECInterrupt ??== true && NVIC_TIMER7DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_DEC_IRQHandler(void)
{
    /* user code [TIMER7_DEC_IRQn local 0] begin */

    /* user code [TIMER7_DEC_IRQn local 0] end */

    /* user code [TIMER7_DEC_IRQn local 1] begin */

    /* user code [TIMER7_DEC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER19DECInterrupt ??== true && NVIC_TIMER19DECInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER19 DEC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER19_DEC_IRQHandler (void)
{
    /* user code [TIMER19_DEC_IRQn local 0] begin */

    /* user code [TIMER19_DEC_IRQn local 0] end */

    /* user code [TIMER19_DEC_IRQn local 1] begin */

    /* user code [TIMER19_DEC_IRQn local 1] end */
}

[/#if]

/* user code [Global Functions Implementations] begin */

/* user code [Global Functions Implementations] end */

/* user code [Static Functions Implementations] begin */

/* user code [Static Functions Implementations] end */
