[#ftl]
[#-- V1.11.0 --]
/*
    \file  main.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "${MCUPart}.h"
#include "${MCUPart}_init.h"

/* External Includes*/
[#if Peripherals?contains("#USBFS#") == true]
[#if USBFS_WorkMode == "USBFS Host" && Peripherals?contains("#USBFS_HOST#") == true]
#include "usbh_core.h"
[/#if]
[#elseif Peripherals?contains("#USBHS#") == true]
[#if USBHS_ExternalPhy == "USBHS Host" && Peripherals?contains("#USBHS_HOST#") == true]
#include "usbh_core.h"
[/#if]
[/#if]
[#if Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable == "TRUE"]
#include "netconf.h"
#include "lwip/tcp.h"
#include "lwip/timeouts.h"
[/#if]
[/#if]
[#if Peripherals?contains("#FREERTOS#") == true]
#include "FreeRTOS.h"
#include "task.h"
[/#if]
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
[#if Peripherals?contains("#FREERTOS#") == true]
#define DEFAULT_TASK_PRIO   ( tskIDLE_PRIORITY + 1 )
[/#if]
[#if Peripherals?contains("#FREERTOS#") == true && Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable"]
#define DHCP_TASK_PRIO      ( tskIDLE_PRIORITY + 4 )
[/#if]
[/#if]
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
[#if Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable == "TRUE"]
__IO uint32_t g_localtime = 0;
[/#if]
[/#if]
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
[#if Peripherals?contains("#FREERTOS#") == true]
static void default_task(void *pvParameters);
[/#if]
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

/*!
    \brief      main function
    \param[in]  none
    \param[out] none
    \retval     none
*/
int main(void)
{
    /* user code [local 0] begin */

    /* user code [local 0] end */

    msd_system_init();
[#if Peripherals?contains("PMU") == true]
    msd_pmu_init();
[/#if]
    msd_clock_init();

    /* user code [local 1] begin */

    /* user code [local 1] end */

[#if PosMain_GPIO != ""]
${PosMain_GPIO}
[/#if]
[#if PosMain_DMA != ""]
${PosMain_DMA}
[/#if]
[#if Peripherals?contains("#ADC0#") == true]
    msd_adc0_init();
[/#if]
[#if Peripherals?contains("#ADC1#") == true]
    msd_adc1_init();
[/#if]
[#if Peripherals?contains("#ADC2#") == true]
    msd_adc2_init();
[/#if]
[#if Peripherals?contains("#CAN0#") == true]
    msd_can0_init();
[/#if]
[#if Peripherals?contains("#CAN1#") == true]
    msd_can1_init();
[/#if]
[#if Peripherals?contains("#CAU#") == true]
    msd_cau_init();
[/#if]
[#if Peripherals?contains("#CRC#") == true]
    msd_crc_init();
[/#if]
[#if Peripherals?contains("#CTC#") == true]
    msd_ctc_init();
[/#if]
[#if Peripherals?contains("#DAC0#") == true]
    msd_dac0_init();
[/#if]
[#if Peripherals?contains("#DCI#") == true]
    msd_dci_init();
[/#if]
[#if Peripherals?contains("#ENET#") == true]
    msd_enet_init();
[/#if]
[#if Peripherals?contains("#EXMC#") == true]
    msd_exmc_init();
[/#if]
[#if Peripherals?contains("#FWDGT#") == true]
    msd_fwdgt_init();
[/#if]
[#if Peripherals?contains("#HAU#") == true]
    msd_hau_init();
[/#if]
[#if Peripherals?contains("#I2C0#") == true]
    msd_i2c0_init();
[/#if]
[#if Peripherals?contains("#I2C1#") == true]
    msd_i2c1_init();
[/#if]
[#if Peripherals?contains("#I2C2#") == true]
    msd_i2c2_init();
[/#if]
[#if Peripherals?contains("#I2C3#") == true]
    msd_i2c3_init();
[/#if]
[#if Peripherals?contains("#I2C4#") == true]
    msd_i2c4_init();
[/#if]
[#if Peripherals?contains("#I2C5#") == true]
    msd_i2c5_init();
[/#if]
[#if Peripherals?contains("#I2S1#") == true]
    msd_i2s1_init();
[/#if]
[#if Peripherals?contains("#I2S2#") == true]
    msd_i2s2_init();
[/#if]
[#if Peripherals?contains("#IPA#") == true]
    msd_ipa_init();
[/#if]
[#if Peripherals?contains("#IREF#") == true]
    msd_iref_init();
[/#if]
[#if Peripherals?contains("#PKCAU#") == true]
    msd_pkcau_init();
[/#if]
[#if Peripherals?contains("#RTC#") == true]
    msd_rtc_init();
[/#if]
[#if Peripherals?contains("#SAI#") == true]
    msd_sai_init();
[/#if]
[#if Peripherals?contains("#SDIO#") == true]
    msd_sdio_init();
[/#if]
[#if Peripherals?contains("#SPI0#") == true]
    msd_spi0_init();
[/#if]
[#if Peripherals?contains("#SPI1#") == true]
    msd_spi1_init();
[/#if]
[#if Peripherals?contains("#SPI2#") == true]
    msd_spi2_init();
[/#if]
[#if Peripherals?contains("#SPI3#") == true]
    msd_spi3_init();
[/#if]
[#if Peripherals?contains("#SPI4#") == true]
    msd_spi4_init();
[/#if]
[#if Peripherals?contains("#SPI5#") == true]
    msd_spi5_init();
[/#if]
[#if Peripherals?contains("#TIMER0#") == true]
    msd_timer0_init();
[/#if]
[#if Peripherals?contains("#TIMER1#") == true]
    msd_timer1_init();
[/#if]
[#if Peripherals?contains("#TIMER2#") == true]
    msd_timer2_init();
[/#if]
[#if Peripherals?contains("#TIMER3#") == true]
    msd_timer3_init();
[/#if]
[#if Peripherals?contains("#TIMER4#") == true]
    msd_timer4_init();
[/#if]
[#if Peripherals?contains("#TIMER5#") == true]
    msd_timer5_init();
[/#if]
[#if Peripherals?contains("#TIMER6#") == true]
    msd_timer6_init();
[/#if]
[#if Peripherals?contains("#TIMER7#") == true]
    msd_timer7_init();
[/#if]
[#if Peripherals?contains("#TIMER8#") == true]
    msd_timer8_init();
[/#if]
[#if Peripherals?contains("#TIMER9#") == true]
    msd_timer9_init();
[/#if]
[#if Peripherals?contains("#TIMER10#") == true]
    msd_timer10_init();
[/#if]
[#if Peripherals?contains("#TIMER11#") == true]
    msd_timer11_init();
[/#if]
[#if Peripherals?contains("#TIMER12#") == true]
    msd_timer12_init();
[/#if]
[#if Peripherals?contains("#TIMER13#") == true]
    msd_timer13_init();
[/#if]
[#if Peripherals?contains("#TLI#") == true]
    msd_tli_init();
[/#if]
[#if Peripherals?contains("#UART3#") == true]
    msd_uart3_init();
[/#if]
[#if Peripherals?contains("#UART4#") == true]
    msd_uart4_init();
[/#if]
[#if Peripherals?contains("#UART6#") == true]
    msd_uart6_init();
[/#if]
[#if Peripherals?contains("#UART7#") == true]
    msd_uart7_init();
[/#if]
[#if Peripherals?contains("#USART0#") == true]
    msd_usart0_init();
[/#if]
[#if Peripherals?contains("#USART1#") == true]
    msd_usart1_init();
[/#if]
[#if Peripherals?contains("#USART2#") == true]
    msd_usart2_init();
[/#if]
[#if Peripherals?contains("#USART5#") == true]
    msd_usart5_init();
[/#if]
[#if Peripherals?contains("#USBFS#") == true]
[#if USBFS_WorkMode == "USBFS Device"]
    msd_usbfs_device_init();
[/#if]
[#if USBFS_WorkMode == "USBFS Host"]
    msd_usbfs_host_init();
[/#if]
[/#if]
[#if Peripherals?contains("#USBHS#") == true]
[#if USBHS_USBMode == "USB Device"]
    msd_usbhs_device_init();
[/#if]
[#if USBHS_USBMode == "USB Host"]
    msd_usbhs_host_init();
[/#if]
[/#if]
[#if Peripherals?contains("#WWDGT#") == true]
    msd_wwdgt_init();
[/#if]
[#if Peripherals?contains("#TRNG#") == true]
    msd_trng_init();
[/#if]

[#if Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
    /* initialize the LwIP stack */
    lwip_stack_init();
[/#if]
[/#if]
[/#if]

[#if Peripherals?contains("#FREERTOS#") == true]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_DYNAMIC_ALLOCATION ??== true]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_DYNAMIC_ALLOCATION == "Enable"]
    /* default task */
    xTaskCreate(default_task, "default", configMINIMAL_STACK_SIZE * 2, NULL, DEFAULT_TASK_PRIO, NULL);
[/#if]
[#if Peripherals?contains("#LWIP#") == true && LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable" && FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_DYNAMIC_ALLOCATION == "Enable"]
    /* start DHCP client */
    xTaskCreate(dhcp_task, "DHCP", configMINIMAL_STACK_SIZE * 2, NULL, DHCP_TASK_PRIO, NULL);
[/#if]
[/#if]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_STATIC_ALLOCATION ??== true]
[#if FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_STATIC_ALLOCATION == "Enable"]
    /* default task */
    xTaskCreateStatic(default_task, "default", configMINIMAL_STACK_SIZE * 2, NULL, DEFAULT_TASK_PRIO, NULL, NULL);
[/#if]
[#if Peripherals?contains("#LWIP#") == true && LWIP_LWIPEnable_TRUELWIPOptionFunctionConfiguration_LWIPDHCP == "Enable" && FREERTOS_FREERTOSEnable_TRUEMemoryConfiguration_SUPPORT_STATIC_ALLOCATION == "Enable"]
    /* start DHCP client */
    xTaskCreateStatic(dhcp_task, "DHCP", configMINIMAL_STACK_SIZE * 2, NULL, DHCP_TASK_PRIO, NULL);
[/#if]
[/#if]

    /* start scheduler */
    vTaskStartScheduler();
[/#if]
    /* user code [local 2] begin */

    /* user code [local 2] end */

    while(1){
        /* user code [local 3] begin */

        /* user code [local 3] end */
[#if Peripherals?contains("#USBFS#") == true]
[#if USBFS_WorkMode == "USBFS Host" && Peripherals?contains("#USBFS_HOST#") == true]
        fs_usbh_core_task();
[/#if]
[/#if]
[#if Peripherals?contains("#USBHS#") == true]
[#if USBHS_ExternalPhy == "USBHS Host" && Peripherals?contains("#USBHS_HOST#") == true]
        hs_usbh_core_task();
[/#if]
[/#if]
    }
}

/* user code [Public Functions Implementations] begin */

/* user code [Public Functions Implementations] end */

/* user code [Private Function Implementations] begin */
[#if Peripherals?contains("#FREERTOS#") == true]
/*!
    \brief      default task
    \param[in]  pvParameters not used
    \param[out] none
    \retval     none
*/
void default_task(void *pvParameters)
{
[#if Peripherals?contains("#LWIP#") == true]
[#if LWIP_LWIPEnable_TRUELWIPInformation_LWIPDependencyFreeRTOS == "Enable"]
    /* initialize the LwIP stack */
    lwip_stack_init();
[/#if]
[/#if]

[#if Peripherals?contains("#FREERTOS#") == true && Peripherals?contains("#LWIP#") == true]
    /* user code [local 4] begin */

    for(;;) {
        vTaskDelete(NULL);
    }

    /* user code [local 4] end */
[/#if]
[#if Peripherals?contains("#FREERTOS#") == true && Peripherals?contains("#LWIP#") != true]
    /* user code [local 5] begin */

    for(;;) {
        vTaskDelay(1);
    }

    /* user code [local 5] end */
[/#if]
}
[#else]

[/#if]
/* user code [Private Function Implementations] end */
