[#ftl]
[#-- V1.3.0 --]

[<GlobalStructs_H_ExternalConstants>]
[#--根据PKCAU的Mode生成不同的代码块--]
[#if PKCAU_PKCAUEnable ??== true]
[#if PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Only" || PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only" || PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then Modular Exponentiation" || PKCAU_PKCAUConfiguration_Mode == "Modular Inversion" || PKCAU_PKCAUConfiguration_Mode == "Modular Reduction" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication"]
    #define PKCAU_MODULUSN_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")}U
    [#if PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only" || PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then Modular Exponentiation" || PKCAU_PKCAUConfiguration_Mode == "Modular Inversion" || PKCAU_PKCAUConfiguration_Mode == "Modular Reduction" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication"]
    #define PKCAU_OPRD_A_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")}U
    [#if PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition"]
    #define PKCAU_OPRD_B_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandBValue,"HEX")}U
    [/#if]
    [#if PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only" || PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then Modular Exponentiation"]
    #define PKCAU_EXP_E_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputExponentEValue,"HEX")}U
    [/#if]
    [/#if]
[#elseif PKCAU_PKCAUConfiguration_Mode == "RSA CRT Exponentiation" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
    #define PKCAU_OPRD_A_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")}U
    [#if PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
    #define PKCAU_OPRD_B_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandBValue,"HEX")}U
    [#if PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction"]
    #define PKCAU_ARITHMETIC_MAX_BUFFER_SIZE PKCAU_OPRD_A_BUFFER_SIZE > PKCAU_OPRD_B_BUFFER_SIZE ? PKCAU_OPRD_A_BUFFER_SIZE : PKCAU_OPRD_B_BUFFER_SIZE
    [/#if]
    [#if PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition"]
    #define PKCAU_ARITHMETIC_BUFFER_SIZE (PKCAU_ARITHMETIC_MAX_BUFFER_SIZE + 1U)
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction"]
    #define PKCAU_ARITHMETIC_BUFFER_SIZE PKCAU_ARITHMETIC_MAX_BUFFER_SIZE
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication"]
    #define PKCAU_ARITHMETIC_BUFFER_SIZE (PKCAU_OPRD_A_BUFFER_SIZE + PKCAU_OPRD_B_BUFFER_SIZE)
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
    #define PKCAU_ARITHMETIC_BUFFER_SIZE 1U
    [/#if]
    [/#if]
    [#if PKCAU_PKCAUConfiguration_Mode == "RSA CRT Exponentiation"]
    #define PKCAU_OPRD_DP_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandDPValue,"HEX")}U
    #define PKCAU_OPRD_DQ_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandDQValue,"HEX")}U
    #define PKCAU_OPRD_QINV_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputOperandQinvValue,"HEX")}U
    #define PKCAU_OPRD_P_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPrimeOperandPValue,"HEX")}U
    #define PKCAU_OPRD_Q_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPrimeOperandQValue,"HEX")}U
    [/#if]
[#elseif PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then ECC Scalar Multiplication" || PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
    [#if PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
    #define PKCAU_MODULUSN_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")}U
    [/#if]
    #define PKCAU_CURVE_MODULUS_P_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")}U
    #define PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")}U
    #define PKCAU_SCALAR_MULTIPLIER_K_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputScalarMultiplierKValue,"HEX")}U
    #define PKCAU_POINT_X_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")}U
    #define PKCAU_POINT_Y_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")}U
[#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign" || PKCAU_PKCAUConfiguration_Mode == "ECDSA Verification"]
    [#if PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign"]
    #define PKCAU_INTEGER_K_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputIntegerKValue,"HEX")}U
    #define PKCAU_PRIVATE_KEY_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPrivateKeyValue,"HEX")}U
    [#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Verification"]
    #define PKCAU_POINT_X_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")}U
    #define PKCAU_POINT_Y_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")}U
    #define PKCAU_SIGN_R_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputSignatureRValue,"HEX")}U
    #define PKCAU_SIGN_S_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputSignatureSValue,"HEX")}U
    [/#if]
    #define PKCAU_CURVE_MODULUS_P_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")}U
    #define PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")}U
    #define PKCAU_BASE_POINT_X_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputBasePointXValue,"HEX")}U
    #define PKCAU_BASE_POINT_Y_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputBasePointYValue,"HEX")}U
    #define PKCAU_CURVE_ORDER_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPrimeCurveOrderValue,"HEX")}U
    #define PKCAU_HASH_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputHashValue,"HEX")}U
[#elseif PKCAU_PKCAUConfiguration_Mode == "Point On Elliptic Curve Fp Check"]
    #define PKCAU_POINT_X_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")}U
    #define PKCAU_POINT_Y_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")}U
    #define PKCAU_CURVE_MODULUS_P_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")}U
    #define PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")}U
    #define PKCAU_COFF_COEFFICIENT_B_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientBValue,"HEX")}U
[/#if]
[/#if]

[<GlobalStructs_C_PrivateVariables>]
[#--根据PKCAU的Mode生成不同的代码块--]
[#if PKCAU_PKCAUEnable ??== true]
[#if PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Only" || PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only"]
__ALIGNED(4) uint8_t modulus_n[PKCAU_MODULUSN_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")};
__ALIGNED(4) uint8_t results_mont[PKCAU_MODULUSN_BUFFER_SIZE];
    [#if PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only"]
__ALIGNED(4) uint8_t oprd_a[PKCAU_OPRD_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")};
__ALIGNED(4) uint8_t exp_e[PKCAU_EXP_E_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputExponentEValue,"HEX")};
__ALIGNED(4) uint8_t results[PKCAU_MODULUSN_BUFFER_SIZE];
    [/#if]
[#elseif PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then Modular Exponentiation"]
__ALIGNED(4) uint8_t modulus_n[PKCAU_MODULUSN_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")};
__ALIGNED(4) uint8_t oprd_a[PKCAU_OPRD_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")};
__ALIGNED(4) uint8_t exp_e[PKCAU_EXP_E_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputExponentEValue,"HEX")};
__ALIGNED(4) uint8_t results[PKCAU_MODULUSN_BUFFER_SIZE];
[#elseif PKCAU_PKCAUConfiguration_Mode == "RSA CRT Exponentiation"]
__ALIGNED(4) uint8_t rsa_crt_a[PKCAU_OPRD_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")};
__ALIGNED(4) uint8_t rsa_crt_dp[PKCAU_OPRD_DP_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandDPValue,"HEX")};
__ALIGNED(4) uint8_t rsa_crt_dq[PKCAU_OPRD_DQ_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandDQValue,"HEX")};
__ALIGNED(4) uint8_t rsa_crt_qinv[PKCAU_OPRD_QINV_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandQinvValue,"HEX")};
__ALIGNED(4) uint8_t rsa_crt_p[PKCAU_OPRD_P_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPrimeOperandPValue,"HEX")};
__ALIGNED(4) uint8_t rsa_crt_q[PKCAU_OPRD_Q_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPrimeOperandQValue,"HEX")};
__ALIGNED(4) uint8_t results[PKCAU_OPRD_A_BUFFER_SIZE];
[#elseif PKCAU_PKCAUConfiguration_Mode == "Modular Inversion" || PKCAU_PKCAUConfiguration_Mode == "Modular Reduction" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication"]
__ALIGNED(4) uint8_t modulus_n[PKCAU_MODULUSN_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")};
__ALIGNED(4) uint8_t oprd_a[PKCAU_OPRD_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")};
[#if PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction"]
__ALIGNED(4) uint8_t oprd_b[PKCAU_OPRD_B_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandBValue,"HEX")};
[/#if]
__ALIGNED(4) uint8_t results[PKCAU_MODULUSN_BUFFER_SIZE];
[#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
__ALIGNED(4) uint8_t oprd_a[PKCAU_OPRD_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandAValue,"HEX")};
__ALIGNED(4) uint8_t oprd_b[PKCAU_OPRD_B_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputOperandBValue,"HEX")};
__ALIGNED(4) uint8_t results[PKCAU_ARITHMETIC_BUFFER_SIZE];
[#elseif PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then ECC Scalar Multiplication" || PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
[#if PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
__ALIGNED(4) uint8_t modulus_n[PKCAU_MODULUSN_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputModulusNValue,"HEX")};
__ALIGNED(4) uint8_t results[PKCAU_MODULUSN_BUFFER_SIZE];
[/#if]
__ALIGNED(4) uint8_t modulus_p[PKCAU_CURVE_MODULUS_P_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")};
__ALIGNED(4) uint8_t coff_a[PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")};
__ALIGNED(4) uint8_t multi_k[PKCAU_SCALAR_MULTIPLIER_K_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputScalarMultiplierKValue,"HEX")};
__ALIGNED(4) uint8_t point_x[PKCAU_POINT_X_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")};
__ALIGNED(4) uint8_t point_y[PKCAU_POINT_Y_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")};
/* ECC out parameter structure */
pkcau_ecc_out_struct pkcau_ecc_out_result;
[#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign" || PKCAU_PKCAUConfiguration_Mode == "ECDSA Verification"]
    [#if PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign"]
    __ALIGNED(4) uint8_t integer_k[PKCAU_INTEGER_K_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputIntegerKValue,"HEX")};
    __ALIGNED(4) uint8_t private_key_d[PKCAU_PRIVATE_KEY_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPrivateKeyValue,"HEX")};
    [#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Verification"]
    __ALIGNED(4) uint8_t point_x[PKCAU_POINT_X_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")};
    __ALIGNED(4) uint8_t point_y[PKCAU_POINT_Y_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")};
    __ALIGNED(4) uint8_t sign_r[PKCAU_SIGN_R_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputSignatureRValue,"HEX")};
    __ALIGNED(4) uint8_t sign_s[PKCAU_SIGN_S_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputSignatureSValue,"HEX")};
    [/#if]
    __ALIGNED(4) uint8_t modulus_p[PKCAU_CURVE_MODULUS_P_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")};
    __ALIGNED(4) uint8_t coff_a[PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")};
    __ALIGNED(4) uint8_t base_point_x[PKCAU_BASE_POINT_X_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputBasePointXValue,"HEX")};
    __ALIGNED(4) uint8_t base_point_y[PKCAU_BASE_POINT_Y_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputBasePointYValue,"HEX")};
    __ALIGNED(4) uint8_t order_n[PKCAU_CURVE_ORDER_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPrimeCurveOrderValue,"HEX")};
    __ALIGNED(4) uint8_t hash_z[PKCAU_HASH_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputHashValue,"HEX")};
    [#if PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign"]
    /* ECC out parameter structure */
    pkcau_ecc_out_struct pkcau_ecc_out_result;
    [/#if]
[#elseif PKCAU_PKCAUConfiguration_Mode == "Point On Elliptic Curve Fp Check"]
__ALIGNED(4) uint8_t point_x[PKCAU_POINT_X_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointXValue,"HEX")};
__ALIGNED(4) uint8_t point_y[PKCAU_POINT_Y_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputPointYValue,"HEX")};
__ALIGNED(4) uint8_t modulus_p[PKCAU_CURVE_MODULUS_P_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveModulusPValue,"HEX")};
__ALIGNED(4) uint8_t coff_a[PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientAValue,"HEX")};
__ALIGNED(4) uint8_t coff_b[PKCAU_COFF_COEFFICIENT_B_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(PKCAU_PKCAUConfiguration_UserInputCurveCoefficientBValue,"HEX")};
[/#if]
[/#if]

[<InitCode>]
[#if PKCAU_PKCAUEnable ??== true]
    [#--根据PKCAU的Mode生成不同的代码块--]
    [#if PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Only" || PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only"]
        /* montgomery parameter structure */
        pkcau_mont_parameter_struct pkcau_mont_parameter;
        /* initialize the PKCAU montgomery parameter structure */
        pkcau_mont_struct_para_init(&pkcau_mont_parameter);
        /* initialize the montgomery parameters */
        pkcau_mont_parameter.modulus_n     = (uint8_t *)modulus_n;
        pkcau_mont_parameter.modulus_n_len = PKCAU_MODULUSN_BUFFER_SIZE;
        /* execute montgomery parameter operation */
        pkcau_mont_param_operation(&pkcau_mont_parameter, results_mont);
        [#if PKCAU_PKCAUConfiguration_Mode == "Modular Exponentiation Only"]
        /* modular parameter structure */
        pkcau_mod_exp_parameter_struct pkcau_mod_exp_parameter;
        /* initialize the PKCAU modular parameter structure */
        pkcau_mod_exp_struct_para_init(&pkcau_mod_exp_parameter);
        /* initialize the modular parameters */
        pkcau_mod_exp_parameter.oprd_a        = (uint8_t *)oprd_a;
        pkcau_mod_exp_parameter.oprd_a_len    = PKCAU_OPRD_A_BUFFER_SIZE;
        pkcau_mod_exp_parameter.exp_e         = (uint8_t *)exp_e;
        pkcau_mod_exp_parameter.e_len         = PKCAU_EXP_E_BUFFER_SIZE;
        pkcau_mod_exp_parameter.modulus_n     = (uint8_t *)modulus_n;
        pkcau_mod_exp_parameter.modulus_n_len = PKCAU_MODULUSN_BUFFER_SIZE;
        pkcau_mod_exp_parameter.mont_para     = (uint8_t *)results_mont;
        pkcau_mod_exp_parameter.mont_para_len = PKCAU_MODULUSN_BUFFER_SIZE;
        /* execute modular exponentiation of fast mode operation */
        pkcau_mod_exp_operation(&pkcau_mod_exp_parameter, PKCAU_MODE_MOD_EXP_FAST, results);
        [/#if]
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then Modular Exponentiation"]
        /* modular parameter structure */
        pkcau_mod_exp_parameter_struct pkcau_mod_exp_parameter;
        /* initialize the PKCAU modular parameter structure */
        pkcau_mod_exp_struct_para_init(&pkcau_mod_exp_parameter);
        /* initialize the modular parameters */
        pkcau_mod_exp_parameter.oprd_a        = (uint8_t *)oprd_a;
        pkcau_mod_exp_parameter.oprd_a_len    = PKCAU_OPRD_A_BUFFER_SIZE;
        pkcau_mod_exp_parameter.exp_e         = (uint8_t *)exp_e;
        pkcau_mod_exp_parameter.e_len         = PKCAU_EXP_E_BUFFER_SIZE;
        pkcau_mod_exp_parameter.modulus_n     = (uint8_t *)modulus_n;
        pkcau_mod_exp_parameter.modulus_n_len = PKCAU_MODULUSN_BUFFER_SIZE;
        /* execute modular exponentiation */
        pkcau_mod_exp_operation(&pkcau_mod_exp_parameter, PKCAU_MODE_MOD_EXP, results);
    [#elseif PKCAU_PKCAUConfiguration_Mode == "RSA CRT Exponentiation"]
        pkcau_crt_parameter_struct pkcau_crt_parameter;
        /* initialize the "RSA CRT Exponentiation" parameter structure */
        pkcau_crt_struct_para_init(&pkcau_crt_parameter);
        /* initialize the "RSA CRT Exponentiation" parameters */
        pkcau_crt_parameter.oprd_a        = (uint8_t *)rsa_crt_a;
        pkcau_crt_parameter.oprd_a_len    = PKCAU_OPRD_A_BUFFER_SIZE;
        pkcau_crt_parameter.oprd_dp       = (uint8_t *)rsa_crt_dp;
        pkcau_crt_parameter.oprd_dp_len   = PKCAU_OPRD_DP_BUFFER_SIZE;
        pkcau_crt_parameter.oprd_dq       = (uint8_t *)rsa_crt_dq;
        pkcau_crt_parameter.oprd_dq_len   = PKCAU_OPRD_DQ_BUFFER_SIZE;
        pkcau_crt_parameter.oprd_qinv     = (uint8_t *)rsa_crt_qinv;
        pkcau_crt_parameter.oprd_qinv_len = PKCAU_OPRD_QINV_BUFFER_SIZE;
        pkcau_crt_parameter.oprd_p        = (uint8_t *)rsa_crt_p;
        pkcau_crt_parameter.oprd_p_len    = PKCAU_OPRD_P_BUFFER_SIZE;
        pkcau_crt_parameter.oprd_q        = (uint8_t *)rsa_crt_q;
        pkcau_crt_parameter.oprd_q_len    = PKCAU_OPRD_Q_BUFFER_SIZE;
        /* execute "RSA CRT Exponentiation" operation */
        pkcau_crt_exp_operation(&pkcau_crt_parameter, results);
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Modular Inversion" || PKCAU_PKCAUConfiguration_Mode == "Modular Reduction" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication"]
        pkcau_mod_parameter_struct pkcau_mod_parameter;
        /* initialize the Modular parameter structure */
        pkcau_mod_struct_para_init(&pkcau_mod_parameter);
        /* initialize the Modular parameters */
        pkcau_mod_parameter.modulus_n     = (uint8_t *)modulus_n;
        pkcau_mod_parameter.modulus_n_len = PKCAU_MODULUSN_BUFFER_SIZE;
        pkcau_mod_parameter.oprd_a        = (uint8_t *)oprd_a;
        pkcau_mod_parameter.oprd_a_len    = PKCAU_OPRD_A_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Modular Addition" || PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction"]
        pkcau_mod_parameter.oprd_b        = (uint8_t *)oprd_b;
        pkcau_mod_parameter.oprd_b_len    = PKCAU_OPRD_B_BUFFER_SIZE;
        [/#if]
        [#if PKCAU_PKCAUConfiguration_Mode == "Modular Inversion"]
        /* execute "Modular Inversion" operation */
        pkcau_mod_inver_operation(&pkcau_mod_parameter, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Modular Reduction"]          
        /* execute "Modular Reduction" operation */
        pkcau_mod_reduc_operation(&pkcau_mod_parameter, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Modular Addition"]
        /* execute "Modular Addition" operation */
        pkcau_mod_operation(&pkcau_mod_parameter, PKCAU_MODE_MOD_ADD, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Modular Subtraction"]
        /* execute "Modular Subtraction" operation */
        pkcau_mod_operation(&pkcau_mod_parameter, PKCAU_MODE_MOD_SUB, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Montgomery Multiplication"]
        /* execute modular multiplication operation */
        pkcau_mod_operation(&pkcau_mod_parameter, PKCAU_MODE_MONT_MUL, results);
        [/#if]
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication" || PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
        pkcau_arithmetic_parameter_struct pkcau_arithmetic_parameter;
        /* initialize the arithmetic parameter structure*/
        pkcau_arithmetic_struct_para_init(&pkcau_arithmetic_parameter);
        /* initialize the arithmetic parameters */
        pkcau_arithmetic_parameter.oprd_a     = (uint8_t *)oprd_a;
        pkcau_arithmetic_parameter.oprd_a_len = PKCAU_OPRD_A_BUFFER_SIZE;
        pkcau_arithmetic_parameter.oprd_b     = (uint8_t *)oprd_b;
        pkcau_arithmetic_parameter.oprd_b_len = PKCAU_OPRD_B_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Mode == "Arithmetic Addition"]
            /* execute arithmetic operation */
            pkcau_arithmetic_operation(&pkcau_arithmetic_parameter, PKCAU_MODE_ARITHMETIC_ADD, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Subtraction"]
            /* execute arithmetic operation */
            pkcau_arithmetic_operation(&pkcau_arithmetic_parameter, PKCAU_MODE_ARITHMETIC_SUB, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Multiplication"]
            /* execute arithmetic operation */
            pkcau_arithmetic_operation(&pkcau_arithmetic_parameter, PKCAU_MODE_ARITHMETIC_MUL, results);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "Arithmetic Comparison"]
            /* execute arithmetic operation */
            pkcau_arithmetic_operation(&pkcau_arithmetic_parameter, PKCAU_MODE_ARITHMETIC_COMP, results);
        [/#if]
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then ECC Scalar Multiplication" || PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
        [#if PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
        /* montgomery parameter structure */
        pkcau_mont_parameter_struct pkcau_mont_parameter;
        /* initialize the PKCAU montgomery parameter structure */
        pkcau_mont_struct_para_init(&pkcau_mont_parameter);
        /* initialize the montgomery parameters */
        pkcau_mont_parameter.modulus_n     = (uint8_t *)modulus_n;
        pkcau_mont_parameter.modulus_n_len = PKCAU_MODULUSN_BUFFER_SIZE;
        /* execute montgomery parameter operation */
        pkcau_mont_param_operation(&pkcau_mont_parameter, results);
        [/#if]

        uint8_t ec_pmul_res_x[PKCAU_CURVE_MODULUS_P_BUFFER_SIZE] = {0};
        uint8_t ec_pmul_res_y[PKCAU_CURVE_MODULUS_P_BUFFER_SIZE] = {0};

        /* ECC curve parameter structure */
        pkcau_ec_group_parameter_struct pkcau_curve_group;
        /* point parameter structure */
        pkcau_point_parameter_struct pkcau_point_parameter;

        /* initialize the ECC curve parameter and point parameter structure */
        pkcau_ec_group_struct_para_init(&pkcau_curve_group);
        pkcau_point_struct_para_init(&pkcau_point_parameter);
        /* initialize the ECC out parameter structure */
        pkcau_ecc_out_struct_para_init(&pkcau_ecc_out_result);

        /* initialize the result point x and point y */ 
        pkcau_ecc_out_result.point_x = ec_pmul_res_x;
        pkcau_ecc_out_result.point_y = ec_pmul_res_y;
        
        /* initialize the input ECC curve parameter */
        pkcau_curve_group.modulus_p     = (uint8_t *)modulus_p;
        pkcau_curve_group.modulus_p_len = PKCAU_CURVE_MODULUS_P_BUFFER_SIZE;
        pkcau_curve_group.coff_a        = (uint8_t *)coff_a;
        pkcau_curve_group.coff_a_len    = PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Sign == "Positive"]
        pkcau_curve_group.a_sign        = 0;
        [#elseif PKCAU_PKCAUConfiguration_Sign == "Negative"]
        pkcau_curve_group.a_sign        = 1;
        [/#if]
        pkcau_curve_group.multi_k       = (uint8_t *)multi_k;
        pkcau_curve_group.multi_k_len   = PKCAU_SCALAR_MULTIPLIER_K_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
        pkcau_curve_group.mont_para     = (uint8_t *)results;
        pkcau_curve_group.mont_para_len = PKCAU_MODULUSN_BUFFER_SIZE;
        [/#if]

        /* initialize the input point parameter */
        pkcau_point_parameter.point_x       = (uint8_t *)point_x;
        pkcau_point_parameter.point_x_len   = PKCAU_POINT_X_BUFFER_SIZE;
        pkcau_point_parameter.point_y       = (uint8_t *)point_y;
        pkcau_point_parameter.point_y_len   = PKCAU_POINT_Y_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Mode == "Mont Para Computation Then ECC Scalar Multiplication"]
        /* execute scalar multiplication operation */
        pkcau_point_mul_operation(&pkcau_point_parameter, &pkcau_curve_group, PKCAU_MODE_ECC_SCALAR_MUL, &pkcau_ecc_out_result);
        [#elseif PKCAU_PKCAUConfiguration_Mode == "ECC Scalar Multiplication Only"]
        /* execute scalar multiplication operation */
        pkcau_point_mul_operation(&pkcau_point_parameter, &pkcau_curve_group, PKCAU_MODE_ECC_SCALAR_MUL_FAST, &pkcau_ecc_out_result);
        [/#if]
    [#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Sign"]
        /* init retval */
        uint8_t retval = 0; 
        [#if PKCAU_PKCAUConfiguration_ExtendECDSASignOutput == "Enable"]
        uint8_t ec_ecdsa_res_x[PKCAU_CURVE_ORDER_BUFFER_SIZE] = {0};
        uint8_t ec_ecdsa_res_y[PKCAU_CURVE_ORDER_BUFFER_SIZE] = {0};
        [/#if]
        uint8_t ec_ecdsa_res_sign_r[PKCAU_CURVE_ORDER_BUFFER_SIZE] = {0};
        uint8_t ec_ecdsa_res_sign_s[PKCAU_CURVE_ORDER_BUFFER_SIZE] = {0};

        /* ECC curve parameter structure */
        pkcau_ec_group_parameter_struct pkcau_curve_group;
        pkcau_hash_parameter_struct pkcau_hash_parameter;
        
        /* initialize the ECC curve parameter and hash parameter structure */
        pkcau_ec_group_struct_para_init(&pkcau_curve_group);
        pkcau_hash_struct_para_init(&pkcau_hash_parameter);
        /* initialize the ECC out parameter */
        pkcau_ecc_out_struct_para_init(&pkcau_ecc_out_result);

        /* initialize result for ECDSA Sign*/
        [#if PKCAU_PKCAUConfiguration_ExtendECDSASignOutput == "Enable"]
        pkcau_ecc_out_result.point_x        = (uint8_t *)ec_ecdsa_res_x;
        pkcau_ecc_out_result.point_y        = (uint8_t *)ec_ecdsa_res_y;
        pkcau_ecc_out_result.sign_extra     = 1;
        [/#if]
        pkcau_ecc_out_result.sign_r         = (uint8_t *)ec_ecdsa_res_sign_r;
        pkcau_ecc_out_result.sign_s         = (uint8_t *)ec_ecdsa_res_sign_s;

        /* initialize the input ECC curve parameter */
        pkcau_curve_group.modulus_p         = (uint8_t *)modulus_p;
        pkcau_curve_group.modulus_p_len     = PKCAU_CURVE_MODULUS_P_BUFFER_SIZE;
        pkcau_curve_group.coff_a            = (uint8_t *)coff_a;
        pkcau_curve_group.coff_a_len        = PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Sign == "Positive"]
        pkcau_curve_group.a_sign            = 0;
        [#elseif PKCAU_PKCAUConfiguration_Sign == "Negative"]
        pkcau_curve_group.a_sign            = 1;
        [/#if]
        pkcau_curve_group.base_point_x      = (uint8_t *)base_point_x;
        pkcau_curve_group.base_point_x_len  = PKCAU_BASE_POINT_X_BUFFER_SIZE;
        pkcau_curve_group.base_point_y      = (uint8_t *)base_point_y;
        pkcau_curve_group.base_point_y_len  = PKCAU_BASE_POINT_Y_BUFFER_SIZE;
        pkcau_curve_group.order_n           = (uint8_t *)order_n;
        pkcau_curve_group.order_n_len       = PKCAU_CURVE_ORDER_BUFFER_SIZE;
        pkcau_curve_group.integer_k         = (uint8_t *)integer_k;
        pkcau_curve_group.integer_k_len     = PKCAU_INTEGER_K_BUFFER_SIZE;
        pkcau_curve_group.private_key_d     = (uint8_t *)private_key_d;
        pkcau_curve_group.private_key_d_len = PKCAU_PRIVATE_KEY_BUFFER_SIZE;
        /* initialize the input hash parameter */
        pkcau_hash_parameter.hash_z     = (uint8_t *)hash_z;
        pkcau_hash_parameter.hash_z_len = PKCAU_HASH_BUFFER_SIZE;
        /* execute "ECDSA Sign" operation */
        retval = pkcau_ecdsa_sign_operation(&pkcau_hash_parameter, &pkcau_curve_group, &pkcau_ecc_out_result);
    [#elseif PKCAU_PKCAUConfiguration_Mode == "ECDSA Verification"]
        uint8_t verify_res = 1;
        /* ECC curve parameter structure */
        pkcau_ec_group_parameter_struct pkcau_curve_group;
        /* hash parameter structure */
        pkcau_hash_parameter_struct pkcau_hash_parameter;
        /* signature parameter structure */
        pkcau_signature_parameter_struct pkcau_signature_parameter;
        /* point parameter structure */
        pkcau_point_parameter_struct pkcau_point_parameter;
        /* initialize the ECC curve parameter, hash parameter, point parameter and signature parameter structure */

        pkcau_ec_group_struct_para_init(&pkcau_curve_group);
        pkcau_hash_struct_para_init(&pkcau_hash_parameter);
        pkcau_point_struct_para_init(&pkcau_point_parameter);
        pkcau_signature_struct_para_init(&pkcau_signature_parameter);

        /* initialize the input ECC signature parameters */
        pkcau_signature_parameter.sign_r     = (uint8_t *)sign_r;
        pkcau_signature_parameter.sign_r_len = PKCAU_SIGN_R_BUFFER_SIZE;
        pkcau_signature_parameter.sign_s     = (uint8_t *)sign_s;
        pkcau_signature_parameter.sign_s_len = PKCAU_SIGN_S_BUFFER_SIZE;
        /* initialize the input point parameters */
        pkcau_point_parameter.point_x     = point_x;
        pkcau_point_parameter.point_x_len = PKCAU_POINT_X_BUFFER_SIZE;
        pkcau_point_parameter.point_y     = point_y;
        pkcau_point_parameter.point_y_len = PKCAU_POINT_Y_BUFFER_SIZE;
        /* initialize the input ECC curve parameters */
        pkcau_curve_group.modulus_p        = (uint8_t *)modulus_p;
        pkcau_curve_group.modulus_p_len    = PKCAU_CURVE_MODULUS_P_BUFFER_SIZE;
        pkcau_curve_group.coff_a           = (uint8_t *)coff_a;
        pkcau_curve_group.coff_a_len       = PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Sign == "Positive"]
        pkcau_curve_group.a_sign        = 0;
        [#elseif PKCAU_PKCAUConfiguration_Sign == "Negative"]
        pkcau_curve_group.a_sign        = 1;
        [/#if]
        pkcau_curve_group.base_point_x     = (uint8_t *)base_point_x;
        pkcau_curve_group.base_point_x_len = PKCAU_BASE_POINT_X_BUFFER_SIZE;
        pkcau_curve_group.base_point_y     = (uint8_t *)base_point_y;
        pkcau_curve_group.base_point_y_len = PKCAU_BASE_POINT_Y_BUFFER_SIZE;
        pkcau_curve_group.order_n          = (uint8_t *)order_n;
        pkcau_curve_group.order_n_len      = PKCAU_CURVE_ORDER_BUFFER_SIZE;
        /* initialize the input hash parameters */
        pkcau_hash_parameter.hash_z     = (uint8_t *)hash_z;
        pkcau_hash_parameter.hash_z_len = PKCAU_HASH_BUFFER_SIZE;
        verify_res = pkcau_ecdsa_verification_operation(&pkcau_point_parameter, &pkcau_hash_parameter, &pkcau_signature_parameter, &pkcau_curve_group);
    [#elseif PKCAU_PKCAUConfiguration_Mode == "Point On Elliptic Curve Fp Check"]
        uint8_t res = 1U;
        /* ECC curve parameter structure */
        pkcau_ec_group_parameter_struct pkcau_curve_group;
        /* point parameter structure */
        pkcau_point_parameter_struct pkcau_point_parameter;

        /* initialize structure parameter */
        pkcau_ec_group_struct_para_init(&pkcau_curve_group);
        pkcau_point_struct_para_init(&pkcau_point_parameter);

        pkcau_point_parameter.point_x     = point_x;
        pkcau_point_parameter.point_x_len = PKCAU_POINT_X_BUFFER_SIZE;
        pkcau_point_parameter.point_y     = point_y;
        pkcau_point_parameter.point_y_len = PKCAU_POINT_Y_BUFFER_SIZE;
        pkcau_curve_group.coff_a           = (uint8_t *)coff_a;
        pkcau_curve_group.coff_a_len       = PKCAU_COFF_COEFFICIENT_A_BUFFER_SIZE;
        pkcau_curve_group.coff_b           = (uint8_t *)coff_b;
        pkcau_curve_group.coff_b_len       = PKCAU_COFF_COEFFICIENT_B_BUFFER_SIZE;
        pkcau_curve_group.modulus_p        = (uint8_t *)modulus_p;
        pkcau_curve_group.modulus_p_len    = PKCAU_CURVE_MODULUS_P_BUFFER_SIZE;
        [#if PKCAU_PKCAUConfiguration_Sign == "Positive"]
        pkcau_curve_group.a_sign           = 0;
        [#elseif PKCAU_PKCAUConfiguration_Sign == "Negative"]
        pkcau_curve_group.a_sign           = 1;
        [/#if]
        res = pkcau_point_check_operation(&pkcau_point_parameter, &pkcau_curve_group);
    [/#if]
[/#if]  