[#ftl]
[#-- V1.0.3 --]

[#if HAU_HAUEnable ??== true]

[<GlobalStructs_H_ExternalConstants>]
[#if HAU_Parameters_KeyType ??== true]
[#if HAU_Parameters_KeyType == "HEX"]
    #define HAU_KEY_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(HAU_Parameters_UserInputKeyValue,"HEX")}U
[#elseif HAU_Parameters_KeyType == "ASCII"]
    #define HAU_KEY_BUFFER_SIZE ${ReflectionFunc.GetArrayLength(HAU_Parameters_UserInputKeyValue,"ASCII")}U
[/#if]
[/#if]

[<GlobalStructs_H_ExternalVariables>]
[#if HAU_Algorithm_Mode == "HMAC"]
__ALIGNED(4) extern uint8_t HAU_KEY_BUFFER[HAU_KEY_BUFFER_SIZE];
[/#if]

[<GlobalStructs_C_PrivateVariables>]
[#if HAU_Algorithm_Mode == "HMAC"]
    [#if HAU_Parameters_KeyType == "HEX"]
    __ALIGNED(4) uint8_t HAU_KEY_BUFFER[HAU_KEY_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(HAU_Parameters_UserInputKeyValue,"HEX")};
    [/#if]
    [#if HAU_Parameters_KeyType == "ASCII"]
    __ALIGNED(4) uint8_t HAU_KEY_BUFFER[HAU_KEY_BUFFER_SIZE] = ${ReflectionFunc.GetValueArray(HAU_Parameters_UserInputKeyValue,"ASCII")};
    [/#if]
[/#if]

[<InitCode>]
[#if HAU_Parameters_UserInputKeyValue ??== true]
[#if HAU_Parameters_KeyType == "HEX"]
    [#assign myvariable = ReflectionFunc.GetArrayLength(HAU_Parameters_UserInputKeyValue, "HEX")]
[#elseif HAU_Parameters_KeyType == "ASCII"]
    [#assign myvariable = ReflectionFunc.GetArrayLength(HAU_Parameters_UserInputKeyValue, "ASCII")]
[/#if]
[/#if]
[#if HAU_HAUEnable ??== true]

    hau_init_parameter_struct hau_init_parameter;

    hau_init_struct_para_init(&hau_init_parameter);

    [#if HAU_Algorithm_Mode == "HASH"]
    hau_init_parameter.mode = HAU_MODE_HASH;
    [#elseif HAU_Algorithm_Mode == "HMAC"]
    hau_init_parameter.mode = HAU_MODE_HMAC;
    [/#if]
    [#if HAU_Algorithm_SecureHashAlgorithmType == "SHA1"]
    hau_init_parameter.algo = HAU_ALGO_SHA1;
    [#elseif HAU_Algorithm_SecureHashAlgorithmType == "SHA224"]
    hau_init_parameter.algo = HAU_ALGO_SHA224;
    [#elseif HAU_Algorithm_SecureHashAlgorithmType == "SHA256"]
    hau_init_parameter.algo = HAU_ALGO_SHA256;
    [#elseif HAU_Algorithm_SecureHashAlgorithmType == "MD5"]
    hau_init_parameter.algo = HAU_ALGO_MD5;
    [/#if]
    [#if HAU_Parameters_HashDataTypeInBit == "No Swapping"]
    hau_init_parameter.datatype = HAU_SWAPPING_32BIT;
    [#elseif HAU_Parameters_HashDataTypeInBit == "Half Words Swapping"]
    hau_init_parameter.datatype = HAU_SWAPPING_16BIT;
    [#elseif HAU_Parameters_HashDataTypeInBit == "Bytes Swapping"]
    hau_init_parameter.datatype = HAU_SWAPPING_8BIT;
    [#elseif HAU_Parameters_HashDataTypeInBit == "Bit Swapping"]
    hau_init_parameter.datatype = HAU_SWAPPING_1BIT;
    [/#if]
    [#if HAU_Algorithm_Mode == "HMAC"]
        [#if myvariable ??== true]
        [#if myvariable?number > 64]
        hau_init_parameter.keytype = HAU_KEY_LONGGER_64;
        [#else]
        hau_init_parameter.keytype = HAU_KEY_SHORTER_64;
        [/#if]
        [/#if]
    [/#if]
    hau_init(&hau_init_parameter);
[/#if]
[/#if]
