[#ftl]
[#-- V1.0.5 --]
/*
    \file  gd32f527_it.c
*/
/*
    Copyright (c) ${CurrentData}, GigaDevice Semiconductor Inc.

    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice, this
       list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.
    3. Neither the name of the copyright holder nor the names of its contributors
       may be used to endorse or promote products derived from this software without
       specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/

#include "gd32f527_it.h"
#include "gd32f527.h"
#include "gd32f527_init.h"
[#if FREERTOS_FREERTOSEnable ??== true]
[#if FREERTOS_FREERTOSEnable == "TRUE"]
#include "FreeRTOS.h"
#include "task.h"
[/#if]
[/#if]
[#if Peripherals?contains("#FREERTOS#") == true]
[#if Peripherals?contains("#LWIP#") == true]
#include "semphr.h"
#include "portmacrocommon.h"
#include "ethernetif.h"
[/#if]
[/#if]

/* External Includes*/
/* user code [External Includes] begin */

/* user code [External Includes] end */

/* Private Type Definitions */
/* user code [Private Type Definitions] begin */

/* user code [Private Type Definitions] end */

/* Private Macros */
#define MULTI_ECC_ERROR_HANDLE(s) \
    do {                          \
    } while(1)

#define SINGLE_ECC_ERROR_HANDLE(s) \
    do {                           \
    } while(1)
/* user code [Private Macros] begin */

/* user code [Private Macros] end */

/* Private Constants */
/* user code [Private Constants] begin */

/* user code [Private Constants] end */

/* Private Variables */
/* user code [Private Variables] begin */

/* user code [Private Variables] end */

/* Private Function Declaration */
/* user code [Private Function Declaration] begin */

/* user code [Private Function Declaration] end */

/* Extern Variables */
/* user code [Extern Variables] begin */

/* user code [Extern Variables] end */

[#if NVIC_NonMaskableInterrupt ??== true && NVIC_NonMaskableInterrupt_Enabled == "TRUE"]
/*!
    \brief      Non Maskable Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void NMI_Handler(void)
{
    /* user code [NMI_IRQn local 0] begin */

    /* user code [NMI_IRQn local 0] end */

    if((SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME0)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME1)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME2)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME3)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME4)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME5)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCME6))) {
        MULTI_ECC_ERROR_HANDLE("SRAM or FLASH multi-bits non-correction ECC error\r\n");
    } else {
        /* if NMI exception occurs, go to infinite loop */
        /* HXTAL clock monitor NMI error */
        while(1) {
            /* user code [NMI_IRQn local 1] begin */

            /* user code [NMI_IRQn local 1] end */
        }
    }

    /* user code [NMI_IRQn local 2] begin */

    /* user code [NMI_IRQn local 2] end */
}

[/#if]
[#if NVIC_SYSCFGSRAMECCErrorInterrupt ??== true && NVIC_SYSCFGSRAMECCErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      SRAM and Flash single bit ECC non-correction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SYSCFG_SINGLE_BIT_ECC_ER_IRQHandler(void)
{
    /* user code [SYSCFG_SRAM_ECC_ER_IRQn local 0] begin */

    /* user code [SYSCFG_SRAM_ECC_ER_IRQn local 0] end */

    if((SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE0)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE1)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE2)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE3)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE4)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE5)) ||
       (SET == syscfg_interrupt_flag_get(SYSCFG_INT_FLAG_ECCSE6))) {
        SINGLE_ECC_ERROR_HANDLE("SRAM or FLASH single bit ECC error\r\n");
    }

    /* user code [SYSCFG_SRAM_ECC_ER_IRQn local 1] begin */

    /* user code [SYSCFG_SRAM_ECC_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_HardfaultInterrupt ??== true && NVIC_HardfaultInterrupt_Enabled == "TRUE"]
/*!
    \brief      HardFault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HardFault_Handler(void)
{
    /* user code [HardFault_IRQn local 0] begin */

    /* user code [HardFault_IRQn local 0] end */
    while(1) {
        /* user code [HardFault_IRQn local 1] begin */

        /* user code [HardFault_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_MemoryManagementInterrupt ??== true && NVIC_MemoryManagementInterrupt_Enabled == "TRUE"]
/*!
    \brief      Memory Management Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void MemManage_Handler(void)
{
    /* user code [MemManage_IRQn local 0] begin */

    /* user code [MemManage_IRQn local 0] end */
    while(1) {
        /* user code [MemManage_IRQn local 1] begin */

        /* user code [MemManage_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_PrefetchFaultMemoryAccessFault ??== true && NVIC_PrefetchFaultMemoryAccessFault_Enabled == "TRUE"]
/*!
    \brief      Pre-fetch Fault,Memory Access Fault Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void BusFault_Handler(void)
{
    /* user code [BusFault_IRQn local 0] begin */

    /* user code [BusFault_IRQn local 0] end */
    while(1) {
        /* user code [BusFault_IRQn local 1] begin */

        /* user code [BusFault_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_UndefinedInstructionOrIllegalState ??== true && NVIC_UndefinedInstructionOrIllegalState_Enabled == "TRUE"]
/*!
    \brief      Undefined Instruction Or Illegal State Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UsageFault_Handler(void)
{
    /* user code [UsageFault_IRQn local 0] begin */

    /* user code [UsageFault_IRQn local 0] end */
    while(1) {
        /* user code [UsageFault_IRQn local 1] begin */

        /* user code [UsageFault_IRQn local 1] end */
    }
}

[/#if]

[#if NVIC_SystemServiceCallViaSWIInstruction ??== true && NVIC_SystemServiceCallViaSWIInstruction_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
/*!
    \brief      System Service Call Via SWI Instruction Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SVC_Handler(void)
{
    /* user code [SVC_IRQn local 0] begin */

    /* user code [SVC_IRQn local 0] end */

    while(1) {
        /* user code [SVC_IRQn local 1] begin */

        /* user code [SVC_IRQn local 1] end */
    }
}

[/#if]
[/#if]
[#if NVIC_PendableRequestForSystemService ??== true && NVIC_PendableRequestForSystemService_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
/*!
    \brief      PendSV Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PendSV_Handler(void)
{
    /* user code [PendSV_IRQn local 0] begin */

    /* user code [PendSV_IRQn local 0] end */

    while(1) {
        /* user code [PendSV_IRQn local 1] begin */

        /* user code [PendSV_IRQn local 1] end */
    }
}

[/#if]
[/#if]
[#if NVIC_DebugMonitorInterrupt ??== true && NVIC_DebugMonitorInterrupt_Enabled == "TRUE"]
/*!
    \brief      Debug Monitor Exception Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DebugMon_Handler(void)
{
    /* user code [DebugMon_IRQn local 0] begin */

    /* user code [DebugMon_IRQn local 0] end */
    while(1) {
        /* user code [DebugMon_IRQn local 1] begin */

        /* user code [DebugMon_IRQn local 1] end */
    }
}

[/#if]
[#if NVIC_SystemTickTimer ??== true && NVIC_SystemTickTimer_Enabled == "TRUE"]
[#if Peripherals?contains("#FREERTOS#") != true]
/*!
    \brief      SysTick Timer Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SysTick_Handler(void)
{
    /* user code [SysTick_IRQn local 0] begin */

    /* user code [SysTick_IRQn local 0] end */

    /* user code [SysTick_IRQn local 1] begin */

    /* user code [SysTick_IRQn local 1] end */
}

[/#if]
[/#if]
[#if NVIC_WWDGTInterrupt ??== true && NVIC_WWDGTInterrupt_Enabled == "TRUE"]
/*!
    \brief      WWDGT Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void WWDGT_IRQHandler(void)
{
    /* user code [WWDGT_IRQn local 0] begin */

    /* user code [WWDGT_IRQn local 0] end */

    /* user code [WWDGT_IRQn local 1] begin */

    /* user code [WWDGT_IRQn local 1] end */
}

[/#if]
[#if NVIC_LVDFromEXTIInterrupt ??== true && NVIC_LVDFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      LVD Through Exti Line Detection Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void LVD_IRQHandler(void)
{
    /* user code [LVD_IRQn local 0] begin */

    /* user code [LVD_IRQn local 0] end */

    /* user code [LVD_IRQn local 1] begin */

    /* user code [LVD_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCTamperAndTimestampFromEXTIInterrupt ??== true && NVIC_RTCTamperAndTimestampFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Tamper And Timestamp From EXTI Interrupt,LXTAL Clock Stuck Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TAMPER_STAMP_IRQHandler(void)
{
    /* user code [TAMPER_STAMP_IRQn local 0] begin */

    /* user code [TAMPER_STAMP_IRQn local 0] end */

    /* user code [TAMPER_STAMP_IRQn local 1] begin */

    /* user code [TAMPER_STAMP_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCWakeupFromEXTIInterrupt ??== true && NVIC_RTCWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Wakeup From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_WKUP_IRQHandler(void)
{
    /* user code [RTC_WKUP_IRQn local 0] begin */

    /* user code [RTC_WKUP_IRQn local 0] end */

    /* user code [RTC_WKUP_IRQn local 1] begin */

    /* user code [RTC_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_FMCGlobalInterrupt ??== true && NVIC_FMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FMC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FMC_IRQHandler(void)
{
    /* user code [FMC_IRQn local 0] begin */

    /* user code [FMC_IRQn local 0] end */

    /* user code [FMC_IRQn local 1] begin */

    /* user code [FMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_RCUAndCTCInterrupt ??== true && NVIC_RCUAndCTCInterrupt_Enabled == "TRUE"]
/*!
    \brief      RCU And CTC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RCU_CTC_IRQHandler(void)
{
    /* user code [RCU_CTC_IRQn local 0] begin */

    /* user code [RCU_CTC_IRQn local 0] end */

    /* user code [RCU_CTC_IRQn local 1] begin */

    /* user code [RCU_CTC_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine0Interrupt ??== true && NVIC_EXTILine0Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI0_IRQHandler(void)
{
    /* user code [EXTI0_IRQn local 0] begin */

    /* user code [EXTI0_IRQn local 0] end */

    /* user code [EXTI0_IRQn local 1] begin */

    /* user code [EXTI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1Interrupt ??== true && NVIC_EXTILine1Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI1_IRQHandler(void)
{
    /* user code [EXTI1_IRQn local 0] begin */

    /* user code [EXTI1_IRQn local 0] end */

    /* user code [EXTI1_IRQn local 1] begin */

    /* user code [EXTI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine2Interrupt ??== true && NVIC_EXTILine2Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI2_IRQHandler(void)
{
    /* user code [EXTI2_IRQn local 0] begin */

    /* user code [EXTI2_IRQn local 0] end */

    /* user code [EXTI2_IRQn local 1] begin */

    /* user code [EXTI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine3Interrupt ??== true && NVIC_EXTILine3Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI3_IRQHandler(void)
{
    /* user code [EXTI3_IRQn local 0] begin */
    /* user code [EXTI3_IRQn local 0] end */

    /* user code [EXTI3_IRQn local 1] begin */
    /* user code [EXTI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine4Interrupt ??== true && NVIC_EXTILine4Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI4_IRQHandler(void)
{
    /* user code [EXTI4_IRQn local 0] begin */
    /* user code [EXTI4_IRQn local 0] end */

    /* user code [EXTI4_IRQn local 1] begin */
    /* user code [EXTI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel0GlobalInterrupt ??== true && NVIC_DMA0Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel0_IRQHandler(void)
{
    /* user code [DMA0_Channel0_IRQn local 0] begin */

    /* user code [DMA0_Channel0_IRQn local 0] end */

    /* user code [DMA0_Channel0_IRQn local 1] begin */

    /* user code [DMA0_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel1GlobalInterrupt ??== true && NVIC_DMA0Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel1_IRQHandler(void)
{
    /* user code [DMA0_Channel1_IRQn local 0] begin */

    /* user code [DMA0_Channel1_IRQn local 0] end */

    /* user code [DMA0_Channel1_IRQn local 1] begin */

    /* user code [DMA0_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel2GlobalInterrupt ??== true && NVIC_DMA0Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel2_IRQHandler(void)
{
    /* user code [DMA0_Channel2_IRQn local 0] begin */

    /* user code [DMA0_Channel2_IRQn local 0] end */

    /* user code [DMA0_Channel2_IRQn local 1] begin */

    /* user code [DMA0_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel3GlobalInterrupt ??== true && NVIC_DMA0Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel3_IRQHandler(void)
{
    /* user code [DMA0_Channel3_IRQn local 0] begin */

    /* user code [DMA0_Channel3_IRQn local 0] end */

    /* user code [DMA0_Channel3_IRQn local 1] begin */

    /* user code [DMA0_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel4GlobalInterrupt ??== true && NVIC_DMA0Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel4_IRQHandler(void)
{
    /* user code [DMA0_Channel4_IRQn local 0] begin */

    /* user code [DMA0_Channel4_IRQn local 0] end */

    /* user code [DMA0_Channel4_IRQn local 1] begin */

    /* user code [DMA0_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel5GlobalInterrupt ??== true && NVIC_DMA0Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel5_IRQHandler(void)
{
    /* user code [DMA0_Channel5_IRQn local 0] begin */

    /* user code [DMA0_Channel5_IRQn local 0] end */

    /* user code [DMA0_Channel5_IRQn local 1] begin */

    /* user code [DMA0_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel6GlobalInterrupt ??== true && NVIC_DMA0Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel6_IRQHandler(void)
{
    /* user code [DMA0_Channel6_IRQn local 0] begin */

    /* user code [DMA0_Channel6_IRQn local 0] end */

    /* user code [DMA0_Channel6_IRQn local 1] begin */

    /* user code [DMA0_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_ADCGlobalInterrupt ??== true && NVIC_ADCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ADC Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ADC_IRQHandler(void)
{
    /* user code [ADC_IRQn local 0] begin */

    /* user code [ADC_IRQn local 0] end */

    /* user code [ADC_IRQn local 1] begin */

    /* user code [ADC_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0TxInterrupt ??== true && NVIC_CAN0TxInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 TX Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_TX_IRQHandler (void)
{
    /* user code [CAN0_TX_IRQn local 0] begin */

    /* user code [CAN0_TX_IRQn local 0] end */

    /* user code [CAN0_TX_IRQn local 1] begin */

    /* user code [CAN0_TX_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0Rx0Interrupt ??== true && NVIC_CAN0Rx0Interrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 RX0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_RX0_IRQHandler (void)
{
    /* user code [CAN0_RX0_IRQn local 0] begin */

    /* user code [CAN0_RX0_IRQn local 0] end */

    /* user code [CAN0_RX0_IRQn local 1] begin */

    /* user code [CAN0_RX0_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0Rx1Interrupt ??== true && NVIC_CAN0Rx1Interrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 RX1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_RX1_IRQHandler (void)
{
    /* user code [CAN0_RX1_IRQn local 0] begin */

    /* user code [CAN0_RX1_IRQn local 0] end */

    /* user code [CAN0_RX1_IRQn local 1] begin */

    /* user code [CAN0_RX1_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN0EWMCInterrupt ??== true && NVIC_CAN0EWMCInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN0 EWMC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN0_EWMC_IRQHandler (void)
{
    /* user code [CAN0_EWMC_IRQn local 0] begin */

    /* user code [CAN0_EWMC_IRQn local 0] end */

    /* user code [CAN0_EWMC_IRQn local 1] begin */

    /* user code [CAN0_EWMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine59Interrupt ??== true && NVIC_EXTILine59Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI5_9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI5_9_IRQHandler(void)
{
    /* user code [EXTI5_9_IRQn local 0] begin */

    /* user code [EXTI5_9_IRQn local 0] end */

    /* user code [EXTI5_9_IRQn local 1] begin */

    /* user code [EXTI5_9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0BreakAndTIMER8GlobalInterrupt ??== true && NVIC_TIMER0BreakAndTIMER8GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Break And TIMER8 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_BRK_TIMER8_IRQHandler(void)
{
    /* user code [TIMER0_BRK_TIMER8_IRQn local 0] begin */

    /* user code [TIMER0_BRK_TIMER8_IRQn local 0] end */

    /* user code [TIMER0_BRK_TIMER8_IRQn local 1] begin */

    /* user code [TIMER0_BRK_TIMER8_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0UpdateAndTIMER9GlobalInterrupt ??== true && NVIC_TIMER0UpdateAndTIMER9GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Update And TIMER9 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_UP_TIMER9_IRQHandler(void)
{
    /* user code [TIMER0_UP_TIMER9_IRQn local 0] begin */

    /* user code [TIMER0_UP_TIMER9_IRQn local 0] end */

    /* user code [TIMER0_UP_TIMER9_IRQn local 1] begin */

    /* user code [TIMER0_UP_TIMER9_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0TriggerChannelCommutationAndTIMER10GlobalInterrupt ??== true && NVIC_TIMER0TriggerChannelCommutationAndTIMER10GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Trigger And Commutation And TIMER8 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_TRG_CMT_TIMER10_IRQHandler(void)
{
    /* user code [TIMER0_TRG_CMT_TIMER10_IRQn local 0] begin */

    /* user code [TIMER0_TRG_CMT_TIMER10_IRQn local 0] end */

    /* user code [TIMER0_TRG_CMT_TIMER10_IRQn local 1] begin */

    /* user code [TIMER0_TRG_CMT_TIMER10_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER0CaptureCompareInterrupt ??== true && NVIC_TIMER0CaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER0 Channel Capture Compare Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER0_Channel_IRQHandler(void)
{
    /* user code [TIMER0_Channel_IRQn local 0] begin */

    /* user code [TIMER0_Channel_IRQn local 0] end */

    /* user code [TIMER0_Channel_IRQn local 1] begin */

    /* user code [TIMER0_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER1GlobalInterrupt ??== true && NVIC_TIMER1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER1_IRQHandler(void)
{
    /* user code [TIMER1_IRQn local 0] begin */

    /* user code [TIMER1_IRQn local 0] end */

    /* user code [TIMER1_IRQn local 1] begin */

    /* user code [TIMER1_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER2GlobalInterrupt ??== true && NVIC_TIMER2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER2_IRQHandler(void)
{
    /* user code [TIMER2_IRQn local 0] begin */

    /* user code [TIMER2_IRQn local 0] end */

    /* user code [TIMER2_IRQn local 1] begin */

    /* user code [TIMER2_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER3GlobalInterrupt ??== true && NVIC_TIMER3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER3_IRQHandler(void)
{
    /* user code [TIMER3_IRQn local 0] begin */

    /* user code [TIMER3_IRQn local 0] end */

    /* user code [TIMER3_IRQn local 1] begin */

    /* user code [TIMER3_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0EventInterrupt ??== true && NVIC_I2C0EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_EV_IRQHandler(void)
{
    /* user code [I2C0_EV_IRQn local 0] begin */

    /* user code [I2C0_EV_IRQn local 0] end */

    /* user code [I2C0_EV_IRQn local 1] begin */

    /* user code [I2C0_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C0ErrorInterrupt ??== true && NVIC_I2C0ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C0 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C0_ER_IRQHandler(void)
{
    /* user code [I2C0_ER_IRQn local 0] begin */

    /* user code [I2C0_ER_IRQn local 0] end */

    /* user code [I2C0_ER_IRQn local 1] begin */

    /* user code [I2C0_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1EventInterrupt ??== true && NVIC_I2C1EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_EV_IRQHandler(void)
{
    /* user code [I2C1_EV_IRQn local 0] begin */

    /* user code [I2C1_EV_IRQn local 0] end */

    /* user code [I2C1_EV_IRQn local 1] begin */

    /* user code [I2C1_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C1ErrorInterrupt ??== true && NVIC_I2C1ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C1 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C1_ER_IRQHandler(void)
{
    /* user code [I2C1_ER_IRQn local 0] begin */

    /* user code [I2C1_ER_IRQn local 0] end */

    /* user code [I2C1_ER_IRQn local 1] begin */

    /* user code [I2C1_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI0GlobalInterrupt ??== true && NVIC_SPI0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI0_IRQHandler(void)
{
    /* user code [SPI0_IRQn local 0] begin */

    /* user code [SPI0_IRQn local 0] end */

    /* user code [SPI0_IRQn local 1] begin */

    /* user code [SPI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI1GlobalInterrupt ??== true && NVIC_SPI1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI1_IRQHandler(void)
{
    /* user code [SPI1_IRQn local 0] begin */

    /* user code [SPI1_IRQn local 0] end */

    /* user code [SPI1_IRQn local 1] begin */

    /* user code [SPI1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART0GlobalInterrupt ??== true && NVIC_USART0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART0 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART0_IRQHandler(void)
{
    /* user code [USART0_IRQn local 0] begin */

    /* user code [USART0_IRQn local 0] end */

    /* user code [USART0_IRQn local 1] begin */

    /* user code [USART0_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART1GlobalInterrupt ??== true && NVIC_USART1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART1 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART1_IRQHandler(void)
{
    /* user code [USART1_IRQn local 0] begin */

    /* user code [USART1_IRQn local 0] end */

    /* user code [USART1_IRQn local 1] begin */

    /* user code [USART1_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART2GlobalInterrupt ??== true && NVIC_USART2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART2_IRQHandler(void)
{
    /* user code [USART2_IRQn local 0] begin */

    /* user code [USART2_IRQn local 0] end */

    /* user code [USART2_IRQn local 1] begin */

    /* user code [USART2_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXTILine1015Interrupt ??== true && NVIC_EXTILine1015Interrupt_Enabled == "TRUE"]
/*!
    \brief      EXTI10_15 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXTI10_15_IRQHandler(void)
{
    /* user code [EXTI10_15_IRQn local 0] begin */

    /* user code [EXTI10_15_IRQn local 0] end */

    /* user code [EXTI10_15_IRQn local 1] begin */

    /* user code [EXTI10_15_IRQn local 1] end */
}

[/#if]
[#if NVIC_RTCAlarmFromEXTIInterrupt ??== true && NVIC_RTCAlarmFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      RTC Alarm From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void RTC_Alarm_IRQHandler(void)
{
    /* user code [RTC_Alarm_IRQn local 0] begin */

    /* user code [RTC_Alarm_IRQn local 0] end */

    /* user code [RTC_Alarm_IRQn local 1] begin */

    /* user code [RTC_Alarm_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBFSWakeupFromEXTIInterrupt ??== true && NVIC_USBFSWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBFS Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBFS_WKUP_IRQHandler(void)
{
    /* user code [USBFS_WKUP_IRQn local 0] begin */

    /* user code [USBFS_WKUP_IRQn local 0] end */

    /* user code [USBFS_WKUP_IRQn local 1] begin */

    /* user code [USBFS_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7BreakAndTIMER11GlobalInterrupt  ??== true && NVIC_TIMER7BreakAndTIMER11GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Break and TIMER11 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_BRK_TIMER11_IRQHandler(void)
{
    /* user code [TIMER7_BRK_TIMER11_IRQn local 0] begin */

    /* user code [TIMER7_BRK_TIMER11_IRQn local 0] end */

    /* user code [TIMER7_BRK_TIMER11_IRQn local 1] begin */

    /* user code [TIMER7_BRK_TIMER11_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7UpdateAndTIMER12GlobalInterrupt ??== true && NVIC_TIMER7UpdateAndTIMER12GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 Wakeup and TIMER12 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_UP_TIMER12_IRQHandler(void)
{
    /* user code [TIMER7_UP_TIMER12_IRQn local 0] begin */

    /* user code [TIMER7_UP_TIMER12_IRQn local 0] end */

    /* user code [TIMER7_UP_TIMER12_IRQn local 1] begin */

    /* user code [TIMER7_UP_TIMER12_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7TriggerChannelCommutationAndTIMER13GlobalInterrupt ??== true && NVIC_TIMER7TriggerChannelCommutationAndTIMER13GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 trigger and commutation and TIMER13 interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_TRG_CMT_TIMER13_IRQHandler(void)
{
    /* user code [TIMER7_TRG_CMT_TIMER13_IRQn local 0] begin */

    /* user code [TIMER7_TRG_CMT_TIMER13_IRQn local 0] end */

    /* user code [TIMER7_TRG_CMT_TIMER13_IRQn local 1] begin */

    /* user code [TIMER7_TRG_CMT_TIMER13_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER7CaptureCompareInterrupt ??== true && NVIC_TIMER7CaptureCompareInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER7 channel capture compare interrupt
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER7_Channel_IRQHandler(void)
{
    /* user code [TIMER7_Channel_IRQn local 0] begin */

    /* user code [TIMER7_Channel_IRQn local 0] end */

    /* user code [TIMER7_Channel_IRQn local 1] begin */

    /* user code [TIMER7_Channel_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA0Channel7GlobalInterrupt ??== true && NVIC_DMA0Channel7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA0 Channel7 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA0_Channel7_IRQHandler(void)
{
    /* user code [DMA0_Channel7_IRQn local 0] begin */

    /* user code [DMA0_Channel7_IRQn local 0] end */

    /* user code [DMA0_Channel7_IRQn local 1] begin */

    /* user code [DMA0_Channel7_IRQn local 1] end */
}

[/#if]
[#if NVIC_EXMCGlobalInterrupt ??== true && NVIC_EXMCGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      EXMC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void EXMC_IRQHandler(void)
{
    /* user code [EXMC_IRQn local 0] begin */

    /* user code [EXMC_IRQn local 0] end */

    /* user code [EXMC_IRQn local 1] begin */

    /* user code [EXMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_SDIOGlobalInterrupt ??== true && NVIC_SDIOGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SDIO Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SDIO_IRQHandler (void)
{
    /* user code [SDIO_IRQn local 0] begin */

    /* user code [SDIO_IRQn local 0] end */

    /* user code [SDIO_IRQn local 1] begin */

    /* user code [SDIO_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER4GlobalInterrupt ??== true && NVIC_TIMER4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER4_IRQHandler(void)
{
    /* user code [TIMER4_IRQn local 0] begin */

    /* user code [TIMER4_IRQn local 0] end */

    /* user code [TIMER4_IRQn local 1] begin */

    /* user code [TIMER4_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI2GlobalInterrupt ??== true && NVIC_SPI2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI2 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI2_IRQHandler(void)
{
    /* user code [SPI2_IRQn local 0] begin */

    /* user code [SPI2_IRQn local 0] end */

    /* user code [SPI2_IRQn local 1] begin */

    /* user code [SPI2_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART3GlobalInterrupt ??== true && NVIC_UART3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART3_IRQHandler(void)
{
    /* user code [UART3_IRQn local 0] begin */

    /* user code [UART3_IRQn local 0] end */

    /* user code [UART3_IRQn local 1] begin */

    /* user code [UART3_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART4GlobalInterrupt ??== true && NVIC_UART4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART4_IRQHandler(void)
{
    /* user code [UART4_IRQn local 0] begin */

    /* user code [UART4_IRQn local 0] end */

    /* user code [UART4_IRQn local 1] begin */

    /* user code [UART4_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER5GlobalInterruptAndDAC0_OUT0DAC0_OUT1UnderrunErrorInterrupt ??== true && NVIC_TIMER5GlobalInterruptAndDAC0_OUT0DAC0_OUT1UnderrunErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER5 And DAC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER5_DAC_IRQHandler(void)
{
    /* user code [TIMER5_DAC_IRQn local 0] begin */

    /* user code [TIMER5_DAC_IRQn local 0] end */

    /* user code [TIMER5_DAC_IRQn local 1] begin */

    /* user code [TIMER5_DAC_IRQn local 1] end */
}

[/#if]
[#if NVIC_TIMER6GlobalInterrupt ??== true && NVIC_TIMER6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TIMER6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TIMER6_IRQHandler(void)
{
    /* user code [TIMER6_IRQn local 0] begin */

    /* user code [TIMER6_IRQn local 0] end */

    /* user code [TIMER6_IRQn local 1] begin */

    /* user code [TIMER6_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel0GlobalInterrupt ??== true && NVIC_DMA1Channel0GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel0_IRQHandler(void)
{
    /* user code [DMA1_Channel0_IRQn local 0] begin */

    /* user code [DMA1_Channel0_IRQn local 0] end */

    /* user code [DMA1_Channel0_IRQn local 1] begin */

    /* user code [DMA1_Channel0_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel1GlobalInterrupt ??== true && NVIC_DMA1Channel1GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel1_IRQHandler(void)
{
    /* user code [DMA1_Channel1_IRQn local 0] begin */

    /* user code [DMA1_Channel1_IRQn local 0] end */

    /* user code [DMA1_Channel1_IRQn local 1] begin */

    /* user code [DMA1_Channel1_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel2GlobalInterrupt ??== true && NVIC_DMA1Channel2GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel2 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel2_IRQHandler(void)
{
    /* user code [DMA1_Channel2_IRQn local 0] begin */

    /* user code [DMA1_Channel2_IRQn local 0] end */

    /* user code [DMA1_Channel2_IRQn local 1] begin */

    /* user code [DMA1_Channel2_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel3GlobalInterrupt ??== true && NVIC_DMA1Channel3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel3 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel3_IRQHandler(void)
{
    /* user code [DMA1_Channel3_IRQn local 0] begin */

    /* user code [DMA1_Channel3_IRQn local 0] end */

    /* user code [DMA1_Channel3_IRQn local 1] begin */

    /* user code [DMA1_Channel3_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel4GlobalInterrupt ??== true && NVIC_DMA1Channel4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel4 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel4_IRQHandler(void)
{
    /* user code [DMA1_Channel4_IRQn local 0] begin */

    /* user code [DMA1_Channel4_IRQn local 0] end */

    /* user code [DMA1_Channel4_IRQn local 1] begin */

    /* user code [DMA1_Channel4_IRQn local 1] end */
}

[/#if]
[#if NVIC_EthernetGlobalInterrupt ??== true && NVIC_EthernetGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      ENET Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET_IRQHandler(void)
{
    /* user code [ENET_IRQn local 0] begin */

    /* user code [ENET_IRQn local 0] end */
[#if Peripherals?contains("#FREERTOS#") == true]
    [#if Peripherals?contains("#LWIP#") == true]

    portBASE_TYPE xHigherPriorityTaskWoken = pdFALSE;

    /* frame received */
    if(SET == enet_interrupt_flag_get(ENET_DMA_INT_FLAG_RS)) {
        /* give the semaphore to wakeup LwIP task */
        xSemaphoreGiveFromISR(g_rx_semaphore, &xHigherPriorityTaskWoken);
    }

    /* clear the enet DMA Rx interrupt pending bits */
    enet_interrupt_flag_clear(ENET_DMA_INT_FLAG_RS_CLR);
    enet_interrupt_flag_clear(ENET_DMA_INT_FLAG_NI_CLR);

    /* switch tasks if necessary */
    if(pdFALSE != xHigherPriorityTaskWoken) {
        portEND_SWITCHING_ISR(xHigherPriorityTaskWoken);
    }

    [/#if]
[#else]

[/#if]
    /* user code [ENET_IRQn local 1] begin */

    /* user code [ENET_IRQn local 1] end */
}

[/#if]
[#if NVIC_EthernetWakeupFromEXTIInterrupt ??== true && NVIC_EthernetWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      ENET Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void ENET_WKUP_IRQHandler (void)
{
    /* user code [ENET_WKUP_IRQn local 0] begin */

    /* user code [ENET_WKUP_IRQn local 0] end */

    /* user code [ENET_WKUP_IRQn local 1] begin */

    /* user code [ENET_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1TxInterrupt ??== true && NVIC_CAN1TxInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 TX Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_TX_IRQHandler (void)
{
    /* user code [CAN1_TX_IRQn local 0] begin */

    /* user code [CAN1_TX_IRQn local 0] end */

    /* user code [CAN1_TX_IRQn local 1] begin */

    /* user code [CAN1_TX_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1Rx0Interrupt ??== true && NVIC_CAN1Rx0Interrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 RX0 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_RX0_IRQHandler (void)
{
    /* user code [CAN1_RX0_IRQn local 0] begin */

    /* user code [CAN1_RX0_IRQn local 0] end */

    /* user code [CAN1_RX0_IRQn local 1] begin */

    /* user code [CAN1_RX0_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1Rx1Interrupt ??== true && NVIC_CAN1Rx1Interrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 RX1 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_RX1_IRQHandler (void)
{
    /* user code [CAN1_RX1_IRQn local 0] begin */

    /* user code [CAN1_RX1_IRQn local 0] end */

    /* user code [CAN1_RX1_IRQn local 1] begin */

    /* user code [CAN1_RX1_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAN1EWMCInterrupt ??== true && NVIC_CAN1EWMCInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAN1 EWMC Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAN1_EWMC_IRQHandler (void)
{
    /* user code [CAN1_EWMC_IRQn local 0] begin */

    /* user code [CAN1_EWMC_IRQn local 0] end */

    /* user code [CAN1_EWMC_IRQn local 1] begin */

    /* user code [CAN1_EWMC_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBFSGlobalInterrupt ??== true && NVIC_USBFSGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBFS Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBFS_IRQHandler(void)
{
    /* user code [USBFS_IRQn local 0] begin */

    /* user code [USBFS_IRQn local 0] end */

    /* user code [USBFS_IRQn local 1] begin */

    /* user code [USBFS_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel5GlobalInterrupt ??== true && NVIC_DMA1Channel5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel5_IRQHandler(void)
{
    /* user code [DMA1_Channel5_IRQn local 0] begin */

    /* user code [DMA1_Channel5_IRQn local 0] end */

    /* user code [DMA1_Channel5_IRQn local 1] begin */

    /* user code [DMA1_Channel5_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel6GlobalInterrupt ??== true && NVIC_DMA1Channel6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel6 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel6_IRQHandler(void)
{
    /* user code [DMA1_Channel6_IRQn local 0] begin */

    /* user code [DMA1_Channel6_IRQn local 0] end */

    /* user code [DMA1_Channel6_IRQn local 1] begin */

    /* user code [DMA1_Channel6_IRQn local 1] end */
}

[/#if]
[#if NVIC_DMA1Channel7GlobalInterrupt ??== true && NVIC_DMA1Channel7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DMA1 Channel7 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DMA1_Channel7_IRQHandler(void)
{
    /* user code [DMA1_Channel7_IRQn local 0] begin */

    /* user code [DMA1_Channel7_IRQn local 0] end */

    /* user code [DMA1_Channel7_IRQn local 1] begin */

    /* user code [DMA1_Channel7_IRQn local 1] end */
}

[/#if]
[#if NVIC_USART5GlobalInterrupt ??== true && NVIC_USART5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USART5 Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USART5_IRQHandler(void)
{
    /* user code [USART5_IRQn local 0] begin */

    /* user code [USART5_IRQn local 0] end */

    /* user code [USART5_IRQn local 1] begin */

    /* user code [USART5_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2EventInterrupt ??== true && NVIC_I2C2EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_EV_IRQHandler (void)
{
    /* user code [I2C2_EV_IRQn local 0] begin */

    /* user code [I2C2_EV_IRQn local 0] end */

    /* user code [I2C2_EV_IRQn local 1] begin */

    /* user code [I2C2_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C2ErrorInterrupt ??== true && NVIC_I2C2ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C2 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C2_ER_IRQHandler(void)
{
    /* user code [I2C2_ER_IRQn local 0] begin */

    /* user code [I2C2_ER_IRQn local 0] end */

    /* user code [I2C2_ER_IRQn local 1] begin */

    /* user code [I2C2_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHSEndpoint1OutInterrupt ??== true && NVIC_USBHSEndpoint1OutInterrupt_Enabled == "TRUE"]
/*!
    \brief       USBHS Endpoint 1 Out Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS_EP1_Out_IRQHandler(void)
{
    /* user code [USBHS_EP1_OUT_IRQn local 0] begin */

    /* user code [USBHS_EP1_OUT_IRQn local 0] end */

    /* user code [USBHS_EP1_OUT_IRQn local 1] begin */

    /* user code [USBHS_EP1_OUT_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHSEndpoint1InInterrupt ??== true && NVIC_USBHSEndpoint1InInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS Rndpoint 1 In Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS_EP1_In_IRQHandler(void)
{
    /* user code [USBHS_EP1_In_IRQn local 0] begin */

    /* user code [USBHS_EP1_In_IRQn local 0] end */

    /* user code [USBHS_EP1_In_IRQn local 1] begin */

    /* user code [USBHS_EP1_In_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHSWakeupFromEXTIInterrupt ??== true && NVIC_USBHSWakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS Wakeup Through EXTI Line Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS_WKUP_IRQHandler(void)
{
    /* user code [USBHS_WKUP_IRQn local 0] begin */

    /* user code [USBHS_WKUP_IRQn local 0] end */

    /* user code [USBHS_WKUP_IRQn local 1] begin */

    /* user code [USBHS_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_USBHSGlobalInterrupt ??== true && NVIC_USBHSGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      USBHS Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void USBHS_IRQHandler(void)
{
    /* user code [USBHS_IRQn local 0] begin */

    /* user code [USBHS_IRQn local 0] end */

    /* user code [USBHS_IRQn local 1] begin */

    /* user code [USBHS_IRQn local 1] end */
}

[/#if]
[#if NVIC_DCIGlobalInterrupt ??== true && NVIC_DCIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      DCI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void DCI_IRQHandler(void)
{
    /* user code [DCI_IRQn local 0] begin */

    /* user code [DCI_IRQn local 0] end */

    /* user code [DCI_IRQn local 1] begin */

    /* user code [DCI_IRQn local 1] end */
}

[/#if]
[#if NVIC_TRNGGlobalInterrupt ??== true && NVIC_TRNGGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TRNG Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TRNG_IRQHandler(void)
{
    /* user code [TRNG_IRQn local 0] begin */

    /* user code [TRNG_IRQn local 0] end */

    /* user code [TRNG_IRQn local 1] begin */

    /* user code [TRNG_IRQn local 1] end */
}

[/#if]
[#if NVIC_FPUGlobalInterrupt ??== true && NVIC_FPUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      FPU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void FPU_IRQHandler(void)
{
    /* user code [FPU_IRQn local 0] begin */

    /* user code [FPU_IRQn local 0] end */

    /* user code [FPU_IRQn local 1] begin */

    /* user code [FPU_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART6GlobalInterrupt ??== true && NVIC_UART6GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART6 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART6_IRQHandler(void)
{
    /* user code [UART6_IRQn local 0] begin */

    /* user code [UART6_IRQn local 0] end */

    /* user code [UART6_IRQn local 1] begin */

    /* user code [UART6_IRQn local 1] end */
}

[/#if]
[#if NVIC_UART7GlobalInterrupt ??== true && NVIC_UART7GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      UART7 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void UART7_IRQHandler(void)
{
    /* user code [UART7_IRQn local 0] begin */

    /* user code [UART7_IRQn local 0] end */

    /* user code [UART7_IRQn local 1] begin */

    /* user code [UART7_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI3GlobalInterrupt ??== true && NVIC_SPI3GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI3 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI3_IRQHandler(void)
{
    /* user code [SPI3_IRQn local 0] begin */

    /* user code [SPI3_IRQn local 0] end */

    /* user code [SPI3_IRQn local 1] begin */

    /* user code [SPI3_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI4GlobalInterrupt ??== true && NVIC_SPI4GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI4 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI4_IRQHandler(void)
{
    /* user code [SPI4_IRQn local 0] begin */

    /* user code [SPI4_IRQn local 0] end */

    /* user code [SPI4_IRQn local 1] begin */

    /* user code [SPI4_IRQn local 1] end */
}

[/#if]
[#if NVIC_SPI5GlobalInterrupt ??== true && NVIC_SPI5GlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SPI5 Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SPI5_IRQHandler(void)
{
    /* user code [SPI5_IRQn local 0] begin */

    /* user code [SPI5_IRQn local 0] end */

    /* user code [SPI5_IRQn local 1] begin */

    /* user code [SPI5_IRQn local 1] end */
}

[/#if]
[#if NVIC_SAIGlobalInterrupt ??== true && NVIC_SAIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      SAI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void SAI_IRQHandler (void)
{
    /* user code [SAI0_IRQn local 0] begin */

    /* user code [SAI0_IRQn local 0] end */

    /* user code [SAI0_IRQn local 1] begin */

    /* user code [SAI0_IRQn local 1] end */
}

[/#if]
[#if NVIC_TLIGlobalInterrupt ??== true && NVIC_TLIGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      TLI Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TLI_IRQHandler(void)
{
    /* user code [TLI_IRQn local 0] begin */

    /* user code [TLI_IRQn local 0] end */

    /* user code [TLI_IRQn local 1] begin */

    /* user code [TLI_IRQn local 1] end */
}

[/#if]
[#if NVIC_TLIGlobalErrorInterrupt ??== true && NVIC_TLIGlobalErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      TLI Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void TLI_ER_IRQHandler(void)
{
    /* user code [TLI_ER_IRQn local 0] begin */

    /* user code [TLI_ER_IRQn local 0] end */

    /* user code [TLI_ER_IRQn local 1] begin */

    /* user code [TLI_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_IPAGlobalInterrupt ??== true && NVIC_IPAGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      IPA Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void IPA_IRQHandler(void)
{
    /* user code [IPA_IRQn local 0] begin */

    /* user code [IPA_IRQn local 0] end */

    /* user code [IPA_IRQn local 1] begin */

    /* user code [IPA_IRQn local 1] end */
}

[/#if]
[#if NVIC_PKCAUGlobalInterrupt ??== true && NVIC_PKCAUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      PKCAU Global Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void PKCAU_IRQHandler(void)
{
    /* user code [PKCAU_IRQn local 0] begin */

    /* user code [PKCAU_IRQn local 0] end */

    /* user code [PKCAU_IRQn local 1] begin */

    /* user code [PKCAU_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3EventInterrupt ??== true && NVIC_I2C3EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_EV_IRQHandler(void)
{
    /* user code [I2C3_EV_IRQn local 0] begin */

    /* user code [I2C3_EV_IRQn local 0] end */

    /* user code [I2C3_EV_IRQn local 1] begin */

    /* user code [I2C3_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3ErrorInterrupt ??== true && NVIC_I2C3ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_ER_IRQHandler(void)
{
    /* user code [I2C3_ER_IRQn local 0] begin */

    /* user code [I2C3_ER_IRQn local 0] end */

    /* user code [I2C3_ER_IRQn local 1] begin */

    /* user code [I2C3_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C4EventInterrupt ??== true && NVIC_I2C4EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C4 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C4_EV_IRQHandler(void)
{
    /* user code [I2C4_EV_IRQn local 0] begin */

    /* user code [I2C4_EV_IRQn local 0] end */

    /* user code [I2C4_EV_IRQn local 1] begin */

    /* user code [I2C4_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C4ErrorInterrupt ??== true && NVIC_I2C4ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C4 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C4_ER_IRQHandler(void)
{
    /* user code [I2C4_ER_IRQn local 0] begin */

    /* user code [I2C4_ER_IRQn local 0] end */

    /* user code [I2C4_ER_IRQn local 1] begin */

    /* user code [I2C4_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C5EventInterrupt ??== true && NVIC_I2C5EventInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C5 Event From EXTI Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C5_EV_IRQHandler(void)
{
    /* user code [I2C5_EV_IRQn local 0] begin */

    /* user code [I2C5_EV_IRQn local 0] end */

    /* user code [I2C5_EV_IRQn local 1] begin */

    /* user code [I2C5_EV_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C5ErrorInterrupt ??== true && NVIC_I2C5ErrorInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C5 Error Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C5_ER_IRQHandler(void)
{
    /* user code [I2C5_ER_IRQn local 0] begin */

    /* user code [I2C5_ER_IRQn local 0] end */

    /* user code [I2C5_ER_IRQn local 1] begin */

    /* user code [I2C5_ER_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C3WakeupFromEXTIInterrupt ??== true && NVIC_I2C3WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C3 Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C3_WKUP_IRQHandler(void)
{
    /* user code [I2C3_WKUP_IRQn local 0] begin */

    /* user code [I2C3_WKUP_IRQn local 0] end */

    /* user code [I2C3_WKUP_IRQn local 1] begin */

    /* user code [I2C3_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C4WakeupFromEXTIInterrupt ??== true && NVIC_I2C4WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C4 Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C4_WKUP_IRQHandler(void)
{
    /* user code [I2C4_WKUP_IRQn local 0] begin */

    /* user code [I2C4_WKUP_IRQn local 0] end */

    /* user code [I2C4_WKUP_IRQn local 1] begin */

    /* user code [I2C4_WKUP_IRQn local 1] end */
}

[/#if]
[#if NVIC_I2C5WakeupFromEXTIInterrupt ??== true && NVIC_I2C5WakeupFromEXTIInterrupt_Enabled == "TRUE"]
/*!
    \brief      I2C5 Wakeup Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void I2C5_WKUP_IRQHandler(void)
{
    /* user code [I2C5_WKUP_IRQn local 0] begin */

    /* user code [I2C5_WKUP_IRQn local 0] end */

    /* user code [I2C5_WKUP_IRQn local 1] begin */

    /* user code [I2C5_WKUP_IRQn local 1] end */
}

[/#if]

[#if NVIC_HAUGlobalInterrupt ??== true && NVIC_HAUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      HAU Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void HAU_IRQHandler(void)
{
    /* user code [HAU_IRQn local 0] begin */

    /* user code [HAU_IRQn local 0] end */

    /* user code [HAU_IRQn local 1] begin */

    /* user code [HAU_IRQn local 1] end */
}

[/#if]
[#if NVIC_CAUGlobalInterrupt ??== true && NVIC_CAUGlobalInterrupt_Enabled == "TRUE"]
/*!
    \brief      CAU Interrupt Handler
    \param[in]  none
    \param[out] none
    \retval     none
*/
void CAU_IRQHandler(void)
{
    /* user code [CAU_IRQn local 0] begin */

    /* user code [CAU_IRQn local 0] end */

    /* user code [CAU_IRQn local 1] begin */

    /* user code [CAU_IRQn local 1] end */
}

[/#if]
