/*********************************************************************
*              SEGGER MICROCONTROLLER GmbH & Co. KG                  *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2010 SEGGER Microcontroller GmbH & Co. KG               *
*                                                                    *
* Internet: www.segger.com Support: support@segger.com               *
*                                                                    *
**********************************************************************
----------------------------------------------------------------------
File    : low_level_init.c
Purpose : Low-level initialization of the device
---------------------------END-OF-HEADER------------------------------
*/

/*********************************************************************
*
*       Defines, watchdog registers macros
*
**********************************************************************
*/
#define WDOG_STCTRLH *((volatile unsigned short *)0x40052000)
#define WDOG_UNLOCK  *((volatile unsigned short *)0x4005200E)

/*********************************************************************
*
*       __low_level_init
*
*  Function description
*    Performs low-level initialization of the device.
*    For this device, we disable the watchdog.
*/
int __low_level_init(void) {
  unsigned short v;
  //
  // Get current watchdog settings
  //
  v = WDOG_STCTRLH;
  v &= ~1UL;  // Clear watchdog enable bit
  //
  // Unlock write access to the watchdog registers
  //
  WDOG_UNLOCK  = 0xC520;
  WDOG_UNLOCK  = 0xD928;
  //
  // Disable watchdog
  //
  WDOG_STCTRLH = v;
  return 1;
}

