#**********************************************************************
#*               SEGGER MICROCONTROLLER GmbH GmbH & Co KG             *
#*       Solutions for real time microcontroller applications         *
#**********************************************************************
#*                                                                    *
#*       (c) 1995 - 2007  SEGGER Microcontroller GmbH & Co KG         *
#*                                                                    *
#*       www.segger.com     Support: support@segger.com               *
#*                                                                    *
#**********************************************************************
#*                                                                    *
#*       embOS * Real time operating system for microcontrollers      *
#*                                                                    *
#*                                                                    *
#*       Please note:                                                 *
#*                                                                    *
#*       Knowledge of this file may under no circumstances            *
#*       be used to write a similar product or a real-time            *
#*       operating system for in-house use.                           *
#*                                                                    *
#*       Thank you for your fairness !                                *
#*                                                                    *
#**********************************************************************
#*                                                                    *
#*       embOS version: 3.52e                                         *
#*                                                                    *
#**********************************************************************
#
#----------------------------------------------------------------------
#File   : LPC2xxx_RAM_JLink.gdb
#Purpose: GDB command file for NXP LPC2xxx series +
#                              J-Link (J-Link GDB Server)
#                              RAM is mapped at 0x00000000-0x00000040
#-------- END-OF-HEADER -----------------------------------------------
#
# Connect to the J-Link gdb server
target remote localhost:2331
# Set gdb server to little endian
monitor endian little
# Set speed to JTAG speed adaptive
monitor speed adaptive
# Reset the target
monitor reset 0
# Map at the first 64 bytes the internal SRAM
monitor long 0xE01FC040 = 0x00000002
# Setup GDB for faster downloads
set remote memory-write-packet-size 1024
set remote memory-write-packet-size fixed
# Set a break at main() 
break main
# Load the ELF-file
load
# Let the application run to main()
continue