/*********************************************************************
*                     SEGGER Microcontroller GmbH                    *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2022 SEGGER Microcontroller GmbH                  *
*                                                                    *
*       Internet: segger.com  Support: support_embos@segger.com      *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system                           *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       OS version: V5.18.0.0                                        *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------
File    : OS_StartLEDBlink.c
Purpose : embOS sample program running two simple tasks, each toggling
          an LED of the target hardware (as configured in BSP.c).
*/

#include "RTOS.h"
#include "BSP.h"

static OS_STACKPTR int StackHP[128], StackLP[128];  // Task stacks
static OS_TASK         TCBHP, TCBLP;                // Task control blocks
static int _Cnt1;
static int _Cnt2;

/*********************************************************************
*
*       _Ramfunc_Loop()
*
*  Function description
*    To demonstrate usage of ramfuncs with trace
*/
__attribute((section(".fast")))static void _Ramfunc_Loop(void) {
  volatile int i = 10000;
  while (i--);
}

/*********************************************************************
*
*       _Flashfunc_Loop()
*
*  Function description
*    Same function as ramfunc. Demonstrates impact of bus wait states
*    on function runtime 
*/
static void _Flashfunc_Loop(void) {
  volatile int i = 10000;
  while (i--);
}

/*********************************************************************
*
*       HPTask()
*
*  Function description
*    Toggles LED0, counts _Cnt1 up and resets it
*    and runs a ramfunc and flashfunc in comparison
*
*/
static void HPTask(void) {  
  while (1) {
    BSP_ToggleLED(0);
    _Cnt1++;
    if (_Cnt1 == 100) {
      _Cnt1 = 0;
    }
    OS_TASK_Delay(1);
    _Ramfunc_Loop();
    OS_TASK_Delay(1);
    _Flashfunc_Loop();
    OS_TASK_Delay(50);
  }
}

/*********************************************************************
*
*       LPTask()
*  Function description
*    Toggles LED1, counts _Cnt2 up and resets it
*
*/
static void LPTask(void) {
  while (1) {
    BSP_ToggleLED(1);
    _Cnt2++;
    if (_Cnt2 == 100) {
      _Cnt2 = 0;
    }
    OS_TASK_Delay(200);
  }
}

/*********************************************************************
*
*       main()
*/
int main(void) {
  OS_Init();    // Initialize embOS
  OS_InitHW();  // Initialize required hardware
  BSP_Init();   // Initialize LED ports
  OS_TASK_CREATE(&TCBHP, "HP Task", 100, HPTask, StackHP);
  OS_TASK_CREATE(&TCBLP, "LP Task",  50, LPTask, StackLP);
  OS_Start();   // Start embOS
  return 0;
}

/*************************** End of file ****************************/
