/*********************************************************************
*              SEGGER MICROCONTROLLER GmbH & Co. KG                  *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2011 SEGGER Microcontroller GmbH & Co. KG               *
*                                                                    *
* Internet: www.segger.com Support: support@segger.com               *
*                                                                    *
**********************************************************************
----------------------------------------------------------------------
File    : RTOSVect.c
Purpose : Vector table for LPC4350 Cortex-M0 core.
---------------------------END-OF-HEADER------------------------------
*/

typedef void( *intfunc )( void );
typedef union { intfunc __fun; void * __ptr; } intvec_elem;

#define OS_TEST 0

#ifdef __ICCARM__
  #pragma language=extended
  #if (__VER__ < 500)
    #pragma segment="CSTACK"
    extern void __program_start(void);
  #else
    #pragma section="CSTACK"
    extern void __iar_program_start(void);
  #endif  // #if (__VER__ < 500)
#endif    // #ifdef __ICCARM__

#ifdef __CC_ARM
  extern unsigned int Image$$CSTACK$$ZI$$Limit;
  extern void __main(void);
#endif

static void OS_Systick               (void) {}
static void OS_COM_IsrHandler        (void) {}
extern void OS_USER_irq_func(void);
static void OS_Exception             (void) {}

static void NMIException             (void) {}
static void HardFaultException       (void) {}
static void MemManageException       (void) {}
static void BusFaultException        (void) {}
static void UsageFaultException      (void) {}
static void DebugMonitor             (void) {}
static void SVCHandler               (void) {}
static void WWDG_IRQHandler          (void) {}
static void PVD_IRQHandler           (void) {}
static void TAMPER_IRQHandler        (void) {}
static void RTC_IRQHandler           (void) {}
static void FLASH_IRQHandler         (void) {}
static void RCC_IRQHandler           (void) {}
static void EXTI0_IRQHandler         (void) {}
static void EXTI1_IRQHandler         (void) {}
static void EXTI2_IRQHandler         (void) {}
static void EXTI3_IRQHandler         (void) {}
static void EXTI4_IRQHandler         (void) {}
static void DMAChannel1_IRQHandler   (void) {}
static void DMAChannel2_IRQHandler   (void) {}
static void DMAChannel3_IRQHandler   (void) {}
static void DMAChannel4_IRQHandler   (void) {}
static void DMAChannel5_IRQHandler   (void) {}
static void DMAChannel6_IRQHandler   (void) {}
static void DMAChannel7_IRQHandler   (void) {}
static void ADC_IRQHandler           (void) {}
static void USB_HP_CAN_TX_IRQHandler (void) {}
static void USB_LP_CAN_RX0_IRQHandler(void) {}
static void CAN_RX1_IRQHandler       (void) {}
static void CAN_SCE_IRQHandler       (void) {}
static void EXTI9_5_IRQHandler       (void) {}
static void TIM1_BRK_IRQHandler      (void) {}
static void TIM1_UP_IRQHandler       (void) {}
static void TIM1_TRG_COM_IRQHandler  (void) {}
static void TIM1_CC_IRQHandler       (void) {}
static void TIM2_IRQHandler          (void) {}
static void TIM3_IRQHandler          (void) {}
static void TIM4_IRQHandler          (void) {}
static void I2C1_EV_IRQHandler       (void) {}
static void I2C1_ER_IRQHandler       (void) {}
static void I2C2_EV_IRQHandler       (void) {}
static void I2C2_ER_IRQHandler       (void) {}
static void SPI1_IRQHandler          (void) {}
static void SPI2_IRQHandler          (void) {}
static void USART2_IRQHandler        (void) {}
static void USART3_IRQHandler        (void) {}
static void EXTI15_10_IRQHandler     (void) {}
static void RTCAlarm_IRQHandler      (void) {}
static void USBWakeUp_IRQHandler     (void) {}


#ifdef __ICCARM__
  #if (__VER__ < 500)
    #pragma location = "INTVEC"
  #else
    #pragma location = ".intvec"
  #endif  // #if (__VER__ < 500)
#endif    // #ifdef __ICCARM__
#ifdef __CC_ARM
  #pragma arm section rodata = "INTVEC"
#endif
/* STM32F10x Vector Table entries */
const intvec_elem __vector_table[] =
{
#ifdef __ICCARM__
  { .__ptr = __sfe( "CSTACK" ) },
#if (__VER__ < 500)
  __program_start,
#else
  __iar_program_start,
#endif  // #if (__VER__ >= 500)
#endif  // #ifdef __ICCARM__
#ifdef __CC_ARM
  (intfunc) &Image$$CSTACK$$ZI$$Limit,
  __main,
#endif
  NMIException,
  HardFaultException,
  MemManageException,
  BusFaultException,
  UsageFaultException,
  0, 0, 0, 0,            /* Reserved */
  SVCHandler,
  DebugMonitor,
  0,                     /* Reserved */
  OS_Exception,
  OS_Systick,
  WWDG_IRQHandler,
  PVD_IRQHandler,
  TAMPER_IRQHandler,
  RTC_IRQHandler,
  FLASH_IRQHandler,
  RCC_IRQHandler,
  EXTI0_IRQHandler,
  EXTI1_IRQHandler,
  EXTI2_IRQHandler,
  EXTI3_IRQHandler,
  EXTI4_IRQHandler,
  DMAChannel1_IRQHandler,
  DMAChannel2_IRQHandler,
  DMAChannel3_IRQHandler,
  DMAChannel4_IRQHandler,
  DMAChannel5_IRQHandler,
  DMAChannel6_IRQHandler,
  DMAChannel7_IRQHandler,
  ADC_IRQHandler,
  USB_HP_CAN_TX_IRQHandler,
  USB_LP_CAN_RX0_IRQHandler,
  CAN_RX1_IRQHandler,
  CAN_SCE_IRQHandler,
  EXTI9_5_IRQHandler,
  TIM1_BRK_IRQHandler,
#if OS_TEST
  OS_USER_irq_func,
#else
  TIM1_UP_IRQHandler,
#endif
  TIM1_TRG_COM_IRQHandler,
  TIM1_CC_IRQHandler,
  TIM2_IRQHandler,
  TIM3_IRQHandler,
  TIM4_IRQHandler,
  I2C1_EV_IRQHandler,
  I2C1_ER_IRQHandler,
  I2C2_EV_IRQHandler,
  I2C2_ER_IRQHandler,
  SPI1_IRQHandler,
  SPI2_IRQHandler,
  OS_COM_IsrHandler,
  USART2_IRQHandler,
  USART3_IRQHandler,
  EXTI15_10_IRQHandler,
  RTCAlarm_IRQHandler,
  USBWakeUp_IRQHandler,
};
