/*********************************************************************
*              SEGGER MICROCONTROLLER GmbH & Co. KG                  *
*        Solutions for real time microcontroller applications        *
**********************************************************************
*                                                                    *
*        (c) 2011 SEGGER Microcontroller GmbH & Co. KG               *
*                                                                    *
* Internet: www.segger.com Support: support@segger.com               *
*                                                                    *
**********************************************************************
----------------------------------------------------------------------
File    : Main.c
Purpose : Implementation of the main() function of the sample project.
          Waits for reception of commands send by the Cortex-M4.
---------------------------END-OF-HEADER------------------------------
*/

#define MAIN_C

#include "Main.h"

/*********************************************************************
*
*       main
*/
void main(void) {
  int i;
  //
  // Wait for command from Cortex-M4
  // If command received, send back response, so Cortex-M4 can resume execution
  //
  do {
    do {
      if (CMD_M4 == 0x1) {
        CMD_M4 = 0;
        break;
      }
    } while(1);
    RESPONSE_M0 = 2;
  } while(1);
}
