/*********************************************************************
*               SEGGER MICROCONTROLLER SYSTEME GmbH                  *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (C) 2002   SEGGER Microcontroller Systeme GmbH               *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
**********************************************************************

----------------------------------------------------------------------
File    : BSP.c 
Purpose : BSP interface for Keil LPC2378 eval board
--------  END-OF-HEADER  ---------------------------------------------
*/

#include "BSP.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/
#define FIO2DIR0 *(volatile unsigned char*)(0x3FFFC040)
#define FIO2SET0 *(volatile unsigned char*)(0x3FFFC058)
#define FIO2CLR0 *(volatile unsigned char*)(0x3FFFC05C)
#define FIO2PIN0 *(volatile unsigned char*)(0x3FFFC054)


/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/

void BSP_Init(void) {
  FIO2DIR0 = 0xFF;      // P2 (0..7) output
}

/*********************************************************************
*
*       LED switching routines
*/

void BSP_SetLED(int Index) {
  FIO2SET0 = 1 << Index;
}

void BSP_ClrLED(int Index) {
  FIO2CLR0 = 1 << Index;

}

void BSP_ToggleLED(int Index) {
  if ((FIO2PIN0) & (1 << Index)) {
    BSP_ClrLED(Index);
  } else {
    BSP_SetLED(Index);
  }
}


/****** EOF *********************************************************/

