/*********************************************************************
*               SEGGER MICROCONTROLLER GmbH GmbH & Co KG             *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2007  SEGGER Microcontroller GmbH & Co KG         *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS version: 3.52e                                         *
*                                                                    *
**********************************************************************

---------------------------------------------------------------------
File        : LPC2148_Startup.s
Purpose     : Purpose: NXP LPC2148 startup file for embOS GNUARM
---------------------------END-OF-HEADER------------------------------
*/

/*********************************************************************
*
*       Defines, used for the processor status register
*
**********************************************************************
*/
        ARM_MODE_USER  = 0x10        /* Normal User Mode                             */ 
        ARM_MODE_FIQ   = 0x11        /* FIQ Fast Interrupts Mode                     */
        ARM_MODE_IRQ   = 0x12        /* IRQ Standard Interrupts Mode                 */
        ARM_MODE_SVC   = 0x13        /* Supervisor Interrupts Mode                   */
        ARM_MODE_ABORT = 0x17        /* Abort Processing memory Faults Mode          */
        ARM_MODE_UNDEF = 0x1B        /* Undefined Instructions Mode                  */
        ARM_MODE_SYS   = 0x1F        /* System Running in Priviledged Operating Mode */
        ARM_MODE_MASK  = 0x1F
       
        I_BIT          = 0x80        /* Disables IRQ when I bit is set               */
        F_BIT          = 0x40        /* Disables FIQ when F bit is set               */

/*********************************************************************
*
*       Defines, sfr
*
**********************************************************************
*/
        MAMCR          = 0xE01FC000  /* MAM Control Register                         */
        MAMTIM         = 0xE01FC004  /* MAM Timing register                          */
   

/*********************************************************************
*
*       Vector table
*
**********************************************************************
*/
        .text
        .global  __vector
        .extern  IRQ_Handler
        .extern  Reset_Handler
         
        .arm
        .section .vectors, "ax" 
                        
__vector:
        ldr     pc,Reset_Addr   /* RESET                 vector */
        ldr     pc,Undef_Addr		/* Undefined instruction vector */
        ldr     pc,SWI_Addr		  /* Software interrupt    vector */
        ldr     pc,PAbt_Addr		/* Prefetch abort        vector */
        ldr     pc,DAbt_Addr    /* Data abort            vector */
        nop                     /* Reserved              vector */
        ldr     pc,IRQ_Addr     /* Interrupt             vector */
        ldr     pc,FIQ_Addr     /* Fast interrupt        vector */

Reset_Addr:     .word   Reset_Handler
Undef_Addr:     .word   Undef_Handler
SWI_Addr:       .word   SWI_Handler
PAbt_Addr:      .word   PAbt_Handler
DAbt_Addr:      .word   DAbt_Handler
IRQ_Addr:       .word   IRQ_Handler
FIQ_Addr:       .word   FIQ_Handler

Undef_Handler:  b       Undef_Handler
SWI_Handler:    b       SWI_Handler
PAbt_Handler:   b       PAbt_Handler
DAbt_Handler:   b       DAbt_Handler
FIQ_Handler:    b       FIQ_Handler 
__vector_end:

/**********************************************************************
* Reset_Handler
*
* Execution starts here.
* After a reset, the mode is ARM, Supervisor, interrupts disabled.
*/
        .extern  _main
        .global  Reset_Handler
        .global  end
        .arm
        .section .text, "ax"  

Reset_Handler:

/**********************************************************************
* LPC2148 Errata
* Date: August 5, 2005
* Document Release: Version 1.0
* Device Affected: LPC2148
* Incorrect read of data from SRAM after Reset and MAM is not enabled or partially enabled MAM.1
* Init MAM before acsses to SRAM
*/
        ldr   r0,=MAMCR
        ldr   r1,=MAMTIM
        ldr   r2,=0
        str   r2,[r0]
        ldr   r2,=3
        str   r2,[r1]
        ldr   r2,=2
        str   r2,[r0]

        /*
         * Setup a stack for each mode
         */    
        msr   CPSR_c, #ARM_MODE_UNDEF | I_BIT | F_BIT   /* Undefined Instruction Mode */     
        ldr   sp, =__stack_und_end__
       
        msr   CPSR_c, #ARM_MODE_ABORT | I_BIT | F_BIT   /* Abort Mode */
        ldr   sp, =__stack_abt_end__
       
        msr   CPSR_c, #ARM_MODE_FIQ   | I_BIT | F_BIT   /* FIQ Mode */   
        ldr   sp, =__stack_fiq_end__
       
        msr   CPSR_c, #ARM_MODE_IRQ   | I_BIT | F_BIT   /* IRQ Mode */   
        ldr   sp, =__stack_irq_end__
       
        msr   CPSR_c, #ARM_MODE_SVC   | I_BIT | F_BIT   /* Supervisor Mode */
        ldr   sp, =__stack_svc_end__

        /* 
         * Now enter embOS internal _main function, 
         * which does low-level and segment initialization.
         * and then calls main().
         */
        ldr   r0, =_main
        mov   lr, pc
        bx    r0
end:    b     end
        .end


        .end
