/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.log;

import com.gigadevice.log.LogConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;

public class WorkbenchListener
implements IWorkbenchListener {
    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!Thread.interrupted() && !WorkbenchListener.isComputerShutdown()) {
                    try {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS");
                        Date date = new Date();
                        String currentDate = simpleDateFormat.format(date);
                        String LogInfoFile = LogConfig.getInfoLogPath();
                        String LogErrorFile = LogConfig.getErrorLogPath();
                        boolean isSame = LogInfoFile.equals(LogErrorFile);
                        if (isSame) {
                            File InfoFile = new File(LogInfoFile);
                            if (InfoFile.exists()) {
                                FileWriter writerInfo = new FileWriter(InfoFile, true);
                                writerInfo.write(String.valueOf(System.getProperty("line.separator")) + "[" + currentDate + "] [INFO]" + System.getProperty("line.separator") + "User closes Embedded Builder.\n");
                                writerInfo.close();
                            }
                        } else {
                            File InfoFile = new File(LogInfoFile);
                            if (InfoFile.exists()) {
                                FileWriter writerInfo = new FileWriter(InfoFile, true);
                                writerInfo.write(String.valueOf(System.getProperty("line.separator")) + "[" + currentDate + "] [INFO]" + System.getProperty("line.separator") + "User closes Embedded Builder\n");
                                writerInfo.close();
                            }
                        }
                    }
                    catch (Throwable e) {
                        LogConfig.logThrowable(e);
                    }
                }
            }
        });
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isComputerShutdown() {
        try {
            String line;
            Process process = Runtime.getRuntime().exec("shutdown /q /f /t 0");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            do {
                if ((line = reader.readLine()) != null) continue;
                process.destroy();
                return false;
            } while (!line.contains("Shutting down"));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogConfig.logExceptionWithMessage("Check whether the shutdown fails!", e);
        }
        return false;
    }
}

