/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.log;

import com.gigadevice.log.LogConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;

public class PluginStartup
implements IStartup {
    private static Logger logger = LogManager.getLogger(PluginStartup.class);

    public void earlyStartup() {
        Display.getDefault().asyncExec(() -> {
            try {
                Display.getDefault().setRuntimeExceptionHandler(throwable -> this.logUncaughtThrowable((Throwable)throwable));
                Display.getDefault().setErrorHandler(Exception2 -> this.logUncaughtThrowable((Throwable)Exception2));
            }
            catch (Throwable e) {
                this.logUncaughtThrowable(e);
            }
        });
    }

    private void logUncaughtThrowable(Throwable throwable) {
        throwable.printStackTrace();
        if (LogConfig.isLog()) {
            if (throwable instanceof Error) {
                logger.fatal("", throwable);
            } else {
                logger.error("", throwable);
            }
        }
    }
}

