/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.manipulation.CUCorrectionProposalCore;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.IProblemLocationCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class TaskMarkerProposalCore
extends CUCorrectionProposalCore {
    private IProblemLocationCore fLocation;

    public TaskMarkerProposalCore(ICompilationUnit cu, IProblemLocationCore location, int relevance) {
        super("", cu, relevance);
        this.fLocation = location;
        this.setDisplayName(CorrectionMessages.TaskMarkerProposal_description);
    }

    @Override
    public void addEdits(IDocument document, TextEdit rootEdit) throws CoreException {
        super.addEdits(document, rootEdit);
        try {
            Position pos = this.getUpdatedPosition(document);
            if (pos != null) {
                rootEdit.addChild((TextEdit)new ReplaceEdit(pos.getOffset(), pos.getLength(), ""));
            } else {
                rootEdit.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), ""));
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    private Position getUpdatedPosition(IDocument document) throws BadLocationException {
        int end;
        IScanner scanner;
        IJavaProject project = this.getCompilationUnit().getJavaProject();
        if (project != null) {
            String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
            String complianceLevel = project.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (String)sourceLevel, (String)complianceLevel);
        } else {
            scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        }
        scanner.setSource(document.get().toCharArray());
        int token = this.getSurroundingComment(scanner);
        if (token == 158) {
            return null;
        }
        int commentStart = scanner.getCurrentTokenStartPosition();
        int commentEnd = scanner.getCurrentTokenEndPosition() + 1;
        int contentStart = commentStart + 2;
        int contentEnd = commentEnd;
        if (token == 1003) {
            contentStart = commentStart + 3;
            contentEnd = commentEnd - 2;
        } else if (token == 1002) {
            contentEnd = commentEnd - 2;
        }
        if (this.hasContent(document, contentStart, this.fLocation.getOffset()) || this.hasContent(document, contentEnd, this.fLocation.getOffset() + this.fLocation.getLength())) {
            return new Position(this.fLocation.getOffset(), this.fLocation.getLength());
        }
        IRegion startRegion = document.getLineInformationOfOffset(commentStart);
        int start = startRegion.getOffset();
        boolean contentAtBegining = this.hasContent(document, start, commentStart);
        if (contentAtBegining) {
            start = commentStart;
        }
        if (token == 1001) {
            end = contentAtBegining ? startRegion.getOffset() + startRegion.getLength() : commentEnd;
        } else {
            int endLine = document.getLineOfOffset(commentEnd - 1);
            if (endLine + 1 == document.getNumberOfLines() || contentAtBegining) {
                IRegion endRegion = document.getLineInformation(endLine);
                end = endRegion.getOffset() + endRegion.getLength();
            } else {
                IRegion endRegion = document.getLineInformation(endLine + 1);
                end = endRegion.getOffset();
            }
        }
        if (this.hasContent(document, commentEnd, end)) {
            end = commentEnd;
            start = commentStart;
        }
        return new Position(start, end - start);
    }

    private int getSurroundingComment(IScanner scanner) {
        try {
            int start = this.fLocation.getOffset();
            int end = start + this.fLocation.getLength();
            int token = scanner.getNextToken();
            while (token != 158) {
                if (TokenScanner.isComment(token)) {
                    int currStart = scanner.getCurrentTokenStartPosition();
                    int currEnd = scanner.getCurrentTokenEndPosition() + 1;
                    if (currStart <= start && end <= currEnd) {
                        return token;
                    }
                }
                token = scanner.getNextToken();
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return 158;
    }

    private boolean hasContent(IDocument document, int start, int end) throws BadLocationException {
        int i = start;
        while (i < end) {
            char ch = document.getChar(i);
            if (!Character.isWhitespace(ch)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

