/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.manipulation.SharedASTProviderCore;
import org.eclipse.jdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;

public class NLSHint {
    private String fAccessorName;
    private IPackageFragment fAccessorPackage;
    private String fResourceBundleName;
    private IPackageFragment fResourceBundlePackage;
    private NLSSubstitution[] fSubstitutions;

    public NLSHint(ICompilationUnit cu, CompilationUnit astRoot) {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull((Object)astRoot);
        IPackageFragment cuPackage = (IPackageFragment)cu.getAncestor(4);
        this.fAccessorName = "Messages";
        this.fAccessorPackage = cuPackage;
        this.fResourceBundleName = "messages.properties";
        this.fResourceBundlePackage = cuPackage;
        IJavaProject project = cu.getJavaProject();
        NLSLine[] lines = NLSHint.createRawLines(cu);
        AccessorClassReference accessClassRef = NLSHint.findFirstAccessorReference(lines, astRoot);
        if (accessClassRef == null) {
            ArrayList<NLSLine> eclipseNLSLines = new ArrayList<NLSLine>();
            accessClassRef = this.createEclipseNLSLines(this.getDocument(cu), astRoot, eclipseNLSLines);
            if (!eclipseNLSLines.isEmpty()) {
                NLSLine[] rawLines = lines;
                int rawLinesLength = rawLines.length;
                int eclipseLinesLength = eclipseNLSLines.size();
                lines = new NLSLine[rawLinesLength + eclipseLinesLength];
                System.arraycopy(rawLines, 0, lines, 0, rawLinesLength);
                int i = 0;
                while (i < eclipseLinesLength) {
                    lines[i + rawLinesLength] = (NLSLine)eclipseNLSLines.get(i);
                    ++i;
                }
            }
        }
        Properties props = null;
        if (accessClassRef != null) {
            props = NLSHintHelper.getProperties(project, accessClassRef);
        }
        if (props == null) {
            props = new Properties();
        }
        this.fSubstitutions = this.createSubstitutions(lines, props, astRoot);
        if (accessClassRef != null) {
            this.fAccessorName = accessClassRef.getName();
            ITypeBinding accessorClassBinding = accessClassRef.getBinding();
            try {
                String fullBundleName;
                IPackageFragment accessorPack = NLSHintHelper.getPackageOfAccessorClass(project, accessorClassBinding);
                if (accessorPack != null) {
                    this.fAccessorPackage = accessorPack;
                }
                if ((fullBundleName = accessClassRef.getResourceBundleName()) != null) {
                    this.fResourceBundleName = Signature.getSimpleName((String)fullBundleName) + ".properties";
                    String packName = Signature.getQualifier((String)fullBundleName);
                    IPackageFragment pack = NLSHintHelper.getResourceBundlePackage(project, packName, this.fResourceBundleName);
                    if (pack != null) {
                        this.fResourceBundlePackage = pack;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private AccessorClassReference createEclipseNLSLines(final IDocument document, CompilationUnit astRoot, List<NLSLine> nlsLines) {
        final AccessorClassReference[] firstAccessor = new AccessorClassReference[1];
        final TreeMap lineToNLSLine = new TreeMap();
        astRoot.accept(new ASTVisitor(){
            private ICompilationUnit fCache_CU;
            private CompilationUnit fCache_AST;

            public boolean visit(QualifiedName node) {
                ITypeBinding superType;
                ITypeBinding type = node.getQualifier().resolveTypeBinding();
                if (type != null && (superType = type.getSuperclass()) != null && NLS.class.getName().equals(superType.getQualifiedName())) {
                    Integer line;
                    try {
                        line = document.getLineOfOffset(node.getStartPosition());
                    }
                    catch (BadLocationException badLocationException) {
                        return true;
                    }
                    NLSLine nlsLine = (NLSLine)lineToNLSLine.get(line);
                    if (nlsLine == null) {
                        nlsLine = new NLSLine(line);
                        lineToNLSLine.put(line, nlsLine);
                    }
                    SimpleName name = node.getName();
                    NLSElement element = new NLSElement(node.getName().getIdentifier(), name.getStartPosition(), name.getLength(), nlsLine.size() - 1, true);
                    nlsLine.add(element);
                    ICompilationUnit bundleCU = (ICompilationUnit)type.getJavaElement().getAncestor(5);
                    if (this.fCache_CU == null || !this.fCache_CU.equals(bundleCU) || this.fCache_AST == null) {
                        this.fCache_CU = bundleCU;
                        this.fCache_AST = this.fCache_CU != null ? SharedASTProviderCore.getAST((ITypeRoot)this.fCache_CU, SharedASTProviderCore.WAIT_YES, null) : null;
                    }
                    String bundleName = NLSHintHelper.getResourceBundleName(this.fCache_AST);
                    element.setAccessorClassReference(new AccessorClassReference(type, bundleName, new Region(node.getStartPosition(), node.getLength())));
                    if (firstAccessor[0] == null) {
                        firstAccessor[0] = element.getAccessorClassReference();
                    }
                }
                return true;
            }
        });
        nlsLines.addAll(lineToNLSLine.values());
        return firstAccessor[0];
    }

    private IDocument getDocument(ICompilationUnit cu) {
        ITextFileBufferManager manager;
        IPath path;
        block10: {
            IDocument iDocument;
            path = cu.getPath();
            manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            try {
                ITextFileBuffer buffer = manager.getTextFileBuffer(path, LocationKind.NORMALIZE);
                if (buffer == null) break block10;
                iDocument = buffer.getDocument();
            }
            catch (Throwable throwable) {
                try {
                    manager.disconnect(path, LocationKind.NORMALIZE, null);
                }
                catch (CoreException coreException) {
                    return null;
                }
                throw throwable;
            }
            try {
                manager.disconnect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException coreException) {
                return null;
            }
            return iDocument;
        }
        try {
            manager.disconnect(path, LocationKind.NORMALIZE, null);
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    private NLSSubstitution[] createSubstitutions(NLSLine[] lines, Properties props, CompilationUnit astRoot) {
        ArrayList<NLSSubstitution> result = new ArrayList<NLSSubstitution>();
        NLSLine[] nLSLineArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            NLSLine line = nLSLineArray[n2];
            NLSElement[] nLSElementArray = line.getElements();
            int n3 = nLSElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                NLSElement nlsElement = nLSElementArray[n4];
                if (nlsElement.hasTag()) {
                    AccessorClassReference accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement);
                    if (accessorClassReference == null) {
                        result.add(new NLSSubstitution(1, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                    } else {
                        String key = NLSHint.stripQuotes(nlsElement.getValue());
                        String value = props.getProperty(key);
                        result.add(new NLSSubstitution(0, key, value, nlsElement, accessorClassReference));
                    }
                } else if (nlsElement.isEclipseNLS()) {
                    String key = nlsElement.getValue();
                    result.add(new NLSSubstitution(0, key, props.getProperty(key), nlsElement, nlsElement.getAccessorClassReference()));
                } else {
                    result.add(new NLSSubstitution(2, NLSHint.stripQuotes(nlsElement.getValue()), nlsElement));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new NLSSubstitution[result.size()]);
    }

    private static AccessorClassReference findFirstAccessorReference(NLSLine[] lines, CompilationUnit astRoot) {
        AccessorClassReference accessorClassReference;
        NLSElement nlsElement;
        int n;
        int n2;
        NLSElement[] nLSElementArray;
        NLSLine line;
        NLSLine[] nLSLineArray = lines;
        int n3 = lines.length;
        int n4 = 0;
        while (n4 < n3) {
            line = nLSLineArray[n4];
            nLSElementArray = line.getElements();
            n2 = nLSElementArray.length;
            n = 0;
            while (n < n2) {
                nlsElement = nLSElementArray[n];
                if (nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n4;
        }
        nLSLineArray = lines;
        n3 = lines.length;
        n4 = 0;
        while (n4 < n3) {
            line = nLSLineArray[n4];
            nLSElementArray = line.getElements();
            n2 = nLSElementArray.length;
            n = 0;
            while (n < n2) {
                nlsElement = nLSElementArray[n];
                if (!nlsElement.hasTag() && (accessorClassReference = NLSHintHelper.getAccessorClassReference(astRoot, nlsElement)) != null) {
                    return accessorClassReference;
                }
                ++n;
            }
            ++n4;
        }
        return null;
    }

    private static String stripQuotes(String str) {
        return str.substring(1, str.length() - 1);
    }

    private static NLSLine[] createRawLines(ICompilationUnit cu) {
        try {
            return NLSScanner.scan(cu);
        }
        catch (JavaModelException | InvalidInputException | BadLocationException throwable) {
            return new NLSLine[0];
        }
    }

    public String getAccessorClassName() {
        return this.fAccessorName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public NLSSubstitution[] getSubstitutions() {
        return this.fSubstitutions;
    }
}

