/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.mbs;

import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.makegen.gnu2.GnuMakefileGenerator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class GDMakefileGenerator
extends GnuMakefileGenerator {
    public static String ARMLinker = "GD ARM MCU Linker";
    public static String ARMCLinker = "GD ARM MCU C Linker";
    public static String ARMCLinkerScriptFileID = "com.gigadevice.mbs.arm.option.linker.general.scriptFile";
    public static String ARMCLinkerLibPathID = "com.gigadevice.mbs.arm.option.linker.libraries.paths";
    public static String ARMCAddLinker = "GD ARM MCU C++ Linker";
    public static String ARMCAddLinkerScriptFileID = "com.gigadevice.mbs.arm.option.cpp.linker.general.scriptFile";
    public static String ARMCAddLinkerLibPathID = "com.gigadevice.mbs.arm.option.cpp.linker.libraries.paths";
    public static String RISCVLinker = "GD RISC-V MCU Linker";
    public static String RISCVCLinker = "GD RISC-V MCU C Linker";
    public static String RISCVCLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.linker.general.scriptFile";
    public static String RISCVCLinkerLibPathID = "com.gigadevice.mbs.riscv.option.linker.libraries.paths";
    public static String RISCVCAddLinker = "GD RISC-V MCU C++ Linker";
    public static String RISCVCAddLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.cpp.linker.general.scriptFile";
    public static String RISCVCAddLinkerLibPathID = "com.gigadevice.mbs.riscv.option.cpp.linker.libraries.paths";
    private static final String OBJECTS_LIST_FILE = "objects.list";
    private static final String OBJS_MACRO = "OBJS";
    private static final String OBJECTS_LIST_REFERENCE = "@\"objects.list\"";

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        super.populateTopMakefile(fileHandle, rebuild);
        this.generateObjectsListFile();
    }

    private void generateObjectsListFile() throws CoreException {
        try {
            List<String> objectFiles = this.collectAllObjectFiles();
            if (objectFiles.isEmpty()) {
                return;
            }
            StringBuilder content = new StringBuilder();
            for (String objFile : objectFiles) {
                content.append("\"").append(objFile).append("\"").append(NEWLINE);
            }
            IPath buildDir = this.getTopBuildDir();
            if (buildDir == null) {
                return;
            }
            File objectsListFile = buildDir.append(OBJECTS_LIST_FILE).toFile();
            try {
                if (!objectsListFile.getParentFile().exists()) {
                    objectsListFile.getParentFile().mkdirs();
                }
                Files.write(objectsListFile.toPath(), content.toString().getBytes("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
        catch (Exception e) {
            String errorMsg = "Failed to generate objects.list file: " + e.getMessage();
            System.out.println(errorMsg);
        }
    }

    private List<String> collectAllObjectFiles() {
        ArrayList<String> objectFiles = new ArrayList<String>();
        IPath buildDir = this.getTopBuildDir();
        try {
            Map buildOutVars = this.getBuildOutputVars();
            List objsPathFiles = (List)buildOutVars.get(OBJS_MACRO);
            if (objsPathFiles != null) {
                Collections.reverse(objsPathFiles);
                objectFiles.size();
                for (IPath path : objsPathFiles) {
                    String relativePath;
                    String pathStr = path.toString();
                    if (pathStr == null || !pathStr.endsWith(".o") || objectFiles.contains(relativePath = this.convertToRelativePath(pathStr, buildDir))) continue;
                    objectFiles.add(relativePath);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return objectFiles;
    }

    private String convertToRelativePath(String absolutePath, IPath buildDir) {
        try {
            String relativePath;
            Path targetPath = new Path(absolutePath);
            if (!targetPath.isAbsolute()) {
                relativePath = absolutePath;
            } else if (buildDir.isPrefixOf((IPath)targetPath)) {
                IPath relPath = targetPath.makeRelativeTo(buildDir);
                relativePath = relPath.toString();
            } else {
                IPath relPath = ManagedBuildManager.calculateRelativePath((IPath)buildDir, (IPath)targetPath);
                relativePath = relPath.toString();
            }
            if (!relativePath.startsWith("./") && !relativePath.startsWith("..")) {
                relativePath = "./" + relativePath;
            }
            return relativePath;
        }
        catch (Exception e) {
            System.err.println("Failed to convert path to relative: " + absolutePath + ", error: " + e.getMessage());
            return absolutePath;
        }
    }

    protected void replaceObjsWithObjectsList(Vector<String> inputs) {
        int i = 0;
        while (i < inputs.size()) {
            String input = inputs.get(i);
            if (input != null && input.equals("$(OBJS)")) {
                inputs.set(i, OBJECTS_LIST_REFERENCE);
                return;
            }
            ++i;
        }
    }

    protected boolean getToolInputsOutputs(ITool tool, Vector<String> inputs, Vector<String> dependencies, Vector<String> outputs, Vector<String> enumeratedPrimaryOutputs, Vector<String> enumeratedSecondaryOutputs, Vector<String> outputVariables, Vector<String> additionalTargets, boolean bTargetTool, Vector<String> managedProjectOutputs) {
        boolean result = super.getToolInputsOutputs(tool, inputs, dependencies, outputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs, outputVariables, additionalTargets, bTargetTool, managedProjectOutputs);
        if (result && bTargetTool && this.isLinkerTool(tool)) {
            this.addLinkerScriptDependencies(dependencies);
            this.replaceObjsWithObjectsList(inputs);
        }
        return result;
    }

    private boolean isLinkerTool(ITool tool) {
        String toolName = tool.getName();
        return toolName != null && (toolName.equals(ARMLinker) || toolName.equals(ARMCLinker) || toolName.equals(ARMCAddLinker) || toolName.equals(RISCVLinker) || toolName.equals(RISCVCLinker) || toolName.equals(RISCVCAddLinker));
    }

    private void addLinkerScriptDependencies(Vector<String> dependencies) {
        try {
            String[] linkerScripts = this.getLinkerScriptsFromConfiguration();
            if (linkerScripts != null && linkerScripts.length > 0) {
                String ldString = linkerScripts[linkerScripts.length - 1];
                ldString = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(ldString, "", " ", 3, (Object)this.getConfig());
                ldString = this.ensurePathIsGNUMakeTargetRuleCompatibleSyntax(ldString);
                String ldNameString = ldString.replace('\\', '/');
                if (!(ldNameString = ldNameString.replaceAll("/ ", "")).contains("/")) {
                    IPath buildDir = this.getTopBuildDir();
                    String[] LibPath = this.getLinkerLibPathFromConfiguration();
                    if (LibPath == null) {
                        return;
                    }
                    String[] stringArray = LibPath;
                    int n = LibPath.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String libPathString = stringArray[n2];
                        libPathString = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(libPathString, "", " ", 3, (Object)this.getConfig());
                        Path targetPath = new Path(libPathString);
                        File ldFile = null;
                        if (targetPath.isAbsolute()) {
                            File absoluteDir = new File(libPathString);
                            if (absoluteDir.exists() && absoluteDir.isDirectory()) {
                                ldString = ldString.replace('\\', '/').replaceAll("/ ", " ");
                                ldFile = new File(absoluteDir, ldString);
                            }
                        } else {
                            IPath absolutePath = buildDir.append(libPathString = libPathString.replace("\"", "").replace("'", ""));
                            File relativeDir = absolutePath.toFile();
                            if (relativeDir.exists() && relativeDir.isDirectory()) {
                                ldString = ldString.replace('\\', '/').replaceAll("/ ", " ");
                                ldFile = new File(relativeDir, ldString);
                            }
                        }
                        if (ldFile != null && ldFile.exists() && ldFile.isFile() && !dependencies.contains(ldString = TargetOSInfo.isWindows() ? ldFile.getAbsolutePath().replace("/", "\\").replace(" ", "\\ ") : ldFile.getAbsolutePath())) {
                            dependencies.add(ldString);
                            return;
                        }
                        ++n2;
                    }
                } else if (!dependencies.contains(ldString)) {
                    dependencies.add(ldString);
                }
            }
        }
        catch (Exception e) {
            System.err.println("\u5a23\u8bf2\u59de\u95be\u70ac\u5e34\u9363\u3128\u527c\u93c8\ue0ff\u7df7\u74a7\u6828\u6902\u9351\u6d2a\u654a: " + e.getMessage());
        }
    }

    private String[] getLinkerLibPathFromConfiguration() {
        block15: {
            try {
                IOption[] options;
                IConfiguration config = this.getConfig();
                ITool linkerTool = config.calculateTargetTool();
                if (linkerTool == null) break block15;
                IOption[] iOptionArray = options = linkerTool.getOptions();
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    IOption option = iOptionArray[n2];
                    if (option != null) {
                        String idString = "";
                        if (linkerTool.getName().equals(ARMLinker) || linkerTool.getName().equals(ARMCLinker)) {
                            idString = ARMCLinkerLibPathID;
                        } else if (linkerTool.getName().equals(ARMCAddLinker)) {
                            idString = ARMCAddLinkerLibPathID;
                        } else if (linkerTool.getName().equals(RISCVLinker) || linkerTool.getName().equals(RISCVCLinker)) {
                            idString = RISCVCLinkerLibPathID;
                        } else if (linkerTool.getName().equals(RISCVCAddLinker)) {
                            idString = RISCVCAddLinkerLibPathID;
                        }
                        if (option.getSuperClass().getId().equals(idString)) {
                            try {
                                String[] LibPathList = option.getLibraryPaths();
                                if (LibPathList.length > 0) {
                                    return LibPathList;
                                }
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                System.err.println("\u947e\u5cf0\u5f47\u6434\u64bb\u53a4\u7f03\ue1bd\u6902\u9351\u6d2a\u654a: " + e.getMessage());
            }
        }
        return null;
    }

    private String[] getLinkerScriptsFromConfiguration() {
        block15: {
            try {
                IOption[] options;
                IConfiguration config = this.getConfig();
                ITool linkerTool = config.calculateTargetTool();
                if (linkerTool == null) break block15;
                IOption[] iOptionArray = options = linkerTool.getOptions();
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    IOption option = iOptionArray[n2];
                    if (option != null) {
                        String idString = "";
                        if (linkerTool.getName().equals(ARMLinker) || linkerTool.getName().equals(ARMCLinker)) {
                            idString = ARMCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(ARMCAddLinker)) {
                            idString = ARMCAddLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVLinker) || linkerTool.getName().equals(RISCVCLinker)) {
                            idString = RISCVCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVCAddLinker)) {
                            idString = RISCVCAddLinkerScriptFileID;
                        }
                        if (option.getSuperClass().getId().equals(idString)) {
                            try {
                                String[] LdFilePathList = option.getStringListValue();
                                if (LdFilePathList.length > 0) {
                                    return LdFilePathList;
                                }
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                System.err.println("\u947e\u5cf0\u5f47\u95be\u70ac\u5e34\u9363\u3128\u527c\u93c8\ue104\u53a4\u7f03\ue1bd\u6902\u9351\u6d2a\u654a: " + e.getMessage());
            }
        }
        return null;
    }

    private void findLinkerScriptsInContainer(IContainer container, Vector<IPath> scripts) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                if (resource.getType() == 1) {
                    String ext = resource.getFileExtension();
                    if ("ld".equals(ext) || "lds".equals(ext) || "ldscript".equals(ext)) {
                        scripts.add(resource.getProjectRelativePath());
                    }
                } else if (resource.getType() == 2 && !this.isGeneratedResource(resource)) {
                    this.findLinkerScriptsInContainer((IContainer)resource, scripts);
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }
}

