/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.jsoncdb.core.participant.builtins;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.eclipse.cdt.jsoncdb.core.participant.IRawSourceFileInfoCollector;
import org.eclipse.cdt.jsoncdb.core.participant.builtins.IBuiltinsOutputProcessor;

public class OutputSniffer
extends OutputStream {
    private static final String SEP = System.lineSeparator();
    private final StringBuilder buffer;
    private final IBuiltinsOutputProcessor processor;
    private final IRawSourceFileInfoCollector infoCollector;
    private final OutputStream os;

    public OutputSniffer(IBuiltinsOutputProcessor processor, OutputStream outputStream, IRawSourceFileInfoCollector infoCollector) {
        this.processor = Objects.requireNonNull(processor, "processor");
        this.infoCollector = Objects.requireNonNull(infoCollector, "infoCollector");
        this.os = outputStream;
        this.buffer = new StringBuilder(512);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) throws IOException {
        if (this.os != null) {
            this.os.write(c);
        }
        OutputSniffer outputSniffer = this;
        synchronized (outputSniffer) {
            this.buffer.append(new String(new byte[]{(byte)c}));
            this.splitLines();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.os != null) {
            this.os.write(b, off, len);
        }
        OutputSniffer outputSniffer = this;
        synchronized (outputSniffer) {
            this.buffer.append(new String(b, off, len));
            this.splitLines();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.os != null) {
            this.os.flush();
        }
        OutputSniffer outputSniffer = this;
        synchronized (outputSniffer) {
            this.splitLines();
            String line = this.buffer.toString();
            this.buffer.setLength(0);
            this.processLine(line);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.os != null) {
            this.os.close();
        }
        this.flush();
    }

    private void splitLines() {
        int idx;
        while ((idx = this.buffer.indexOf(SEP)) != -1) {
            String line = this.buffer.substring(0, idx);
            this.buffer.delete(0, idx + SEP.length());
            this.processLine(line);
        }
    }

    private void processLine(String line) {
        this.processor.processLine(line, this.infoCollector);
    }
}

