/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.xml.sax.SAXException;

public class GDProjectSelectorMCUPage
extends WizardPage {
    private Table table = null;
    private List<MCUSeletorInfo> MCUSeletorInfoList;
    public static Map<String, Integer> MCUSeletorInfoMap;
    public static Map<Integer, Combo> FilterComboMap;
    public static Map<Integer, List<String>> FilterComboItemMap;
    private String MCUPart;
    private String MCUCore;
    private String MCUFwlibType;
    public static boolean WriteChangeLog;
    private Composite fwlibComposite;
    private Combo fwlibCombo;

    static {
        WriteChangeLog = true;
    }

    public GDProjectSelectorMCUPage() {
        super("New GD Project");
        this.setTitle("New GD Project");
        this.setDescription("Please select the target");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.MCUSeletorInfoList = new ArrayList<MCUSeletorInfo>();
        FilterComboMap = new HashMap<Integer, Combo>();
        FilterComboItemMap = new HashMap<Integer, List<String>>();
        MCUSeletorInfoMap = new HashMap<String, Integer>();
        this.InitMCUSeletorInfoList("arm");
        this.InitMCUSeletorInfoList("riscv");
        this.InitFilterComboItemMap();
        try {
            this.createGui(container);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    private void createGui(Composite parent) throws ParserConfigurationException, SAXException, IOException {
        Composite filterComposite = new Composite(parent, 0);
        GridLayout filterLayout = new GridLayout(3, true);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterComposite.setLayout((Layout)filterLayout);
        GridData filterData = new GridData(4, 128, true, false);
        filterData.horizontalSpan = 3;
        filterComposite.setLayoutData((Object)filterData);
        this.addFilterControl(filterComposite, "Series:", 0);
        this.addFilterControl(filterComposite, "Package:", 1);
        this.addFilterControl(filterComposite, "Core:", 2);
        this.addFilterControl(filterComposite, "Flash >= ", 3);
        this.addFilterControl(filterComposite, "RAM >= ", 4);
        this.addFilterControl(filterComposite, "IO >= ", 5);
        this.table = new Table(parent, 67586);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.horizontalSpan = 3;
        tableData.heightHint = 400;
        this.table.setLayoutData((Object)tableData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] tableHeader = new String[]{"  MCU", "  Package", "  Core", "  Flash", "  Ram", "  IO", "  FwlibType", "Support Code Gen"};
        int[] Headerlength = new int[]{120, 100, 80, 80, 80, 80, 100, 120};
        int i = 0;
        while (i < tableHeader.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(tableHeader[i]);
            tableColumn.setWidth(Headerlength[i]);
            tableColumn.setMoveable(true);
            tableColumn.setResizable(true);
            ++i;
        }
        this.table.setHeaderBackground(new Color(null, 210, 210, 210));
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int total = GDProjectSelectorMCUPage.this.table.getItemCount();
                int i = 0;
                while (i < total) {
                    TableItem item = GDProjectSelectorMCUPage.this.table.getItem(i);
                    if (GDProjectSelectorMCUPage.this.table.isSelected(i)) {
                        GDProjectSelectorMCUPage.this.MCUPart = item.getText();
                        GDProjectSelectorMCUPage.this.MCUCore = item.getText(TableInfoColumn.CORE.getIndex());
                        String fwlibType = item.getText(TableInfoColumn.FWLIBTYPE.getIndex());
                        if (fwlibType.contains(",")) {
                            GDProjectSelectorMCUPage.this.fwlibComposite.setVisible(true);
                        } else {
                            GDProjectSelectorMCUPage.this.fwlibComposite.setVisible(false);
                            GDProjectSelectorMCUPage.this.fwlibCombo.select(0);
                        }
                        GDProjectSelectorMCUPage.this.setPageComplete(true);
                    }
                    ++i;
                }
            }
        });
        this.fwlibComposite = new Composite(parent, 0);
        GridLayout fwlibLayout = new GridLayout(2, false);
        fwlibLayout.marginWidth = 0;
        fwlibLayout.marginHeight = 5;
        this.fwlibComposite.setLayout((Layout)fwlibLayout);
        GridData fwlibData = new GridData(4, 0x1000000, true, false);
        fwlibData.horizontalSpan = 3;
        this.fwlibComposite.setLayoutData((Object)fwlibData);
        Label fwlibLabel = new Label(this.fwlibComposite, 0);
        fwlibLabel.setText("FWLib Type:");
        GridData fwlibLabelData = new GridData(16384, 0x1000000, false, false);
        fwlibLabelData.widthHint = 100;
        fwlibLabel.setLayoutData((Object)fwlibLabelData);
        this.fwlibCombo = new Combo(this.fwlibComposite, 8);
        this.fwlibCombo.add("Standard");
        this.fwlibCombo.add("Hal");
        this.fwlibCombo.select(0);
        GridData fwlibComboData = new GridData(16384, 0x1000000, false, false);
        fwlibComboData.widthHint = 100;
        this.fwlibCombo.setLayoutData((Object)fwlibComboData);
        this.fwlibComposite.setVisible(false);
        this.updateTable(this.MCUSeletorInfoList);
    }

    public void addFilterControl(Composite parent, String FilterLab, int FilterType) {
        Composite filterContainer = new Composite(parent, 0);
        GridLayout containerLayout = new GridLayout(2, false);
        containerLayout.marginWidth = 5;
        containerLayout.marginHeight = 5;
        filterContainer.setLayout((Layout)containerLayout);
        GridData containerData = new GridData(4, 0x1000000, true, false);
        filterContainer.setLayoutData((Object)containerData);
        Label label = new Label(filterContainer, 0);
        label.setText(FilterLab);
        GridData labelData = new GridData(16384, 0x1000000, false, false);
        labelData.widthHint = 80;
        label.setLayoutData((Object)labelData);
        Combo filterCombo = new Combo(filterContainer, 8);
        GridData comboData = new GridData(4, 0x1000000, true, false);
        comboData.minimumWidth = 100;
        filterCombo.setLayoutData((Object)comboData);
        filterCombo.add("ALL");
        List<String> filterList = FilterComboItemMap.get(FilterType);
        int i = 0;
        while (i < filterList.size()) {
            filterCombo.add(filterList.get(i));
            ++i;
        }
        filterCombo.select(0);
        filterCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArrayList<MCUSeletorInfo> MCUList = new ArrayList<MCUSeletorInfo>();
                MCUList.addAll(GDProjectSelectorMCUPage.this.ReturnMatchMCUList());
                GDProjectSelectorMCUPage.this.updateTable(MCUList);
            }
        });
        FilterComboMap.put(FilterType, filterCombo);
    }

    public void updateTable(List<MCUSeletorInfo> MCUSeletorInfoList) {
        this.setPageComplete(false);
        this.table.removeAll();
        boolean isShowFwlibType = true;
        int i = 0;
        while (i < MCUSeletorInfoList.size()) {
            String[] test = new String[this.table.getColumnCount()];
            test[TableInfoColumn.MCU.getIndex()] = MCUSeletorInfoList.get(i).getMCUPart();
            test[TableInfoColumn.PACKAGE.getIndex()] = MCUSeletorInfoList.get(i).getPackageType();
            test[TableInfoColumn.CORE.getIndex()] = MCUSeletorInfoList.get(i).getCore();
            test[TableInfoColumn.FLASH.getIndex()] = MCUSeletorInfoList.get(i).getFlashSize();
            test[TableInfoColumn.RAM.getIndex()] = MCUSeletorInfoList.get(i).getRamSize();
            test[TableInfoColumn.IO.getIndex()] = MCUSeletorInfoList.get(i).getIOType();
            test[TableInfoColumn.FWLIBTYPE.getIndex()] = MCUSeletorInfoList.get(i).getFwlibType();
            test[TableInfoColumn.SupportCode.getIndex()] = MCUSeletorInfoList.get(i).getSupportCodeGen() ? "true" : "false";
            String fwlibType = MCUSeletorInfoList.get(i).getFwlibType();
            if (!fwlibType.contains(",")) {
                isShowFwlibType = false;
            }
            TableItem item = new TableItem(this.table, 0);
            item.setText(test);
            ++i;
        }
        if (isShowFwlibType) {
            this.fwlibComposite.setVisible(true);
        } else {
            this.fwlibComposite.setVisible(false);
            this.fwlibCombo.select(0);
        }
        this.table.update();
    }

    private List<MCUSeletorInfo> ReturnMatchMCUList() {
        ArrayList<MCUSeletorInfo> MCUList = new ArrayList<MCUSeletorInfo>();
        int i = 0;
        while (i < this.MCUSeletorInfoList.size()) {
            String Series = FilterComboMap.get(0).getText();
            String Package = FilterComboMap.get(1).getText();
            String Core = FilterComboMap.get(2).getText();
            boolean FlashSizeMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 3);
            boolean RamSizeMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 4);
            boolean IOMatch = this.checkSelectCondition(this.MCUSeletorInfoList.get(i), 5);
            if ((Series.equals(this.MCUSeletorInfoList.get(i).getSeries()) || Series.equals("ALL")) && (Package.equals(this.MCUSeletorInfoList.get(i).getPackageType()) || Package.equals("ALL")) && (Core.equals(this.MCUSeletorInfoList.get(i).getCore()) || Core.equals("ALL")) && FlashSizeMatch && RamSizeMatch && IOMatch) {
                MCUList.add(this.MCUSeletorInfoList.get(i));
            }
            ++i;
        }
        return MCUList;
    }

    private boolean checkSelectCondition(MCUSeletorInfo MCUSeletorInfoObj, int filterType) {
        String tmpSizeStr;
        int Size;
        block10: {
            String condition = FilterComboMap.get(filterType).getText();
            if (condition.equals("ALL")) {
                return true;
            }
            Size = Integer.parseInt(condition);
            tmpSizeStr = "";
            if (filterType == 3) {
                tmpSizeStr = MCUSeletorInfoObj.getFlashSize();
            } else if (filterType == 4) {
                tmpSizeStr = MCUSeletorInfoObj.getRamSize();
            } else if (filterType == 5) {
                tmpSizeStr = MCUSeletorInfoObj.getIOType();
            }
            if (!tmpSizeStr.equals("")) break block10;
            return false;
        }
        try {
            int tmpSize = Integer.parseInt(tmpSizeStr);
            if (tmpSize >= Size) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void InitFilterComboItemMap() {
        ArrayList<String> SeriesList = new ArrayList<String>();
        ArrayList<String> PackageList = new ArrayList<String>();
        ArrayList<String> CoreList = new ArrayList<String>();
        ArrayList<String> FlashList = new ArrayList<String>();
        ArrayList<String> RamList = new ArrayList<String>();
        ArrayList<String> IOList = new ArrayList<String>();
        int i = 0;
        while (i < this.MCUSeletorInfoList.size()) {
            String IOType;
            String RamSize;
            String FlashSize;
            String CoreType;
            String PackageType;
            String Series = this.MCUSeletorInfoList.get(i).getSeries();
            if (!SeriesList.contains(Series)) {
                SeriesList.add(Series);
            }
            if (!PackageList.contains(PackageType = this.MCUSeletorInfoList.get(i).getPackageType())) {
                PackageList.add(PackageType);
            }
            if (!CoreList.contains(CoreType = this.MCUSeletorInfoList.get(i).getCore())) {
                CoreList.add(CoreType);
            }
            if (!FlashList.contains(FlashSize = this.MCUSeletorInfoList.get(i).getFlashSize())) {
                FlashList.add(FlashSize);
            }
            if (!RamList.contains(RamSize = this.MCUSeletorInfoList.get(i).getRamSize())) {
                RamList.add(RamSize);
            }
            if (!IOList.contains(IOType = this.MCUSeletorInfoList.get(i).getIOType())) {
                IOList.add(IOType);
            }
            ++i;
        }
        Collections.sort(SeriesList);
        Collections.sort(PackageList);
        Collections.sort(CoreList);
        FilterComboItemMap.put(0, SeriesList);
        FilterComboItemMap.put(1, PackageList);
        FilterComboItemMap.put(2, CoreList);
        FilterComboItemMap.put(3, FlashList);
        FilterComboItemMap.put(4, RamList);
        FilterComboItemMap.put(5, IOList);
    }

    private void InitMCUSeletorInfoList(String CoreType) {
        List McuList = new ArrayList();
        String mcuType = "mcu_" + CoreType;
        McuList = McuFactory.getGDMcuTree((String)mcuType);
        String ChangeLogPath = String.valueOf(McuFactory.getResourcePath()) + "ChangeLog.txt";
        BufferedWriter bufferedWriter = null;
        WriteChangeLog = false;
        try {
            if (WriteChangeLog) {
                OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ChangeLogPath, true), StandardCharsets.UTF_8);
                bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.newLine();
                bufferedWriter.write("<GD Project>");
                bufferedWriter.newLine();
                WriteChangeLog = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < McuList.size()) {
            int WritePartNoCount = 0;
            Object mcuGroup = McuList.get(i);
            List mcuSubGroup = ((McuGroup)mcuGroup).getChildren();
            String fwlibType = ((McuGroup)mcuGroup).getFwlibType();
            int j = 0;
            while (j < mcuSubGroup.size()) {
                String Series = ((McuSubGroup)mcuSubGroup.get(j)).getName();
                boolean isSupportSubGroup = ((McuSubGroup)mcuSubGroup.get(j)).isSupport();
                if (isSupportSubGroup) {
                    String Core = ((McuSubGroup)mcuSubGroup.get(j)).getCPUCore();
                    List MCUList = ((McuSubGroup)mcuSubGroup.get(j)).getChildren();
                    int k = 0;
                    while (k < MCUList.size()) {
                        MCUSeletorInfo mcuSeletorInfo = new MCUSeletorInfo();
                        mcuSeletorInfo = new MCUSeletorInfo();
                        String MCUPart = ((MCUs)MCUList.get(k)).getName();
                        if (MCUSeletorInfoMap.containsKey(MCUPart)) {
                            mcuSeletorInfo = this.MCUSeletorInfoList.get(MCUSeletorInfoMap.get(MCUPart));
                            mcuSeletorInfo.setFwlibType(String.valueOf(mcuSeletorInfo.getFwlibType()) + "," + fwlibType);
                        } else {
                            String FlashSize = ((MCUs)MCUList.get(k)).getFlashSize();
                            String RamSize = ((MCUs)MCUList.get(k)).getRamSize();
                            String PackageType = ((MCUs)MCUList.get(k)).getPackageType();
                            String IO = ((MCUs)MCUList.get(k)).getIO();
                            boolean SupportCodeGen = ((McuSubGroup)mcuSubGroup.get(j)).getSupportCodeGen();
                            mcuSeletorInfo.setMCUPart(MCUPart);
                            mcuSeletorInfo.setSeries(Series);
                            mcuSeletorInfo.setPackageType(PackageType);
                            mcuSeletorInfo.setCore(Core);
                            mcuSeletorInfo.setFlashSize(FlashSize);
                            mcuSeletorInfo.setRamSize(RamSize);
                            mcuSeletorInfo.setIOType(IO);
                            mcuSeletorInfo.setFwlibType(fwlibType);
                            mcuSeletorInfo.setSupportCodeGen(SupportCodeGen);
                            this.MCUSeletorInfoList.add(mcuSeletorInfo);
                            if (!MCUSeletorInfoMap.containsKey(MCUPart)) {
                                MCUSeletorInfoMap.put(MCUPart, this.MCUSeletorInfoList.size() - 1);
                            }
                            if (bufferedWriter != null) {
                                try {
                                    bufferedWriter.write(String.valueOf(MCUPart) + " ");
                                    if (++WritePartNoCount >= 8) {
                                        bufferedWriter.newLine();
                                        WritePartNoCount = 0;
                                    }
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.newLine();
                    if (WritePartNoCount != 0) {
                        bufferedWriter.newLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MCUSeletorInfo getMCUSeletorInfo() {
        MCUSeletorInfo mcuSeletorInfo = new MCUSeletorInfo();
        List McuList = new ArrayList();
        String mcuCoreType = "arm";
        if (!this.MCUCore.toLowerCase().contains("cortex")) {
            mcuCoreType = "riscv";
        }
        String mcuType = "mcu_" + mcuCoreType;
        McuList = McuFactory.getGDMcuTree((String)mcuType);
        int i = 0;
        while (i < McuList.size()) {
            Object mcuGroup = McuList.get(i);
            List mcuSubGroup = ((McuGroup)mcuGroup).getChildren();
            int j = 0;
            while (j < mcuSubGroup.size()) {
                List MCUList = ((McuSubGroup)mcuSubGroup.get(j)).getChildren();
                int k = 0;
                while (k < MCUList.size()) {
                    block9: {
                        String firmwareSeries;
                        String fwlibType;
                        String MCUGroup;
                        block10: {
                            MCUGroup = ((McuGroup)mcuGroup).getName();
                            fwlibType = ((McuGroup)mcuGroup).getFwlibType();
                            firmwareSeries = ((McuGroup)mcuGroup).getDirPath();
                            String MCUPartStr = ((MCUs)MCUList.get(k)).getName();
                            if (!MCUPartStr.equals(this.MCUPart)) break block9;
                            if (!this.fwlibCombo.isVisible()) break block10;
                            this.MCUFwlibType = this.fwlibCombo.getText().toUpperCase();
                            if (!fwlibType.toUpperCase().equals(this.MCUFwlibType)) break block9;
                        }
                        String Series = ((McuSubGroup)mcuSubGroup.get(j)).getName();
                        boolean isSupportSubGroup = ((McuSubGroup)mcuSubGroup.get(j)).isSupport();
                        if (isSupportSubGroup) {
                            String Core = ((McuSubGroup)mcuSubGroup.get(j)).getCPUCore();
                            String PerisRelationFilePath = ((McuSubGroup)mcuSubGroup.get(j)).getRelationFilePath();
                            String RCUPath = ((McuSubGroup)mcuSubGroup.get(j)).getRCUPath();
                            String CodeGroup = ((McuSubGroup)mcuSubGroup.get(j)).getCodeGroup();
                            boolean SupportCodeGen = ((McuSubGroup)mcuSubGroup.get(j)).getSupportCodeGen();
                            String spPeri2FuncFilePath = ((McuSubGroup)mcuSubGroup.get(j)).getSPPeri2FuncFilePath();
                            if (CodeGroup.equals("")) {
                                CodeGroup = MCUGroup;
                            }
                            String FlashSize = ((MCUs)MCUList.get(k)).getFlashSize();
                            String RamSize = ((MCUs)MCUList.get(k)).getRamSize();
                            String PackageType = ((MCUs)MCUList.get(k)).getPackageType();
                            String IO = ((MCUs)MCUList.get(k)).getIO();
                            String DataSheetPath = ((MCUs)MCUList.get(k)).getDataSheetPath();
                            String AFIOPath = ((MCUs)MCUList.get(k)).getAFIOPath();
                            String PeriTreeFilePath = ((MCUs)MCUList.get(k)).getPerisTreeFilePath();
                            ArrayList Symbols = ((MCUs)MCUList.get(k)).getSymbols();
                            mcuSeletorInfo.setFwlibType(fwlibType);
                            mcuSeletorInfo.setCodeGroup(CodeGroup);
                            mcuSeletorInfo.setMCUGroup(MCUGroup);
                            mcuSeletorInfo.setSeries(Series);
                            mcuSeletorInfo.setCore(Core);
                            mcuSeletorInfo.setMCUPart(this.MCUPart);
                            mcuSeletorInfo.setFlashSize(FlashSize);
                            mcuSeletorInfo.setPackageType(PackageType);
                            mcuSeletorInfo.setRamSize(RamSize);
                            mcuSeletorInfo.setIOType(IO);
                            mcuSeletorInfo.setDataSheetPath(DataSheetPath);
                            mcuSeletorInfo.setAFIOPath(AFIOPath);
                            mcuSeletorInfo.setPerisTreeFilePath(PeriTreeFilePath);
                            mcuSeletorInfo.setPerisRelationFilePath(PerisRelationFilePath);
                            mcuSeletorInfo.setRCUPath(RCUPath);
                            mcuSeletorInfo.setSvdPath(((MCUs)MCUList.get(k)).getSVD());
                            mcuSeletorInfo.setSymbols((List)Symbols);
                            mcuSeletorInfo.setSupportCodeGen(SupportCodeGen);
                            mcuSeletorInfo.setSPPeri2FuncFilePath(spPeri2FuncFilePath);
                            mcuSeletorInfo.setMcuObj((MCUs)MCUList.get(k));
                            mcuSeletorInfo.setDirPath(firmwareSeries);
                            return mcuSeletorInfo;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return mcuSeletorInfo;
    }

    public static enum TableInfoColumn {
        MCU(0),
        PACKAGE(1),
        CORE(2),
        FLASH(3),
        RAM(4),
        IO(5),
        FWLIBTYPE(6),
        SupportCode(7);

        private final int index;

        private TableInfoColumn(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

