/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target.gdconfigui;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GDProjectCreateNamePage
extends WizardPage {
    private Text textName;
    private Text projectLocation;
    private IWizardPage next;

    public GDProjectCreateNamePage() {
        super("New GD Project");
        this.setTitle("New GD Project");
        this.setDescription("Please input GD Project Name");
    }

    public void createControl(Composite parent) {
        final Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(6, false));
        final Label labelMessage = new Label(container, 0);
        labelMessage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 6, 1));
        labelMessage.setText("                                                          ");
        labelMessage.setForeground(new Color(null, 255, 0, 0));
        labelMessage.setVisible(true);
        Label labelName = new Label(container, 0);
        labelName.setText("Project Name");
        this.textName = new Text(container, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GDProjectCreateNamePage.this.textName.getText().isEmpty()) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    IProject project = root.getProject(GDProjectCreateNamePage.this.textName.getText());
                    if (project.exists()) {
                        GDProjectCreateNamePage.this.setPageComplete(false);
                        labelMessage.setText("The project already exists!");
                        labelMessage.setVisible(true);
                    } else {
                        labelMessage.setVisible(false);
                        GDProjectCreateNamePage.this.setPageComplete(true);
                    }
                } else {
                    GDProjectCreateNamePage.this.setPageComplete(false);
                }
            }
        });
        final Button useDefaultsButton = new Button(container, 32);
        useDefaultsButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 6, 2));
        useDefaultsButton.setText("Use default location");
        useDefaultsButton.setSelection(true);
        useDefaultsButton.setEnabled(false);
        Label pathLabelName = new Label(container, 0);
        pathLabelName.setText("Project Path");
        this.projectLocation = new Text(container, 2048);
        this.projectLocation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        this.projectLocation.setText(root.getLocation().toString());
        this.projectLocation.setToolTipText(root.getLocation().toString());
        this.projectLocation.setEnabled(false);
        this.projectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!GDProjectCreateNamePage.this.projectLocation.getText().isEmpty()) {
                    String path = GDProjectCreateNamePage.this.projectLocation.getText();
                    File folder = new File(path);
                    if (!folder.exists() && !folder.isDirectory()) {
                        GDProjectCreateNamePage.this.setPageComplete(false);
                        labelMessage.setText("The project location is empty!");
                        labelMessage.setVisible(true);
                    } else {
                        labelMessage.setVisible(false);
                        GDProjectCreateNamePage.this.setPageComplete(true);
                    }
                } else {
                    GDProjectCreateNamePage.this.setPageComplete(false);
                }
            }
        });
        final Button browerButton = new Button(container, 0);
        browerButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        browerButton.setText("browse...");
        browerButton.setEnabled(false);
        browerButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(container.getShell());
                directoryDialog.setText("Choose");
                directoryDialog.setMessage("Choose Directory");
                directoryDialog.setFilterPath(GDProjectCreateNamePage.this.projectLocation.getText());
                String path = directoryDialog.open();
                if (path != null) {
                    GDProjectCreateNamePage.this.projectLocation.setText(path);
                    GDProjectCreateNamePage.this.projectLocation.setToolTipText(path);
                } else {
                    labelMessage.setText("The project location is empty!");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        useDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GDProjectCreateNamePage.this.projectLocation != null) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    if (useDefaultsButton.getSelection()) {
                        GDProjectCreateNamePage.this.projectLocation.setText(root.getLocation().toString());
                        GDProjectCreateNamePage.this.projectLocation.setToolTipText(root.getLocation().toString());
                        GDProjectCreateNamePage.this.projectLocation.setEnabled(false);
                        browerButton.setEnabled(false);
                    } else {
                        GDProjectCreateNamePage.this.projectLocation.setEnabled(true);
                        browerButton.setEnabled(true);
                    }
                }
            }
        });
    }

    public boolean isPageComplete() {
        if (this.textName.getText().isEmpty()) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(this.textName.getText());
        return !project.exists();
    }

    public String getName() {
        return this.textName.getText();
    }

    public String getProjectLocation() {
        return this.projectLocation.getText();
    }
}

