/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target;

import com.gigadevice.codegenerate.projectmigrate.GenerateProjectFile;
import com.gigadevice.templates.core.ProjectSetOptionValue;
import com.gigadevice.templates.target.CreateMultiBuildConfigurations;
import com.gigadevice.templates.target.ui.WizardPageTargetSettings;
import com.gigadevice.utils.preferences.EclipsePreferences;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.mcuxmlinfo.McuGroup;
import com.gigadevice.venustool.mcuxmlinfo.McuSubGroup;
import java.io.File;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProjectSettings
extends ProcessRunner {
    private String FileSrcPath;
    private String FileTargetPath;
    private String FileCodeLoaction;
    private String FileCodeLoactionAddress;
    private String FileRamLength;
    private String FileRamOrigin;
    private String FileFlashlength;
    private String FileFlashOrigin;
    private String FileStacklength;
    private String FileStackOrigin;
    private String flashBaseInFlash;
    private String flashSizeInFlash;
    private String ramBaseInFlash;
    private String ramSizeInFlash;
    private String flashBaseInRam;
    private String flashSizeInRam;
    private String ramBaseInRam;
    private String ramSizeInRam;
    private String toolchain;
    private String RISCVtoolchainPath;
    private String ARMtoolchainPath;
    private String buildtoolPath;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        this.toolchain = template.getTemplateInfo().getToolChainIds()[0];
        class ToolSettings {
            private String projectName;
            private String MCU;
            private String MCUSubGroup;
            private String MCUGroup;
            private String MCUCore;
            private String[] Symbols;
            private String FPU;
            private String FABIsoft = "Library (soft)";
            private String FABIhard = "FP instructions (hard)";
            private String CodeLocation;

            ToolSettings() {
            }
        }
        ToolSettings toolSettings = new ToolSettings();
        MCUs mcuObj = WizardPageTargetSettings.getSelMcu();
        toolSettings.MCU = mcuObj.getName();
        toolSettings.MCUSubGroup = ((McuSubGroup)mcuObj.getParent()).getName();
        toolSettings.MCUGroup = ((McuGroup)((McuSubGroup)mcuObj.getParent()).getParent()).getName();
        toolSettings.MCUCore = ((McuSubGroup)mcuObj.getParent()).getCPUCore();
        this.FileFlashOrigin = (String)template.getValueStore().get("flashOrigin");
        this.FileFlashlength = (String)template.getValueStore().get("flashLength");
        this.FileRamOrigin = (String)template.getValueStore().get("ramOrigin");
        this.FileRamLength = (String)template.getValueStore().get("ramLength");
        this.flashBaseInFlash = (String)template.getValueStore().get("flashBaseInFlash");
        this.flashSizeInFlash = (String)template.getValueStore().get("flashSizeInFlash");
        this.ramBaseInFlash = (String)template.getValueStore().get("ramBaseInFlash");
        this.ramSizeInFlash = (String)template.getValueStore().get("ramSizeInFlash");
        this.flashBaseInRam = (String)template.getValueStore().get("flashBaseInRam");
        this.flashSizeInRam = (String)template.getValueStore().get("flashSizeInRam");
        this.ramBaseInRam = (String)template.getValueStore().get("ramBaseInRam");
        this.ramSizeInRam = (String)template.getValueStore().get("ramSizeInRam");
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            if (arg.getName().equals("projectName")) {
                toolSettings.projectName = arg.getSimpleValue();
            }
            if (arg.getName().equals("MCUCore")) {
                toolSettings.MCUCore = arg.getSimpleValue();
            }
            if (arg.getName().equals("FPU")) {
                toolSettings.FPU = arg.getSimpleValue();
            }
            if (arg.getName().equals("CodeLocation")) {
                toolSettings.CodeLocation = arg.getSimpleValue();
                this.FileCodeLoaction = arg.getSimpleValue();
                if (this.FileCodeLoaction.equals("FLASH")) {
                    this.FileCodeLoactionAddress = "0x08000000";
                }
                if (this.FileCodeLoaction.equals("RAM")) {
                    this.FileCodeLoactionAddress = "0x20000000";
                }
            }
            if (arg.getName().equals("ldSrcPath")) {
                this.FileSrcPath = arg.getSimpleValue();
            }
            if (arg.getName().equals("ldTargetPath")) {
                this.FileTargetPath = arg.getSimpleValue();
            }
            if (arg.getName().equals("Stacklength")) {
                this.FileStacklength = arg.getSimpleValue();
            }
            if (arg.getName().equals("StackOrigin")) {
                this.FileStackOrigin = arg.getSimpleValue();
            }
            ++n2;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(toolSettings.projectName);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription workspaceDesc = workspace.getDescription();
        workspaceDesc.isAutoBuilding();
        workspaceDesc.setAutoBuilding(false);
        try {
            workspace.setDescription(workspaceDesc);
        }
        catch (CoreException coreException) {}
        new EclipsePreferences("com.gigadevice.utils");
        this.FileSrcPath = String.valueOf(McuFactory.getFirmwarePath((String)template.getLabel(), (String)((String)template.getValueStore().get("chipGroupName")))) + this.FileSrcPath;
        this.FileTargetPath = projectHandle.getFolder(this.FileTargetPath).getLocation().toOSString();
        String sepStr = "^";
        String LdInfoStr = String.valueOf(this.FileSrcPath) + sepStr + this.FileTargetPath + sepStr + this.FileStackOrigin + sepStr + this.FileStacklength + sepStr + this.FileFlashOrigin + sepStr + this.FileFlashlength + sepStr + this.FileRamOrigin + sepStr + this.FileRamLength + sepStr + this.FileCodeLoaction;
        Location l = Platform.getInstallLocation();
        l.getURL().toString();
        this.RISCVtoolchainPath = "." + File.separator + "Tools" + File.separator + "RISC-V Embedded GCC" + File.separator + "8.2.0-2.2-20190521-0004" + File.separator + "bin";
        this.buildtoolPath = "." + File.separator + "Tools" + File.separator + "Build Tools" + File.separator + "2.10-20180103-1919" + File.separator + "bin";
        this.ARMtoolchainPath = "." + File.separator + "Tools" + File.separator + "GNU Tools ARM Embedded" + File.separator + "xpack-arm-none-eabi-gcc" + File.separator + "9.2.1-1.1" + File.separator + "bin";
        String SpecialToolChainPath = ((McuSubGroup)mcuObj.getParent()).getToolChainPath();
        if (!SpecialToolChainPath.equals("")) {
            this.RISCVtoolchainPath = SpecialToolChainPath;
            this.buildtoolPath = this.buildtoolPath.replace("\\", "/");
        }
        ProjectSetOptionValue SetOptionValue = new ProjectSetOptionValue();
        SetOptionValue.setLdInfoStr(LdInfoStr);
        SetOptionValue.setToolSettingsMCUCore(toolSettings.MCUCore);
        SetOptionValue.setFileCodeLoactionAddress(this.FileCodeLoactionAddress);
        SetOptionValue.setFileStackOrigin(this.FileStackOrigin);
        SetOptionValue.setFileStacklength(this.FileStacklength);
        SetOptionValue.setARMtoolchainPath(this.ARMtoolchainPath);
        SetOptionValue.setToolSettingsMCUCore(toolSettings.MCUCore);
        SetOptionValue.setToolSettingsFPU(toolSettings.FPU);
        SetOptionValue.setFileFlashlength(this.FileFlashlength);
        SetOptionValue.setFileRamLength(this.FileRamLength);
        SetOptionValue.setFileFlashOrigin(this.FileFlashOrigin);
        SetOptionValue.setFileRamOrigin(this.FileRamOrigin);
        SetOptionValue.setRISCVtoolchainPath(this.RISCVtoolchainPath);
        SetOptionValue.setMcuObj(mcuObj);
        SetOptionValue.setToolchain(this.toolchain);
        SetOptionValue.setFileCodeLoaction(this.FileCodeLoaction);
        SetOptionValue.setBuildtoolPath(this.buildtoolPath);
        SetOptionValue.setToolSettingsMCU(toolSettings.MCU);
        SetOptionValue.setFileSrcPath(this.FileSrcPath);
        SetOptionValue.setFileTargetPath(this.FileTargetPath);
        GenerateProjectFile.SetAllOptionValue((IProject)projectHandle, (ProjectSetOptionValue)SetOptionValue);
        CreateMultiBuildConfigurations sBuildConfiguration = new CreateMultiBuildConfigurations();
        sBuildConfiguration.process(template, projectHandle, mcuObj.getName());
    }

    public static void update_xmlInfo(String xmlPath, String projectName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(xmlPath);
            doc.getDocumentElement();
            NodeList projectDescription = doc.getElementsByTagName("projectDescription");
            Element temp = null;
            int i = 0;
            while (i < projectDescription.getLength()) {
                temp = (Element)projectDescription.item(i);
                Node name = temp.getElementsByTagName("name").item(0).getFirstChild();
                name.setNodeValue(projectName);
                ++i;
            }
            doc.getDocumentElement().normalize();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(xmlPath));
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
            System.out.println("XML file updated successfully");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void folder_toProject(IFolder folder) {
        IProject parentProject = folder.getProject();
        HashSet<IWorkingSet> parentWorkingSets = new HashSet<IWorkingSet>();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet[] iWorkingSetArray = workingSetManager.getWorkingSets();
        int n = iWorkingSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkingSet workingSet = iWorkingSetArray[n2];
            IAdaptable[] iAdaptableArray = workingSet.getElements();
            int n3 = iAdaptableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IAdaptable element = iAdaptableArray[n4];
                if (parentProject.equals(Adapters.adapt((Object)element, IProject.class))) {
                    parentWorkingSets.add(workingSet);
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        try {
            IProjectDescription desc = ResourcesPlugin.getWorkspace().loadProjectDescription(folder.getLocation().append(".project"));
            desc.setLocation(folder.getLocation());
            CreateProjectOperation operation = new CreateProjectOperation(desc, desc.getName());
            try {
                IStatus status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, null, null);
                if (status.isOK()) {
                    IProject newProject = (IProject)operation.getAffectedObjects()[0];
                    workingSetManager.addToWorkingSets((IAdaptable)newProject, parentWorkingSets.toArray(new IWorkingSet[parentWorkingSets.size()]));
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void deleteFileOfFolder(File path) {
        if (!path.exists()) {
            return;
        }
        if (path.isFile()) {
            path.delete();
            return;
        }
        File[] files = path.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            this.deleteFileOfFolder(files[i]);
            ++i;
        }
        path.delete();
    }
}

