/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target;

import com.gigadevice.mbs.arm.Option;
import com.gigadevice.templates.core.ProjectSetOptionValue;
import com.gigadevice.venustool.TargetOSInfo;
import java.io.File;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectCppSettings
extends ProcessRunner {
    private String toolchain;
    private String RISCVtoolchainPath;
    private String ARMtoolchainPath;
    private String buildtoolPath;
    private String projectName;

    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        this.toolchain = template.getTemplateInfo().getToolChainIds()[0];
        System.out.println(this.toolchain);
        this.RISCVtoolchainPath = "." + File.separator + "Tools" + File.separator + "RISC-V Embedded GCC" + File.separator + "8.2.0-2.2-20190521-0004" + File.separator + "bin";
        this.buildtoolPath = "." + File.separator + "Tools" + File.separator + "Build Tools" + File.separator + "2.10-20180103-1919" + File.separator + "bin";
        this.ARMtoolchainPath = "." + File.separator + "Tools" + File.separator + "GNU Tools ARM Embedded" + File.separator + "xpack-arm-none-eabi-gcc" + File.separator + "9.2.1-1.1" + File.separator + "bin";
        if (TargetOSInfo.isLinux()) {
            this.RISCVtoolchainPath = "." + File.separator + "Tools" + File.separator + "RISC-VEmbeddedGCC" + File.separator + "8.2.0-2.2-20190521-0004" + File.separator + "bin";
            this.buildtoolPath = "." + File.separator + "Tools" + File.separator + "BuildTools" + File.separator + "2.10-20180103-1919" + File.separator + "bin";
            this.ARMtoolchainPath = "." + File.separator + "Tools" + File.separator + "GNUToolsARMEmbedded" + File.separator + "xpack-arm-none-eabi-gcc" + File.separator + "9.2.1-1.1" + File.separator + "bin";
        }
        ProcessArgument[] processArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument arg = processArgumentArray[n2];
            if (arg.getName().equals("projectName")) {
                this.projectName = arg.getSimpleValue();
            }
            ++n2;
        }
        IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        ProjectSetOptionValue SetOptionValue = new ProjectSetOptionValue();
        switch (this.toolchain) {
            case "com.gigadevice.mbs.arm.toolChain": {
                try {
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_NAME, "GNU Tools for ARM Embedded Processors");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_PREFIX, "arm-none-eabi-");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_CPP, "arm-none-eabi-g++");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_RM, "rm");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_MAKE, "make");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_OBJCOPY, "arm-none-eabi-objcopy");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_OBJDUMP, "arm-none-eabi-objdump");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_SIZE, "arm-none-eabi-size");
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_TOOLCHAIN_PATH, this.ARMtoolchainPath);
                    SetOptionValue.setOptionValue(projectHandle, Option.OPTIONID_BUILDTOOL_PATH, this.buildtoolPath);
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            }
            case "com.gigadevice.mbs.riscv.toolChain": {
                try {
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_NAME, "GNU MCU RISC-V GCC");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_PATH, this.RISCVtoolchainPath);
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_BUILDTOOL_PATH, this.buildtoolPath);
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_PREFIX, "riscv-none-embed-");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_CPP, "riscv-none-embed-g++");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_RM, "rm");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_MAKE, "make");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJCOPY, "riscv-none-embed-objcopy");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_OBJDUMP, "riscv-none-embed-objdump");
                    SetOptionValue.setOptionValue(projectHandle, com.gigadevice.mbs.riscv.Option.OPTIONID_TOOLCHAIN_SIZE, "riscv-none-embed-size");
                    break;
                }
                catch (BuildException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

