/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.templates.target;

import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.CoreInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CreateMultiBuildConfigurations {
    private static final String DebugConfigurationName = "GD ARM MCU Debug";
    private static final String ReleaseConfigurationName = "GD ARM MCU Release";
    public static String ARTIFACT_NAME = "${ProjName}";
    LinkedHashMap<String, CoreInfo> CoreInfoMap;
    public static String CoreType = "";
    public static String ProjectLocation = "";
    public static final String CoreTypeDefaultSymbol = "xxx";
    private static MCUSeletorInfo tmpMcuSeletorInfo = null;
    private static final String ARMFamily = "com.gigadevice.mbs.arm.option.targetProcessor.ARMFamily";

    public void process(TemplateCore template, IProject project, String targetMCUPartNo) {
        try {
            ProjectLocation = project.getLocation().toString();
            this.AnalyseMCUCoreType(template);
            tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)1, (String)targetMCUPartNo);
            this.CoreInfoMap = tmpMcuSeletorInfo.getCoreInfoMap();
            if (this.CoreInfoMap == null || this.CoreInfoMap.size() == 0) {
                this.CoreInfoMap = tmpMcuSeletorInfo.getMCUSubGroupCoreInfoMap();
            }
            if (this.CoreInfoMap.size() > 0) {
                this.createConfigurations(project);
                ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
                this.setAllConfigurationInfo(project);
            } else {
                List configs = ProjectUtils.getConfigurationsListForProject((IProject)project);
                for (IConfiguration config : configs) {
                    this.setLinkerFile(config, (String)template.getValueStore().get("ldFile"));
                    ArrayList<String> tempList = new ArrayList<String>();
                    this.setIncludeFile(project, config, tempList);
                }
            }
            ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
            project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void AnalyseMCUCoreType(TemplateCore template) {
        String type = (String)template.getValueStore().get("MCUCore");
        CoreType = type.toLowerCase().contains("risc") ? "riscv" : "arm";
    }

    private void createConfigurations(IProject project) throws CoreException {
        IConfiguration[] configs;
        Set<String> MCUCores = this.CoreInfoMap.keySet();
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] arrayOfIConfiguration = configs = buildInfo.getManagedProject().getConfigurations();
        boolean isAppend = false;
        if (MCUCores.size() > 1) {
            isAppend = true;
        }
        IConfiguration[] iConfigurationArray = arrayOfIConfiguration;
        int n = arrayOfIConfiguration.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration config = iConfigurationArray[n2];
            boolean first = true;
            String originalName = config.getName();
            String originalID = config.getId().substring(0, config.getId().lastIndexOf("."));
            for (String MCUCore : MCUCores) {
                CoreInfo coreInfo = this.CoreInfoMap.get(MCUCore);
                if (!isAppend) continue;
                String ShortCore = this.getShortCore(coreInfo.getCoreIndex(), coreInfo.getCoreID());
                if (!first) {
                    config = buildInfo.getManagedProject().createConfigurationClone(config, String.valueOf(String.valueOf(originalID)) + "." + this.getNewID());
                }
                first = false;
                config.setName(String.valueOf(this.getBuildType(originalName)) + ShortCore);
                config.setArtifactName(String.valueOf(String.valueOf(ARTIFACT_NAME)) + "_" + ShortCore);
            }
            ++n2;
        }
    }

    private String getOptionID(String Option) {
        String OptionID = Option.replaceAll(CoreTypeDefaultSymbol, CoreType);
        return OptionID;
    }

    private void setIncludeFile(IProject project, IConfiguration config, ArrayList<String> ExcludePath) {
        ArrayList<String> type = new ArrayList<String>();
        type.add(".h");
        File rootFile = new File(project.getLocation().toOSString());
        ArrayList<String> IncludeFileList = this.findDirectoriesWithSpecialFiles(rootFile, rootFile, type, ExcludePath);
        if (IncludeFileList == null || IncludeFileList.size() == 0) {
            return;
        }
        String OptionID = this.getOptionID("com.gigadevice.mbs.xxx.option.CCompiler.includes.paths");
        this.setOptionValue(config, OptionID, ProjectUtils.ArrayListToList(IncludeFileList));
    }

    public void setLinkerFile(IConfiguration config, String LdFile) {
        if (LdFile == null || LdFile.length() <= 0) {
            return;
        }
        String OptionID = this.getOptionID("com.gigadevice.mbs.xxx.option.linker.general.scriptFile");
        this.setOptionValue(config, OptionID, ProjectUtils.StringToList((String)LdFile));
    }

    public void setSymbols(IConfiguration config, ArrayList<String> Symbols) {
        if (Symbols == null || Symbols.size() <= 0) {
            return;
        }
        ArrayList addSymbols = ProjectUtils.getAddSymbols();
        for (String Symbol : addSymbols) {
            if (Symbols.contains(Symbol)) continue;
            Symbols.add(Symbol);
        }
        String OptionID = this.getOptionID("com.gigadevice.mbs.xxx.option.CCompiler.symbols.defs");
        this.setOptionValue(config, OptionID, ProjectUtils.ArrayListToList(Symbols));
        OptionID = this.getOptionID("com.gigadevice.mbs.xxx.option.assembler.symbols.defs");
        this.setOptionValue(config, OptionID, ProjectUtils.ArrayListToList(Symbols));
    }

    private String getShortCore(String CoreIndex, String CoreID) {
        String ShortCore = "";
        ShortCore = CoreID.contains("-") ? CoreID.split("-")[1] : CoreID;
        ShortCore = String.valueOf(ShortCore) + "_" + CoreIndex;
        ShortCore = ShortCore.toUpperCase();
        return ShortCore;
    }

    private String getBuildType(String originalName) {
        String buildType = "";
        if (originalName.toLowerCase().contains("debug")) {
            buildType = "Debug_";
        } else if (originalName.toLowerCase().contains("release")) {
            buildType = "Release_";
        }
        return buildType;
    }

    private void setOptions(IConfiguration Configuration, String CoreName) {
        LinkedHashMap Options;
        CoreInfo coreInfo = this.CoreInfoMap.get(CoreName);
        if (coreInfo == null) {
            return;
        }
        if (!tmpMcuSeletorInfo.getCore().toLowerCase().contains("risc")) {
            this.setOptionValue(Configuration, ARMFamily, coreInfo.getCoreID());
        }
        if ((Options = coreInfo.getOptions()) == null || Options.size() <= 0) {
            return;
        }
        Set OptionIDs = Options.keySet();
        for (String OptionID : OptionIDs) {
            LinkedHashMap ValueType = (LinkedHashMap)Options.get(OptionID);
            Set ValueSet = ValueType.keySet();
            for (String value : ValueSet) {
                String type = (String)ValueType.get(value);
                switch (value) {
                    case "true": {
                        this.setOptionValue(Configuration, OptionID, true);
                        break;
                    }
                    case "false": {
                        this.setOptionValue(Configuration, OptionID, false);
                        break;
                    }
                    default: {
                        if (value.contains(",") || type.equalsIgnoreCase("list")) {
                            this.setOptionValue(Configuration, OptionID, ProjectUtils.StringToList((String)value));
                            break;
                        }
                        this.setOptionValue(Configuration, OptionID, value);
                    }
                }
            }
        }
    }

    private int getNewID() {
        SecureRandom random = new SecureRandom();
        int newId = random.nextInt();
        if (newId < 0) {
            newId *= -1;
        }
        return newId;
    }

    private void setOptionValue(IConfiguration configuration, String id, String value) {
        try {
            ITool[] tools;
            IToolChain toolChain = configuration.getToolChain();
            IOption toolChainOption = toolChain.getOptionById(id);
            if (toolChainOption != null) {
                configuration.setOption((IHoldsOptions)toolChain, toolChainOption, value);
            }
            ITool[] iToolArray = tools = configuration.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption toolOption = tool.getOptionById(id);
                if (toolOption != null) {
                    configuration.setOption((IHoldsOptions)tool, toolOption, value);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    private void setOptionValue(IConfiguration configuration, String id, Boolean value) {
        try {
            ITool[] tools;
            IToolChain toolChain = configuration.getToolChain();
            IOption toolChainOption = toolChain.getOptionById(id);
            if (toolChainOption != null) {
                configuration.setOption((IHoldsOptions)toolChain, toolChainOption, value.booleanValue());
            }
            ITool[] iToolArray = tools = configuration.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption toolOption = tool.getOptionById(id);
                if (toolOption != null) {
                    configuration.setOption((IHoldsOptions)tool, toolOption, value.booleanValue());
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    private void setOptionValue(IConfiguration configuration, String id, String[] value) {
        try {
            ITool[] tools;
            IToolChain toolChain = configuration.getToolChain();
            IOption toolChainOption = toolChain.getOptionById(id);
            if (toolChainOption != null) {
                configuration.setOption((IHoldsOptions)toolChain, toolChainOption, value);
            }
            ITool[] iToolArray = tools = configuration.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption toolOption = tool.getOptionById(id);
                if (toolOption != null) {
                    configuration.setOption((IHoldsOptions)tool, toolOption, value);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    private void setConfigurationInfo(IProject project, String MCUCore, String configName) {
        ICConfigurationDescription[] configDescriptions;
        ICProjectDescriptionManager pdManager = CoreModel.getDefault().getProjectDescriptionManager();
        ICProjectDescription projectDesc = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions = projectDesc.getConfigurations();
        int n = configDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configDesc = iCConfigurationDescriptionArray[n2];
            IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configDesc);
            if (config.getName().equals(configName)) {
                try {
                    String prefix = "/" + project.getName() + "/";
                    CoreInfo coreInfo = this.CoreInfoMap.get(MCUCore);
                    if (coreInfo == null) {
                        return;
                    }
                    this.setOptions(config, MCUCore);
                    this.setSymbols(config, coreInfo.getSymbols());
                    this.setLinkerFile(config, coreInfo.getLdFile());
                    ArrayList<String> ExcludeFileList = this.getExcludeFileStringList(MCUCore, "");
                    this.setIncludeFile(project, config, ExcludeFileList);
                    List<IPath> IPathList = this.getExcludeFilePathList(MCUCore, prefix);
                    this.setExcludedPath(IPathList, configName, projectDesc);
                    pdManager.setProjectDescription(project, projectDesc, true, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private void setAllConfigurationInfo(IProject project) throws CoreException {
        Set<String> MCUCores = this.CoreInfoMap.keySet();
        if (MCUCores == null || MCUCores.size() <= 0) {
            return;
        }
        int CoreNum = MCUCores.size();
        for (String MCUCore : MCUCores) {
            CoreInfo coreInfo = this.CoreInfoMap.get(MCUCore);
            String ShortCore = this.getShortCore(coreInfo.getCoreIndex(), coreInfo.getCoreID());
            String DebugConfigName = "";
            String ReleaseConfigName = "";
            if (CoreNum <= 1) {
                DebugConfigName = DebugConfigurationName;
                ReleaseConfigName = ReleaseConfigurationName;
            } else {
                DebugConfigName = String.valueOf(this.getBuildType("Debug")) + ShortCore;
                ReleaseConfigName = String.valueOf(this.getBuildType("Release")) + ShortCore;
            }
            this.setConfigurationInfo(project, MCUCore, DebugConfigName);
            this.setConfigurationInfo(project, MCUCore, ReleaseConfigName);
        }
    }

    private List<IPath> getExcludeFilePathList(String MCUCore, String prefix) {
        ArrayList<String> ExcludeResources = this.getExcludeFileStringList(MCUCore, prefix);
        ArrayList<IPath> IPathList = new ArrayList<IPath>();
        for (String ExcludeResource : ExcludeResources) {
            IPathList.add((IPath)new Path(ExcludeResource));
        }
        return IPathList;
    }

    private ArrayList<String> getExcludeFileStringList(String MCUCore, String prefix) {
        ArrayList ExcludeResources = this.CoreInfoMap.get(MCUCore).getExcludeResource();
        ArrayList<String> StringList = new ArrayList<String>();
        for (String ExcludeResource : ExcludeResources) {
            if (ExcludeResource.contains(",")) {
                String[] SplitExcludeResource;
                String[] stringArray = SplitExcludeResource = ExcludeResource.split(",");
                int n = SplitExcludeResource.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String locationString = ProjectUtils.findFileFolder((String)ProjectLocation, (String)string);
                    StringList.add(String.valueOf(prefix) + locationString + string);
                    ++n2;
                }
                continue;
            }
            String locationString = ProjectUtils.findFileFolder((String)ProjectLocation, (String)ExcludeResource);
            StringList.add(String.valueOf(prefix) + locationString + ExcludeResource);
        }
        return StringList;
    }

    public void setExcludedPath(List<IPath> excludeList, String ConfigName, ICProjectDescription projectDesc) throws CoreException {
        ICConfigurationDescription config = projectDesc.getConfigurationByName(ConfigName);
        if (config == null) {
            return;
        }
        for (IPath path : excludeList) {
            this.setExcludedPath(path, config);
        }
    }

    private void setExcludedPath(IPath path, ICConfigurationDescription config) throws CoreException {
        ICSourceEntry[] newEntries = CDataUtil.setExcluded((IPath)path, (boolean)(path instanceof IFolder), (boolean)true, (ICSourceEntry[])config.getSourceEntries());
        config.setSourceEntries(newEntries);
    }

    public ArrayList<String> findDirectoriesWithSpecialFiles(File rootFolder, File currentFolder, ArrayList<String> FileType, ArrayList<String> ExcludeFolder) {
        File[] files;
        ArrayList<String> result = new ArrayList<String>();
        if (currentFolder.isDirectory() && (files = currentFolder.listFiles()) != null) {
            File file;
            boolean containsSpecialFile = false;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.isFile()) {
                    for (String type : FileType) {
                        if (!file.getName().endsWith(type)) continue;
                        containsSpecialFile = true;
                        break;
                    }
                }
                if (containsSpecialFile) break;
                ++n2;
            }
            if (containsSpecialFile) {
                String relativePath = "\"../" + rootFolder.toURI().relativize(currentFolder.toURI()).getPath() + "\"";
                result.add(relativePath);
            }
            fileArray = files;
            n = files.length;
            n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.isDirectory() && !ExcludeFolder.contains(file.getName())) {
                    result.addAll(this.findDirectoriesWithSpecialFiles(rootFolder, file, FileType, ExcludeFolder));
                }
                ++n2;
            }
        }
        return result;
    }

    public static IConfiguration getConfigurationByName(IProject project, String configName) {
        if (!project.exists()) {
            return null;
        }
        try {
            ICConfigurationDescription[] configDescriptions;
            ICConfigurationDescription[] iCConfigurationDescriptionArray = configDescriptions = CoreModel.getDefault().getProjectDescription(project).getConfigurations();
            int n = configDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                ICConfigurationDescription description = iCConfigurationDescriptionArray[n2];
                IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)description);
                if (configuration.getName().equals(configName)) {
                    return configuration;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

