/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codepreview.util;

import com.gigadevice.codegenerate.codetemplate.GenerateTemplateCode;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.filegenerate.FileGenerate;
import com.gigadevice.codegenerate.xmlparse.CodeTemplateXMLParse;
import com.gigadevice.mwcodegenerate.baseinfo.MwGenerateCode;
import com.gigadevice.periconfigview.utils.PerisConfigUtil;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;

public class CodePreviewUtil {
    public static void updateTemplateFile(String projectPath) {
        CodePreviewUtil.UpdateOldDirFile(projectPath);
        CodePreviewUtil.GenerateNewCodeFile(projectPath);
    }

    public static void DeleteDir() {
        File newDir;
        String oldPath = CodePreviewUtil.GetOldFilePath();
        String newPath = CodePreviewUtil.GetNewFilePath();
        File oldDir = new File(oldPath);
        if (oldDir.exists()) {
            CodePreviewUtil.deleteDirectoryRecursively(oldDir);
        }
        if ((newDir = new File(newPath)).exists()) {
            CodePreviewUtil.deleteDirectoryRecursively(newDir);
        }
    }

    public static void UpdateOldDirFile(String projectPath) {
        CodePreviewUtil.DeleteDir();
        String configPath = CodePreviewUtil.GetOldFilePath();
        CodePreviewUtil.copyDirectoryByPath(projectPath, configPath);
    }

    public static void copyDirectoryByPath(String sourcePath, String targetPath) {
        File sourceDir = new File(sourcePath);
        File targetDir = new File(targetPath);
        if (!sourceDir.exists()) {
            return;
        }
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            CodePreviewUtil.copyDirectory(sourceDir, targetDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void GenerateNewCodeFile(String projectPath) {
        String configPath = CodePreviewUtil.GetNewFilePath();
        CodePreviewUtil.copyDirectoryByPath(String.valueOf(projectPath) + File.separator + "inc", String.valueOf(configPath) + File.separator + "inc");
        CodePreviewUtil.copyDirectoryByPath(String.valueOf(projectPath) + File.separator + "src", String.valueOf(configPath) + File.separator + "src");
        TemplateGroupStruct codeTemplateObj = null;
        String filePath = String.valueOf(GeneralPathUtil.ResourcePath) + "CodeTemplate" + File.separator + "CodeTemplate.xml";
        codeTemplateObj = CodeTemplateXMLParse.parseTemplateCodeXML((String)filePath);
        PerisConfigUtil.InitGeneralandSysPeriCofigInfo();
        FileGenerate FileGenerateObj = new FileGenerate(configPath, GlobalVariables.McuSeletorInfo.getCodeGroup(), codeTemplateObj);
        FileGenerateObj.GenerateCodeFile();
        try {
            MwGenerateCode obj = new MwGenerateCode();
            obj.generateProcess(configPath, true);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (TemplateException e1) {
            e1.printStackTrace();
        }
        CodePreviewUtil.generateTemplateCode(configPath, codeTemplateObj);
    }

    public static String GetNewFilePath() {
        String configPath = String.valueOf(GeneralPathUtil.getEclipsePath()) + "configuration" + File.separator + "com.gigadevice.config" + File.separator + "New";
        return configPath;
    }

    public static String GetOldFilePath() {
        String configPath = String.valueOf(GeneralPathUtil.getEclipsePath()) + "configuration" + File.separator + "com.gigadevice.config" + File.separator + "Old";
        return configPath;
    }

    private static void copyDirectory(File source, File target) throws Exception {
        if (source.isDirectory()) {
            String[] files;
            if (!target.exists()) {
                target.mkdir();
            }
            if ((files = source.list()) != null) {
                String[] stringArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    File sourceFile = new File(source, file);
                    File targetFile = new File(target, file);
                    CodePreviewUtil.copyDirectory(sourceFile, targetFile);
                    ++n2;
                }
            }
        } else {
            Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static boolean deleteDirectoryRecursively(File directory) {
        if (directory == null || !directory.exists()) {
            return false;
        }
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    CodePreviewUtil.deleteDirectoryRecursively(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }

    public static String getFileOldPath(String newFileName) {
        File foundFile;
        File rootDir;
        String oldFilePath = "";
        String oldFileRootPath = CodePreviewUtil.GetOldFilePath();
        if (oldFileRootPath != null && !oldFileRootPath.isEmpty() && (rootDir = new File(oldFileRootPath)).exists() && rootDir.isDirectory() && (foundFile = CodePreviewUtil.findFileInDirectory(rootDir, newFileName)) != null) {
            oldFilePath = foundFile.getAbsolutePath();
        }
        return oldFilePath;
    }

    public static File findFileInDirectory(File directory, String fileName) {
        if (directory == null || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File found;
            File file = fileArray[n2];
            if (file.isFile() && file.getName().equals(fileName)) {
                return file;
            }
            if (file.isDirectory() && (found = CodePreviewUtil.findFileInDirectory(file, fileName)) != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    private static void generateTemplateCode(String GdcFilePath, TemplateGroupStruct codeTemplateObj) {
        String mcuGroup = GlobalVariables.McuSeletorInfo.getFirstPeriConfigAndCodePath();
        LinkedHashMap templateGroupMap = codeTemplateObj.getGroups();
        if (!templateGroupMap.containsKey(mcuGroup)) {
            return;
        }
        TemplateInfoStruct templateInfoObj = (TemplateInfoStruct)templateGroupMap.get(mcuGroup);
        LinkedHashMap templateMap = templateInfoObj.getTemplate();
        for (Map.Entry templateMapEntry : templateMap.entrySet()) {
            String cfr_ignored_0 = (String)templateMapEntry.getKey();
            TemplateStruct templateObj = (TemplateStruct)templateMapEntry.getValue();
            if (!templateObj.getSourceType().equals("1")) continue;
            LinkedHashMap perMap = new LinkedHashMap();
            GenerateTemplateCode obj = new GenerateTemplateCode(templateObj, perMap);
            obj.generateCode(GdcFilePath, templateObj);
        }
    }
}

