/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.codepreview;

import com.gigadevice.codepreview.CodePreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class FileTreePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree fileTree;
    private JTabbedPane rightTabbedPane;
    private File rootFolder;

    public FileTreePanel(File rootFolder, JTabbedPane rightTabbedPane) {
        this.rootFolder = rootFolder;
        this.rightTabbedPane = rightTabbedPane;
        this.initializePanel();
    }

    private void initializePanel() {
        this.setLayout(new BorderLayout());
        this.fileTree = this.createFileTree(this.rootFolder);
        this.fileTree.setRowHeight(20);
        JPanel controlPanel = this.createControlPanel();
        JScrollPane scrollPane = new JScrollPane(this.fileTree);
        this.add((Component)controlPanel, "North");
        this.add((Component)scrollPane, "Center");
        this.addEventListeners();
    }

    private JTree createFileTree(File rootFolder) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootFolder);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.loadDirectoryContents(rootNode, rootFolder);
        final JTree tree = new JTree(treeModel);
        tree.expandPath(new TreePath(rootNode.getPath()));
        tree.setCellRenderer(new FileTreeCellRenderer());
        SwingUtilities.invokeLater(() -> this.expandAllNodes(tree, rootNode));
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                DefaultMutableTreeNode firstChild;
                File file;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof File && (file = (File)userObject).isDirectory() && node.getChildCount() > 0 && (firstChild = (DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() instanceof String && ((String)firstChild.getUserObject()).equals("Loading...")) {
                    node.removeAllChildren();
                    FileTreePanel.this.loadDirectoryContents(node, file);
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    model.nodeStructureChanged(node);
                    SwingUtilities.invokeLater(() -> FileTreePanel.this.expandAllNodes(tree, node));
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.addFolderContextMenu(tree);
        return tree;
    }

    private JPanel createControlPanel() {
        JPanel controlPanel = new JPanel(new FlowLayout(0));
        JButton expandAllButton = new JButton("Expand All");
        JButton collapseAllButton = new JButton("Collapse All");
        expandAllButton.setToolTipText("Expand all nodes");
        collapseAllButton.setToolTipText("Collapse all nodes");
        expandAllButton.addActionListener(e -> {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.fileTree.getModel().getRoot();
            this.expandAllNodes(this.fileTree, root);
        });
        collapseAllButton.addActionListener(e -> {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.fileTree.getModel().getRoot();
            this.collapseAllNodes(this.fileTree, root);
            this.fileTree.expandPath(new TreePath(root.getPath()));
        });
        controlPanel.add(expandAllButton);
        controlPanel.add(collapseAllButton);
        return controlPanel;
    }

    private void addEventListeners() {
        this.fileTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                File file;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)FileTreePanel.this.fileTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                Object userObject = node.getUserObject();
                if (userObject instanceof File && (file = (File)userObject).isFile()) {
                    CodePreview.openFileSideBySideDiffView(file, FileTreePanel.this.rightTabbedPane);
                }
            }
        });
        this.fileTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                File file;
                Object userObject;
                DefaultMutableTreeNode node;
                TreePath path;
                if (e.getClickCount() == 1 && (path = FileTreePanel.this.fileTree.getPathForLocation(e.getX(), e.getY())) != null && (node = (DefaultMutableTreeNode)path.getLastPathComponent()) != null && (userObject = node.getUserObject()) instanceof File && (file = (File)userObject).isFile()) {
                    String fileName = file.getName();
                    boolean isAlreadyOpen = false;
                    int i = 0;
                    while (i < FileTreePanel.this.rightTabbedPane.getTabCount()) {
                        String title = FileTreePanel.this.rightTabbedPane.getTitleAt(i);
                        if (title.equals(fileName)) {
                            FileTreePanel.this.rightTabbedPane.setSelectedIndex(i);
                            isAlreadyOpen = true;
                            CodePreview.saveCurrentState();
                            break;
                        }
                        ++i;
                    }
                    if (!isAlreadyOpen) {
                        CodePreview.openFileSideBySideDiffView(file, FileTreePanel.this.rightTabbedPane);
                    }
                }
            }
        });
    }

    private void loadDirectoryContents(DefaultMutableTreeNode parent, File directory) {
        File file;
        File[] files = directory.listFiles();
        if (files == null) {
            parent.add(new DefaultMutableTreeNode("Error: Unable to list directory contents"));
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.isDirectory()) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(file);
                parent.add(child);
                this.loadDirectoryContents(child, file);
            }
            ++n2;
        }
        fileArray = files;
        n = files.length;
        n2 = 0;
        while (n2 < n) {
            file = fileArray[n2];
            if (file.isFile()) {
                parent.add(new DefaultMutableTreeNode(file));
            }
            ++n2;
        }
    }

    private void addFolderContextMenu(final JTree tree) {
        final JPopupMenu folderPopupMenu = new JPopupMenu();
        JMenuItem expandFolderItem = new JMenuItem("Expand Current Folder");
        JMenuItem collapseFolderItem = new JMenuItem("Collapse Current Folder");
        JMenuItem expandAllFolderItem = new JMenuItem("Expand All Subfolders");
        JMenuItem collapseAllFolderItem = new JMenuItem("Collapse All Subfolders");
        folderPopupMenu.add(expandFolderItem);
        folderPopupMenu.add(collapseFolderItem);
        folderPopupMenu.addSeparator();
        folderPopupMenu.add(expandAllFolderItem);
        folderPopupMenu.add(collapseAllFolderItem);
        expandFolderItem.addActionListener(e -> {
            File file;
            DefaultMutableTreeNode node;
            Object userObject;
            TreePath path = tree.getSelectionPath();
            if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof File && (file = (File)userObject).isDirectory()) {
                DefaultMutableTreeNode firstChild;
                if (node.getChildCount() > 0 && (firstChild = (DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() instanceof String && ((String)firstChild.getUserObject()).equals("Loading...")) {
                    node.removeAllChildren();
                    this.loadDirectoryContents(node, file);
                    DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
                    model.nodeStructureChanged(node);
                }
                tree.expandPath(path);
            }
        });
        collapseFolderItem.addActionListener(e -> {
            TreePath path = tree.getSelectionPath();
            if (path != null && path.getPathCount() > 1) {
                tree.collapsePath(path);
            }
        });
        expandAllFolderItem.addActionListener(e -> {
            File file;
            DefaultMutableTreeNode node;
            Object userObject;
            TreePath path = tree.getSelectionPath();
            if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof File && (file = (File)userObject).isDirectory()) {
                this.expandAllNodes(tree, node);
            }
        });
        collapseAllFolderItem.addActionListener(e -> {
            File file;
            DefaultMutableTreeNode node;
            Object userObject;
            TreePath path = tree.getSelectionPath();
            if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof File && (file = (File)userObject).isDirectory()) {
                this.collapseAllNodes(tree, node);
                if (path.getPathCount() > 1) {
                    tree.expandPath(path);
                }
            }
        });
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FileTreePanel.this.showFolderContextMenu(e, tree, folderPopupMenu);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FileTreePanel.this.showFolderContextMenu(e, tree, folderPopupMenu);
                }
            }
        });
    }

    private void showFolderContextMenu(MouseEvent e, JTree tree, JPopupMenu folderPopupMenu) {
        File file;
        DefaultMutableTreeNode node;
        Object userObject;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof File && (file = (File)userObject).isDirectory()) {
            tree.setSelectionPath(path);
            boolean isExpanded = tree.isExpanded(path);
            boolean isRoot = path.getPathCount() == 1;
            JMenuItem expandItem = (JMenuItem)folderPopupMenu.getComponent(0);
            JMenuItem collapseItem = (JMenuItem)folderPopupMenu.getComponent(1);
            expandItem.setEnabled(!isExpanded);
            collapseItem.setEnabled(isExpanded && !isRoot);
            folderPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void expandAllNodes(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() > 0) {
            tree.expandPath(new TreePath(node.getPath()));
            int i = 0;
            while (i < node.getChildCount()) {
                File file;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object userObject = child.getUserObject();
                if (userObject instanceof File && (file = (File)userObject).isDirectory()) {
                    DefaultMutableTreeNode firstGrandChild;
                    if (child.getChildCount() > 0 && (firstGrandChild = (DefaultMutableTreeNode)child.getChildAt(0)).getUserObject() instanceof String && ((String)firstGrandChild.getUserObject()).equals("Loading...")) {
                        child.removeAllChildren();
                        this.loadDirectoryContents(child, file);
                    }
                    this.expandAllNodes(tree, child);
                }
                ++i;
            }
        }
    }

    private void collapseAllNodes(JTree tree, DefaultMutableTreeNode node) {
        if (node.getChildCount() > 0) {
            int i = 0;
            while (i < node.getChildCount()) {
                File file;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                Object userObject = child.getUserObject();
                if (userObject instanceof File && (file = (File)userObject).isDirectory()) {
                    this.collapseAllNodes(tree, child);
                }
                ++i;
            }
            TreePath path = new TreePath(node.getPath());
            if (path.getPathCount() > 1) {
                tree.collapsePath(path);
            }
        }
    }

    public JTree getFileTree() {
        return this.fileTree;
    }

    private static class FileTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        private Map<String, Icon> iconCache = new HashMap<String, Icon>();
        private Icon folderIcon = this.loadIcon("/icons/cprojects.gif");
        private Icon cFileIcon = this.loadIcon("/icons/c_file_obj.gif");
        private Icon hFileIcon = this.loadIcon("/icons/open_include.gif");
        private Icon fileEditIcon = this.loadIcon("/icons/edit.gif");
        private Icon fileAddIcon = this.loadIcon("/icons/add.gif");
        private Icon fileDeleteIcon = this.loadIcon("/icons/delete.gif");

        private Icon loadIcon(String path) {
            try {
                URL resource = this.getClass().getResource(path);
                if (resource != null) {
                    return new ImageIcon(resource);
                }
            }
            catch (Exception exception) {}
            return null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof File) {
                File file = (File)userObject;
                label.setText(file.getName());
                String path = file.getAbsolutePath();
                Icon icon = this.iconCache.get(path);
                if (file.isDirectory()) {
                    icon = this.folderIcon != null ? this.folderIcon : this.fileSystemView.getSystemIcon(file);
                } else if (file.isFile()) {
                    if (file.getName().endsWith(".c")) {
                        icon = CodePreview.isFileDifferent(file) ? (this.fileEditIcon != null ? this.fileEditIcon : this.fileSystemView.getSystemIcon(file)) : (CodePreview.isNewFile(file) ? (this.fileAddIcon != null ? this.fileAddIcon : this.fileSystemView.getSystemIcon(file)) : (this.cFileIcon != null ? this.cFileIcon : this.fileSystemView.getSystemIcon(file)));
                    } else if (file.getName().endsWith(".h")) {
                        if (CodePreview.isFileDifferent(file)) {
                            icon = this.fileEditIcon != null ? this.fileEditIcon : this.fileSystemView.getSystemIcon(file);
                        } else if (CodePreview.isNewFile(file)) {
                            icon = this.fileAddIcon != null ? this.fileAddIcon : this.fileSystemView.getSystemIcon(file);
                        } else {
                            Icon icon2 = icon = this.hFileIcon != null ? this.hFileIcon : this.fileSystemView.getSystemIcon(file);
                        }
                    }
                }
                if (icon == null) {
                    icon = this.fileSystemView.getSystemIcon(file);
                }
                this.iconCache.put(path, icon);
                label.setIcon(icon);
            }
            return label;
        }
    }
}

