/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.gdconfig.ui.access;

import com.gigadevice.gdconfig.ui.access.SerializeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.core.resources.IProject;

public class SerializeAccess {
    public static void SerializeSave(IProject m_Project) {
        String GdcFilePath = SerializeAccess.GetGdcFilePath(m_Project);
        ObjectOutputStream oos = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(GdcFilePath, false);
            oos = new ObjectOutputStream(fileOutputStream);
            SerializeUtil Util = new SerializeUtil();
            oos.writeObject(Util);
            fileOutputStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int DeserializeExtract(IProject m_Project) {
        String GdcFilePath = SerializeAccess.GetGdcFilePath(m_Project);
        try {
            Throwable throwable = null;
            Object var3_7 = null;
            try (ObjectInputStream ios = new ObjectInputStream(new FileInputStream(GdcFilePath));){
                ios.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (FileNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return 0;
    }

    protected static String GetGdcFilePath(IProject m_Project) {
        String ProjectName = m_Project.getName();
        String projectPath = m_Project.getLocation().toOSString();
        File folder = new File(projectPath);
        if (folder == null || !folder.isDirectory()) {
            throw new IllegalArgumentException("The provided path is not a valid directory.");
        }
        File[] files = folder.listFiles();
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().endsWith(".gdc")) {
                return file.getAbsolutePath();
            }
            ++n2;
        }
        String GdcFilePath = String.valueOf(m_Project.getLocation().toOSString()) + File.separator + ProjectName + "." + "gdc";
        return GdcFilePath;
    }
}

