/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.gdconfig.ui;

import com.gigadevice.clockconfigview.RCUTreeView;
import com.gigadevice.codegenerate.codetemplate.GenerateTemplateCode;
import com.gigadevice.codegenerate.codetemplate.TemplateGroupStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateInfoStruct;
import com.gigadevice.codegenerate.codetemplate.TemplateStruct;
import com.gigadevice.codegenerate.filegenerate.FileGenerate;
import com.gigadevice.codegenerate.generatecode.PeriCodeGen;
import com.gigadevice.codegenerate.informationbasestruct.GroupStruct;
import com.gigadevice.codegenerate.informationbasestruct.InfoGroupStruct;
import com.gigadevice.codegenerate.informationbasestruct.InfoStruct;
import com.gigadevice.codegenerate.projectmigrate.GenerateProjectFile;
import com.gigadevice.codegenerate.xmlparse.CodeTemplateXMLParse;
import com.gigadevice.codegenerate.xmlparse.InformationXmlParse;
import com.gigadevice.codepreview.CodePreview;
import com.gigadevice.codepreview.util.CodePreviewUtil;
import com.gigadevice.conflict.ConflictCheck;
import com.gigadevice.conflict.NewConflictCheck;
import com.gigadevice.conflict.baseinfo.ConflictGroupInfo;
import com.gigadevice.conflict.baseinfo.NewRelationGroup;
import com.gigadevice.conflict.util.ConflictUtil;
import com.gigadevice.conflict.xmlparse.NewConditionXmlParse;
import com.gigadevice.gdconfig.ui.access.SerializeAccess_Template;
import com.gigadevice.gdconfig.ui.baseinfo.FirmwareStruct;
import com.gigadevice.gdconfig.ui.baseinfo.FirmwaresStruct;
import com.gigadevice.gdconfig.ui.baseinfo.SeriesStruct;
import com.gigadevice.gdconfig.ui.gdprojectsetting.GDProjectSettingView;
import com.gigadevice.gdconfig.ui.utils.ProjectConfigUtil;
import com.gigadevice.mwcodegenerate.baseinfo.MwGenearteTools;
import com.gigadevice.mwcodegenerate.baseinfo.MwGenerateCode;
import com.gigadevice.periconfigview.PeriConfigurationView;
import com.gigadevice.periconfigview.ProjectManagerView;
import com.gigadevice.periconfigview.utils.ProjectManagerSettingUtil;
import com.gigadevice.pinoutview.PackageView;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.generalperi.GeneralPeriVariables;
import com.gigadevice.venustool.clockconfiginfo.RCUCondition;
import freemarker.template.TemplateException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GdConfigPage
extends Action {
    public static JPanel MenuPane;
    private static JMenuBar menuBar;
    public static JPanel TabsPanel;
    public static TemplateGroupStruct codeTemplateObj;
    public static int CopyFolderDeep;
    private static boolean IsFirstGenerate;
    private static JTabbedPane tabPanel;
    private static Map<Integer, Boolean> tabErrorStates;
    private static Map<Integer, String> tabOriginalTitles;

    static {
        CopyFolderDeep = 0;
        tabErrorStates = new HashMap<Integer, Boolean>();
        tabOriginalTitles = new HashMap<Integer, String>();
    }

    public static void initConfigPage() {
        TabsPanel = new JPanel(new BorderLayout());
        GdConfigPage.initConfigTab();
    }

    private static void initConfigTab() {
        tabPanel = new JTabbedPane();
        tabPanel.setFont(new Font("Arial", 1, 15));
        JComponent panel1 = PackageView.createPartControl();
        tabPanel.addTab("Pinout", null, panel1, "Pinout Config");
        tabOriginalTitles.put(0, "Pinout");
        tabErrorStates.put(0, false);
        if (GlobalVariables.isSupportCodeGen()) {
            JComponent panel2 = RCUTreeView.createPartControl();
            tabPanel.addTab("Clock Configuration", null, panel2, "Clock Configuration");
            tabOriginalTitles.put(1, "Clock Configuration");
            tabErrorStates.put(1, false);
            JComponent panel3 = PeriConfigurationView.createPartControl();
            tabPanel.addTab("Configuration", null, panel3, "Configuration");
            tabOriginalTitles.put(2, "Configuration");
            tabErrorStates.put(2, false);
            JComponent projectManagerTab = ProjectManagerView.createPartControl();
            tabPanel.addTab("Project Manager", null, projectManagerTab, "Project Manager");
            JComponent panel4 = CodePreview.createPartControl();
            tabPanel.addTab("Code Preview", null, panel4, "Code Preview");
        }
        tabPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int selectedIndex = ((JTabbedPane)e.getSource()).getSelectedIndex();
                String tabTitle = tabPanel.getTitleAt(selectedIndex);
                switch (tabTitle = tabTitle.replaceAll("<[^>]*>", "")) {
                    case "Configuration": {
                        RCUTreeView.UpdateView((boolean)false);
                        PeriConfigurationView.UpdatePeriConfigPanel();
                        break;
                    }
                    case "Clock Configuration": {
                        RCUTreeView.UpdateView((boolean)false);
                        break;
                    }
                    case "Pinout": {
                        PackageView.UpdatePeriTreePanel();
                        break;
                    }
                    case "Code Preview": {
                        final IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask("Load Code Preview...", -1);
                                String GdcFilePath = "";
                                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                                IWorkspaceRoot root = workspace.getRoot();
                                IProject project = root.getProject(GlobalVariables.ProjectName);
                                if (project.exists() && !(GdcFilePath = project.getLocation().toOSString()).equals("")) {
                                    CodePreviewUtil.updateTemplateFile((String)GdcFilePath);
                                }
                                CodePreview.updateCodePreview();
                                monitor.done();
                            }
                        };
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = Display.getDefault().getActiveShell();
                                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
                                try {
                                    progressMonitorDialog.run(true, false, iRunnableWithProgress);
                                }
                                catch (InvocationTargetException e1) {
                                    e1.printStackTrace();
                                }
                                catch (InterruptedException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        });
                        break;
                    }
                }
            }
        });
        GdConfigPage.initTabListeners();
        tabPanel.setTabLayoutPolicy(1);
        TabsPanel.add((Component)tabPanel, "Center");
    }

    private static Component initProjectSettingMenu() {
        String[][] menuNameMnemonics;
        MenuPane = new JPanel(new BorderLayout());
        MenuPane.setFont(new Font("Arial", 1, 15));
        menuBar = new JMenuBar();
        MenuPane.add((Component)menuBar, "East");
        String[][] stringArrayArray = menuNameMnemonics = new String[][]{{"Project", "f"}};
        int n = menuNameMnemonics.length;
        int n2 = 0;
        while (n2 < n) {
            String[] menuNameMnemonic = stringArrayArray[n2];
            menuBar.add(GdConfigPage.createMenu(menuNameMnemonic[0], menuNameMnemonic[1]));
            ++n2;
        }
        JMenu projectMenu = GdConfigPage.getMenu("Project");
        projectMenu.setFont(new Font("Arial", 1, 15));
        JMenuItem SettingsItem = GdConfigPage.createMenuItem("Settings", null, null, null);
        projectMenu.add(SettingsItem);
        SettingsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e_FirmLocBroswse) {
                ProjectConfigUtil.ProjSCodeConf = null;
                ProjectConfigUtil.ProjSetConf = null;
                GDProjectSettingView GDProjectSetting = new GDProjectSettingView(false, true);
                GDProjectSetting.setAlwaysOnTop(true);
                GDProjectSetting.setLocationRelativeTo(null);
                GDProjectSetting.setVisible(true);
            }
        });
        return MenuPane;
    }

    private static Component initConfigMenu() {
        String[][] menuNameMnemonics;
        MenuPane = new JPanel(new BorderLayout());
        MenuPane.setFont(new Font("Arial", 1, 15));
        menuBar = new JMenuBar();
        MenuPane.add((Component)menuBar, "West");
        String[][] stringArrayArray = menuNameMnemonics = new String[][]{{"Project", "f"}, {"Tool", "e"}};
        int n = menuNameMnemonics.length;
        int n2 = 0;
        while (n2 < n) {
            String[] menuNameMnemonic = stringArrayArray[n2];
            menuBar.add(GdConfigPage.createMenu(menuNameMnemonic[0], menuNameMnemonic[1]));
            ++n2;
        }
        JMenu projectMenu = GdConfigPage.getMenu("Project");
        projectMenu.setFont(new Font("Arial", 1, 15));
        JMenuItem GenerateCodeItem = GdConfigPage.createMenuItem("Generate Code", null, null, null);
        projectMenu.add(GenerateCodeItem);
        GenerateCodeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e_FirmLocBroswse) {
                if (!GlobalVariables.isSupportCodeGen()) {
                    Frame frame = new Frame();
                    frame.setAlwaysOnTop(true);
                    Object[] options = new Object[]{"OK"};
                    JOptionPane.showOptionDialog(null, "This series of code generation features is not currently supported!", "Message", -1, -1, null, options, options[0]);
                    return;
                }
                if (GlobalVariables.ProjectName != null) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IWorkspaceRoot root = workspace.getRoot();
                    IProject project = root.getProject(GlobalVariables.ProjectName);
                    SerializeAccess_Template.SerializeSave(project);
                }
            }
        });
        JMenu EditMenu = GdConfigPage.getMenu("Tool");
        EditMenu.setFont(new Font("Arial", 1, 15));
        JMenuItem ClearItem = GdConfigPage.createMenuItem("Clear", null, null, null);
        EditMenu.add(ClearItem);
        JMenuItem RefreshItem = GdConfigPage.createMenuItem("Refresh", null, null, null);
        EditMenu.add(RefreshItem);
        ClearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = new Frame();
                frame.setAlwaysOnTop(true);
                Object[] options = new Object[]{"YES", "No"};
                int res = JOptionPane.showOptionDialog(null, "Would you like to reset all the pins settings?", "Message", 0, 0, null, options, options[0]);
                if (res == 0) {
                    GlobalVariables.isInitProject = true;
                    ProjectConfigUtil.ClearAllGlobalVars();
                    TabsPanel.removeAll();
                    GdConfigPage.initConfigTab();
                    TabsPanel.updateUI();
                }
            }
        });
        RefreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Frame frame = new Frame();
                frame.setAlwaysOnTop(true);
                Object[] options = new Object[]{"YES", "No"};
                int res = JOptionPane.showOptionDialog(null, "Would you like to refresh?", "Message", 0, 0, null, options, options[0]);
                if (res == 0) {
                    GlobalVariables.MCUObj = null;
                    ConflictUtil.PeriConflictInfos.clear();
                    GlobalVariables.PeriConfigViewObj = null;
                    GeneralPeriVariables.GeneralPeriParaObjectList.clear();
                    PeriCodeGen.CodeGenInfoObj = null;
                    GlobalVariables.isInitProject = true;
                    ProjectConfigUtil.ClearAllGlobalVars();
                    TabsPanel.removeAll();
                    GdConfigPage.initConfigTab();
                    TabsPanel.updateUI();
                }
            }
        });
        JMenuItem SettingsItem = GdConfigPage.createMenuItem("Settings", null, null, null);
        EditMenu.add(SettingsItem);
        SettingsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e_FirmLocBroswse) {
                try {
                    ProjectConfigUtil.ProjSCodeConf = null;
                    ProjectConfigUtil.ProjSetConf = null;
                    GDProjectSettingView GDProjectSetting = new GDProjectSettingView(false, false);
                    GDProjectSetting.setAlwaysOnTop(true);
                    GDProjectSetting.setLocationRelativeTo(null);
                    GDProjectSetting.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return MenuPane;
    }

    private static JMenu createMenu(String name, String mnemonic) {
        JMenu menu = new JMenu(name);
        menu.setFont(new Font("Arial", 1, 15));
        if (mnemonic != null) {
            menu.setMnemonic(mnemonic.toCharArray()[0]);
        }
        return menu;
    }

    private static JMenu getMenu(String menuName) {
        JMenu menu = null;
        int i = 0;
        while (i < menuBar.getMenuCount()) {
            menu = menuBar.getMenu(i);
            if (menu.getText().equals(menuName)) {
                return menu;
            }
            ++i;
        }
        return null;
    }

    private static JMenuItem createMenuItem(String name, String mnemonic, Icon icon, KeyStroke keyStroke) {
        JMenuItem menuItem = new JMenuItem(name, icon);
        menuItem.setFont(new Font("Arial", 1, 15));
        if (mnemonic != null) {
            menuItem.setMnemonic(mnemonic.toCharArray()[0]);
        }
        if (keyStroke != null) {
            menuItem.setAccelerator(keyStroke);
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
            }
        });
        return menuItem;
    }

    public static GenerateCodeTips onMenuItemGenerateCode(IProgressMonitor monitor) {
        String GdcFilePath = "";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(GlobalVariables.ProjectName);
        if (project.exists() && (GdcFilePath = project.getLocation().toOSString()).equals("")) {
            return GenerateCodeTips.PROJECT_NOTEXIST;
        }
        codeTemplateObj = null;
        String filePath = String.valueOf(GeneralPathUtil.ResourcePath) + "CodeTemplate" + File.separator + "CodeTemplate.xml";
        codeTemplateObj = CodeTemplateXMLParse.parseTemplateCodeXML((String)filePath);
        new File(String.valueOf(GdcFilePath) + File.separator + "src").mkdirs();
        File mainFile = new File(String.valueOf(GdcFilePath) + File.separator + "src");
        File[] mainFiles = mainFile.listFiles();
        if (mainFiles != null) {
            File[] fileArray = mainFiles;
            int n = mainFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File mFile = fileArray[n2];
                if (mFile.getName().equals("main.c")) {
                    // empty if block
                }
                ++n2;
            }
        }
        boolean cprojectFlag = false;
        String CProjectFilePath = String.valueOf(GdcFilePath) + File.separator + ".cproject";
        String ProjectFilePath = String.valueOf(GdcFilePath) + File.separator + ".project";
        File CProjectFile = new File(CProjectFilePath);
        File ProjectFile = new File(ProjectFilePath);
        if (CProjectFile.exists() && ProjectFile.exists()) {
            cprojectFlag = true;
            IsFirstGenerate = false;
        } else {
            IsFirstGenerate = true;
        }
        GenerateCodeTips moveFlowTips = GdConfigPage.moveFlow(GdcFilePath, workspace, root, project);
        if (moveFlowTips != GenerateCodeTips.MOVEFLOW_SUCESS) {
            return moveFlowTips;
        }
        try {
            MwGenerateCode obj = new MwGenerateCode();
            obj.generateProcess(GdcFilePath, false);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (TemplateException e1) {
            e1.printStackTrace();
        }
        String m_GdcFilePath = project.getLocation().toOSString();
        GenerateProjectFile GenerateProjectFileObj = new GenerateProjectFile(m_GdcFilePath, GlobalVariables.ProjectName);
        GenerateProjectFileObj.UpdateFile();
        if (CProjectFile.exists()) {
            cprojectFlag = true;
            m_GdcFilePath = project.getLocation().toOSString();
            GenerateProjectFileObj = new GenerateProjectFile(m_GdcFilePath, GlobalVariables.ProjectName);
            try {
                GenerateProjectFileObj.updateProjectSettingsSymbolsInfo();
            }
            catch (ProcessFailureException e) {
                e.printStackTrace();
            }
        }
        GdConfigPage.generateTemplateCode(GdcFilePath);
        if (project.exists()) {
            try {
                String pathString = String.valueOf(GeneralPathUtil.ResourcePath) + "ThirdPartyLib/" + GlobalVariables.McuSeletorInfo.getMCUGroup();
                File CopyExtraLibFile = new File(pathString);
                if (CopyExtraLibFile.exists()) {
                    GdConfigPage.CopyExtraLibFile(CopyExtraLibFile, GdcFilePath);
                }
                File SourceFilelist = new File(GdcFilePath);
                String[] SourceFileName = SourceFilelist.list();
                int i = 0;
                while (i < SourceFileName.length) {
                    File SourceFile = new File(String.valueOf(GdcFilePath) + File.separator + SourceFileName[i]);
                    if (SourceFile.isDirectory()) {
                        GdConfigPage.UpdateSourceFolder(monitor, SourceFileName[i]);
                    }
                    ++i;
                }
                GdConfigPage.SFUpdateCProjectFile(GdcFilePath);
                if (cprojectFlag) {
                    MwGenerateCode.MwUpdateCProjectFile((String)GdcFilePath);
                }
                project.refreshLocal(2, null);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return GenerateCodeTips.GENERATE_SUCESS;
    }

    public static void UpdateSourceFolder(IProgressMonitor monitor, String SourcePath) {
        String GdcFilePath = "";
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(GlobalVariables.ProjectName);
        if (project.exists() && (GdcFilePath = project.getLocation().toOSString()).equals("")) {
            return;
        }
        IFolder Folder = project.getFolder(SourcePath);
        if (!Folder.exists()) {
            try {
                GdConfigPage.createFolder(Folder, true, true, monitor);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        try {
            GdConfigPage.addSourceEntry(project, Folder, true, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        monitor.done();
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                GdConfigPage.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static void addSourceEntry(IProject project, IFolder folder, boolean removeProject, IProgressMonitor monitor) throws CoreException {
        ICConfigurationDescription[] cfgs;
        boolean addEntryFlag = true;
        ICProjectDescription des = CCorePlugin.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            String cfgName = cfg.getName().toString();
            if (cfgName.equals("GD ARM MCU Debug") || cfgName.equals("GD RISC-V MCU Debug")) {
                ICSourceEntry[] entries = cfg.getSourceEntries();
                int i = 0;
                while (i < entries.length) {
                    String SourceEntryName = entries[i].getName();
                    String folderName = folder.getName();
                    String SourceEntryFolderName = SourceEntryName.split("/")[SourceEntryName.split("/").length - 1];
                    if (SourceEntryFolderName.equals(folderName)) {
                        addEntryFlag = false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        if (addEntryFlag) {
            CSourceEntry newEntry = new CSourceEntry(folder, null, 0);
            GdConfigPage.addEntryToAllCfgs(des, (ICSourceEntry)newEntry, removeProject);
            CCorePlugin.getDefault().setProjectDescription(project, des, false, monitor);
        }
    }

    private static void addEntryToAllCfgs(ICProjectDescription des, ICSourceEntry entry, boolean removeProject) throws WriteAccessException, CoreException {
        ICConfigurationDescription[] cfgs;
        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = des.getConfigurations();
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n2];
            ICSourceEntry[] entries = cfg.getSourceEntries();
            entries = GdConfigPage.addEntry(entries, entry, removeProject);
            cfg.setSourceEntries(entries);
            ++n2;
        }
    }

    private static ICSourceEntry[] addEntry(ICSourceEntry[] entries, ICSourceEntry sourceEntry, boolean removeProject) {
        HashSet<ICSourceEntry> set = new HashSet<ICSourceEntry>();
        ICSourceEntry[] iCSourceEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ICSourceEntry entry = iCSourceEntryArray[n2];
            if (!removeProject || new Path(entry.getValue()).segmentCount() != 1) {
                set.add(entry);
            }
            ++n2;
        }
        set.add(sourceEntry);
        return set.toArray(new ICSourceEntry[set.size()]);
    }

    public static void SFUpdateCProjectFile(String GdcFilePath) {
        String CProjectFilePath = String.valueOf(GdcFilePath) + File.separator + ".cproject";
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(new File(CProjectFilePath));
            Element root = document.getRootElement();
            GdConfigPage.FindAndRemoveSpecialFileInfoNode(root);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            XMLWriter writer = new XMLWriter((OutputStream)new FileOutputStream(CProjectFilePath), format);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void FindAndRemoveSpecialFileInfoNode(Element element) {
        if ("tool".equals(element.getName())) {
            String str;
            String lastTwoChars;
            if (element.getParent().getName().equals("fileInfo") && (lastTwoChars = (str = element.getParent().attribute("name").getText()).substring(str.length() - 2)).equals(".c") && element.getParent().getParent() != null) {
                element.getParent().getParent().remove(element.getParent());
            }
        } else {
            for (Element child : element.elements()) {
                GdConfigPage.FindAndRemoveSpecialFileInfoNode(child);
            }
        }
    }

    public static String InformationPopup() {
        String resStr = "";
        String McuGroup = GlobalVariables.McuSeletorInfo.getCodeGroup();
        String filePath = String.valueOf(GeneralPathUtil.ResourcePath) + "Info" + File.separator + McuGroup + File.separator + "Information.xml";
        InfoStruct infoStruct = InformationXmlParse.parseInformationXMl((String)filePath);
        if (infoStruct == null) {
            return "";
        }
        LinkedHashMap infoGroup = infoStruct.getGroups();
        Iterator iterator = infoGroup.keySet().iterator();
        while (iterator.hasNext()) {
            String keyGroup;
            String groupName = keyGroup = (String)iterator.next();
            GroupStruct groupStructObj = (GroupStruct)infoGroup.get(groupName);
            if (!groupName.equals(McuGroup)) continue;
            Vector infoGroupVector = groupStructObj.getInfoGroup();
            int i = 0;
            while (i < infoGroupVector.size()) {
                InfoGroupStruct infoGroupStructObj = (InfoGroupStruct)infoGroupVector.get(i);
                String tipStr = infoGroupStructObj.getTips();
                Vector conflictGroupInfoVector = infoGroupStructObj.getRelation();
                int j = 0;
                while (j < conflictGroupInfoVector.size()) {
                    ConflictGroupInfo ConflictGroupObj = (ConflictGroupInfo)conflictGroupInfoVector.get(j);
                    if (ConflictCheck.PrivilegeCheck((String)ConflictGroupObj.getType(), (List)ConflictGroupObj.getConditionsList())) {
                        resStr = String.valueOf(resStr) + System.lineSeparator() + tipStr;
                    }
                    ++j;
                }
                ++i;
            }
        }
        if (resStr.equals("")) {
            return resStr;
        }
        return resStr;
    }

    private static void generateTemplateCode(String GdcFilePath) {
        String mcuGroup = GlobalVariables.McuSeletorInfo.getPeriConfigAndCodePath();
        LinkedHashMap templateGroupMap = codeTemplateObj.getGroups();
        if (!templateGroupMap.containsKey(mcuGroup)) {
            return;
        }
        TemplateInfoStruct templateInfoObj = (TemplateInfoStruct)templateGroupMap.get(mcuGroup);
        LinkedHashMap templateMap = templateInfoObj.getTemplate();
        for (Map.Entry templateMapEntry : templateMap.entrySet()) {
            String cfr_ignored_0 = (String)templateMapEntry.getKey();
            TemplateStruct templateObj = (TemplateStruct)templateMapEntry.getValue();
            if (!templateObj.getSourceType().equals("1")) continue;
            LinkedHashMap perMap = new LinkedHashMap();
            GenerateTemplateCode obj = new GenerateTemplateCode(templateObj, perMap);
            obj.generateCode(GdcFilePath, templateObj);
        }
    }

    public static GenerateCodeTips moveFlow(String m_GdcFilePath, IWorkspace m_workspace, IWorkspaceRoot m_root, IProject m_project) {
        String FirmwaresXmlPath = String.valueOf(GeneralPathUtil.ResourcePath) + File.separator + "mcus" + File.separator + "mcu_firmware.xml";
        boolean GetMCUSeriesFlag = false;
        String CopyPath = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        FirmwaresStruct FirmwaresInfo = new FirmwaresStruct();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document d = builder.parse(new File(FirmwaresXmlPath));
            NodeList sList = d.getElementsByTagName("FirmwareInfo");
            if (sList == null) {
                System.out.print("FirmwaresInfo is Null !");
                return GenerateCodeTips.FIRWARESINFO_NULL;
            }
            GdConfigPage.node(sList, FirmwaresInfo);
            int i = 0;
            while (i < FirmwaresInfo.GetFirmwareStructList().size()) {
                int j = 0;
                while (j < FirmwaresInfo.GetFirmwareStructList().get(i).GetSeriesStructList().size()) {
                    if (GlobalVariables.McuSeletorInfo.getSeries().equals(FirmwaresInfo.GetFirmwareStructList().get(i).GetSeriesStructList().get(j).GetMCUSeries())) {
                        CopyPath = String.valueOf(GeneralPathUtil.ResourcePath) + FirmwaresInfo.GetFirmwareStructList().get(i).GetFirmwareCopyPath();
                        GetMCUSeriesFlag = true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!GetMCUSeriesFlag) {
            return GenerateCodeTips.TARGETCHIP_NOTEXIT;
        }
        if (m_project.exists()) {
            m_GdcFilePath = m_project.getLocation().toOSString();
            if (m_GdcFilePath.equals("")) {
                return GenerateCodeTips.TARGET_FIRWARELIB_ERROR;
            }
            CopyFolderDeep = 0;
            boolean CopyFlag = true;
            if (IsFirstGenerate || ProjectManagerSettingUtil.getOverwriteState((String)"OverwriteFirmwareLib")) {
                CopyFlag = GdConfigPage.copyFirmwareFolder(CopyPath, m_GdcFilePath);
            }
            if (!CopyFlag) {
                return GenerateCodeTips.SOURCEANDTARGET_FIRWARELIB_ERROR;
            }
        } else {
            return GenerateCodeTips.PROJECT_NOTEXIST;
        }
        FileGenerate FileGenerateObj = new FileGenerate(m_GdcFilePath, GlobalVariables.McuSeletorInfo.getCodeGroup(), codeTemplateObj);
        FileGenerateObj.GenerateCodeFile();
        return GenerateCodeTips.MOVEFLOW_SUCESS;
    }

    public static void node(NodeList list, FirmwaresStruct FirmwaresInfo) {
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            NodeList childNodes = node.getChildNodes();
            String FirmwarePack = node.getAttributes().getNamedItem("FirmwarePack").getNodeValue();
            String FirmwareLoc = node.getAttributes().getNamedItem("FirmwareLoc").getNodeValue();
            String FirmwareCopyPath = node.getAttributes().getNamedItem("FirmwareCopyPath").getNodeValue();
            FirmwareStruct FirmwareInfo = new FirmwareStruct();
            FirmwareInfo.SetFirwarePack(FirmwarePack);
            FirmwareInfo.SetFirmwareLoc(FirmwareLoc);
            FirmwareInfo.SetFirmwareCopyPath(FirmwareCopyPath);
            int j = 0;
            while (j < childNodes.getLength()) {
                if (childNodes.item(j).getNodeType() == 1) {
                    String MCUSerise = childNodes.item(j).getAttributes().getNamedItem("SeriesName").getNodeValue();
                    SeriesStruct SeriesInfo = new SeriesStruct();
                    SeriesInfo.SetMCUSeries(MCUSerise);
                    FirmwareInfo.PutSeriesStructList(SeriesInfo);
                }
                ++j;
            }
            FirmwaresInfo.PutFirmwareStructList(FirmwareInfo);
            ++i;
        }
    }

    public static boolean copyFirmwareFolder(String FirmwareOldPath, String FirmwareNewPath) {
        block9: {
            try {
                File FirmwareFilelist = new File(FirmwareOldPath);
                String[] FirmwareFile = FirmwareFilelist.list();
                if (FirmwareNewPath != null) {
                    new File(FirmwareNewPath).mkdirs();
                }
                File FirmwareTemp = null;
                if (FirmwareFile == null) break block9;
                int i = 0;
                while (i < FirmwareFile.length) {
                    block11: {
                        block10: {
                            FirmwareTemp = new File(String.valueOf(FirmwareOldPath) + File.separator + FirmwareFile[i]);
                            if (!FirmwareTemp.isFile()) break block10;
                            String LowerFirmwareTempName = FirmwareTemp.getName().toString().toLowerCase();
                            if (LowerFirmwareTempName.contains("_flash.ld") || LowerFirmwareTempName.contains(".cfg") || LowerFirmwareTempName.contains(".s")) break block11;
                            FileInputStream FirmwareNewPathInput = new FileInputStream(FirmwareTemp);
                            FileOutputStream FirmwareOutput = new FileOutputStream(String.valueOf(FirmwareNewPath) + File.separator + FirmwareTemp.getName().toString());
                            byte[] Firmwarebuffer = new byte[65536];
                            int length = FirmwareNewPathInput.read(Firmwarebuffer);
                            while (length != -1) {
                                FirmwareOutput.write(Firmwarebuffer, 0, length);
                                length = FirmwareNewPathInput.read(Firmwarebuffer);
                            }
                            FirmwareOutput.flush();
                            FirmwareOutput.close();
                            FirmwareNewPathInput.close();
                        }
                        String LowerFirmwareTempFullPath = FirmwareTemp.toString().toLowerCase();
                        if ((FirmwareTemp.isDirectory() && CopyFolderDeep == 0 && !LowerFirmwareTempFullPath.contains("example") || FirmwareTemp.isDirectory() && CopyFolderDeep != 0) && !LowerFirmwareTempFullPath.contains("ldscripts") && !LowerFirmwareTempFullPath.contains("gcc_startup")) {
                            ++CopyFolderDeep;
                            GdConfigPage.copyFirmwareFolder(String.valueOf(FirmwareOldPath) + File.separator + FirmwareFile[i], String.valueOf(FirmwareNewPath) + File.separator + FirmwareFile[i]);
                            --CopyFolderDeep;
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private static void CopyExtraLibFile(File ThirdPartyLibPath, String projectPath) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(ThirdPartyLibPath + "/ConfigThirdPartyLib.xml");
            Element rootElement = document.getRootElement();
            Iterator perisIterator = rootElement.elementIterator("Peris");
            while (perisIterator.hasNext()) {
                Element perisElement = (Element)perisIterator.next();
                Element TemplateElement = perisElement.element("Template");
                Element PathConfigElement = TemplateElement.element("PathConfig");
                Iterator templateNodeIterator = PathConfigElement.elementIterator("TemplateNode");
                Element includePathsElement = TemplateElement.element("IncludePaths");
                Element relationElement = TemplateElement.element("Relation");
                String type = GlobalVariables.McuSeletorInfo.getCore();
                String CoreType = "";
                CoreType = type.toLowerCase().contains("risc") ? "riscv" : "arm";
                String OptionID = "com.gigadevice.mbs." + CoreType + ".option.CCompiler.includes.paths";
                String[] IncludePathsArray = GdConfigPage.getIncludePaths(OptionID);
                ArrayList<String> includePathsList = new ArrayList<String>(Arrays.asList(IncludePathsArray));
                Iterator includePathIterator = includePathsElement.elementIterator("IncludePath");
                NewRelationGroup childObj = NewConditionXmlParse.ParseNewConditionRelationNode((Element)relationElement);
                boolean PrivilegeCheckSuccess = NewConflictCheck.PrivilegeCheck((NewRelationGroup)childObj);
                boolean copyOrDeleteFileSuccess = false;
                while (templateNodeIterator.hasNext()) {
                    String[] arr;
                    Element templateNodeElement = (Element)templateNodeIterator.next();
                    String SourcePath = templateNodeElement.attributeValue("SourcePath").replaceAll("/+", "/").replaceAll("\\\\+", "\\\\").replace("\\", "/");
                    String TargetPath = templateNodeElement.attributeValue("TargetPath").replaceAll("/+", "/").replaceAll("\\\\+", "\\\\").replace("\\", "/");
                    String destSourcePath = (ThirdPartyLibPath + SourcePath).replace("\\", "/");
                    String destTargetPath = (String.valueOf(projectPath) + TargetPath).replace("\\", "/");
                    File SourceFile = new File(destSourcePath);
                    if (SourceFile.isFile()) {
                        if (PrivilegeCheckSuccess) {
                            File targetDir = new File(destTargetPath);
                            if (!targetDir.exists()) {
                                new File(destTargetPath).mkdirs();
                            }
                            copyOrDeleteFileSuccess = MwGenearteTools.copyFile((String)projectPath, (File)SourceFile, (File)new File(destTargetPath, SourceFile.getName()));
                            continue;
                        }
                        arr = null;
                        if (TargetPath.equals("") || (arr = TargetPath.split("/")).length <= 1) continue;
                        destTargetPath = String.valueOf(projectPath) + "/" + arr[1];
                        copyOrDeleteFileSuccess = MwGenearteTools.delAllFiles((String)destTargetPath);
                        continue;
                    }
                    if (PrivilegeCheckSuccess) {
                        copyOrDeleteFileSuccess = MwGenearteTools.copyDir((String)projectPath, (String)destSourcePath, (String)destTargetPath);
                        continue;
                    }
                    arr = null;
                    if (TargetPath.equals("") || (arr = TargetPath.split("/")).length <= 1) continue;
                    destTargetPath = String.valueOf(projectPath) + "/" + arr[1];
                    copyOrDeleteFileSuccess = MwGenearteTools.delAllFiles((String)destTargetPath);
                }
                while (includePathIterator.hasNext()) {
                    Element includePathElement = (Element)includePathIterator.next();
                    String includePath = includePathElement.attributeValue("Path");
                    if (PrivilegeCheckSuccess) {
                        if (includePathsList.contains(includePath)) continue;
                        includePathsList.add(includePath);
                        continue;
                    }
                    includePathsList.remove(includePath);
                }
                if (!copyOrDeleteFileSuccess) continue;
                GdConfigPage.setIncludePaths(OptionID, includePathsList.toArray(new String[0]));
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String[] getIncludePaths(String optionID) {
        ICConfigurationDescription[] configurationDescriptions;
        String[] sReturnArray = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(GlobalVariables.ProjectName);
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configurationDescriptions = projectDescription.getConfigurations();
        int n = configurationDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configurationDescription = iCConfigurationDescriptionArray[n2];
            IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configurationDescription);
            try {
                ITool[] tools;
                ITool[] iToolArray = tools = configuration.getTools();
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    IOption toolOption = tool.getOptionBySuperClassId(optionID);
                    if (toolOption != null) {
                        sReturnArray = toolOption.getIncludePaths();
                    }
                    ++n4;
                }
            }
            catch (BuildException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return sReturnArray;
    }

    public static void setIncludePaths(String optionID, String[] value) {
        ICConfigurationDescription[] configurationDescriptions;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(GlobalVariables.ProjectName);
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configurationDescriptions = projectDescription.getConfigurations();
        int n = configurationDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICConfigurationDescription configurationDescription = iCConfigurationDescriptionArray[n2];
            IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)configurationDescription);
            GdConfigPage.setOptionValue(configuration, optionID, value);
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)project, (boolean)true);
        try {
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        System.out.println();
    }

    public static void setOptionValue(IConfiguration configuration, String id, String[] value) {
        try {
            ITool[] tools;
            IToolChain toolChain = configuration.getToolChain();
            IOption toolChainOption = toolChain.getOptionBySuperClassId(id);
            if (toolChainOption != null) {
                configuration.setOption((IHoldsOptions)toolChain, toolChainOption, value);
            }
            ITool[] iToolArray = tools = configuration.getTools();
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption toolOption = tool.getOptionBySuperClassId(id);
                if (toolOption != null) {
                    configuration.setOption((IHoldsOptions)tool, toolOption, value);
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    public static void ClearAction() {
        GlobalVariables.isDirtyFlag = true;
        GlobalVariables.isInitProject = true;
        ProjectConfigUtil.ClearUserConfigVars();
        TabsPanel.removeAll();
        GdConfigPage.initConfigTab();
        TabsPanel.updateUI();
    }

    private static void initTabListeners() {
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GdConfigPage.checkTabConditions();
            }
        });
        timer.start();
    }

    public static void checkTabConditions() {
        if (tabPanel == null) {
            return;
        }
        boolean pinoutError = GdConfigPage.checkPinoutError();
        GdConfigPage.updateTabState(0, pinoutError);
        boolean clockError = GdConfigPage.checkClockError();
        GdConfigPage.updateTabState(1, clockError);
        boolean configError = GdConfigPage.checkConfigurationError();
        GdConfigPage.updateTabState(2, configError);
    }

    private static boolean checkPinoutError() {
        return false;
    }

    private static boolean checkClockError() {
        Map clockTreeInvalidMap = RCUCondition.getClockTreeErrorInfo();
        Map clockTreeErrorInfo_MinMaxMap = RCUCondition.getClockTreeErrorInfo_MinMax();
        if (clockTreeErrorInfo_MinMaxMap.size() != 0) {
            return true;
        }
        if (clockTreeInvalidMap.isEmpty()) {
            return false;
        }
        for (String key : clockTreeInvalidMap.keySet()) {
            Vector vectorTemp;
            if (!key.equals("Selector") || (vectorTemp = (Vector)clockTreeInvalidMap.get(key)).size() == 0) continue;
            return true;
        }
        return false;
    }

    private static boolean checkConfigurationError() {
        return false;
    }

    private static void updateTabState(int tabIndex, boolean hasError) {
        if (tabPanel == null || tabIndex >= tabPanel.getTabCount()) {
            return;
        }
        Boolean currentState = tabErrorStates.get(tabIndex);
        if (currentState == null) {
            currentState = false;
        }
        if (currentState == hasError) {
            return;
        }
        tabErrorStates.put(tabIndex, hasError);
        String originalTitle = tabOriginalTitles.get(tabIndex);
        if (originalTitle == null) {
            return;
        }
        if (hasError) {
            String errorTitle = "<html><font color='red'>" + originalTitle + "</font></html>";
            tabPanel.setTitleAt(tabIndex, errorTitle);
        } else {
            tabPanel.setTitleAt(tabIndex, originalTitle);
        }
    }

    public static void triggerTabStateCheck() {
        GdConfigPage.checkTabConditions();
    }

    public static void setTabErrorState(int tabIndex, boolean hasError) {
        GdConfigPage.updateTabState(tabIndex, hasError);
    }

    public static enum GenerateCodeTips {
        PROJECT_NOTEXIST,
        FIRWARESINFO_NULL,
        TARGETCHIP_NOTEXIT,
        TARGET_FIRWARELIB_ERROR,
        SOURCEANDTARGET_FIRWARELIB_ERROR,
        MOVEFLOW_SUCESS,
        IS_CANCLE,
        GENERATE_SUCESS;

    }
}

