/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.gdconfig.ui.access;

import com.gigadevice.clockconfigview.utils.RCUTreeUtil;
import com.gigadevice.gdconfig.ui.access.SerializeAccess;
import com.gigadevice.gdconfig.ui.utils.ProjectConfigUtil;
import com.gigadevice.logging.ide.LogManager;
import com.gigadevice.periconfigview.utils.DMAConfigUtil;
import com.gigadevice.periconfigview.utils.GPIOConfigUtil;
import com.gigadevice.periconfigview.utils.GeneralPeriConfigUtil;
import com.gigadevice.periconfigview.utils.NVICConfigUtil;
import com.gigadevice.periconfigview.utils.ProjectManagerSettingUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;

public class SerializeAccess_Template
extends SerializeAccess {
    static Map<String, String> MCUMap = new LinkedHashMap<String, String>();
    static int GDCFile_Version = 1;
    public static int GDCFile_Flag = 0;
    static final String Constant_FileVersion = "FileVersion";
    static final String Constant_MCUPartNo = "MCUPartNo";
    static final String Constant_FwlibType = "FwlibType";
    static final String Constant_PeriAndPinContent = "PeriandPinContent";
    static final String Constant_ClockContent = "ClockContent";
    static final String Constant_PeriConfigContent = "PeriConfigContent";
    static final String Constant_DMAConfigContent = "DMAConfigContent";
    static final String Constant_GPIOConfigContent = "GPIOConfigContent";
    static final String Constant_NVICConfigContent = "NVICConfigContent";
    static final String Constant_ProjectSettingContent = "ProjectManagerSettingContent";
    public static final String Constant_GDC_Warning = "Project is invalid.";
    static int Cur_GDCFile_Version = 0;

    public static void SerializeSave(IProject m_Project) {
        String GdcFilePath = SerializeAccess_Template.GetGdcFilePath(m_Project);
        String templatePath = null;
        try {
            if (TargetOSInfo.isWindows()) {
                templatePath = String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.gdconfig.ui").getEntry("")).getPath().substring(1).replace("/", System.getProperty("file.separator"))) + "templates" + System.getProperty("file.separator");
            } else if (TargetOSInfo.isLinux()) {
                templatePath = String.valueOf(FileLocator.toFileURL((URL)Platform.getBundle((String)"com.gigadevice.gdconfig.ui").getEntry("")).getPath().replace("/", System.getProperty("file.separator"))) + "templates" + System.getProperty("file.separator");
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String templateName = "gdc.ftl";
        MCUMap.put(Constant_FileVersion, String.valueOf(GDCFile_Version));
        MCUMap.put(Constant_MCUPartNo, GlobalVariables.McuSeletorInfo.getMCUPart());
        MCUMap.put(Constant_FwlibType, GlobalVariables.McuSeletorInfo.getFwlibType());
        MCUMap.put(Constant_PeriAndPinContent, GlobalVariables.Serialize());
        MCUMap.put(Constant_ClockContent, RCUTreeUtil.Serialize());
        MCUMap.put(Constant_PeriConfigContent, GeneralPeriConfigUtil.Serialize());
        MCUMap.put(Constant_DMAConfigContent, DMAConfigUtil.Serialize());
        MCUMap.put(Constant_GPIOConfigContent, GPIOConfigUtil.Serialize());
        MCUMap.put(Constant_NVICConfigContent, NVICConfigUtil.Serialize());
        MCUMap.put(Constant_ProjectSettingContent, ProjectManagerSettingUtil.Serialize());
        if (templatePath != null) {
            try {
                Configuration configuration = new Configuration(Configuration.VERSION_2_3_32);
                configuration.setDirectoryForTemplateLoading(new File(templatePath));
                configuration.setDefaultEncoding("utf-8");
                Template template = configuration.getTemplate(templateName);
                FileWriter out = new FileWriter(new File(GdcFilePath));
                template.process(MCUMap, (Writer)out);
                ((Writer)out).close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static int DeserializeExtract(IProject m_Project) {
        String GdcFilePath = SerializeAccess_Template.GetGdcFilePath(m_Project);
        Path path = Paths.get(GdcFilePath, new String[0]);
        List<String> contentList = null;
        try {
            contentList = Files.readAllLines(path);
        }
        catch (IOException e) {
            GDCFile_Flag = 1;
            e.printStackTrace();
        }
        if (contentList == null) {
            return 2;
        }
        String content = String.join((CharSequence)"\n", contentList);
        String Temp = SerializeAccess_Template.extractValue(content, Constant_FileVersion);
        if (Temp.equals("") || Temp == null) {
            return 1;
        }
        Cur_GDCFile_Version = Integer.parseInt(Temp);
        String TempMCUPartNo = SerializeAccess_Template.extractValue(content, Constant_MCUPartNo);
        if (TempMCUPartNo == null) {
            return 1;
        }
        TempMCUPartNo = CPNChangeXmlParse.getNewCPN((String)TempMCUPartNo, (boolean)true);
        GlobalVariables.McuSeletorInfo.setMCUPart(TempMCUPartNo);
        String TempFwlibType = SerializeAccess_Template.extractValue(content, Constant_FwlibType);
        if (TempFwlibType == null && (TempMCUPartNo.toUpperCase().contains("GD32H737") || TempMCUPartNo.toUpperCase().contains("GD32H757") || TempMCUPartNo.toUpperCase().contains("GD32H757"))) {
            TempFwlibType = "HAL";
        }
        GlobalVariables.McuSeletorInfo.setFwlibType(TempFwlibType);
        LogManager.getInstance().info("GDProject", "TempMCUPartNo:" + TempMCUPartNo);
        ProjectConfigUtil.InitAllGlobalVars();
        SerializeAccess_Template.extractContent(content);
        ProjectConfigUtil.LoadAllGlobalVars();
        return 0;
    }

    private static void extractContent(String content) {
        String pattern = "\\[<(.*?)>]\\s*([<\\s\\S>]*?)(?=\\[<|$)";
        Pattern r = Pattern.compile(pattern, 32);
        Matcher m = r.matcher(content);
        while (m.find()) {
            String header = m.group(1);
            String str = m.group(2);
            switch (header) {
                case "PeriandPinContent": {
                    GlobalVariables.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "PeriConfigContent": {
                    GeneralPeriConfigUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "ClockContent": {
                    RCUTreeUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "DMAConfigContent": {
                    DMAConfigUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "GPIOConfigContent": {
                    GPIOConfigUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "NVICConfigContent": {
                    NVICConfigUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
                case "ProjectManagerSettingContent": {
                    ProjectManagerSettingUtil.DeSerialize((String)str, (int)Cur_GDCFile_Version);
                    break;
                }
            }
        }
    }

    private static String extractValue(String content, String name) {
        String pattern = String.valueOf(name) + "=(.*?)(?:\n|$)";
        String value = null;
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(content);
        if (m.find()) {
            value = m.group(1).trim();
        }
        return value;
    }
}

