/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.DependentValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.core.runtime.CoreException;

public final class EvalFixed
extends CPPEvaluation {
    public static final ICPPEvaluation INCOMPLETE = new EvalFixed(ProblemType.UNKNOWN_FOR_EXPRESSION, IASTExpression.ValueCategory.PRVALUE, IntegralValue.ERROR);
    private final IType fType;
    private final IValue fValue;
    private final IASTExpression.ValueCategory fValueCategory;
    private boolean fIsTypeDependent;
    private boolean fCheckedIsTypeDependent;
    private boolean fIsValueDependent;
    private boolean fCheckedIsValueDependent;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;

    public EvalFixed(IType type, IASTExpression.ValueCategory cat, IValue value) {
        Number num;
        if (value.getEvaluation() instanceof EvalFixed) {
            EvalFixed inner = (EvalFixed)value.getEvaluation();
            type = inner.fType;
            cat = inner.fValueCategory;
            value = inner.fValue;
        }
        if (type instanceof CPPBasicType && (num = value.numberValue()) != null) {
            CPPBasicType t = (CPPBasicType)type.clone();
            t.setAssociatedNumericalValue(num.longValue());
            type = t;
        }
        this.fType = type;
        this.fValueCategory = cat;
        this.fValue = value;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        if (!this.fCheckedIsTypeDependent) {
            this.fCheckedIsTypeDependent = true;
            this.fIsTypeDependent = CPPTemplates.isDependentType(this.fType);
        }
        return this.fIsTypeDependent;
    }

    @Override
    public boolean isValueDependent() {
        if (!this.fCheckedIsValueDependent) {
            this.fCheckedIsValueDependent = true;
            this.fIsValueDependent = IntegralValue.isDependentValue(this.fValue);
        }
        return this.fIsValueDependent;
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    private boolean computeIsConstantExpression() {
        return this.fType instanceof ICPPClassType && TypeTraits.isEmpty(this.fType) || EvalFixed.isConstexprValue(this.fValue);
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalFixed)) {
            return false;
        }
        EvalFixed o = (EvalFixed)other;
        return this.fType.isSameType(o.fType) && this.fValue.isEquivalentTo(o.fValue);
    }

    @Override
    public IType getType() {
        return this.fType;
    }

    @Override
    public IValue getValue() {
        return this.fValue;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.fValueCategory;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        includeValue = includeValue && this.fValue != IntegralValue.UNKNOWN;
        short firstBytes = 7;
        if (includeValue) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        switch (this.fValueCategory) {
            case PRVALUE: {
                firstBytes = (short)(firstBytes | 0x40);
                break;
            }
            case LVALUE: {
                firstBytes = (short)(firstBytes | 0x80);
                break;
            }
        }
        buffer.putShort(firstBytes);
        buffer.marshalType(this.fType);
        if (includeValue) {
            buffer.marshalValue(this.fValue);
        }
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean readValue = (firstBytes & 0x20) != 0;
        IASTExpression.ValueCategory cat = switch (firstBytes & 0xC0) {
            case 64 -> IASTExpression.ValueCategory.PRVALUE;
            case 128 -> IASTExpression.ValueCategory.LVALUE;
            default -> IASTExpression.ValueCategory.XVALUE;
        };
        IType type = buffer.unmarshalType();
        IValue value = readValue ? buffer.unmarshalValue() : IntegralValue.UNKNOWN;
        return new EvalFixed(type, cat, value);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        IType type = CPPTemplates.instantiateType(this.fType, context);
        IValue value = CPPTemplates.instantiateValue(this.fValue, context, maxDepth);
        if (type == this.fType && value == this.fValue) {
            return this;
        }
        if (value == IntegralValue.ERROR) {
            return INCOMPLETE;
        }
        if (type instanceof ICPPParameterPackType && value.numberValue() != null) {
            type = ((ICPPParameterPackType)type).getType();
        }
        return new EvalFixed(type, this.fValueCategory, value);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation eval = this.fValue.getEvaluation();
        if (eval == null) {
            return this;
        }
        if ((eval = eval.computeForFunctionCall(record, context.recordStep())) == this.fValue.getEvaluation()) {
            return this;
        }
        EvalFixed evalFixed = new EvalFixed(this.fType, this.fValueCategory, DependentValue.create(eval));
        return evalFixed;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return CPPTemplates.determinePackSize(this.fValue, tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return false;
    }

    public String toString() {
        return String.valueOf(this.fType.toString()) + ": " + this.fValue.toString();
    }

    @Override
    public boolean isNoexcept() {
        return true;
    }
}

