/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.adapter;

import com.gigadevice.adapter.Activator;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.mbs.arm.TargetBuildInfo;
import com.gigadevice.utils.ProjectUtils;
import com.gigadevice.venustool.GeneralPathUtil;
import com.gigadevice.venustool.GlobalVariables;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.MCUs;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.target.ILaunchTarget;

public class AdapterUtils {
    public static MCUSeletorInfo tmpMcuSeletorInfo = new MCUSeletorInfo();

    public static TargetAdapter.MbsType getToolChainType(IProject project) {
        IConfiguration cfg = ProjectUtils.getActiveConfigurationsForProject((IProject)project);
        if (cfg != null) {
            IToolChain toolchain = cfg.getToolChain();
            String idVal = toolchain.getId();
            if (idVal.contains("arm")) {
                return TargetAdapter.MbsType.ARM;
            }
            return TargetAdapter.MbsType.RISCV;
        }
        return null;
    }

    public static String getDownloadFilePath(IProject project, String FileType) {
        String TargetFileName = null;
        ILaunchConfiguration launchConfig = null;
        launchConfig = AdapterUtils.getTargetLanuchConfiguration(project);
        if (launchConfig == null) {
            return null;
        }
        try {
            String progName = launchConfig.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            progName = progName.trim();
            if (progName.length() > 0) {
                if (progName.contains(":")) {
                    TargetFileName = progName = progName.replace(".elf", FileType);
                } else {
                    String LocationVal = project.getLocation().toOSString();
                    LocationVal = LocationVal.replace("/", File.separator);
                    progName = progName.replace(".elf", FileType);
                    TargetFileName = String.valueOf(LocationVal) + File.separator + progName;
                }
                File f = new File(TargetFileName);
                if (!f.exists()) {
                    TargetFileName = null;
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return TargetFileName;
    }

    public static String getToolChainPath(IProject project) {
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getToolChainPath(project);
            }
            com.gigadevice.mbs.riscv.TargetBuildInfo riscvInfo = new com.gigadevice.mbs.riscv.TargetBuildInfo();
            return riscvInfo.getToolChainPath(project);
        }
        return null;
    }

    public static String getToolChainPrefix(IProject project) {
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getToolChainPrefix(project);
            }
            com.gigadevice.mbs.riscv.TargetBuildInfo riscvInfo = new com.gigadevice.mbs.riscv.TargetBuildInfo();
            return riscvInfo.getToolChainPrefix(project);
        }
        return null;
    }

    public static String getTargetMcuPartNo(IProject project) {
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getTargetMcuPartNo(project);
            }
            com.gigadevice.mbs.riscv.TargetBuildInfo riscvInfo = new com.gigadevice.mbs.riscv.TargetBuildInfo();
            return riscvInfo.getTargetMcuPartNo(project);
        }
        return null;
    }

    public static String getTargetMcuCoreType(IProject project) {
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getTargetMcuCoreType(project);
            }
            return null;
        }
        return null;
    }

    public static long getCodePositon(IProject project) {
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getCodePositon(project);
            }
            com.gigadevice.mbs.riscv.TargetBuildInfo riscvInfo = new com.gigadevice.mbs.riscv.TargetBuildInfo();
            return riscvInfo.getCodePositon(project);
        }
        return 0L;
    }

    public static String getLdFileName(IProject project) {
        String LdFileName = null;
        TargetAdapter.MbsType mbsSel = AdapterUtils.getToolChainType(project);
        if (mbsSel != null) {
            if (mbsSel == TargetAdapter.MbsType.ARM) {
                TargetBuildInfo armInfo = new TargetBuildInfo();
                return armInfo.getLdFileName(project);
            }
            com.gigadevice.mbs.riscv.TargetBuildInfo riscvInfo = new com.gigadevice.mbs.riscv.TargetBuildInfo();
            LdFileName = riscvInfo.getLdFileName(project);
        }
        return LdFileName;
    }

    public static List<String> getLdFilePath(File dir, String LdFileName, List<String> ldFileLstList) {
        String ldFilePath = null;
        File[] fsFiles = dir.listFiles();
        if (fsFiles != null) {
            int i = 0;
            while (i < fsFiles.length) {
                if (fsFiles[i].getAbsolutePath().contains(LdFileName)) {
                    ldFilePath = fsFiles[i].getAbsolutePath();
                    ldFileLstList.add(ldFilePath);
                }
                if (fsFiles[i].isDirectory()) {
                    AdapterUtils.getLdFilePath(fsFiles[i], LdFileName, ldFileLstList);
                }
                ++i;
            }
        }
        return ldFileLstList;
    }

    public static String getFlashAddress(String LdFilePath) {
        String flashAddress = null;
        String tempLineStr = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(LdFilePath));
            while ((tempLineStr = reader.readLine()) != null) {
                String upperStr = tempLineStr.toUpperCase();
                if (!upperStr.contains("FLASH") || !upperStr.contains("ORIGIN")) continue;
                upperStr = upperStr.replace(" ", "");
                int beginIndex = upperStr.indexOf("0X");
                int endIndex = upperStr.indexOf(",");
                if (beginIndex <= -1 || endIndex <= -1) break;
                flashAddress = upperStr.substring(beginIndex, endIndex);
                flashAddress = flashAddress.replace("0X", "0x");
                break;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flashAddress;
    }

    public static ILaunchConfiguration getTargetLanuchConfiguration(IProject project) {
        ILaunchConfiguration launchConfig;
        ILaunchBarManager manager;
        block7: {
            manager = Activator.getService(ILaunchBarManager.class);
            launchConfig = null;
            launchConfig = manager.getActiveLaunchConfiguration();
            if (launchConfig != null) break block7;
            return null;
        }
        try {
            String projectName = launchConfig.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
            if (!projectName.equalsIgnoreCase(project.getName())) {
                launchConfig = null;
                ILaunchDescriptor[] descs = manager.getLaunchDescriptors();
                ILaunchConfiguration tmp = null;
                int i = 0;
                while (i < descs.length) {
                    ILaunchTarget[] targets = manager.getLaunchTargets(descs[i]);
                    tmp = manager.getLaunchConfiguration(descs[i], targets[0]);
                    String tmpName = tmp.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                    if (tmpName.equalsIgnoreCase(project.getName())) {
                        launchConfig = tmp;
                        break;
                    }
                    ++i;
                }
            }
            if (launchConfig == null) {
                return null;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
        return launchConfig;
    }

    public static byte[] File2ByteArray(File tFile) {
        byte[] buffer = null;
        try {
            int n;
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tFile));
            ByteArrayOutputStream bos = new ByteArrayOutputStream((int)tFile.length());
            if ((int)tFile.length() == 0) {
                throw new IOException("\u93c2\u56e6\u6b22\u6d93\u8679\u2516\u951b\ufffd");
            }
            byte[] b = new byte[0x100000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    public static long ByteArray2Long(byte[] inData, long inDataLen, int StartPos) {
        long retVal = 0L;
        long tempVal = 0L;
        if (StartPos + 4 > (int)inDataLen) {
            return 0L;
        }
        int i = StartPos;
        while (i < StartPos + 4) {
            tempVal = (long)inData[i] & 0xFFL;
            retVal |= (tempVal <<= 8 * (i - StartPos));
            ++i;
        }
        return retVal;
    }

    public static int getProjectTypeByIProject(IProject project) {
        int ProjectType = 1;
        List gdcList = ProjectUtils.getGDCList((IProject)project);
        ProjectType = gdcList.size() == 0 ? 1 : 0;
        return ProjectType;
    }

    public static void initMCUSeletorInfoByIProject(IProject project) {
        String McuNo = AdapterUtils.getTargetMcuPartNo(project);
        if ((McuNo = CPNChangeXmlParse.getNewCPN((String)McuNo, (boolean)false)) != null && McuNo != "") {
            int ProjectType = AdapterUtils.getProjectTypeByIProject(project);
            tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)ProjectType, (String)McuNo);
        } else {
            tmpMcuSeletorInfo = null;
        }
    }

    public static String getFirstFileByType(IProject project, String FileType, boolean DoInitMCUSeletorInfo) {
        ArrayList Files;
        String FirstFile = "";
        if (DoInitMCUSeletorInfo) {
            AdapterUtils.initMCUSeletorInfoByIProject(project);
        } else {
            tmpMcuSeletorInfo = GlobalVariables.McuSeletorInfo;
        }
        if (tmpMcuSeletorInfo != null && (Files = McuFactory.getFileParaList((String)FileType, (MCUs)tmpMcuSeletorInfo.getMcuObj())) != null && Files.size() > 0) {
            FirstFile = (String)Files.get(0);
        }
        return FirstFile;
    }

    public static ArrayList<String> getFilesByType(IProject project, String FileType, boolean DoInitMCUSeletorInfo) {
        if (DoInitMCUSeletorInfo) {
            AdapterUtils.initMCUSeletorInfoByIProject(project);
        } else {
            tmpMcuSeletorInfo = GlobalVariables.McuSeletorInfo;
        }
        if (tmpMcuSeletorInfo != null) {
            ArrayList Files = McuFactory.getFileParaList((String)FileType, (MCUs)tmpMcuSeletorInfo.getMcuObj());
            return Files;
        }
        return null;
    }

    public static String getJlinkServerCLPath() {
        String gdbName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLinkGDBServerCL.exe" : "JLinkGDBServer";
        return String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "J-Link" + File.separator + gdbName;
    }

    public static String getJlinkExePath() {
        String exeName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLink.exe" : "JLinkExe";
        return AdapterUtils.getJLinkExeNameByName(exeName);
    }

    public static String getJlinkScriptPath() {
        String jlinkPath = AdapterUtils.getJlinkExePath();
        String exeName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLink.exe" : "JLinkExe";
        String scriptPath = jlinkPath.replace(exeName, "jlinkscrippt.jlink");
        return scriptPath;
    }

    public static String getJLinkRTTExePath() {
        String exeName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLinkRTTClient.exe" : "JLinkRTTClientExe";
        return AdapterUtils.getJLinkExeNameByName(exeName);
    }

    public static String getJlinkConfigFilePath() {
        String jlinkPath = AdapterUtils.getJlinkExePath();
        String exeName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLink.exe" : "JLinkExe";
        String scriptPath = jlinkPath.replace(exeName, "IDEJLinkConfig.txt");
        return scriptPath;
    }

    private static String getJLinkExeNameByName(String exeName) {
        String gdbName;
        String tmpPath;
        Path checkpath;
        String exePath = String.valueOf(GeneralPathUtil.getToolsPath()) + File.separator + "J-Link" + File.separator + exeName;
        String serverPath = TargetAdapter.getServerPath();
        if (serverPath == null) {
            return exePath;
        }
        if (!serverPath.contains(GeneralPathUtil.getToolsPath()) && Files.exists(checkpath = Paths.get(tmpPath = serverPath.replace(gdbName = System.getProperty("os.name").toLowerCase().contains("win") ? "JLinkGDBServerCL.exe" : "JLinkGDBServerCLExe", exeName), new String[0]), new LinkOption[0])) {
            exePath = tmpPath;
        }
        return exePath;
    }
}

