/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.debug.Activator;
import com.gigadevice.debug.GdbServerDebugUtil;
import com.gigadevice.debug.liveexpressions.GDBDebugManager;
import com.gigadevice.debug.liveexpressions.IDebugContextManagerListener;
import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.liveexpressions.actions.ExpandAllAction;
import com.gigadevice.debug.ui.IPeriRegListener;
import com.gigadevice.debug.ui.PeripheralsViewManager;
import com.gigadevice.debug.utils.GdbDebugUtil;
import com.gigadevice.debug.utils.SVDUtil;
import com.gigadevice.debug.utils.ToolUtil;
import com.gigadevice.debug.utils.TreeField;
import com.gigadevice.debug.utils.TreePeripheral;
import com.gigadevice.debug.utils.TreePeripheralGroup;
import com.gigadevice.debug.utils.TreeRegister;
import com.gigadevice.debug.utils.TreeUnit;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class PeripheralsView
extends ViewPart
implements IDebugContextListener,
IDebugContextManagerListener,
IPeriRegListener {
    protected TreeViewer viewer;
    public TreePeripheralGroup peripheralGroup;
    public String filePath = "";
    ArrayList<TreeUnit> periUnits;
    private static Object curSession = null;
    private DsfSession.SessionStartedListener sessionStartedListener;
    private DsfSession.SessionEndedListener sessionEndedListener;
    public static boolean fSuspended = true;
    protected TreeColumnLayout layout;
    protected Tree tree;
    public boolean isloadSVDInfo = false;
    private GDBDebugManager fContextManager = new GDBDebugManager(this);
    Composite delayComposite;
    protected Spinner delaySpinBox;
    protected int delay = 1000;
    private ExpandAllAction expandAllAction;
    private MyPartListener myPartListener;
    public static PeripheralsViewManager fPeriRegManager;
    private static PeripheralsView activeInstance;
    public int tmp = 0;
    protected final ContributionItem delaySpin = new ContributionItem("delaySpin"){
        protected int minValue;
        protected int maxValue;
        {
            this.minValue = 1000;
            this.maxValue = 10000;
        }

        public void fill(ToolBar parent, int index) {
            ToolItem item = new ToolItem(parent, 2);
            PeripheralsView.this.delayComposite = new Composite((Composite)parent, 0);
            PeripheralsView.this.delayComposite.setToolTipText("test");
            PeripheralsView.this.delayComposite.setBounds(0, 0, 150, 23);
            Label lblNewLabel = new Label(PeripheralsView.this.delayComposite, 0);
            lblNewLabel.setBounds(0, 5, 40, 18);
            lblNewLabel.setText("Delay:");
            PeripheralsView.this.delaySpinBox = new Spinner(PeripheralsView.this.delayComposite, 2048);
            PeripheralsView.this.delaySpinBox.setBounds(40, 2, 80, 22);
            PeripheralsView.this.delaySpinBox.setToolTipText("valid range: [1000,10000]");
            PeripheralsView.this.delaySpinBox.setIncrement(100);
            PeripheralsView.this.delaySpinBox.setMinimum(this.minValue);
            PeripheralsView.this.delaySpinBox.setMaximum(this.maxValue);
            PeripheralsView.this.delaySpinBox.setSelection(PeripheralsView.this.delay);
            PeripheralsView.this.delaySpinBox.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    this.setDelay((this).PeripheralsView.this.delaySpinBox.getSelection());
                }
            });
            PeripheralsView.this.delaySpinBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.setDelay((this).PeripheralsView.this.delaySpinBox.getSelection());
                }

                public void widgetSelected(SelectionEvent e) {
                    if ((e.stateMask & SWT.BUTTON_MASK) != 0) {
                        this.setDelay((this).PeripheralsView.this.delaySpinBox.getSelection());
                    }
                }
            });
            PeripheralsView.this.delaySpinBox.setEnabled(true);
            item.setWidth(120);
            item.setControl((Control)PeripheralsView.this.delayComposite);
        }

        private int round(int number, int increment) {
            int a = number / increment * increment;
            int b = a + increment;
            return number - a > b - number ? b : a;
        }

        private void setDelay(int spinnerValue) {
            int value = this.round(spinnerValue, 100);
            if (value < this.minValue) {
                value = this.minValue;
            } else if (value > this.maxValue) {
                value = this.maxValue;
            }
            PeripheralsView.this.delaySpinBox.setSelection(value);
            PeripheralsView.this.delay = value;
            PeripheralsView.this.setDelay(value);
        }

        public void fill(CoolBar parent, int index) {
            super.fill(parent, index);
            Spinner spinner = new Spinner((Composite)parent, 0);
            spinner.setLayoutData((Object)new GridData());
        }
    };

    public PeripheralsView() {
        this.periUnits = new ArrayList();
        this.filePath = Activator.getInstance().getPreferenceStore().getString("com.gigadevice.debug.launch.svdpath");
        fPeriRegManager = new PeripheralsViewManager();
        fPeriRegManager.addListener(this);
        activeInstance = this;
        System.out.println("PeripheralsView: Constructor called, activeInstance set");
    }

    public void createPartControl(Composite parent) {
        this.tree = new Tree(parent, 68354);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.layout = new TreeColumnLayout();
        parent.setLayout((Layout)this.layout);
        new ViewContentProvider(this.filePath);
        this.viewer = new TreeViewer(this.tree);
        int i = 0;
        while (i < 4) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 16384);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            if (i == 0) {
                treeColumn.setText("  Name");
                this.layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(2, 10, true));
                treeViewerColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(this.viewer, 0));
            } else if (i == 1) {
                treeColumn.setText("  Address");
                this.layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(2, 10, true));
                treeViewerColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(this.viewer, 1));
            } else if (i == 2) {
                treeColumn.setText("  HEX Value");
                this.layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(2, 10, true));
                treeViewerColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(this.viewer, 2));
                treeViewerColumn.setEditingSupport((EditingSupport)new ValueColumnEditSupport(this.viewer, 2));
            } else if (i == 3) {
                treeColumn.setText("  BINARY Value");
                this.layout.setColumnData((Widget)treeColumn, (ColumnLayoutData)new ColumnWeightData(2, 10, true));
                treeViewerColumn.setLabelProvider((CellLabelProvider)new ViewLabelProvider(this.viewer, 3));
            }
            treeColumn.setResizable(true);
            treeColumn.setMoveable(true);
            ++i;
        }
        this.viewer.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                final Object unit = treeItem.getData();
                if (unit instanceof TreePeripheral) {
                    PeripheralsView.this.addUpdateTreeUnits((TreeUnit)unit);
                    if (!PeripheralsView.this.periUnits.contains((TreeUnit)unit)) {
                        PeripheralsView.this.periUnits.add((TreeUnit)unit);
                    }
                } else {
                    return;
                }
                System.out.println("PeripheralsView: Expanded peripheral: " + ((TreeUnit)unit).getName());
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).PeripheralsView.this.viewer.refresh((Object)(this).PeripheralsView.this.peripheralGroup);
                        (this).PeripheralsView.this.viewer.refresh(unit);
                    }
                });
            }
        });
        this.viewer.getTree().addListener(18, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                Object unit = treeItem.getData();
                if (unit instanceof TreePeripheral) {
                    PeripheralsView.this.deleteUpdateTreeUnits((TreeUnit)unit);
                    PeripheralsView.this.periUnits.remove(unit);
                }
            }
        });
        this.viewer.refresh();
        this.tree.update();
        this.sessionCreate();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeripheralsView.this.initSVDInfo();
            }
        });
        this.createActions();
        this.fContextManager.start();
        IWorkbenchPage page = this.getSite().getPage();
        this.myPartListener = new MyPartListener();
        page.addPartListener((IPartListener)this.myPartListener);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeripheralsView.this.reconnectLiveService();
            }
        });
    }

    private void createActions() {
        this.expandAllAction = new ExpandAllAction(this);
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager toolbar = bars.getToolBarManager();
        toolbar.add((IContributionItem)this.delaySpin);
        toolbar.add((IAction)this.expandAllAction);
        this.delaySpin.setVisible(true);
    }

    public void initSVDInfo() {
        boolean filePathChanged;
        String newFilePath = GdbServerDebugUtil.SVDFilePath;
        if (newFilePath.equals("")) {
            newFilePath = Activator.getInstance().getPreferenceStore().getString("com.gigadevice.debug.launch.svdpath");
        }
        boolean bl = filePathChanged = !newFilePath.equals(this.filePath);
        if (this.isloadSVDInfo && !filePathChanged) {
            return;
        }
        System.out.println("PeripheralsView: initSVDInfo - Loading SVD file: " + newFilePath);
        this.clrTreeUnits(this.peripheralGroup);
        if (this.periUnits != null && !this.periUnits.isEmpty()) {
            System.out.println("PeripheralsView: Cleaning up " + this.periUnits.size() + " expanded peripheral units");
            for (TreeUnit unit : this.periUnits) {
                if (!(unit instanceof TreePeripheral)) continue;
                this.deleteUpdateTreeUnits(unit);
                System.out.println("PeripheralsView: Cleaned up peripheral: " + unit.getName());
            }
        }
        this.filePath = newFilePath;
        this.peripheralGroup = null;
        this.periUnits = new ArrayList();
        ViewContentProvider viewContentProvider = new ViewContentProvider(this.filePath);
        if (this.peripheralGroup == null) {
            System.err.println("PeripheralsView: Failed to load SVD file: " + this.filePath);
            return;
        }
        if (!this.peripheralGroup.hasChildUnits()) {
            System.out.println("PeripheralsView: SVD file has no peripheral units: " + this.filePath);
            return;
        }
        this.viewer.setContentProvider((IContentProvider)viewContentProvider);
        this.viewer.setInput((Object)this.peripheralGroup);
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getExpanded()) {
                items[i].setExpanded(false);
            }
            ++i;
        }
        this.viewer.collapseAll();
        this.viewer.refresh();
        this.tree.update();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeripheralsView.this.viewer.refresh();
                System.out.println("PeripheralsView: SVD info reloaded successfully");
            }
        });
        this.isloadSVDInfo = true;
        if (curSession == null && (curSession = GdbDebugUtil.getSession()) == null) {
            return;
        }
        fPeriRegManager.setThreadState(2);
    }

    public void dispose() {
        fPeriRegManager.setThreadState(0);
        if (curSession == null) {
            return;
        }
        curSession = null;
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        DsfSession.removeSessionStartedListener((DsfSession.SessionStartedListener)this.sessionStartedListener);
        DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this.sessionEndedListener);
        if (activeInstance == this) {
            activeInstance = null;
        }
        super.dispose();
        IWorkbenchPage page = this.getSite().getPage();
        if (page != null && this.myPartListener != null) {
            page.removePartListener((IPartListener)this.myPartListener);
        }
    }

    public void sessionCreate() {
        this.sessionStartedListener = new DsfSessionStartedListener();
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this.sessionStartedListener);
        this.sessionEndedListener = new DsfSession.SessionEndedListener(){

            public void sessionEnded(DsfSession session) {
                DebugEvent event = new DebugEvent((Object)new DsfSessionChangedDebugEvent(session), 8);
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{event});
            }
        };
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this.sessionEndedListener);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
    }

    public static synchronized long getMemory(long address, int length) {
        if (curSession instanceof DsfSession && !((DsfSession)curSession).isActive()) {
            curSession = GdbDebugUtil.getSession();
        }
        try {
            long value = GdbDebugUtil.getMemory(curSession, Long.toString(address), length, 1000);
            fSuspended = GdbDebugUtil.fSuspended;
            return value;
        }
        catch (TimeoutException e) {
            System.out.println(e);
            return -1L;
        }
    }

    public static int setMemory(long address, long val, int length) {
        try {
            return GdbDebugUtil.setMemory(curSession, Long.toString(address), Long.toString(val), length, 5000);
        }
        catch (TimeoutException e) {
            System.out.println(e);
            return -1;
        }
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void gdbTerminatedClr() {
        fPeriRegManager.setThreadState(1);
        if (curSession != null) {
            curSession = null;
        }
        this.clrTreeUnits(this.peripheralGroup);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PeripheralsView.this.viewer.refresh();
            }
        });
    }

    public void gdbSuspendedUpdate() {
        fPeriRegManager.setThreadState(3);
    }

    public void gdbResumeUpdate() {
        fPeriRegManager.setThreadState(2);
    }

    private void clrTreeUnits(TreeUnit element) {
        if (element instanceof TreeRegister) {
            ((TreeRegister)element).clearValue();
        } else if (element instanceof TreePeripheralGroup && ((TreePeripheralGroup)element).hasChildUnits()) {
            TreePeripheralGroup pelement = (TreePeripheralGroup)element;
            TreeUnit[] treeUnitArray = pelement.getChildUnits();
            int n = treeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeUnit telement = treeUnitArray[n2];
                this.clrTreeUnits(telement);
                ++n2;
            }
        }
    }

    private synchronized void addUpdateTreeUnits(TreeUnit pelement) {
        if (pelement instanceof TreePeripheral && ((TreePeripheralGroup)pelement).hasChildUnits()) {
            TreeUnit[] treeUnitArray = ((TreePeripheral)pelement).getChildUnits();
            int n = treeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeUnit telement = treeUnitArray[n2];
                fPeriRegManager.updatePeriRegs((TreeRegister)telement, 0);
                ++n2;
            }
        }
        fPeriRegManager.setThreadState(2);
    }

    private synchronized void deleteUpdateTreeUnits(TreeUnit pelement) {
        if (pelement instanceof TreePeripheral && ((TreePeripheralGroup)pelement).hasChildUnits()) {
            TreeUnit[] treeUnitArray = ((TreePeripheral)pelement).getChildUnits();
            int n = treeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeUnit telement = treeUnitArray[n2];
                fPeriRegManager.updatePeriRegs((TreeRegister)telement, 1);
                ++n2;
            }
        }
    }

    private synchronized void updateTreeUnits(ArrayList<TreeUnit> units) {
        if (units.size() == 0) {
            return;
        }
        for (TreeUnit pelement : units) {
            if (!(pelement instanceof TreePeripheral) || !((TreePeripheralGroup)pelement).hasChildUnits()) continue;
            TreeUnit[] treeUnitArray = ((TreePeripheral)pelement).getChildUnits();
            int n = treeUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeUnit telement = treeUnitArray[n2];
                System.out.println("element " + telement.getName() + "  : ");
                ++n2;
            }
        }
    }

    public void debugContextChanged(DebugContextEvent event) {
        DsfServicesTracker tracker = this.fContextManager.getServicesTracker();
        if (tracker == null) {
            return;
        }
        IGDBVarManagerService liveService = (IGDBVarManagerService)tracker.getService(IGDBVarManagerService.class);
        if (liveService != null) {
            fPeriRegManager.setLiveService(liveService);
            System.out.println("PeripheralsView: liveService set successfully in debugContextChanged");
        } else {
            System.out.println("PeripheralsView: liveService is null in debugContextChanged, setting WAIT_UPDATE state");
            fPeriRegManager.setThreadState(1);
        }
    }

    public void setDelay(int value) {
        fPeriRegManager.setUpdateTimer(value);
    }

    @Override
    public void gdbSession(String id) {
    }

    @Override
    public void gdbSuspend() {
        System.out.println("gdbSuspend");
        fSuspended = true;
        this.gdbSuspendedUpdate();
    }

    @Override
    public void gdbResume() {
        System.out.println("gdbResume");
        fSuspended = false;
        this.periRegUpdate();
        this.gdbResumeUpdate();
    }

    @Override
    public void gdbExited() {
        System.out.println("gdbExited");
        this.gdbTerminatedClr();
        GdbDebugUtil.fGDBDebug = false;
    }

    public boolean isViewActive() {
        return this.getSite().getPage().getActivePart() == this;
    }

    private void reconnectLiveService() {
        if (!GdbDebugUtil.fGDBDebug) {
            return;
        }
        try {
            DsfServicesTracker tracker = this.fContextManager.getServicesTracker();
            if (tracker == null) {
                System.out.println("PeripheralsView: ServicesTracker is null, attempting to recreate...");
                tracker = this.fContextManager.getOrCreateServicesTracker();
            }
            if (tracker != null) {
                IGDBVarManagerService liveService = (IGDBVarManagerService)tracker.getService(IGDBVarManagerService.class);
                if (liveService != null && liveService.isRegistered()) {
                    fPeriRegManager.setLiveService(liveService);
                    System.out.println("PeripheralsView: Successfully reconnected liveService");
                } else {
                    System.out.println("PeripheralsView: liveService not available from tracker, will retry in getLiveService");
                }
            } else {
                System.out.println("PeripheralsView: Failed to create ServicesTracker");
            }
        }
        catch (Exception e) {
            System.err.println("PeripheralsView: Failed to reconnect liveService: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void onSVDFilePathChanged() {
        if (activeInstance != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    activeInstance.initSVDInfo();
                }
            });
        }
    }

    @Override
    public void periRegUpdate() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PeripheralsView.this.peripheralGroup != null) {
                    PeripheralsView.this.viewer.refresh((Object)PeripheralsView.this.peripheralGroup);
                    for (TreeUnit unit : PeripheralsView.this.periUnits) {
                        if (!(unit instanceof TreePeripheral)) continue;
                        PeripheralsView.this.viewer.refresh((Object)unit);
                    }
                }
            }
        });
    }

    public class DsfSessionChangedDebugEvent {
        private DsfSession session;

        public DsfSessionChangedDebugEvent(DsfSession session) {
            this.session = session;
        }
    }

    public class DsfSessionStartedListener
    implements DsfSession.SessionStartedListener {
        public DsfSessionStartedListener() {
            DsfSession[] sessions = DsfSession.getActiveSessions();
            int i = 0;
            while (i < sessions.length) {
                this.sessionStarted(sessions[i]);
                ++i;
            }
        }

        public void sessionStarted(DsfSession session) {
            new SessionListener(session);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    GdbDebugUtil.fGDBDebug = true;
                    System.out.println("PeripheralsView: Debug session started, reloading SVD info");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            PeripheralsView.this.initSVDInfo();
                            if (((DsfSessionStartedListener)(this).DsfSessionStartedListener.this).PeripheralsView.this.peripheralGroup != null) {
                                ((DsfSessionStartedListener)(this).DsfSessionStartedListener.this).PeripheralsView.this.viewer.refresh();
                                ((DsfSessionStartedListener)(this).DsfSessionStartedListener.this).PeripheralsView.this.tree.update();
                            }
                        }
                    });
                }
            });
        }
    }

    private class MyPartListener
    implements IPartListener {
        private MyPartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == PeripheralsView.this) {
                activeInstance = PeripheralsView.this;
                if (!GdbDebugUtil.fGDBDebug) {
                    return;
                }
                PeripheralsView.this.reconnectLiveService();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            System.out.println("PeripheralsView_partBroughtToTop");
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == PeripheralsView.this) {
                System.out.println("PeripheralsView_partDeactivated");
                PeripheralsView.this.gdbTerminatedClr();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == PeripheralsView.this) {
                System.out.println("PeripheralsView_partDeactivated");
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == PeripheralsView.this) {
                PeripheralsView.this.reconnectLiveService();
            }
            System.out.println("PeripheralsView_partOpened");
        }
    }

    public class SessionListener {
        private String sessionId;

        public SessionListener(DsfSession session) {
            this.sessionId = session.getId();
            session.addServiceEventListener((Object)this, null);
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.ISuspendedDMEvent event) {
            if (event instanceof IRunControl.IContainerSuspendedDMEvent) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)new DsfSessionChangedDebugEvent(DsfSession.getSession((String)this.sessionId)), 2)});
            }
        }

        @DsfServiceEventHandler
        public void eventDispatched(IRunControl.IResumedDMEvent event) {
            if (event instanceof IRunControl.IContainerResumedDMEvent) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)new DsfSessionChangedDebugEvent(DsfSession.getSession((String)this.sessionId)), 1)});
            }
        }
    }

    public class ValueColumnEditSupport
    extends EditingSupport {
        final TreeViewer viewer;
        final int columnIndex;
        private TextCellEditor valueEditor;

        public ValueColumnEditSupport(TreeViewer viewer, int columnIndex) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
            this.columnIndex = columnIndex;
            this.valueEditor = new TextCellEditor((Composite)this.viewer.getTree());
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof TreeField || element instanceof TreeRegister) {
                return this.valueEditor;
            }
            return null;
        }

        protected boolean canEdit(Object element) {
            IAdaptable context = DebugUITools.getDebugContext();
            if (context == null) {
                return false;
            }
            if (this.columnIndex == 0 || this.columnIndex == 1) {
                return false;
            }
            TreeUnit unit = (TreeUnit)element;
            if (unit instanceof TreeRegister) {
                if (((TreeRegister)unit).getRWState() != 2 || ((TreeRegister)unit).getRWState() != 0) {
                    return false;
                }
            } else if (unit instanceof TreeField) {
                TreeRegister register = (TreeRegister)((TreeField)unit).getParentUnit();
                if (register.getRWState() != 0 || register.getRWState() != 2) {
                    return true;
                }
                if (register.getRWState() == 0 && ((TreeField)unit).getRWState() != 2) {
                    return true;
                }
            }
            return false;
        }

        protected Object getValue(Object element) {
            if (element instanceof TreeUnit) {
                return Long.toString(((TreeUnit)element).getValue());
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (value == null) {
                return;
            }
            if (element instanceof TreeUnit) {
                TreeUnit unit = (TreeUnit)element;
                long[] retVal = new long[2];
                if (unit instanceof TreeField) {
                    if (this.checkValidInput(unit, (String)value, retVal)) {
                        long registerVal = this.getRegisterValue((TreeField)unit, retVal[0]);
                        ((TreeRegister)unit.getParentUnit()).setValue(registerVal);
                        this.viewer.refresh();
                    }
                } else if (unit instanceof TreeRegister && this.checkValidInput(unit, (String)value, retVal)) {
                    unit.setValue(retVal[0]);
                }
            }
        }

        public boolean checkValidInput(TreeUnit unit, String inputStr, long[] retVal) {
            String valStr = "";
            if (this.columnIndex == 2) {
                valStr = inputStr.indexOf("0x") > -1 ? inputStr.substring(inputStr.indexOf("0x")) : (inputStr.contains("x") ? inputStr.substring(inputStr.indexOf("x")) : inputStr);
            } else if (this.columnIndex == 3) {
                if (inputStr.indexOf("0b") > -1) {
                    valStr = inputStr.substring(inputStr.indexOf("0b"));
                }
                if (valStr.length() > ((TreeField)unit).getBitWidth()) {
                    return false;
                }
            }
            retVal[0] = Long.valueOf(valStr);
            return true;
        }

        long getRegisterValue(TreeField unit, long val) {
            long registerVal = ((TreeRegister)unit.getParentUnit()).getValue();
            long validFormat = 0L;
            int i = 0;
            while (i < unit.getBitWidth()) {
                validFormat |= (long)(1 << i);
                ++i;
            }
            registerVal &= validFormat << unit.getBitOffset() ^ 0xFFFFFFFFFFFFFFFFL;
            return registerVal |= val << unit.getBitOffset();
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        public ViewContentProvider(String filePath) {
            if (!GdbServerDebugUtil.SVDFilePath.equalsIgnoreCase("")) {
                filePath = GdbServerDebugUtil.SVDFilePath;
                System.out.println("ViewContentProvider: Using GdbServerDebugUtil.SVDFilePath: " + filePath);
                this.initPerisTree(filePath);
            } else if (!filePath.equalsIgnoreCase("")) {
                System.out.println("ViewContentProvider: Using provided filePath: " + filePath);
                this.initPerisTree(filePath);
            } else {
                System.out.println("ViewContentProvider: No valid filePath provided");
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof TreePeripheralGroup) {
                Object[] units = ((TreePeripheralGroup)parentElement).getChildUnits();
                return units;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof TreeUnit) {
                return ((TreeUnit)element).getParentUnit();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof TreePeripheral) {
                return ((TreePeripheral)element).getChildUnits().length > 0;
            }
            if (element instanceof TreeRegister) {
                return ((TreeRegister)element).getChildUnits().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement.equals(PeripheralsView.this.getViewSite())) {
                if (PeripheralsView.this.peripheralGroup == null) {
                    this.initPerisTree(PeripheralsView.this.filePath);
                }
                return this.getChildren(PeripheralsView.this.peripheralGroup);
            }
            return this.getChildren(inputElement);
        }

        void initPerisTree(String filePath) {
            System.out.println("ViewContentProvider: Loading peripherals tree from: " + filePath);
            PeripheralsView.this.peripheralGroup = new SVDUtil().getPeripheralsTree(filePath);
            if (PeripheralsView.this.peripheralGroup == null) {
                System.err.println("ViewContentProvider: Failed to load peripherals tree from: " + filePath);
                return;
            }
            System.out.println("ViewContentProvider: Successfully loaded " + (PeripheralsView.this.peripheralGroup.hasChildUnits() ? PeripheralsView.this.peripheralGroup.getChildUnits().length : 0) + " peripheral units");
        }
    }

    public class ViewLabelProvider
    extends ColumnLabelProvider {
        final TreeViewer viewer;
        final int columnIndex;

        public ViewLabelProvider(TreeViewer viewer, int columnIndex) {
            this.viewer = viewer;
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            if (element instanceof TreeUnit) {
                TreeUnit unit = (TreeUnit)element;
                if (this.columnIndex == 0) {
                    return unit.getName();
                }
                if (this.columnIndex == 1) {
                    if (element instanceof TreeRegister) {
                        return "0x " + ToolUtil.appendZeroto32bits(Long.toHexString(((TreeRegister)element).getRegisterAddr()));
                    }
                    if (element instanceof TreePeripheral) {
                        return "";
                    }
                    if (element instanceof TreeField) {
                        return "";
                    }
                } else if (this.columnIndex == 2) {
                    if (element instanceof TreeRegister) {
                        TreeRegister reg = (TreeRegister)element;
                        if (Activator.getInstance().isDebugging()) {
                            long value = reg.getValue();
                            if (!GdbDebugUtil.isNonStop && !fSuspended) {
                                return "Invalid Value";
                            }
                            return Long.toString(value);
                        }
                        if (!GdbDebugUtil.isNonStop && !fSuspended) {
                            return "Invalid Value";
                        }
                        long value = reg.getValue();
                        return "0x " + ToolUtil.appendZeroto32bits(Long.toHexString(value));
                    }
                    if (element instanceof TreeField) {
                        if (!GdbDebugUtil.isNonStop && !fSuspended) {
                            return "Invalid Value";
                        }
                        TreeField field = (TreeField)element;
                        return field.getFieldValueinHex(field.getValue());
                    }
                    if (element instanceof TreePeripheral) {
                        return "";
                    }
                } else if (this.columnIndex == 3) {
                    if (element instanceof TreeField) {
                        if (!GdbDebugUtil.isNonStop && !fSuspended) {
                            return "Invalid Value";
                        }
                        TreeField field = (TreeField)element;
                        return field.getFieldValueinBinary(field.getValue());
                    }
                    return "";
                }
            }
            return "";
        }

        public Color getColor(int systemColorID) {
            Display display = Display.getCurrent();
            return display.getSystemColor(systemColorID);
        }
    }
}

