/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.debug.MCUDebugPlugin;
import com.gigadevice.debug.utils.CApplication;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.debug.utils.ToolUtil;
import com.gigadevice.utils.constants.DebugConstants;
import com.gigadevice.venustool.baseinfo.MCUSeletorInfo;
import com.gigadevice.venustool.mcuxmlinfo.CoreInfo;
import com.gigadevice.venustool.mcuxmlinfo.McuFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CMainTab2;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class MainTab
extends CMainTab2 {
    private final boolean fDontCheckProgram;
    private final boolean fSpecifyCoreFile;
    private final boolean fIncludeBuildSettings;
    protected int AppNum = 0;
    protected int MAXAppNum = 10;
    protected List<CApplication> fCApplications = new ArrayList<CApplication>();
    private LinkedHashMap<String, CoreInfo> CoreInfoMap = new LinkedHashMap();
    int CurIndex = 0;
    private ScrolledComposite scrolledComposite;
    protected Composite comp;
    protected Composite mainComp;
    protected GridData gd;
    private Image checkImage;
    private Image uncheckImage;

    public MainTab(int flags) {
        super(flags);
        this.fDontCheckProgram = (flags & 2) != 0;
        this.fSpecifyCoreFile = (flags & 4) != 0;
        this.fIncludeBuildSettings = (flags & 8) != 0;
    }

    int GetAppNum(ILaunchConfiguration config) {
        int AppNum = 1;
        IProject project = DebugUtil.getCurProject(config);
        String McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
        MCUSeletorInfo tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)1, (String)McuNo);
        AppNum = tmpMcuSeletorInfo.getCoreNum();
        return AppNum;
    }

    public void createControl(Composite parent) {
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.comp = new Composite((Composite)this.scrolledComposite, 0);
        this.setControl((Control)this.scrolledComposite);
        GridLayout layout = new GridLayout();
        this.comp.setLayout((Layout)layout);
        LaunchUIPlugin.getDefault().getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.cdt.launch.launch_configuration_dialog_main_tab");
        this.createVerticalSpacer(this.comp, 1);
        this.createProjectGroup(this.comp, 1);
        this.createExeFileGroup(this.comp, 1, 1);
        if (this.fIncludeBuildSettings) {
            this.createBuildOptionGroup(this.comp, 1);
        }
        this.createVerticalSpacer(this.comp, 1);
        if (this.fSpecifyCoreFile) {
            this.createCoreFileGroup(this.comp, 1);
        }
        LaunchUIPlugin.setDialogShell((Shell)parent.getShell());
        parent.addDisposeListener(e -> this.disposeImage());
    }

    private void disposeImage() {
        if (this.checkImage != null && !this.checkImage.isDisposed()) {
            this.checkImage.dispose();
            this.checkImage = null;
        }
        if (this.uncheckImage != null && !this.uncheckImage.isDisposed()) {
            this.uncheckImage.dispose();
            this.uncheckImage = null;
        }
    }

    public void dispose() {
        super.dispose();
        this.disposeImage();
    }

    protected void createExeFileGroup(Composite parent, int colSpan, int Num) {
        this.mainComp = new Composite(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        this.mainComp.setLayoutData((Object)gd);
    }

    protected ArrayList<String> getCoreIndexList(ILaunchConfiguration config) {
        if (this.AppNum <= 1) {
            return null;
        }
        ArrayList<String> CoreIndexList = new ArrayList<String>();
        boolean needUpdatebyCoreMap = false;
        int i = 0;
        while (i < this.AppNum) {
            String CoreIndexStr;
            String tempCoreStr = DebugUtil.getAttribute(config, "com.gigadevice.debug.launch.coreIndex", i);
            if (tempCoreStr != null && tempCoreStr != "") break;
            String ApplicationStr = DebugUtil.getAttribute(config, "org.eclipse.cdt.launch.PROGRAM_NAME", i);
            if (ApplicationStr != null && ApplicationStr != "") {
                CoreIndexStr = DebugUtil.getCoreIndexFromProgram(ApplicationStr, config);
                if (CoreIndexStr.equals("")) {
                    CoreIndexList.clear();
                    needUpdatebyCoreMap = true;
                    break;
                }
            } else {
                needUpdatebyCoreMap = true;
                break;
            }
            CoreIndexList.add(CoreIndexStr);
            ++i;
        }
        if (needUpdatebyCoreMap) {
            Set<String> Cores = this.CoreInfoMap.keySet();
            for (String Core : Cores) {
                CoreIndexList.add(Core);
            }
        }
        return CoreIndexList;
    }

    private String getSelectedCoreIndex() {
        String portCmdString = " -port";
        for (CApplication cApplication : this.fCApplications) {
            if (!cApplication.isfIsActivated()) continue;
            CoreInfo SelectCoreInfo = this.CoreInfoMap.get(cApplication.getfActivationButton().getText());
            portCmdString = String.valueOf(portCmdString) + " " + SelectCoreInfo.getAPIndex();
        }
        return portCmdString;
    }

    protected void updateCmdParaPort(ILaunchConfiguration configuration) {
        if (this.AppNum > 1) {
            try {
                String mode = configuration.getAttribute("com.gigadevice.debug.gdlink.server", DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
                if (mode.contains(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
                    String newSelectedCore = this.getSelectedCoreIndex();
                    String CMDPara = configuration.getAttribute("com.gigadevice.debug.launch.serverParam", "");
                    if (CMDPara.contains(" -port")) {
                        int startIndex = CMDPara.indexOf(" -port");
                        String temp = (CMDPara = String.valueOf(CMDPara.substring(0, startIndex)) + newSelectedCore).substring(startIndex + 6);
                        if (temp.contains(" -")) {
                            int endIndex = CMDPara.substring(startIndex + 6).indexOf(" -");
                            CMDPara = String.valueOf(CMDPara) + CMDPara.substring(endIndex);
                        }
                    } else {
                        CMDPara = String.valueOf(CMDPara) + newSelectedCore;
                    }
                    ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("com.gigadevice.debug.launch.serverParam", CMDPara);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void updateAppWidgetState(CApplication cApplication) {
        Boolean debugIsActivated = cApplication.isfIsActivated();
        cApplication.getfAppProgText().setEditable(debugIsActivated.booleanValue());
        if (cApplication.isfIsActivable()) {
            if (debugIsActivated.booleanValue()) {
                cApplication.getfActivationButton().setBackground(new Color(null, 0, 255, 0));
                cApplication.getfActivationButton().setImage(this.checkImage);
            } else {
                cApplication.getfActivationButton().setBackground(new Color(null, 255, 0, 0));
                cApplication.getfActivationButton().setImage(this.uncheckImage);
            }
        }
        cApplication.getfAppVariablesButton().setEnabled(debugIsActivated.booleanValue());
        cApplication.getfAppSearchButton().setEnabled(debugIsActivated.booleanValue());
        cApplication.getfAppBrowseButton().setEnabled(debugIsActivated.booleanValue());
    }

    protected void createExeFile(Composite mainComp, int Num, final ILaunchConfiguration config) {
        ArrayList<String> CoreIndexList = this.getCoreIndexList(config);
        boolean hasCoreIndex = false;
        if (CoreIndexList == null || CoreIndexList.size() == 0) {
            hasCoreIndex = true;
        }
        int i = 0;
        while (i < Num) {
            final CApplication cApplication = new CApplication();
            cApplication.setfIndex(i);
            cApplication.setfIsActivable(Num > 1);
            this.fCApplications.add(cApplication);
            Label fProgLabel = new Label(mainComp, 0);
            fProgLabel.setText(LaunchMessages.CMainTab_C_Application);
            cApplication.setfAppProgLabel(fProgLabel);
            this.gd = new GridData();
            fProgLabel.setLayoutData((Object)this.gd);
            Composite progComp = new Composite(mainComp, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            progComp.setLayout((Layout)layout);
            this.gd = new GridData(768);
            progComp.setLayoutData((Object)this.gd);
            progComp.setFont(this.comp.getFont());
            if (cApplication.isfIsActivable()) {
                String CoreIndex = "";
                if (hasCoreIndex) {
                    CoreIndex = DebugUtil.getAttribute(config, "com.gigadevice.debug.launch.coreIndex", i);
                } else {
                    CoreIndex = CoreIndexList.get(i);
                    DebugUtil.setAttribute((ILaunchConfigurationWorkingCopy)config, "com.gigadevice.debug.launch.coreIndex", CoreIndex, i);
                }
                String debugIsActivatedStr = DebugUtil.getAttribute(config, "com.gigadevice.debug.launch.debugIsActivated", i);
                if (debugIsActivatedStr.equals("")) {
                    debugIsActivatedStr = "true";
                    DebugUtil.setAttribute((ILaunchConfigurationWorkingCopy)config, "com.gigadevice.debug.launch.debugIsActivated", "true", i);
                }
                Boolean debugIsActivated = debugIsActivatedStr.equals("true") ? Boolean.valueOf(true) : Boolean.valueOf(false);
                cApplication.setfIsActivated(debugIsActivated);
                Button fActivationButton = debugIsActivated != false ? this.createPushButton(progComp, CoreIndex, this.checkImage) : this.createPushButton(progComp, CoreIndex, this.uncheckImage);
                cApplication.setfActivationButton(fActivationButton);
                fActivationButton.setToolTipText("Activate/Deactivate the program");
                GridData gd = new GridData();
                fActivationButton.setLayoutData((Object)gd);
                fActivationButton.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Boolean preState = cApplication.isfIsActivated();
                        cApplication.setfIsActivated(preState == false);
                        MainTab.this.updateAppWidgetState(cApplication);
                        MainTab.this.updateLaunchConfigurationDialog();
                        MainTab.this.updateCmdParaPort(config);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
            }
            final Text fProgText = new Text(progComp, 2052);
            cApplication.setfAppProgText(fProgText);
            this.gd = new GridData(768);
            fProgText.setLayoutData((Object)this.gd);
            fProgText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent evt) {
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            });
            Composite buttonComp = new Composite(mainComp, 0);
            GridLayout layout2 = new GridLayout(3, false);
            layout2.marginHeight = 0;
            layout2.marginWidth = 0;
            buttonComp.setLayout((Layout)layout2);
            this.gd = new GridData(128);
            buttonComp.setLayoutData((Object)this.gd);
            buttonComp.setFont(this.comp.getFont());
            Button variablesButton = this.createVariablesButton(buttonComp, LaunchMessages.CMainTab_Variables, fProgText);
            cApplication.setfAppVariablesButton(variablesButton);
            final Button fSearchButton = this.createPushButton(buttonComp, LaunchMessages.CMainTab_Search, null);
            fSearchButton.setData((Object)i);
            cApplication.setfAppSearchButton(fSearchButton);
            fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    MainTab.this.handleSearchButtonSelected((Integer)fSearchButton.getData());
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            });
            final Button browseForBinaryButton = this.createPushButton(buttonComp, LaunchMessages.Launch_common_Browse_2, null);
            cApplication.setfAppBrowseButton(browseForBinaryButton);
            browseForBinaryButton.setData((Object)i);
            browseForBinaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String text = MainTab.this.handleBrowseButtonSelected(LaunchMessages.CMainTab2_Application_Selection, (Integer)browseForBinaryButton.getData());
                    if (text != null) {
                        fProgText.setText(text);
                    }
                    MainTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.updateAppWidgetState(cApplication);
            ++i;
        }
    }

    protected void initializeProgramName(ICElement cElement, ILaunchConfigurationWorkingCopy config) {
        String name;
        boolean renamed = false;
        if (!(cElement instanceof IBinary)) {
            cElement = cElement.getCProject();
        }
        String buildConfigName = null;
        if (cElement instanceof ICProject) {
            IProject project = cElement.getCProject().getProject();
            name = project.getName();
            ICProjectDescription projDes = CCorePlugin.getDefault().getProjectDescription(project);
            if (projDes != null) {
                buildConfigName = projDes.getActiveConfiguration().getName();
                name = String.valueOf(name) + " " + buildConfigName;
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
            renamed = true;
        }
        IBinary binary = null;
        if (cElement instanceof ICProject) {
            IBinary[] bins = this.getBinaryFiles((ICProject)cElement);
            if (bins != null && bins.length >= 1) {
                int i = 0;
                while (i < bins.length) {
                    binary = bins[i];
                    if (binary != null) {
                        String path = binary.getResource().getProjectRelativePath().toOSString();
                        if (i == 0) {
                            config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", path);
                        } else {
                            try {
                                ToolUtil.setAttribute(config, "org.eclipse.cdt.launch.PROGRAM_NAME", path, i);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                            }
                        }
                        if (!renamed) {
                            String name2 = binary.getElementName();
                            int index = name2.lastIndexOf(46);
                            if (index > 0) {
                                name2 = name2.substring(0, index);
                            }
                            name2 = this.getLaunchConfigurationDialog().generateName(name2);
                            config.rename(name2);
                            renamed = true;
                        }
                    }
                    ++i;
                }
            }
        } else if (cElement instanceof IBinary) {
            binary = (IBinary)cElement;
        }
        if (!renamed) {
            name = this.getLaunchConfigurationDialog().generateName(cElement.getCProject().getElementName());
            config.rename(name);
        }
    }

    private void initializeImage() {
        if (this.AppNum > 1) {
            String checkImagePath = "icons/check16/checkbox_checked.png";
            String uncheckImagePath = "icons/check16/checkbox_unchecked.png";
            this.checkImage = MCUDebugPlugin.getImageDescriptor(checkImagePath).createImage();
            this.uncheckImage = MCUDebugPlugin.getImageDescriptor(uncheckImagePath).createImage();
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        IProject project = DebugUtil.getCurProject(config);
        String McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
        MCUSeletorInfo tmpMcuSeletorInfo = McuFactory.getSeletorInfoByPartNo((int)1, (String)McuNo);
        this.AppNum = tmpMcuSeletorInfo.getCoreNum();
        this.initializeImage();
        if (this.AppNum > 0) {
            this.CoreInfoMap = DebugUtil.getCoreInfo(config);
            if (this.fCApplications.size() == 0) {
                this.createExeFile(this.mainComp, this.AppNum, config);
            }
        } else {
            this.CoreInfoMap.clear();
        }
        this.filterPlatform = this.getPlatform(config);
        this.updateProjectFromConfig(config);
        this.updateProgramFromConfig(config);
        this.updateCoreFromConfig(config);
        this.updateBuildOptionFromConfig(config);
        this.scrolledComposite.setContent((Control)this.comp);
        this.scrolledComposite.setMinSize(this.comp.computeSize(-1, -1));
    }

    protected void updateProgramFromConfig(ILaunchConfiguration config) {
        if (this.fProjText != null) {
            int i = 0;
            while (i < this.MAXAppNum) {
                if (i >= this.fCApplications.size()) {
                    return;
                }
                String programName = DebugUtil.getAttribute(config, "org.eclipse.cdt.launch.PROGRAM_NAME", i);
                if (this.fCApplications.get(i).getfAppProgText() != null) {
                    this.fCApplications.get(i).getfAppProgText().setText(programName);
                }
                ++i;
            }
        }
    }

    protected String handleBrowseButtonSelected(String title, int index) {
        FileDialog fileDialog = new FileDialog(this.getShell(), 0);
        fileDialog.setText(title);
        fileDialog.setFileName(this.fCApplications.get(index).getfAppProgText().getText());
        return fileDialog.open();
    }

    private boolean checkSameProgramName() {
        ArrayList<String> ProgTextList = new ArrayList<String>();
        int i = 0;
        while (i < this.fCApplications.size()) {
            String ProgramName = this.fCApplications.get(i).getfAppProgText().getText().trim();
            if (!ProgramName.equals("") && this.fCApplications.get(i).isfIsActivated()) {
                ProgramName = ProgramName.replace("\\", "/");
                if (ProgTextList.size() > 0 && ProgTextList.contains(ProgramName)) {
                    return false;
                }
                ProgTextList.add(ProgramName);
            }
            ++i;
        }
        return true;
    }

    protected boolean checkHasAcvicatedDebug() {
        if (this.fCApplications.size() > 1) {
            int i = 0;
            while (i < this.fCApplications.size()) {
                if (this.fCApplications.get(i).isfIsActivated()) {
                    return true;
                }
                ++i;
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean isValid(ILaunchConfiguration config) {
        String coreName;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (!this.fDontCheckProgram) {
            if (!this.checkSameProgramName()) {
                this.setErrorMessage("two or more programs specified are the same");
                return false;
            }
            if (!this.checkHasAcvicatedDebug()) {
                this.setErrorMessage("Requires at least one program activated");
                return false;
            }
            int i = 0;
            while (i < this.AppNum) {
                if (this.fCApplications.get(i).isfIsActivated()) {
                    String programName = this.fCApplications.get(i).getfAppProgText().getText().trim();
                    try {
                        programName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(programName);
                    }
                    catch (CoreException coreException) {}
                    if (programName.length() == 0) {
                        this.setErrorMessage(LaunchMessages.CMainTab_Program_not_specified);
                        return false;
                    }
                    if (programName.equals(".") || programName.equals("..")) {
                        this.setErrorMessage(LaunchMessages.CMainTab_Program_does_not_exist);
                        return false;
                    }
                    Path exePath = new Path(programName);
                    if (exePath.isAbsolute()) {
                        File executable = exePath.toFile();
                        if (!executable.exists()) {
                            this.setErrorMessage(LaunchMessages.CMainTab_Program_does_not_exist);
                            return false;
                        }
                        if (!executable.isFile()) {
                            this.setErrorMessage(LaunchMessages.CMainTab_Selection_must_be_file);
                            return false;
                        }
                    } else {
                        String projectName = this.fProjText.getText().trim();
                        if (projectName.length() == 0) {
                            this.setErrorMessage(LaunchMessages.CMainTab_Project_not_specified);
                            return false;
                        }
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (!project.exists()) {
                            this.setErrorMessage(LaunchMessages.Launch_common_Project_does_not_exist);
                            return false;
                        }
                        if (!project.isOpen()) {
                            this.setErrorMessage(LaunchMessages.CMainTab_Project_must_be_opened);
                            return false;
                        }
                        if (!project.getFile(programName).exists()) {
                            this.setErrorMessage(LaunchMessages.CMainTab_Program_does_not_exist);
                            return false;
                        }
                    }
                }
                ++i;
            }
        }
        if (this.fCoreText != null && !(coreName = this.fCoreText.getText().trim()).equals("")) {
            try {
                coreName = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(coreName, false);
            }
            catch (CoreException e) {
                this.setErrorMessage(e.getMessage());
                return false;
            }
            coreName = coreName.trim();
            File filePath = new File(coreName);
            if (!filePath.isDirectory() && !filePath.exists()) {
                this.setErrorMessage(LaunchMessages.CMainTab2_File_does_not_exist);
                return false;
            }
        }
        return true;
    }

    protected void handleSearchButtonSelected(int index) {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchMessages.CMainTab_Project_required, (String)LaunchMessages.CMainTab_Enter_project_before_searching_for_program);
            return;
        }
        CElementLabelProvider programLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuilder name = new StringBuilder();
                    name.append(bin.getPath().lastSegment());
                    return name.toString();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IBinary belement;
                if (!(element instanceof ICElement)) {
                    return super.getImage(element);
                }
                ICElement celement = (ICElement)element;
                if (celement.getElementType() == 14 && (belement = (IBinary)celement).isExecutable()) {
                    return DebugUITools.getImage((String)"IMG_ACT_RUN");
                }
                return super.getImage(element);
            }
        };
        CElementLabelProvider qualifierLabelProvider = new CElementLabelProvider(){

            public String getText(Object element) {
                if (element instanceof IBinary) {
                    IBinary bin = (IBinary)element;
                    StringBuilder name = new StringBuilder();
                    name.append(bin.getCPU()).append(bin.isLittleEndian() ? "le" : "be");
                    name.append(" - ");
                    name.append(bin.getPath().toString());
                    return name.toString();
                }
                return super.getText(element);
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)programLabelProvider, (ILabelProvider)qualifierLabelProvider);
        dialog.setElements((Object[])this.getBinaryFiles(this.getCProject()));
        dialog.setMessage(LaunchMessages.CMainTab_Choose_program_to_run);
        dialog.setTitle(LaunchMessages.CMainTab_Program_Selection);
        dialog.setUpperListLabel(LaunchMessages.Launch_common_BinariesColon);
        dialog.setLowerListLabel(LaunchMessages.Launch_common_QualifierColon);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            IBinary binary = (IBinary)dialog.getFirstResult();
            this.fCApplications.get(index).getfAppProgText().setText(binary.getResource().getProjectRelativePath().toString());
        }
    }

    private void updateAppSelection(ILaunchConfigurationWorkingCopy config) {
        if (this.AppNum > 1) {
            int i = 0;
            while (i < this.fCApplications.size()) {
                CApplication cApplication = this.fCApplications.get(i);
                DebugUtil.setAttribute(config, "com.gigadevice.debug.launch.debugIsActivated", String.valueOf(cApplication.isfIsActivated()), i);
                DebugUtil.setAttribute(config, "com.gigadevice.debug.launch.coreIndex", cApplication.getfActivationButton().getText(), i);
                ++i;
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        ICProject cProject = this.getCProject();
        if (cProject != null && cProject.exists()) {
            config.setMappedResources(new IResource[]{cProject.getProject()});
        } else {
            config.setMappedResources(null);
        }
        boolean hasSetDefault = false;
        int i = 0;
        while (i < this.AppNum) {
            try {
                String debugIsActivatedStr = DebugUtil.getAttribute((ILaunchConfiguration)config, "com.gigadevice.debug.launch.debugIsActivated", i);
                if (i == 0) {
                    if (this.AppNum == 1) {
                        config.setAttribute("com.gigadevice.debug.launch.serverstart", true);
                    } else if (this.AppNum > 1) {
                        if (debugIsActivatedStr.equals("true") || debugIsActivatedStr.equals("1")) {
                            config.setAttribute("com.gigadevice.debug.launch.serverstart", true);
                            hasSetDefault = true;
                        } else {
                            config.setAttribute("com.gigadevice.debug.launch.serverstart", false);
                        }
                    }
                    config.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fCApplications.get(i).getfAppProgText().getText());
                } else {
                    if (hasSetDefault) {
                        ToolUtil.setAttribute(config, "com.gigadevice.debug.launch.serverstart", false, i);
                    } else if (debugIsActivatedStr.equals("true") || debugIsActivatedStr.equals("1")) {
                        ToolUtil.setAttribute(config, "com.gigadevice.debug.launch.serverstart", true, i);
                        hasSetDefault = true;
                    } else {
                        ToolUtil.setAttribute(config, "com.gigadevice.debug.launch.serverstart", false, i);
                    }
                    ToolUtil.setAttribute(config, "org.eclipse.cdt.launch.PROGRAM_NAME", this.fCApplications.get(i).getfAppProgText().getText(), i);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.updateAppSelection(config);
        this.updateCmdParaPort((ILaunchConfiguration)config);
        config.setAttribute("com.gigadevice.debug.launch.corecount", this.AppNum);
        config.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        if (this.fCoreText != null) {
            config.setAttribute("org.eclipse.cdt.launch.COREFILE_PATH", this.fCoreText.getText());
            config.setAttribute("org.eclipse.cdt.dsf.gdb.POST_MORTEM_TYPE", this.getSelectedCoreType());
        }
    }
}

