/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.adapter.TargetAdapter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.Workbench;

public class EraseAction
extends Action {
    public void run() {
        final IProject proj = EraseAction.getCurrentProject();
        if (proj == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)"Please select your target project.");
            return;
        }
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("erasing......", -1);
                TargetAdapter.eraseChip((IProject)proj);
                monitor.done();
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static IProject getCurrentProject() {
        ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        IProject project = null;
        Object element = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        return project;
    }
}

