/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.adapter.gdlink.GDLinkOperation;
import com.gigadevice.adapter.jlink.JLinkOperation;
import com.gigadevice.debug.AbstractDebugServer;
import com.gigadevice.debug.Activator;
import com.gigadevice.debug.GdbServerFactory;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.utils.constants.DebugConstants;
import com.gigadevice.venustool.TargetOSInfo;
import com.gigadevice.venustool.xmlparse.CPNChangeXmlParse;
import java.io.File;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DebugTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration fConfiguration;
    private Text fGdbServerPort;
    protected int CoreNum = 0;
    private Text fGdbServerExeLoc;
    private Button fGdbServerBrowseButton;
    private Group settings_group;
    private StackLayout settings_layout;
    private Text fServerIpAddress;
    private Combo fDbgCombo;
    private Button fIDEBrowseButton;
    private Text fIDEText;
    private Button fInterfaceSwd;
    private Button fInterfaceJtag;
    private Button fCodeinRAM;
    private Text fDevice;
    private Combo fGDLinkDebuggerServerCombo;
    private Button fConnectUnderResetButton;
    private TargetAdapter.MbsType mbsType;
    private String McuNo;
    private String coreType;
    private Button btnEnableLiveExpress;
    private static final String riscvInitCommands = "set mem inaccessible-by-default off" + System.lineSeparator() + "set arch riscv:rv32" + System.lineSeparator() + "set remotetimeout 250";
    private static final String armInitCommands = "set mem inaccessible-by-default off";
    private Text sramDownloadAddress;

    protected DebugTab() {
    }

    public String getName() {
        return "Debugger";
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        Group group = new Group(comp, 0);
        GridLayout layout1 = new GridLayout();
        group.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Debugger");
        Composite comp1 = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp1.setLayout((Layout)layout2);
        GridData gd1 = new GridData(768);
        comp1.setLayoutData((Object)gd1);
        Label label = new Label(comp1, 0);
        label.setText("Debugger:");
        this.fDbgCombo = new Combo(comp1, 12);
        Iterator<String> iterator = GdbServerFactory.getServerMap().keySet().iterator();
        while (iterator.hasNext()) {
            this.fDbgCombo.add(iterator.next());
        }
        if (!iterator.toString().equals("")) {
            this.fDbgCombo.select(0);
        }
        Composite comp2 = new Composite((Composite)group, 0);
        GridLayout layout22 = new GridLayout();
        layout22.numColumns = 5;
        layout22.marginHeight = 0;
        comp2.setLayout((Layout)layout22);
        GridData gd12 = new GridData(768);
        comp2.setLayoutData((Object)gd12);
        Label label1 = new Label(comp2, 0);
        label1.setText("Core ID: ");
        Composite local = new Composite(comp2, 0);
        GridLayout layout23 = new GridLayout();
        layout23.numColumns = 3;
        layout23.marginHeight = 0;
        layout23.marginWidth = 0;
        local.setLayout((Layout)layout23);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = ((GridLayout)comp2.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd2);
        this.fIDEText = new Text(local, 2052);
        gd2 = new GridData();
        gd2.widthHint = 120;
        this.fIDEText.setLayoutData((Object)gd2);
        this.fIDEBrowseButton = new Button(local, 0);
        this.fIDEBrowseButton.setText("Scan");
        this.fIDEBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String CoreIDStr = DebugTab.this.getCoreID();
                if (CoreIDStr != null && CoreIDStr != "") {
                    DebugTab.this.fIDEText.setText(CoreIDStr);
                } else {
                    DebugTab.this.fIDEText.setText("");
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Error ", (String)"Fail to read core ID.");
                }
            }
        });
        this.createGdbServerGroup(comp);
        this.createOtherSettingsControl(comp);
        this.createConnectOptionGroup(comp);
    }

    private void showSubView() {
        this.fDbgCombo.getText();
        this.settings_layout.topControl = GdbServerFactory.getServer(this.fDbgCombo.getText()).getControl();
        this.settings_group.layout();
    }

    private void createConnectOptionGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Connect Configuration");
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 1;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        this.fConnectUnderResetButton = new Button(comp, 32);
        this.fConnectUnderResetButton.setText("Connect Under Reset");
        gd = new GridData();
        gd.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns;
        gd.widthHint = 300;
        this.fConnectUnderResetButton.setLayoutData((Object)gd);
        this.fConnectUnderResetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.scheduleUpdateJob();
                GDLinkOperation.setConnectUnderReset((boolean)DebugTab.this.fConnectUnderResetButton.getSelection());
            }
        });
    }

    private void createGdbServerGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("GDB Server Setup");
        Composite comp = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp.setLayoutData((Object)gd2);
        Label label = new Label(comp, 0);
        label.setText("IP Address:");
        this.fServerIpAddress = new Text(comp, 2052);
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fServerIpAddress.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText("Port:");
        this.fGdbServerPort = new Text(comp, 2052);
        gd2 = new GridData();
        gd2.widthHint = 60;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGdbServerPort.setLayoutData((Object)gd2);
        label = new Label(comp, 0);
        label.setText("Device:");
        Composite local = new Composite(comp, 0);
        GridLayout layout3 = new GridLayout();
        layout3.numColumns = 2;
        layout3.marginHeight = 0;
        local.setLayout((Layout)layout3);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fDevice = new Text(local, 2052);
        gd3 = new GridData();
        gd3.widthHint = 120;
        this.fDevice.setLayoutData((Object)gd3);
        this.fCodeinRAM = new Button(local, 32);
        this.fCodeinRAM.setText("Code in RAM");
        gd3 = new GridData();
        gd3.horizontalIndent = 20;
        gd3.widthHint = 120;
        this.fCodeinRAM.setLayoutData((Object)gd3);
        label = new Label(comp, 0);
        label.setText("Interface:");
        local = new Composite(comp, 0);
        layout3 = new GridLayout();
        layout3.numColumns = 2;
        layout3.marginHeight = 0;
        local.setLayout((Layout)layout3);
        gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fInterfaceSwd = new Button(local, 16);
        this.fInterfaceSwd.setText("SWD");
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fInterfaceSwd.setLayoutData((Object)gd3);
        this.fInterfaceJtag = new Button(local, 16);
        this.fInterfaceJtag.setText("JTAG");
        gd3 = new GridData();
        gd3.widthHint = 60;
        this.fInterfaceJtag.setLayoutData((Object)gd3);
        label = new Label(comp, 0);
        label.setText("GDB Server:");
        this.fGDLinkDebuggerServerCombo = new Combo(comp, 12);
        gd2 = new GridData();
        gd2.widthHint = 120;
        gd2.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        this.fGDLinkDebuggerServerCombo.setLayoutData((Object)gd2);
        this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
        this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
        label = new Label(comp, 0);
        label.setText("Exe Location:");
        local = new Composite(comp, 0);
        layout3 = new GridLayout();
        layout3.numColumns = 3;
        layout3.marginHeight = 0;
        layout3.marginWidth = 0;
        local.setLayout((Layout)layout3);
        gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fGdbServerExeLoc = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fGdbServerExeLoc.setLayoutData((Object)gd3);
        this.fGdbServerBrowseButton = new Button(local, 0);
        this.fGdbServerBrowseButton.setText("Browse");
        this.fDbgCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.doDebuggerChanged(DebugTab.this.fDbgCombo.getText());
                DebugTab.this.scheduleUpdateJob();
                String CoreIDStr = DebugTab.this.getCoreID();
                if (CoreIDStr != null) {
                    DebugTab.this.fIDEText.setText(CoreIDStr);
                } else {
                    DebugTab.this.fIDEText.setText("");
                }
            }
        });
        this.fGDLinkDebuggerServerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.doGDLinkDebuggerServerChanged(DebugTab.this.fGDLinkDebuggerServerCombo.getText());
                DebugTab.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerExeLoc.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugTab.this.scheduleUpdateJob();
            }
        });
        this.fCodeinRAM.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.scheduleUpdateJob();
            }
        });
        this.fGdbServerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.browseButtonSelected("Select GDB Server", DebugTab.this.fGdbServerExeLoc);
            }
        });
        this.fDevice.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugTab.this.McuNo = DebugTab.this.fDevice.getText();
                DebugTab.this.scheduleUpdateJob();
                GdbServerFactory.getServer(DebugTab.this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)DebugTab.this.fConfiguration, DebugTab.this.fGDLinkDebuggerServerCombo.getText(), DebugTab.this.getInterfaceStr(), DebugTab.this.fDevice.getText());
                DebugTab.this.fDbgCombo.getText().equalsIgnoreCase(DebugConstants.debuggerEnum.JLink.toString());
            }
        });
        this.fInterfaceSwd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.scheduleUpdateJob();
                String CoreIDStr = DebugTab.this.getCoreID();
                if (CoreIDStr != null) {
                    DebugTab.this.fIDEText.setText(CoreIDStr);
                } else {
                    DebugTab.this.fIDEText.setText("");
                }
                GdbServerFactory.getServer(DebugTab.this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)DebugTab.this.fConfiguration, DebugTab.this.fGDLinkDebuggerServerCombo.getText(), "swd", DebugTab.this.fDevice.getText());
            }
        });
        this.fInterfaceJtag.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.scheduleUpdateJob();
                String CoreIDStr = DebugTab.this.getCoreID();
                if (CoreIDStr != null) {
                    DebugTab.this.fIDEText.setText(CoreIDStr);
                } else {
                    DebugTab.this.fIDEText.setText("");
                }
                GdbServerFactory.getServer(DebugTab.this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)DebugTab.this.fConfiguration, DebugTab.this.fGDLinkDebuggerServerCombo.getText(), "jtag", DebugTab.this.fDevice.getText());
            }
        });
    }

    private String getInterfaceStr() {
        String Interface = "";
        Interface = this.fInterfaceSwd.getSelection() ? "swd" : "jtag";
        return Interface;
    }

    private void createOtherSettingsControl(Composite parent) {
        this.settings_group = new Group(parent, 0);
        this.settings_layout = new StackLayout();
        this.settings_group.setLayout((Layout)this.settings_layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.settings_group);
        this.settings_group.setText("GDB Server other options");
        this.settings_group.setBackgroundMode(1);
        for (AbstractDebugServer serv : GdbServerFactory.getServerMap().values()) {
            serv.createControl((Composite)this.settings_group, this);
        }
        this.createOtherControl(parent);
        this.createDownloadConfigGroup(parent);
    }

    private void createOtherControl(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout1 = new GridLayout();
        group.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Other Config:");
        Composite comp1 = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp1.setLayout((Layout)layout2);
        GridData gd1 = new GridData(768);
        comp1.setLayoutData((Object)gd1);
        this.btnEnableLiveExpress = new Button(comp1, 32);
        this.btnEnableLiveExpress.setText("Non-stop mode (Note: Enable LiveExpression)");
        this.btnEnableLiveExpress.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebugTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createDownloadConfigGroup(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout1 = new GridLayout();
        group.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("Download Config:");
        Composite comp1 = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp1.setLayout((Layout)layout2);
        GridData gd1 = new GridData(768);
        comp1.setLayoutData((Object)gd1);
        Label label = new Label(comp1, 0);
        label.setText("Sram Code Download Address:");
        this.sramDownloadAddress = new Text(comp1, 2052);
        this.sramDownloadAddress.setText("0x20000000");
    }

    private void doDebuggerChanged(String text) {
        String debuggerName = "";
        try {
            debuggerName = this.fConfiguration.getAttribute("com.gigadevice.debug.launch.jtagDevice", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (debuggerName.equalsIgnoreCase(text)) {
            return;
        }
        if (text.equalsIgnoreCase(DebugConstants.debuggerEnum.GDLink.toString())) {
            this.fGDLinkDebuggerServerCombo.setEnabled(true);
            String GDLinkDebuggerServer = "";
            try {
                GDLinkDebuggerServer = this.fConfiguration.getAttribute("com.gigadevice.debug.gdlink.server", "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            int length = this.fGDLinkDebuggerServerCombo.getItems().length;
            int i = 0;
            while (i < length) {
                this.fGDLinkDebuggerServerCombo.remove(0);
                ++i;
            }
            length = this.fGDLinkDebuggerServerCombo.getItems().length;
            this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
            this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
            if (!GDLinkDebuggerServer.equals("") && GDLinkDebuggerServer.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString())) {
                GDLinkDebuggerServer = DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString();
            }
            i = 0;
            while (i < this.fGDLinkDebuggerServerCombo.getItemCount()) {
                if (this.fGDLinkDebuggerServerCombo.getItem(i).equals(GDLinkDebuggerServer)) {
                    this.fGDLinkDebuggerServerCombo.select(i);
                    this.showSubView();
                    this.doGDLinkDebuggerServerChanged(GDLinkDebuggerServer);
                }
                ++i;
            }
        } else {
            int length = this.fGDLinkDebuggerServerCombo.getItems().length;
            int i = 0;
            while (i < length) {
                this.fGDLinkDebuggerServerCombo.remove(0);
                ++i;
            }
            length = this.fGDLinkDebuggerServerCombo.getItems().length;
            this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString());
            this.fGDLinkDebuggerServerCombo.select(0);
            this.fGDLinkDebuggerServerCombo.setEnabled(false);
            this.doJLinkDebuggerServerChanged(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString());
        }
        this.showSubView();
        String DebuggerServerText = this.fGDLinkDebuggerServerCombo.getText();
        try {
            ILaunchConfigurationWorkingCopy copy = this.fConfiguration.getWorkingCopy();
            String ServerArgs = "";
            try {
                ServerArgs = "-device " + this.McuNo + " -speed 500 -if " + copy.getAttribute("com.gigadevice.debug.launch.interface", "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (this.mbsType == TargetAdapter.MbsType.RISCV) {
                this.fInterfaceSwd.setEnabled(false);
                this.fInterfaceSwd.setSelection(false);
                this.fInterfaceJtag.setSelection(true);
                ServerArgs = "-device " + this.McuNo + " -speed 500 -if jtag";
            } else {
                this.fInterfaceSwd.setEnabled(true);
                this.fInterfaceSwd.setSelection(true);
                this.fInterfaceJtag.setSelection(false);
                ServerArgs = "-device " + this.McuNo + " -speed 500 -if swd";
            }
            GdbServerFactory.getServer(this.fDbgCombo.getText()).setDefaults(copy, this.mbsType, DebuggerServerText, ServerArgs);
            GdbServerFactory.getServer(this.fDbgCombo.getText()).initializeFrom((ILaunchConfiguration)copy, this.mbsType, DebuggerServerText, ServerArgs);
            copy.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.showSubView();
        this.fGdbServerPort.setText(GdbServerFactory.getServer(this.fDbgCombo.getText()).getDefaultPortNumber());
        String ServerPath = "";
        if (text.contains(DebugConstants.debuggerEnum.JLink.toString())) {
            try {
                ServerPath = this.fConfiguration.getAttribute("com.gigadevice.debug.jlink.location", "");
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            try {
                ServerPath = this.fConfiguration.getAttribute("com.gigadevice.debug.openocd.location", "");
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (ServerPath.equalsIgnoreCase("") || DebuggerServerText.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            ServerPath = GdbServerFactory.getServer(this.fDbgCombo.getText()).getServerLocation(this.mbsType, this.McuNo, "", "");
        }
        if (ServerPath.contains(this.fGDLinkDebuggerServerCombo.getText())) {
            this.fGdbServerExeLoc.setText(ServerPath);
        }
    }

    private void doGDLinkDebuggerServerChanged(String text) {
        String ServerPath = "";
        try {
            ServerPath = this.fConfiguration.getAttribute("com.gigadevice.debug.openocd.location", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String debuggerServerText = this.fGDLinkDebuggerServerCombo.getText();
        if (ServerPath.equalsIgnoreCase("") || !ServerPath.toLowerCase().contains(text.toLowerCase()) || debuggerServerText.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            ServerPath = GdbServerFactory.getServer(this.fDbgCombo.getText()).getServerLocation(this.mbsType, this.McuNo, debuggerServerText, "");
        }
        boolean liveExpressEnable = false;
        if (text.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
            this.fGdbServerPort.setText("5099");
            String temp = "";
            if (this.fInterfaceSwd.getSelection()) {
                temp = "swd";
            } else if (this.fInterfaceJtag.getSelection()) {
                temp = "jtag";
            }
            GdbServerFactory.getServer(this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)this.fConfiguration, text, temp, this.fDevice.getText());
            liveExpressEnable = true;
            this.fConnectUnderResetButton.setEnabled(true);
        } else {
            this.fGdbServerPort.setText("3333");
            GdbServerFactory.getServer(this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)this.fConfiguration, text, "", this.fDevice.getText());
            this.fConnectUnderResetButton.setEnabled(false);
            this.fConnectUnderResetButton.setSelection(false);
        }
        if (!liveExpressEnable || !System.getProperty("os.name").toLowerCase().contains("win")) {
            this.btnEnableLiveExpress.setSelection(false);
            this.btnEnableLiveExpress.setEnabled(false);
        } else {
            this.btnEnableLiveExpress.setEnabled(true);
        }
        this.fGdbServerExeLoc.setText(ServerPath);
        TargetAdapter.setServerPath((String)ServerPath);
    }

    private void doJLinkDebuggerServerChanged(String text) {
        String ServerPath = "";
        try {
            ServerPath = this.fConfiguration.getAttribute("com.gigadevice.debug.openocd.location", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (ServerPath.equalsIgnoreCase("") || !ServerPath.toLowerCase().contains(text.toLowerCase())) {
            ServerPath = GdbServerFactory.getServer(this.fDbgCombo.getText()).getServerLocation(this.mbsType, this.McuNo, this.fGDLinkDebuggerServerCombo.getText(), "");
        }
        if (text.equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString())) {
            this.getJlinkServerStartupArgs();
            String temp = "";
            if (this.fInterfaceSwd.getSelection()) {
                temp = "swd";
            } else if (this.fInterfaceJtag.getSelection()) {
                temp = "jtag";
            }
            GdbServerFactory.getServer(this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)this.fConfiguration, text, temp, this.fDevice.getText());
        }
        this.fGdbServerExeLoc.setText(ServerPath);
        TargetAdapter.setServerPath((String)ServerPath);
        this.btnEnableLiveExpress.setSelection(false);
        this.btnEnableLiveExpress.setEnabled(false);
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        str = dialog.open();
        String debugger = "";
        try {
            debugger = this.fConfiguration.getAttribute("com.gigadevice.debug.launch.jtagDevice", "");
            if (debugger.contains(DebugConstants.debuggerEnum.JLink.toString())) {
                if (!JLinkOperation.checkJlinkGDBServerFile((String)str).booleanValue()) {
                    MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Error ", (String)"Please select the JLinkGDBServerCL.exe file.");
                    return;
                }
                TargetAdapter.setServerPath((String)str);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        String tmp = null;
        if (str != null) {
            tmp = str.replace("/", File.separator);
        }
        if (str != null) {
            text.setText(tmp);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fConfiguration = configuration;
        if (DebugUtil.getCurProject((ILaunchConfiguration)configuration) == null) {
            return;
        }
        configuration.setAttribute("com.gigadevice.debug.launch.useRemoteTarget", true);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", false);
        AbstractDebugServer curServer = GdbServerFactory.getServer(DebugConstants.debuggerEnum.GDLink.toString());
        this.updateMcuNoandToolchainPath(configuration);
        if (this.mbsType == TargetAdapter.MbsType.RISCV) {
            configuration.setAttribute("com.gigadevice.debug.launch.initCommands", riscvInitCommands);
            configuration.setAttribute("com.gigadevice.debug.launch.interface", DebugConstants.interfaceEnum.jtag.toString());
        } else {
            configuration.setAttribute("com.gigadevice.debug.launch.initCommands", armInitCommands);
            configuration.setAttribute("com.gigadevice.debug.launch.interface", DebugConstants.interfaceEnum.swd.toString());
        }
        configuration.setAttribute("com.gigadevice.debug.launch.codeinRAM", "false");
        configuration.setAttribute("com.gigadevice.debug.launch.sramCodeAddress", "");
        configuration.setAttribute("com.gigadevice.debug.launch.jtagDevice", DebugConstants.debuggerEnum.GDLink.toString());
        configuration.setAttribute("com.gigadevice.debug.gdlink.server", DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
        configuration.setAttribute("com.gigadevice.debug.launch.ipAddress", curServer.getDefaultIpAddress());
        try {
            configuration.getAttribute("com.gigadevice.debug.launch.corecount", 1);
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
        String ServerArgs = "";
        try {
            ServerArgs = "-device " + this.McuNo + " -speed 500 -if " + configuration.getAttribute("com.gigadevice.debug.launch.interface", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        curServer.setDefaults(configuration, this.mbsType, "com.gigadevice.debug.gdlink.server", ServerArgs);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String temp;
        this.fConfiguration = configuration;
        if (DebugUtil.getCurProject(configuration) == null) {
            return;
        }
        try {
            String DebuggerServerText;
            String debugger = configuration.getAttribute("com.gigadevice.debug.launch.jtagDevice", "");
            int i = 0;
            while (i < this.fDbgCombo.getItemCount()) {
                if (this.fDbgCombo.getItem(i).equals(debugger)) {
                    this.fDbgCombo.select(i);
                    this.showSubView();
                }
                ++i;
            }
            this.fServerIpAddress.setText(GdbServerFactory.getServer(this.fDbgCombo.getText()).getDefaultIpAddress());
            this.fGdbServerPort.setText(GdbServerFactory.getServer(this.fDbgCombo.getText()).getDefaultPortNumber());
            String interfaceAttr = configuration.getAttribute("com.gigadevice.debug.launch.interface", "");
            if (interfaceAttr.equalsIgnoreCase(DebugConstants.interfaceEnum.swd.toString())) {
                this.fInterfaceSwd.setSelection(true);
            } else if (interfaceAttr.equalsIgnoreCase(DebugConstants.interfaceEnum.jtag.toString())) {
                this.fInterfaceJtag.setSelection(true);
            } else {
                this.fInterfaceSwd.setSelection(true);
            }
            this.fCodeinRAM.setSelection(DebugUtil.getCodeinRAMBooleanValue(configuration));
            temp = configuration.getAttribute("com.gigadevice.debug.launch.device", "");
            if (temp.equalsIgnoreCase("")) {
                IProject project = DebugUtil.getCurProject(configuration);
                this.mbsType = AdapterUtils.getToolChainType((IProject)project);
                this.McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
                if (this.McuNo == null) {
                    this.McuNo = "";
                }
            } else {
                this.McuNo = temp = CPNChangeXmlParse.getNewCPN((String)temp, (boolean)false);
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("com.gigadevice.debug.launch.device", this.McuNo);
            }
            this.fDevice.setText(this.McuNo);
            String sramCodeAddress = configuration.getAttribute("com.gigadevice.debug.launch.sramCodeAddress", "");
            if (this.McuNo.contains("GD32H7")) {
                if (sramCodeAddress.equals("")) {
                    sramCodeAddress = "0x24000000";
                }
            } else {
                if (sramCodeAddress.equals("")) {
                    sramCodeAddress = "0x20000000";
                }
                this.sramDownloadAddress.setEnabled(false);
            }
            this.sramDownloadAddress.setText(sramCodeAddress);
            GDLinkOperation.setMCUPartNo((String)this.McuNo);
            String ServerArgs = "";
            try {
                ServerArgs = "-device " + this.fDevice.getText() + " -speed 2000 -if " + configuration.getAttribute("com.gigadevice.debug.launch.interface", "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (this.mbsType == TargetAdapter.MbsType.RISCV) {
                this.fInterfaceSwd.setEnabled(false);
                this.fInterfaceSwd.setSelection(false);
                this.fInterfaceJtag.setSelection(true);
                ServerArgs = "-device " + this.fDevice.getText() + " -speed 2000 -if jtag";
            } else {
                this.fInterfaceSwd.setEnabled(true);
            }
            GdbServerFactory.getServer(this.fDbgCombo.getText()).initializeFrom(configuration, this.mbsType, this.fGDLinkDebuggerServerCombo.getText(), ServerArgs);
            if (debugger.equalsIgnoreCase(DebugConstants.debuggerEnum.GDLink.toString())) {
                this.fGDLinkDebuggerServerCombo.setEnabled(true);
                String GDLinkDebuggerServer = configuration.getAttribute("com.gigadevice.debug.gdlink.server", "");
                int length = this.fGDLinkDebuggerServerCombo.getItems().length;
                int i2 = 0;
                while (i2 < length) {
                    this.fGDLinkDebuggerServerCombo.remove(0);
                    ++i2;
                }
                length = this.fGDLinkDebuggerServerCombo.getItems().length;
                this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString());
                this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.Openocd.toString());
                i2 = 0;
                while (i2 < this.fGDLinkDebuggerServerCombo.getItemCount()) {
                    if (this.fGDLinkDebuggerServerCombo.getItem(i2).equals(GDLinkDebuggerServer)) {
                        this.fGDLinkDebuggerServerCombo.select(i2);
                        this.showSubView();
                        this.doGDLinkDebuggerServerChanged(GDLinkDebuggerServer);
                    } else {
                        this.fGDLinkDebuggerServerCombo.select(0);
                        this.showSubView();
                        this.doGDLinkDebuggerServerChanged(this.fGDLinkDebuggerServerCombo.getText());
                    }
                    ++i2;
                }
            } else {
                int length = this.fGDLinkDebuggerServerCombo.getItems().length;
                int i3 = 0;
                while (i3 < length) {
                    this.fGDLinkDebuggerServerCombo.remove(0);
                    ++i3;
                }
                length = this.fGDLinkDebuggerServerCombo.getItems().length;
                this.fGDLinkDebuggerServerCombo.add(DebugConstants.GDLinkDebuggerServerEnum.JGDBServer.toString());
                this.fGDLinkDebuggerServerCombo.select(0);
                this.fGDLinkDebuggerServerCombo.setEnabled(false);
                this.btnEnableLiveExpress.setSelection(false);
                this.btnEnableLiveExpress.setEnabled(false);
            }
            if (this.fGdbServerExeLoc.getText().equalsIgnoreCase("")) {
                String ServerPath = "";
                if (debugger.contains(DebugConstants.debuggerEnum.JLink.toString())) {
                    ServerPath = configuration.getAttribute("com.gigadevice.debug.jlink.location", GdbServerFactory.getServer(this.fDbgCombo.getText()).getServerLocation(this.mbsType, this.McuNo, "", this.fConfiguration.getAttribute("com.gigadevice.debug.jlink.location", "")));
                    TargetAdapter.setServerPath((String)ServerPath);
                } else {
                    ServerPath = configuration.getAttribute("com.gigadevice.debug.openocd.location", GdbServerFactory.getServer(this.fDbgCombo.getText()).getServerLocation(this.mbsType, this.McuNo, "", this.fConfiguration.getAttribute("com.gigadevice.debug.openocd.location", "")));
                }
                this.fGdbServerExeLoc.setText(ServerPath);
            }
            if ((DebuggerServerText = this.fGDLinkDebuggerServerCombo.getText()).equalsIgnoreCase(DebugConstants.GDLinkDebuggerServerEnum.GDLinkGDBServer.toString())) {
                String GDLinkServerPath = DebugUtil.getGDLinkGDBServerEXELoc();
                this.fGdbServerExeLoc.setText(GDLinkServerPath);
                ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("com.gigadevice.debug.openocd.location", this.fGdbServerExeLoc.getText());
            }
            this.fConnectUnderResetButton.setSelection(configuration.getAttribute("com.gigadevice.debug.connectUnderReset", false));
            GDLinkOperation.setConnectUnderReset((boolean)this.fConnectUnderResetButton.getSelection());
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
        String CoreIDStr = this.getCoreID();
        if (CoreIDStr != null) {
            this.fIDEText.setText(CoreIDStr);
        } else {
            this.fIDEText.setText("");
        }
        boolean enableNonStop = true;
        try {
            enableNonStop = configuration.getAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", false);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.btnEnableLiveExpress.setSelection(enableNonStop);
        temp = "";
        if (this.fInterfaceSwd.getSelection()) {
            temp = "swd";
        } else if (this.fInterfaceJtag.getSelection()) {
            temp = "jtag";
        }
        GdbServerFactory.getServer(this.fDbgCombo.getText()).UpdateGroup((ILaunchConfigurationWorkingCopy)this.fConfiguration, this.fGDLinkDebuggerServerCombo.getText(), temp, this.fDevice.getText());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (DebugUtil.getCurProject((ILaunchConfiguration)configuration) == null) {
            return;
        }
        GDLinkOperation.setMCUPartNo((String)this.fDevice.getText());
        String dbgDevice = this.fDbgCombo.getText();
        configuration.setAttribute("com.gigadevice.debug.launch.jtagDevice", dbgDevice);
        configuration.setAttribute("com.gigadevice.debug.launch.ipAddress", this.fServerIpAddress.getText().trim());
        configuration.setAttribute("com.gigadevice.debug.gdlink.server", this.fGDLinkDebuggerServerCombo.getText());
        try {
            configuration.setAttribute("com.gigadevice.debug.launch.portNumber", Integer.parseInt(this.fGdbServerPort.getText().trim()));
        }
        catch (NumberFormatException numberFormatException) {
            configuration.setAttribute("com.gigadevice.debug.launch.portNumber", 0);
        }
        if (dbgDevice.equals(DebugConstants.debuggerEnum.GDLink.toString())) {
            configuration.setAttribute("com.gigadevice.debug.openocd.location", this.fGdbServerExeLoc.getText());
        } else {
            configuration.setAttribute("com.gigadevice.debug.jlink.location", this.fGdbServerExeLoc.getText());
        }
        this.updateMcuNoandToolchainPath(configuration);
        configuration.setAttribute("com.gigadevice.debug.launch.device", this.fDevice.getText().trim());
        if (dbgDevice.equals(DebugConstants.debuggerEnum.JLink.toString())) {
            String serverParam = this.getJlinkServerStartupArgs();
            configuration.setAttribute("com.gigadevice.debug.launch.serverParam", serverParam);
        }
        String interfaceStr = "";
        if (this.fInterfaceSwd.getSelection()) {
            interfaceStr = DebugConstants.interfaceEnum.swd.toString();
        } else if (this.fInterfaceJtag.getSelection()) {
            interfaceStr = DebugConstants.interfaceEnum.jtag.toString();
        }
        configuration.setAttribute("com.gigadevice.debug.launch.interface", interfaceStr);
        String codeinRAMStr = "";
        if (this.fCodeinRAM.getSelection()) {
            codeinRAMStr = "true";
        } else if (!this.fCodeinRAM.getSelection()) {
            codeinRAMStr = "false";
        }
        configuration.setAttribute("com.gigadevice.debug.launch.codeinRAM", codeinRAMStr);
        String sramCodeAddress = this.sramDownloadAddress.getText();
        configuration.setAttribute("com.gigadevice.debug.launch.sramCodeAddress", sramCodeAddress);
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_APPEND_TO_FILE", true);
        IProject project = DebugUtil.getCurProject((ILaunchConfiguration)configuration);
        String file = String.valueOf(project.getLocation().makeAbsolute().toFile().getAbsolutePath()) + DebugConstants.Debug_Log_FileName;
        configuration.setAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", file);
        configuration.setAttribute("org.eclipse.cdt.dsf.gdb.NON_STOP", this.btnEnableLiveExpress.getSelection());
        configuration.setAttribute("com.gigadevice.debug.connectUnderReset", this.fConnectUnderResetButton.getSelection());
        GDLinkOperation.setConnectUnderReset((boolean)this.fConnectUnderResetButton.getSelection());
        GdbServerFactory.getServer(this.fDbgCombo.getText()).performApply(configuration, this.mbsType);
    }

    private void updatePortNumber(int CoreCount, ILaunchConfigurationWorkingCopy configuration) {
        int debugCount = 0;
        int i = 0;
        while (i < CoreCount) {
            String debugIsActivatedStr = DebugUtil.getAttribute(this.fConfiguration, "com.gigadevice.debug.launch.debugIsActivated", i);
            if (debugIsActivatedStr.equals("true") || debugIsActivatedStr.equals("")) {
                DebugUtil.setAttribute(configuration, "com.gigadevice.debug.launch.portNumber", Integer.parseInt(this.fGdbServerPort.getText().trim()) + debugCount, i);
                ++debugCount;
            } else {
                DebugUtil.setAttribute(configuration, "com.gigadevice.debug.launch.portNumber", 0, i);
            }
            ++i;
        }
    }

    public void subPageChanged() {
        this.updateLaunchConfigurationDialog();
    }

    public void updateMcuNoandToolchainPath(ILaunchConfigurationWorkingCopy conf) {
        IProject project = DebugUtil.getCurProject((ILaunchConfiguration)conf);
        if (project == null) {
            return;
        }
        this.mbsType = AdapterUtils.getToolChainType((IProject)project);
        String toolchainPath = "";
        String toolchainPrefix = "";
        if (project != null) {
            String temp = "";
            try {
                temp = conf.getAttribute("com.gigadevice.debug.launch.device", "");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (temp.equalsIgnoreCase("")) {
                this.McuNo = AdapterUtils.getTargetMcuPartNo((IProject)project);
                if (this.McuNo == null) {
                    this.McuNo = "";
                }
            } else {
                this.McuNo = temp = CPNChangeXmlParse.getNewCPN((String)temp, (boolean)false);
                conf.setAttribute("com.gigadevice.debug.launch.device", this.McuNo);
            }
            toolchainPath = AdapterUtils.getToolChainPath((IProject)project);
            this.coreType = AdapterUtils.getTargetMcuCoreType((IProject)project);
            toolchainPrefix = AdapterUtils.getToolChainPrefix((IProject)project);
        }
        if (toolchainPath == null) {
            toolchainPath = "";
        }
        if (this.mbsType == TargetAdapter.MbsType.RISCV) {
            if (TargetOSInfo.isWindows()) {
                conf.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(toolchainPath) + File.separator + toolchainPrefix + "gdb.exe");
            } else if (TargetOSInfo.isLinux()) {
                conf.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(toolchainPath) + File.separator + toolchainPrefix + "gdb");
            }
        } else if (TargetOSInfo.isWindows()) {
            conf.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(toolchainPath) + File.separator + toolchainPrefix + "gdb.exe");
        } else if (TargetOSInfo.isLinux()) {
            conf.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", String.valueOf(toolchainPath) + File.separator + toolchainPrefix + "gdb");
        }
    }

    public String getCoreID() {
        String RetStr = null;
        IProject project = null;
        try {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""));
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        String gdbSel = this.fDbgCombo.getText();
        String gdbnterface = "";
        gdbnterface = this.fInterfaceSwd.getSelection() ? DebugConstants.interfaceEnum.swd.toString() : DebugConstants.interfaceEnum.jtag.toString();
        RetStr = TargetAdapter.readMcuID((IProject)project, (String)gdbSel, (String)gdbnterface);
        return RetStr;
    }

    public String getJlinkServerStartupArgs() {
        String srvArgs = "";
        srvArgs = String.valueOf(srvArgs) + "-port 2331";
        srvArgs = String.valueOf(srvArgs) + " -s";
        if (this.mbsType == TargetAdapter.MbsType.ARM) {
            if (this.coreType.indexOf("ARMFamily") > -1) {
                this.coreType = this.coreType.substring(this.coreType.indexOf("ARMFamily") + 10, this.coreType.length());
            }
            if (this.coreType.equalsIgnoreCase("cortex-m0")) {
                this.coreType = "cortex-m23";
            }
            srvArgs = String.valueOf(srvArgs) + " -device " + JLinkOperation.getJlinkMCUPart((String)this.McuNo);
        } else {
            srvArgs = String.valueOf(srvArgs) + " -device " + JLinkOperation.getJlinkMCUPart((String)this.McuNo);
        }
        srvArgs = String.valueOf(srvArgs) + " -endian little";
        srvArgs = String.valueOf(srvArgs) + " -speed 4000 -timeout 5000";
        if (this.fInterfaceSwd.getSelection()) {
            srvArgs = String.valueOf(srvArgs) + " -if " + DebugConstants.interfaceEnum.swd.toString();
        } else if (this.fInterfaceJtag.getSelection()) {
            srvArgs = String.valueOf(srvArgs) + " -if " + DebugConstants.interfaceEnum.jtag.toString();
        }
        return srvArgs;
    }
}

