/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.model.CContainer;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.ViewPart;

public class CompilationResultsView
extends ViewPart
implements ISelectionListener,
IResourceChangeListener {
    public static String ARMLinker = "GD ARM MCU Linker";
    public static String ARMCLinker = "GD ARM MCU C Linker";
    public static String ARMCLinkerScriptFileID = "com.gigadevice.mbs.arm.option.linker.general.scriptFile";
    public static String ARMCAddLinker = "GD ARM MCU C++ Linker";
    public static String ARMCAddLinkerScriptFileID = "com.gigadevice.mbs.arm.option.cpp.linker.general.scriptFile";
    public static String RISCVLinker = "GD RISC-V MCU Linker";
    public static String RISCVCLinker = "GD RISC-V MCU C Linker";
    public static String RISCVCLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.linker.general.scriptFile";
    public static String RISCVCAddLinker = "GD RISC-V MCU C++ Linker";
    public static String RISCVCAddLinkerScriptFileID = "com.gigadevice.mbs.riscv.option.cpp.linker.general.scriptFile";
    public Text textReminder;
    public Text textName;
    public Text temptext;
    public Table table;
    public IProject curPro = null;
    public String projectName = null;
    public boolean disposedFlag = false;
    public boolean selectionChangedFlag = false;
    public TabFolder tabFoleder;
    public Table tableDetails;
    public Tree tree;
    private TabItem tabItem;
    private LinkedHashMap<String, List<String>> sectionsMap = new LinkedHashMap();
    private LinkedHashMap<String, List<String>> tableInfoMap;
    private LinkedHashMap<String, List<List<String>>> treeNodeInfoMap;
    private LinkedHashMap<String, List<String>> treeNodeStateMap = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashMap<String, List<List<String>>>> symbolTableMap = new LinkedHashMap();

    public CompilationResultsView() {
        this.curPro = CompilationResultsView.getCurrentProject();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.sectionsMap.clear();
        this.treeNodeStateMap.clear();
        this.symbolTableMap.clear();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.textName = new Text(parent, 74);
        this.textName.setBounds(10, 10, 1099, 46);
        this.textName.setForeground(new Color(null, 0, 0, 0));
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.textName.setText("No compilation results are displayed at this time \nTips: 1.When opening the page for the first time, you need to select a project first.");
        this.table = new Table(parent, 0);
        GridData tableLayoutData = new GridData(4, 4, true, true, 2, 3);
        tableLayoutData.heightHint = 50;
        this.table.setLayoutData((Object)tableLayoutData);
        this.table.setBackground(new Color(null, 255, 255, 255));
        this.table.setVisible(false);
        String[] tableHeader = new String[]{"", "Start address", "End address", "Size", "Unoccupied", "Occupied", "Occupancy(%)"};
        int[] Headerlength = new int[]{120, 120, 120, 120, 120, 120, 120};
        int i = 0;
        while (i < tableHeader.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(tableHeader[i]);
            tableColumn.setWidth(Headerlength[i]);
            tableColumn.setMoveable(true);
            tableColumn.setAlignment(0x1000000);
            ++i;
        }
        this.temptext = new Text(parent, 8);
        this.temptext.setBounds(10, 10, 1099, 23);
        this.temptext.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.temptext.setVisible(false);
        this.tree = new Tree(parent, 0);
        GridData gd_tree = new GridData(16384, 4, false, true, 1, 1);
        gd_tree.widthHint = 167;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setVisible(false);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                String item = treeItem.getText();
                TreeItem parentTeeItem = treeItem.getParentItem();
                String parentItem = "";
                if (parentTeeItem != null) {
                    parentItem = parentTeeItem.getText();
                    ArrayList<String> tempList = new ArrayList<String>();
                    tempList.add(parentItem);
                    tempList.add(item);
                    CompilationResultsView.this.treeNodeStateMap.put(CompilationResultsView.this.projectName, tempList);
                }
                TreeItem[] selectedItemArr = CompilationResultsView.this.tree.getSelection();
                int i = 0;
                while (i < selectedItemArr.length) {
                    TreeItem selectedItem = selectedItemArr[i];
                    String selectedItemStr = selectedItem.getText();
                    if (item.equals(selectedItemStr)) {
                        CompilationResultsView.this.updateTableDetails(parentItem, item);
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tableDetails = new Table(parent, 2048);
        this.tableDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableDetails.setLinesVisible(true);
        this.tableDetails.setVisible(false);
        String[] HeadertableDetails = new String[]{"", "Run Address(VMA)", "Size"};
        int[] Headersize = new int[]{150, 150, 150};
        int i2 = 0;
        while (i2 < HeadertableDetails.length) {
            TableColumn tableColumn = new TableColumn(this.tableDetails, 0);
            tableColumn.setText(HeadertableDetails[i2]);
            tableColumn.setWidth(Headersize[i2]);
            tableColumn.setMoveable(true);
            tableColumn.setAlignment(0x1000000);
            ++i2;
        }
        this.tableDetails.addListener(8, new Listener(){

            public void handleEvent(Event event) {
            }
        });
        this.getSite().getPage().addSelectionListener((ISelectionListener)this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CompilationResultsView.this.disposedFlag = true;
            }
        });
        parent.setFocus();
    }

    public void setFocus() {
        this.table.setFocus();
        if (this.curPro == null) {
            return;
        }
        this.updateCompilerResults(this.curPro);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection == null) {
            return;
        }
        Object element = null;
        if (selection instanceof IStructuredSelection) {
            IResource container;
            element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IResource) {
                this.curPro = ((IResource)element).getProject();
                if (!this.disposedFlag) {
                    this.updateCompilerResults(this.curPro);
                }
            } else if (element instanceof CContainer) {
                IContainer container2 = ((CContainer)element).getResource();
                if (container2 instanceof IResource) {
                    IProject selectPro = container2.getProject();
                    if (this.curPro == null) {
                        this.updateCompilerResults(selectPro);
                        return;
                    }
                    if (!selectPro.getName().equals(this.curPro.getName())) {
                        this.updateCompilerResults(selectPro);
                        this.curPro = selectPro;
                    }
                }
            } else if (element instanceof TranslationUnit && (container = ((TranslationUnit)element).getResource()) instanceof IResource) {
                IProject selectPro = container.getProject();
                if (this.curPro == null) {
                    this.updateCompilerResults(selectPro);
                    return;
                }
                if (!selectPro.getName().equals(this.curPro.getName())) {
                    this.updateCompilerResults(selectPro);
                    this.curPro = selectPro;
                }
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        if (this.curPro == null) {
            return;
        }
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource instanceof IProject) {
                        final IProject project = (IProject)resource;
                        if (!CompilationResultsView.this.curPro.getName().equals(project.getName())) {
                            return false;
                        }
                        String lstfileString = CompilationResultsView.this.findLstFilePath(project, ".lst");
                        if (lstfileString != null) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CompilationResultsView.this.updateCompilerResults(project);
                                }
                            });
                        } else {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    CompilationResultsView.this.clearUI();
                                }
                            });
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IProject getCurrentProject() {
        IProject project = null;
        try {
            ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
            ISelection selection = selectionService.getSelection();
            Object element = null;
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
                project = ((IResource)element).getProject();
            }
            return project;
        }
        catch (Exception exception) {
            return project;
        }
    }

    public void clearUI() {
        if (this.textName.isDisposed() || this.table.isDisposed() || this.tree.isDisposed() || this.tableDetails.isDisposed()) {
            return;
        }
        this.textName.setText("No compilation results are displayed at this time,Please compile the project first.");
        this.textName.setForeground(new Color(null, 0, 0, 0));
        this.table.setVisible(false);
        this.table.removeAll();
        this.table.update();
        this.tree.setVisible(false);
        this.tableDetails.setVisible(false);
        this.tableDetails.removeAll();
        this.tableDetails.update();
    }

    public void updateCompilerResults(IProject curPro) {
        if (this.tree.isDisposed()) {
            return;
        }
        this.tree.removeAll();
        String projectPath = curPro.getLocation().toString();
        String fileName = String.valueOf(projectPath.substring(projectPath.lastIndexOf("/") + 1)) + ".lst";
        File file = new File(projectPath);
        ArrayList<String> fileLdList = new ArrayList<String>();
        List<String> ldList = CompilationResultsView.getALLFilesPath(file, ".ld", fileLdList);
        if (ldList.isEmpty()) {
            this.textName.setText("Failed to obtain the ld file,please configure the ld file in the project path.");
            this.textName.setForeground(new Color(null, 0, 0, 0));
            this.table.setVisible(false);
            this.table.removeAll();
            this.table.update();
            this.tree.setVisible(false);
            this.tableDetails.setVisible(false);
            this.tableDetails.removeAll();
            this.tableDetails.update();
            return;
        }
        String ldFileName = "";
        int i = 0;
        while (i < ldList.size()) {
            if (ldList.get(i).contains("ldscripts")) {
                ldFileName = ldList.get(i);
            }
            ++i;
        }
        LinkedHashMap<String, List<String>> memoryMap = CompilationResultsView.parseMemorySection(ldFileName);
        ArrayList<String> fileLstList = new ArrayList<String>();
        List<String> lstlist = CompilationResultsView.getALLFilesPath(file, fileName, fileLstList);
        if (lstlist.isEmpty()) {
            this.textName.setText("No compilation results are displayed at this time,Please compile the project first.");
            this.textName.setForeground(new Color(null, 0, 0, 0));
            this.table.setVisible(false);
            this.table.removeAll();
            this.table.update();
            this.tree.setVisible(false);
            this.tableDetails.setVisible(false);
            this.tableDetails.removeAll();
            this.tableDetails.update();
            return;
        }
        String lstFileName = lstlist.get(0).toString();
        String tempdebugString = lstFileName.substring(0, lstFileName.lastIndexOf(File.separator));
        String debugString = tempdebugString.substring(tempdebugString.lastIndexOf(File.separator) + 1);
        this.projectName = projectPath.substring(projectPath.lastIndexOf("/") + 1);
        String path = String.valueOf(this.projectName) + ".elf" + " - " + "/" + this.projectName + "/" + debugString;
        this.textName.setForeground(new Color(null, 1, 104, 181));
        this.textName.setText(path);
        this.sectionsMap = CompilationResultsView.parseSectionsInfo(lstFileName);
        LinkedHashMap<String, List<String>> buildAnalyerMap = CompilationResultsView.analyzeMemoryUsage(memoryMap, this.sectionsMap);
        this.table.setHeaderVisible(true);
        this.table.setVisible(true);
        this.updateTable(buildAnalyerMap);
        this.symbolTableMap = CompilationResultsView.parseSymbolTable(lstFileName, memoryMap);
        for (String memorykey : this.symbolTableMap.keySet()) {
            TreeItem parentTreeItem = new TreeItem(this.tree, 0);
            parentTreeItem.setText(memorykey);
            LinkedHashMap<String, List<List<String>>> symbolMap = this.symbolTableMap.get(memorykey);
            for (String symbolkey : symbolMap.keySet()) {
                new TreeItem(parentTreeItem, 0).setText(symbolkey);
            }
        }
        this.tree.setVisible(true);
        if (this.treeNodeStateMap.containsKey(this.projectName)) {
            List<String> tempList = this.treeNodeStateMap.get(this.projectName);
            this.SetTreeNodeChecked(tempList);
        }
        this.tableDetails.setHeaderVisible(true);
        this.tableDetails.setVisible(true);
    }

    public void SetTreeNodeChecked(TreeItem item, List<String> tempList) {
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem tempItem = items[i];
            if (tempItem.getText().equals(tempList.get(1))) {
                this.tree.setSelection(tempItem);
                this.updateTableDetails(tempList.get(1));
            }
            ++i;
        }
    }

    public void SetTreeNodeChecked(List<String> tempList) {
        TreeItem[] parentitems;
        TreeItem[] treeItemArray = parentitems = this.tree.getItems();
        int n = parentitems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem parentItemkey = treeItemArray[n2];
            if (parentItemkey.getText().equals(tempList.get(0))) {
                TreeItem[] tempItem;
                TreeItem[] treeItemArray2 = tempItem = parentItemkey.getItems();
                int n3 = tempItem.length;
                int n4 = 0;
                while (n4 < n3) {
                    TreeItem tempItemkey = treeItemArray2[n4];
                    if (tempItemkey.getText().equals(tempList.get(1))) {
                        this.tree.setSelection(tempItemkey);
                        this.updateTableDetails(parentItemkey.getText(), tempItemkey.getText());
                    }
                    ++n4;
                }
                return;
            }
            ++n2;
        }
    }

    public static List<String> getALLFilesPath(File dir, String fileName, List<String> fileList) {
        File[] fs = dir.listFiles();
        if (fs != null) {
            int i = 0;
            while (i < fs.length) {
                if (fs[i].getAbsolutePath().contains(fileName)) {
                    fileList.add(fs[i].getAbsolutePath());
                }
                if (fs[i].isDirectory()) {
                    try {
                        CompilationResultsView.getALLFilesPath(fs[i], fileName, fileList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        return fileList;
    }

    public String modifyString(String str) {
        StringBuffer sBuffer = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) != ' ') {
                sBuffer.append(str.charAt(i));
            }
            try {
                if (str.charAt(i) == ' ' && str.charAt(i + 1) != ' ') {
                    sBuffer.append(' ');
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return sBuffer.toString();
    }

    public String getKBSize(int size) {
        String KBSize;
        if (size >= 1024) {
            if (size % 1024 == 0) {
                KBSize = String.valueOf(String.valueOf(size / 1024)) + "KB";
            } else {
                double tempSize = (double)size / 1024.0;
                String tempStr = String.format("%.2f", tempSize);
                KBSize = String.valueOf(tempStr) + "KB";
            }
        } else {
            KBSize = String.valueOf(String.valueOf(size)) + "B";
        }
        return KBSize;
    }

    public String getNeedText(String filename, String beginStr, String endStr) {
        String tempstr = "";
        String tempLineStr = null;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while ((tempLineStr = reader.readLine()) != null) {
                tempstr = String.valueOf(tempstr) + tempLineStr;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int beginIndex = tempstr.indexOf(beginStr);
        int endIndex = tempstr.indexOf(endStr);
        String SubString = tempstr.substring(beginIndex, endIndex);
        return SubString;
    }

    public LinkedHashMap<String, List<String>> getlstMapInfo(String filename, String beginStr, String endStr) {
        String tempSubString = this.getNeedText(filename, beginStr, endStr);
        String subString = this.modifyString(tempSubString);
        LinkedHashMap<String, List<String>> sectionsMap = new LinkedHashMap<String, List<String>>();
        String[] Sections = subString.split(" ");
        int i = 0;
        while (i < Sections.length) {
            if (Sections[i].contains(".")) {
                ArrayList<String> tempList = new ArrayList<String>();
                tempList.add(Sections[i + 1]);
                tempList.add(Sections[i + 2]);
                sectionsMap.put(Sections[i], tempList);
            }
            ++i;
        }
        return sectionsMap;
    }

    public LinkedHashMap<String, List<String>> getldMapInfo(String filename, String beginStr, String endStr) {
        String tempSubString = this.getNeedText(filename, beginStr, endStr);
        String subString = this.modifyString(tempSubString);
        LinkedHashMap<String, List<String>> memorysMap = new LinkedHashMap<String, List<String>>();
        String[] memoryStr = subString.split(" ");
        int i = 0;
        while (i < memoryStr.length) {
            String addressStr;
            String tempStr;
            ArrayList<String> tempList;
            if ((memoryStr[i].contains("FLASH") || memoryStr[i].contains("flash")) && !memoryStr[i + 1].contains("*")) {
                tempList = new ArrayList<String>();
                tempStr = memoryStr[i + 5];
                addressStr = tempStr.substring(0, tempStr.length() - 1);
                tempList.add(addressStr);
                String tempstr = memoryStr[i + 8];
                int index = tempstr.indexOf("k");
                if (index > 0) {
                    tempstr = tempstr.substring(0, index + 1);
                }
                tempList.add(tempstr);
                memorysMap.put("FLASH", tempList);
            }
            if (memoryStr[i].contains("RAM") || memoryStr[i].contains("ram")) {
                tempList = new ArrayList();
                tempStr = memoryStr[i + 5];
                addressStr = tempStr.substring(0, tempStr.length() - 1);
                String tempSizeStr = memoryStr[i + 8];
                String sizeStr = tempSizeStr;
                int index = sizeStr.indexOf("}");
                if (index > 0) {
                    sizeStr = sizeStr.substring(0, index);
                }
                tempList.add(addressStr);
                tempList.add(sizeStr);
                memorysMap.put("RAM", tempList);
            }
            ++i;
        }
        return memorysMap;
    }

    public void updateTable(LinkedHashMap<String, List<String>> buildAnalyerMap) {
        this.table.removeAll();
        Set<String> keyset = buildAnalyerMap.keySet();
        for (String key : keyset) {
            String[] info = new String[this.table.getColumnCount()];
            info[0] = key;
            List<String> tempList = buildAnalyerMap.get(key);
            int i = 0;
            while (i < tempList.size()) {
                info[i + 1] = tempList.get(i);
                ++i;
            }
            TableItem item = new TableItem(this.table, 0x1000000);
            item.setText(info);
        }
        this.table.update();
    }

    public String strToEightStr(String str) {
        String eightStr = "";
        int length = str.length();
        if (length < 8) {
            int addLength = 8 - length;
            int i = 0;
            while (i < addLength) {
                eightStr = "0" + str;
                ++i;
            }
        } else {
            return str;
        }
        return eightStr;
    }

    public void getTableColumnInfo(String filename) {
        LinkedHashMap<String, String> tableColumnMap = new LinkedHashMap<String, String>();
        this.tableInfoMap = new LinkedHashMap();
        String rex = "<(.*?)>:";
        Pattern pattern = Pattern.compile(rex);
        boolean flag = false;
        try {
            List<String> allLines = Files.readAllLines(Paths.get(filename, new String[0]));
            for (String line : allLines) {
                Matcher matcher = pattern.matcher(line);
                while (matcher.find()) {
                    matcher.group();
                    String[] tempArr = line.split(" ");
                    String VMAAddress = tempArr[0];
                    String tableColName = tempArr[1].substring(1, tempArr[1].length() - 2);
                    tableColumnMap.put(VMAAddress, tableColName);
                }
                if (line.contains("SYMBOL TABLE:")) {
                    flag = true;
                } else if (line.contains("Disassembly of section")) {
                    flag = false;
                }
                if (!flag) continue;
                String tempLine = this.modifyString(line);
                String[] tempArr = tempLine.split(" ");
                this.tableInfoMap.put(tempArr[tempArr.length - 1], new ArrayList<String>(Arrays.asList(tempArr)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<List<String>> getTreeItemInfo(String itemValue) {
        this.treeNodeInfoMap = new LinkedHashMap();
        for (String key : this.tableInfoMap.keySet()) {
            List<String> tempList = this.tableInfoMap.get(key);
            ArrayList itemList = new ArrayList();
            ArrayList<String> tempitem = new ArrayList<String>();
            String treeNodeValue = null;
            tempitem.add(key);
            tempitem.add(tempList.get(0));
            int i = 0;
            while (i < tempList.size()) {
                String tempStr = tempList.get(i);
                for (String keySection : this.sectionsMap.keySet()) {
                    if (!tempStr.contains(keySection) || key.equals(keySection)) continue;
                    treeNodeValue = keySection;
                    String size = tempStr.substring(tempStr.length() - 8, tempStr.length());
                    tempitem.add(this.getKBSize(Integer.parseInt(size, 16)));
                }
                ++i;
            }
            if (this.treeNodeInfoMap.containsKey(treeNodeValue)) {
                this.treeNodeInfoMap.get(treeNodeValue).add(tempitem);
                continue;
            }
            itemList.add(tempitem);
            this.treeNodeInfoMap.put(treeNodeValue, itemList);
        }
        return this.treeNodeInfoMap.get(itemValue);
    }

    public void updateTableDetails(String item) {
        this.tableDetails.removeAll();
        if (this.sectionsMap.containsKey(item)) {
            List<List<String>> nodeList = this.getTreeItemInfo(item);
            int i = 0;
            while (i < nodeList.size()) {
                String[] tableInfo = nodeList.get(i).toArray(new String[nodeList.size()]);
                TableItem tableItem = new TableItem(this.tableDetails, 0);
                tableItem.setText(tableInfo);
                ++i;
            }
        }
        this.tableDetails.update();
    }

    public void updateTableDetails(String parentItem, String item) {
        LinkedHashMap<String, List<List<String>>> itemMap;
        this.tableDetails.removeAll();
        if (this.symbolTableMap.containsKey(parentItem) && (itemMap = this.symbolTableMap.get(parentItem)).containsKey(item)) {
            List<List<String>> nodeList = itemMap.get(item);
            int i = 0;
            while (i < nodeList.size()) {
                String[] tableInfo = nodeList.get(i).toArray(new String[nodeList.size()]);
                TableItem tableItem = new TableItem(this.tableDetails, 0);
                tableItem.setText(tableInfo);
                ++i;
            }
        }
        this.tableDetails.update();
    }

    public static LinkedHashMap<String, List<String>> parseMemorySection(String ldFilePath) {
        LinkedHashMap<String, List<String>> memoryMap = new LinkedHashMap<String, List<String>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(ldFilePath));){
                String line;
                StringBuilder content = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    content.append(line).append("\n");
                }
                String memorySection = CompilationResultsView.extractMemorySection(content.toString());
                if (memorySection == null || memorySection.isEmpty()) {
                    return memoryMap;
                }
                CompilationResultsView.parseMemoryRegions(memorySection, memoryMap);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("\u7487\u8bf2\u5f47\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6: " + e.getMessage());
            e.printStackTrace();
        }
        return memoryMap;
    }

    private static String extractMemorySection(String content) {
        Pattern memoryPattern = Pattern.compile("MEMORY\\s*\\{([^}]*)\\}", 32);
        Matcher matcher = memoryPattern.matcher(content = CompilationResultsView.removeComments(content));
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return null;
    }

    private static String removeComments(String content) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        int length = content.length();
        while (i < length) {
            if (i < length - 1 && content.charAt(i) == '/' && content.charAt(i + 1) == '*') {
                i = CompilationResultsView.skipBlockComment(content, i);
                continue;
            }
            if (i < length - 1 && content.charAt(i) == '/' && content.charAt(i + 1) == '/') {
                i = CompilationResultsView.skipLineComment(content, i);
                continue;
            }
            if (i >= length) continue;
            result.append(content.charAt(i));
            ++i;
        }
        return result.toString();
    }

    private static int skipBlockComment(String content, int startIndex) {
        int i = startIndex + 2;
        int nestLevel = 1;
        int length = content.length();
        while (i < length - 1 && nestLevel > 0) {
            if (content.charAt(i) == '/' && content.charAt(i + 1) == '*') {
                ++nestLevel;
                i += 2;
                continue;
            }
            if (content.charAt(i) == '*' && content.charAt(i + 1) == '/') {
                --nestLevel;
                i += 2;
                continue;
            }
            ++i;
        }
        return i;
    }

    private static int skipLineComment(String content, int startIndex) {
        int i = startIndex + 2;
        int length = content.length();
        while (i < length && content.charAt(i) != '\n' && content.charAt(i) != '\r') {
            ++i;
        }
        if (i < length && content.charAt(i) == '\r') {
            ++i;
        }
        if (i < length && content.charAt(i) == '\n') {
            ++i;
        }
        return i;
    }

    private static void parseMemoryRegions(String memoryContent, LinkedHashMap<String, List<String>> memoryMap) {
        Pattern regionPattern = Pattern.compile("(\\w+)\\s*\\([^)]+\\)\\s*:\\s*ORIGIN\\s*=\\s*(0x[0-9a-fA-F]+)\\s*,\\s*LENGTH\\s*=\\s*(\\d+[KkMmGg]?)", 2);
        Matcher matcher = regionPattern.matcher(memoryContent);
        while (matcher.find()) {
            String regionName = matcher.group(1).trim();
            String origin = matcher.group(2).trim();
            String length = matcher.group(3).trim();
            ArrayList<String> regionInfo = new ArrayList<String>();
            regionInfo.add(origin);
            regionInfo.add(length);
            memoryMap.put(regionName, regionInfo);
        }
    }

    public static LinkedHashMap<String, List<String>> parseSectionsInfo(String lstFilePath) {
        LinkedHashMap<String, List<String>> sectionsMap = new LinkedHashMap<String, List<String>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(lstFilePath));){
                String line;
                boolean inSectionsBlock = false;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).equals("Sections:") || line.equals("\u947a\u50a6\u7d30")) {
                        inSectionsBlock = true;
                        reader.readLine();
                        continue;
                    }
                    if (line.startsWith("SYMBOL TABLE:")) {
                        break;
                    }
                    if (!inSectionsBlock || line.isEmpty()) continue;
                    CompilationResultsView.parseSectionLine(line, sectionsMap);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("\u7487\u8bf2\u5f47LST\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6: " + e.getMessage());
            e.printStackTrace();
        }
        return sectionsMap;
    }

    private static void parseSectionLine(String line, LinkedHashMap<String, List<String>> sectionsMap) {
        Pattern sectionPattern = Pattern.compile("^\\s*(\\d+)\\s+(\\S+)\\s+(\\w+)\\s+(\\w+)\\s+(\\w+)\\s+.*");
        Matcher matcher = sectionPattern.matcher(line);
        if (matcher.matches()) {
            matcher.group(1);
            String name = matcher.group(2);
            String size = matcher.group(3);
            String vma = matcher.group(4);
            String lma = matcher.group(5);
            ArrayList<String> sectionInfo = new ArrayList<String>();
            sectionInfo.add(size);
            sectionInfo.add(vma);
            sectionInfo.add(lma);
            sectionsMap.put(name, sectionInfo);
        }
    }

    public String findLstFilePath(IProject project, String lstSuffix) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        if (lstSuffix == null || lstSuffix.trim().isEmpty()) {
            return null;
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = project.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                String lstPath;
                IResource member = iResourceArray[n2];
                if (member.getType() == 2 && (lstPath = this.findLstFileInFolder(member, lstSuffix)) != null) {
                    return lstPath;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String findLstFileInFolder(IResource folder, String lstSuffix) {
        block5: {
            if (folder.getType() == 2) break block5;
            return null;
        }
        try {
            IResource[] members;
            IResource[] iResourceArray = members = ((IFolder)folder).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                String fileName;
                IResource member = iResourceArray[n2];
                if (member.getType() == 1 && (fileName = (file = (IFile)member).getName()).toLowerCase().endsWith(lstSuffix)) {
                    return file.getLocation().toOSString();
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static LinkedHashMap<String, List<String>> analyzeMemoryUsage(LinkedHashMap<String, List<String>> memoryMap, LinkedHashMap<String, List<String>> sectionsMap) {
        LinkedHashMap<String, List<String>> buildAnalyzerMap = new LinkedHashMap<String, List<String>>();
        for (String regionName : memoryMap.keySet()) {
            List<String> regionInfo = memoryMap.get(regionName);
            String startAddress = regionInfo.get(0);
            String sizeStr = regionInfo.get(1);
            long regionStartAddr = CompilationResultsView.parseHexAddress(startAddress);
            long regionTotalSize = CompilationResultsView.parseSizeToBytes(sizeStr);
            long regionEndAddr = regionStartAddr + regionTotalSize;
            long usedSize = CompilationResultsView.calculateRegionUsage(regionName, regionStartAddr, regionEndAddr, sectionsMap);
            long freeSize = regionTotalSize - usedSize;
            double usageRate = (double)usedSize / (double)regionTotalSize;
            DecimalFormat percentFormat = new DecimalFormat("##.##%");
            String usageRateStr = percentFormat.format(usageRate);
            String startAddrStr = startAddress;
            String endAddrStr = "0x" + String.format("%08X", regionEndAddr);
            String totalSizeStr = CompilationResultsView.formatSize(regionTotalSize);
            String freeSizeStr = CompilationResultsView.formatSize(freeSize);
            String usedSizeStr = CompilationResultsView.formatSize(usedSize);
            ArrayList<String> resultList = new ArrayList<String>();
            resultList.add(startAddrStr);
            resultList.add(endAddrStr);
            resultList.add(totalSizeStr);
            resultList.add(freeSizeStr);
            resultList.add(usedSizeStr);
            resultList.add(usageRateStr);
            buildAnalyzerMap.put(regionName, resultList);
        }
        return buildAnalyzerMap;
    }

    private static long calculateRegionUsage(String regionName, long regionStartAddr, long regionEndAddr, LinkedHashMap<String, List<String>> sectionsMap) {
        long usedSize = 0L;
        for (String sectionName : sectionsMap.keySet()) {
            List<String> sectionInfo = sectionsMap.get(sectionName);
            if (sectionInfo.size() < 3) continue;
            long sectionSize = Long.parseLong(sectionInfo.get(0), 16);
            long vmaAddress = Long.parseLong(sectionInfo.get(1), 16);
            long lmaAddress = Long.parseLong(sectionInfo.get(2), 16);
            boolean occupiesRegion = false;
            occupiesRegion = regionName.toUpperCase().equals("FLASH") ? CompilationResultsView.occupiesFlashMemory(sectionName, lmaAddress, regionStartAddr, regionEndAddr) : CompilationResultsView.occupiesRuntimeMemory(sectionName, vmaAddress, regionStartAddr, regionEndAddr);
            if (!occupiesRegion) continue;
            usedSize += sectionSize;
        }
        return usedSize;
    }

    private static boolean occupiesFlashMemory(String sectionName, long lmaAddress, long regionStartAddr, long regionEndAddr) {
        if (CompilationResultsView.isDebugSection(sectionName)) {
            return false;
        }
        if (sectionName.equals(".bss") || sectionName.equals(".heap_stack") || sectionName.contains("COMMON")) {
            return false;
        }
        if (sectionName.equals(".ARM.attributes")) {
            return false;
        }
        return lmaAddress >= regionStartAddr && lmaAddress < regionEndAddr;
    }

    private static boolean occupiesRuntimeMemory(String sectionName, long vmaAddress, long regionStartAddr, long regionEndAddr) {
        if (CompilationResultsView.isDebugSection(sectionName)) {
            return false;
        }
        if (sectionName.equals(".ARM.attributes")) {
            return false;
        }
        if (sectionName.equals(".comment")) {
            return false;
        }
        return vmaAddress >= regionStartAddr && vmaAddress < regionEndAddr;
    }

    private static boolean isDebugSection(String sectionName) {
        return sectionName.startsWith(".debug_") || sectionName.equals(".stab") || sectionName.equals(".stabstr") || sectionName.startsWith(".gnu.debug") || sectionName.equals(".dwarf");
    }

    private static String formatSize(long bytes) {
        if (bytes >= 0x40000000L) {
            double gb = (double)bytes / 1.073741824E9;
            return String.format("%.2fGB", gb);
        }
        if (bytes >= 0x100000L) {
            double mb = (double)bytes / 1048576.0;
            return String.format("%.2fMB", mb);
        }
        if (bytes >= 1024L) {
            double kb = (double)bytes / 1024.0;
            if (kb == (double)((long)kb)) {
                return String.format("%.0fKB", kb);
            }
            return String.format("%.2fKB", kb);
        }
        return String.valueOf(bytes) + "B";
    }

    public static LinkedHashMap<String, LinkedHashMap<String, List<List<String>>>> parseSymbolTable(String lstFilePath, LinkedHashMap<String, List<String>> memoryMap) {
        LinkedHashMap<String, LinkedHashMap<String, List<List<String>>>> symbolTableMap = new LinkedHashMap<String, LinkedHashMap<String, List<List<String>>>>();
        LinkedHashMap<String, MemoryRegion> memoryRegions = CompilationResultsView.parseMemoryRegions(memoryMap);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(lstFilePath));){
                String line;
                boolean inSymbolTable = false;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("SYMBOL TABLE:")) {
                        inSymbolTable = true;
                        continue;
                    }
                    if (inSymbolTable && (line.startsWith("Disassembly of section") || line.isEmpty())) {
                        if (!line.startsWith("Disassembly of section")) continue;
                        break;
                    }
                    if (!inSymbolTable || line.isEmpty() || line.contains("*ABS*")) continue;
                    CompilationResultsView.parseSymbolLine(line, symbolTableMap, memoryRegions);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            System.err.println("\u7487\u8bf2\u5f47LST\u93c2\u56e6\u6b22\u6fb6\u8fab\u89e6: " + e.getMessage());
            e.printStackTrace();
        }
        return symbolTableMap;
    }

    private static void parseSymbolLine(String line, LinkedHashMap<String, LinkedHashMap<String, List<List<String>>>> symbolTableMap, LinkedHashMap<String, MemoryRegion> memoryRegions) {
        String vmaStr = "";
        String sectionName = "";
        String sizeStr = "";
        String symbolName = "";
        String[] linestr = line.replaceAll("\\t", " ").replaceAll("\\s+", " ").split(" ");
        if (linestr.length == 6) {
            vmaStr = linestr[0];
            sectionName = linestr[3];
            sizeStr = linestr[4];
            symbolName = linestr[5];
        }
        if (linestr.length == 5) {
            vmaStr = linestr[0];
            sectionName = linestr[2];
            sizeStr = linestr[3];
            symbolName = linestr[4];
        }
        if (linestr.length == 4) {
            vmaStr = linestr[0];
            sectionName = linestr[1];
            sizeStr = linestr[2];
            symbolName = linestr[3];
        }
        if (CompilationResultsView.isIgnorableSection(sectionName) || CompilationResultsView.isIgnorableSymbol(symbolName)) {
            return;
        }
        long vmaAddress = Long.parseLong(vmaStr, 16);
        String size = sizeStr;
        String memoryRegionName = CompilationResultsView.findMemoryRegion(vmaAddress, memoryRegions);
        if (memoryRegionName != null) {
            ArrayList<String> symbolInfo = new ArrayList<String>();
            symbolInfo.add(symbolName);
            symbolInfo.add(vmaStr);
            symbolInfo.add(size);
            LinkedHashMap regionMap = symbolTableMap.computeIfAbsent(String.valueOf(memoryRegionName) + " Details", k -> new LinkedHashMap());
            List sectionList = regionMap.computeIfAbsent(sectionName, k -> new ArrayList());
            sectionList.add(symbolInfo);
        }
    }

    private static String findMemoryRegion(long vmaAddress, LinkedHashMap<String, MemoryRegion> memoryRegions) {
        for (String regionName : memoryRegions.keySet()) {
            MemoryRegion region = memoryRegions.get(regionName);
            if (vmaAddress < region.startAddress || vmaAddress >= region.endAddress) continue;
            return regionName;
        }
        return null;
    }

    private static LinkedHashMap<String, MemoryRegion> parseMemoryRegions(LinkedHashMap<String, List<String>> memoryMap) {
        LinkedHashMap<String, MemoryRegion> regions = new LinkedHashMap<String, MemoryRegion>();
        for (String regionName : memoryMap.keySet()) {
            List<String> regionInfo = memoryMap.get(regionName);
            String startAddressStr = regionInfo.get(0);
            String sizeStr = regionInfo.get(1);
            long startAddress = CompilationResultsView.parseHexAddress(startAddressStr);
            long size = CompilationResultsView.parseSizeToBytes(sizeStr);
            long endAddress = startAddress + size;
            regions.put(regionName, new MemoryRegion(startAddress, endAddress));
        }
        return regions;
    }

    private static boolean isIgnorableSection(String sectionName) {
        return sectionName.startsWith(".debug_") || sectionName.equals("*ABS*") || sectionName.equals("*UND*") || sectionName.equals("*COM*") || sectionName.startsWith(".gnu.debug");
    }

    private static boolean isIgnorableSymbol(String symbolName) {
        return symbolName.startsWith("$") || symbolName.contains("crtstuff") || symbolName.contains("__EH_FRAME") || symbolName.equals("") || symbolName.trim().isEmpty();
    }

    private static long parseHexAddress(String addressStr) {
        if (addressStr.startsWith("0x") || addressStr.startsWith("0X")) {
            return Long.parseLong(addressStr.substring(2), 16);
        }
        return Long.parseLong(addressStr, 16);
    }

    private static long parseSizeToBytes(String sizeStr) {
        if (sizeStr == null || sizeStr.trim().isEmpty()) {
            return 0L;
        }
        sizeStr = sizeStr.trim().toUpperCase();
        long multiplier = 1L;
        if (sizeStr.endsWith("K")) {
            multiplier = 1024L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("M")) {
            multiplier = 0x100000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("G")) {
            multiplier = 0x40000000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        }
        try {
            long value = Long.parseLong(sizeStr);
            return value * multiplier;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static IConfiguration getCurrentProjectConfiguration(IProject project) {
        ICConfigurationDescription activeConfigDescription;
        block6: {
            ICProjectDescription projectDescription;
            block5: {
                if (project == null) {
                    return null;
                }
                try {
                    projectDescription = CoreModel.getDefault().getProjectDescription(project);
                    if (projectDescription != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    System.err.println("\u947e\u5cf0\u5f47\u5bb8\u30e7\u25bc\u95b0\u5d87\u7586\u6fb6\u8fab\u89e6: " + e.getMessage());
                    e.printStackTrace();
                    return null;
                }
            }
            activeConfigDescription = projectDescription.getActiveConfiguration();
            if (activeConfigDescription != null) break block6;
            return null;
        }
        IConfiguration configuration = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)activeConfigDescription);
        return configuration;
    }

    private String[] getLinkerScriptsFromConfiguration(IProject project) {
        block17: {
            IConfiguration config;
            block16: {
                config = CompilationResultsView.getCurrentProjectConfiguration(project);
                if (config != null) break block16;
                return null;
            }
            try {
                IOption[] options;
                ITool linkerTool = config.calculateTargetTool();
                if (linkerTool == null) break block17;
                IOption[] iOptionArray = options = linkerTool.getOptions();
                int n = options.length;
                int n2 = 0;
                while (n2 < n) {
                    IOption option = iOptionArray[n2];
                    if (option != null) {
                        String idString = "";
                        if (linkerTool.getName().equals(ARMLinker) || linkerTool.getName().equals(ARMCLinker)) {
                            idString = ARMCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(ARMCAddLinker)) {
                            idString = ARMCAddLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVLinker) || linkerTool.getName().equals(RISCVCLinker)) {
                            idString = RISCVCLinkerScriptFileID;
                        } else if (linkerTool.getName().equals(RISCVCAddLinker)) {
                            idString = RISCVCAddLinkerScriptFileID;
                        }
                        if (option.getSuperClass().getId().equals(idString)) {
                            try {
                                String[] LdFilePathList = option.getStringListValue();
                                if (LdFilePathList.length > 0) {
                                    return LdFilePathList;
                                }
                            }
                            catch (BuildException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                System.err.println("\u947e\u5cf0\u5f47\u95be\u70ac\u5e34\u9363\u3128\u527c\u93c8\ue104\u53a4\u7f03\ue1bd\u6902\u9351\u6d2a\u654a: " + e.getMessage());
            }
        }
        return null;
    }

    private static class MemoryRegion {
        final long startAddress;
        final long endAddress;

        MemoryRegion(long startAddress, long endAddress) {
            this.startAddress = startAddress;
            this.endAddress = endAddress;
        }
    }
}

