/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.liveexpressions;

import com.gigadevice.debug.liveexpressions.ExpVarLoadAndSave;
import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.liveexpressions.ILiveVarListener;
import com.gigadevice.debug.liveexpressions.LiveVariable;
import com.gigadevice.debug.utils.GdbDebugUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVar;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarAssignInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarChange;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarCreateInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarListChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarSetFormatInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarShowAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarUpdateInfo;

public class LiveVarManager {
    private ArrayList<LiveVariable> expVarList = new ArrayList();
    private IGDBVarManagerService liveService;
    private int numberFormat = 0;
    public VarUpdateThread updateThread = null;
    private ArrayList<ILiveVarListener> listeners;

    public LiveVarManager() {
        this.expVarList.addAll(ExpVarLoadAndSave.loadExpVarList());
        LiveVariable ExpressionObj = new LiveVariable(null, null);
        this.expVarList.add(ExpressionObj);
        this.listeners = new ArrayList();
        this.updateThread = new VarUpdateThread();
        this.updateThread.start();
    }

    public ArrayList<LiveVariable> getExpressions() {
        return this.expVarList;
    }

    public synchronized boolean addExpression(String exprStr) {
        boolean[] success = new boolean[]{true};
        if (exprStr != null && !exprStr.isEmpty()) {
            LiveVariable expr = this.getNewExpression(exprStr, success);
            if (expr != null) {
                this.addExpression(expr);
            } else {
                this.addExpression(new LiveVariable(exprStr, null));
            }
        }
        return success[0];
    }

    public synchronized void addExpression(LiveVariable expr) {
        this.expVarList.add(this.expVarList.size() - 1, expr);
        this.notifyExpressionUpdate(null);
    }

    public synchronized void updateExpression(LiveVariable expr, String newExprStr) {
        boolean[] success = new boolean[1];
        LiveVariable newExpr = this.getNewExpression(newExprStr, success);
        if (newExpr == null) {
            newExpr = new LiveVariable(newExprStr, null);
        }
        int index = this.expVarList.indexOf(expr);
        this.expVarList.set(index, newExpr);
    }

    public synchronized void removeExpression(LiveVariable expr) {
        if (expr != null && expr.getExpression() != null) {
            this.expVarList.remove(expr);
        }
    }

    private synchronized LiveVariable getNewExpression(String expr, boolean[] success) {
        if (expr != null && !expr.isEmpty()) {
            String typeStr;
            int typeId;
            MIVarCreateInfo varInfo = null;
            IGDBVarManagerService tmpService = this.getLiveService();
            if (tmpService != null) {
                varInfo = tmpService.createExpVar(expr, success);
            }
            if (varInfo != null && (typeId = LiveVarManager.checkType(typeStr = varInfo.getType())) != 0) {
                LiveVariable expression = new LiveVariable(expr, null);
                expression.setValue(varInfo.getValue());
                expression.setType(varInfo.getType());
                expression.setGdbVarName(varInfo.getName());
                expression.setNumChildren(varInfo.getNumChildren());
                MIVarShowAttributesInfo varAttributes = tmpService.showExpVarAttr(varInfo.getName());
                boolean editable = false;
                if (varAttributes != null) {
                    editable = varAttributes.isEditable();
                }
                expression.setEditable(editable);
                if (this.numberFormat != 0) {
                    this.changeNumberFormat(expression);
                }
                return expression;
            }
        }
        return null;
    }

    public static int checkType(String type) {
        if (type != null) {
            Pattern arrayPattern = Pattern.compile(".+\\[\\d+\\]");
            if (arrayPattern.matcher(type).find()) {
                return 0;
            }
            Pattern ptrPattern = Pattern.compile(".+\\*+");
            if (ptrPattern.matcher(type).find()) {
                return 2;
            }
        }
        return 3;
    }

    public synchronized void updateExpressionListInNotNOStopMode() {
        for (LiveVariable obj : this.expVarList) {
            obj.setValue("Non-stop mode is disable,target not available!");
            this.notifyExpressionUpdate(obj);
            if (obj.getNumChildren() <= 0) continue;
            ArrayList<LiveVariable> childs = obj.getExpressions();
            for (LiveVariable child : childs) {
                child.setValue("Non-stop mode is disable,target not available!");
                this.notifyExpressionUpdate(child);
            }
        }
    }

    public synchronized void updateExpressionListInGDBServerNullMode() {
        for (LiveVariable obj : this.expVarList) {
            obj.setValue("Restart debugging, target available!");
            this.notifyExpressionUpdate(obj);
            if (obj.getNumChildren() <= 0) continue;
            ArrayList<LiveVariable> childs = obj.getExpressions();
            for (LiveVariable child : childs) {
                child.setValue("Restart debugging, target available!");
                this.notifyExpressionUpdate(child);
            }
        }
    }

    public synchronized void updateExpressionList() {
        ArrayList<LiveVariable> inContextList = this.getInContext();
        if (inContextList.size() > 0) {
            for (LiveVariable expr : inContextList) {
                IGDBVarManagerService tmpService = this.getLiveService();
                if (tmpService == null) continue;
                MIVarUpdateInfo updateInfo = tmpService.updateExpVarValue(expr.getGdbVarName());
                this.updateExpression(expr, updateInfo);
            }
        }
    }

    private ArrayList<LiveVariable> getInContext() {
        ArrayList<LiveVariable> inContextList = new ArrayList<LiveVariable>();
        for (LiveVariable expr : this.expVarList) {
            if (!expr.inContext()) continue;
            inContextList.add(expr);
        }
        return inContextList;
    }

    public void updateExpression(LiveVariable expr, MIVarUpdateInfo updateInfo) {
        if (updateInfo != null) {
            MIVarChange[] changes;
            MIVarChange[] arrayOfMIVarChange1 = changes = updateInfo.getMIVarChanges();
            int i = changes.length;
            int b = 0;
            while (b < i) {
                MIVarChange change = arrayOfMIVarChange1[b];
                LiveVariable changedExpr = expr.findExpression(change.getVarName());
                if (changedExpr != null) {
                    changedExpr.setValue(change.getValue());
                    System.out.println(String.valueOf(changedExpr.getExpression()) + ": " + change.getValue());
                    this.notifyExpressionUpdate(changedExpr);
                }
                b = (byte)(b + 1);
            }
        }
    }

    private void notifyExpressionUpdate(LiveVariable expr) {
        for (ILiveVarListener listener : this.listeners) {
            listener.varUpdate(expr);
        }
    }

    public synchronized boolean setExpressionValue(LiveVariable expr, String value) {
        MIVarAssignInfo info;
        IGDBVarManagerService tmpService;
        boolean ret = false;
        if (expr.isEditable() && (tmpService = this.getLiveService()) != null && (info = tmpService.setExpVarValue(expr.getGdbVarName(), value)) != null && !info.isError()) {
            expr.setValue(info.getValue());
            this.notifyExpressionUpdate(expr);
            ret = true;
        }
        return ret;
    }

    public synchronized void setNumberFormat(int numberFormat) {
        this.numberFormat = numberFormat;
        this.changeNumberFormat(this.expVarList);
    }

    public synchronized void changeNumberFormat(ArrayList<LiveVariable> list) {
        for (LiveVariable expr : list) {
            this.changeNumberFormat(expr);
            if (expr.getNumChildren() <= 0) continue;
            ArrayList<LiveVariable> childs = expr.getExpressions();
            for (LiveVariable obj : childs) {
                this.changeNumberFormat(obj);
            }
        }
    }

    public int getNumberFormat() {
        return this.numberFormat;
    }

    private synchronized void changeNumberFormat(LiveVariable expr) {
        String gdbFmt = this.getGdbFmt(this.numberFormat);
        IGDBVarManagerService tmpService = this.getLiveService();
        if (tmpService != null) {
            MIVarSetFormatInfo formatInfo = tmpService.setExpVarFormat(expr.getGdbVarName(), gdbFmt);
            if (formatInfo != null) {
                expr.setValue(formatInfo.getValue());
                this.notifyExpressionUpdate(expr);
            } else {
                String value = expr.getValue();
                if (gdbFmt.equals("HEX.Format")) {
                    value = "0x" + Integer.toHexString(Integer.valueOf(expr.getValue()));
                } else if (gdbFmt.equals("BINARY.Format")) {
                    value = Integer.toBinaryString(Integer.valueOf(expr.getValue()));
                } else if (gdbFmt.equals("OCTAL.Format")) {
                    value = Integer.toOctalString(Integer.valueOf(expr.getValue()));
                }
                expr.setValue(value);
                this.notifyExpressionUpdate(expr);
            }
        }
    }

    private String getGdbFmt(int fmtId) {
        switch (fmtId) {
            case 0: {
                return "NATURAL.Format";
            }
            case 1: {
                return "HEX.Format";
            }
            case 2: {
                return "DECIMAL.Format";
            }
            case 3: {
                return "OCTAL.Format";
            }
            case 4: {
                return "BINARY.Format";
            }
            case 5: {
                return "NATURAL.Format";
            }
        }
        return "natural";
    }

    public synchronized void setLiveService(IGDBVarManagerService liveService) {
        this.liveService = liveService;
    }

    public IGDBVarManagerService getLiveService() {
        if (this.liveService != null && this.liveService.isRegistered()) {
            return this.liveService;
        }
        return null;
    }

    public void setAutoUpdate(int state) {
        this.updateThread.setThreadState(state);
    }

    public void addExpressionListener(ILiveVarListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeExpressionListener(ILiveVarListener listener) {
        this.listeners.remove(listener);
    }

    public int getSize() {
        return this.expVarList.size();
    }

    public synchronized void removeAllExpressions() {
        Iterator<LiveVariable> it = this.expVarList.iterator();
        while (it.hasNext()) {
            IGDBVarManagerService tmpService;
            LiveVariable expr = it.next();
            if (expr.getExpression() == null) continue;
            if (expr.inContext() && (tmpService = this.getLiveService()) != null) {
                tmpService.deleteExpVar(expr.getGdbVarName());
            }
            it.remove();
        }
    }

    public void dispose() {
        this.updateThread.setThreadState(0);
        ExpVarLoadAndSave.saveExpVarList(this.expVarList);
    }

    public synchronized void reset() {
        for (LiveVariable expr : this.expVarList) {
            expr.reset();
        }
    }

    public synchronized void reCreateVar() {
        ArrayList<LiveVariable> tmpList = new ArrayList<LiveVariable>(this.expVarList);
        this.removeAllExpressions();
        for (LiveVariable expr : tmpList) {
            String s = expr.getExpression();
            if (s == null || s.isEmpty()) continue;
            this.addExpression(s);
        }
    }

    public void setDelay(int value) {
        this.updateThread.setUpdateTimer(value);
    }

    public synchronized void listChildren(LiveVariable parent) {
        MIVarListChildrenInfo childInfo = null;
        IGDBVarManagerService tmpService = this.getLiveService();
        if (tmpService != null) {
            childInfo = tmpService.listExpVarChildren(parent.getGdbVarName(), 0, 0);
        }
        if (childInfo != null) {
            MIVar[] miVars;
            MIVar[] arrayOfMIVar1 = miVars = childInfo.getMIVars();
            int i = miVars.length;
            int b = 0;
            while (b < i) {
                LiveVariable childExpression = null;
                MIVar miVar = arrayOfMIVar1[b];
                String name = miVar.getExp();
                String typeStr = miVar.getType();
                int typeId = LiveVarManager.checkType(typeStr);
                if (typeId != 0) {
                    childExpression = new LiveVariable(name, null);
                    String val = null;
                    tmpService = this.getLiveService();
                    if (tmpService != null) {
                        val = tmpService.evaluateVarExpression(miVar.getVarName());
                    }
                    if (val != null) {
                        childExpression.setValue(val);
                        MIVarShowAttributesInfo varAttributes = tmpService.showExpVarAttr(miVar.getVarName());
                        boolean editable = false;
                        if (varAttributes != null) {
                            editable = varAttributes.isEditable();
                        }
                        childExpression.setEditable(editable);
                    } else {
                        childExpression.setValue("");
                    }
                }
                childExpression.setType(miVar.getType());
                childExpression.setGdbVarName(miVar.getVarName());
                childExpression.setNumChildren(miVar.getNumChild());
                if (this.numberFormat != 0) {
                    this.changeNumberFormat(childExpression);
                }
                parent.addChildExpression(childExpression);
                b = (byte)(b + 1);
            }
        }
    }

    public void getFormatValue(String value, int Format) {
    }

    public class VarUpdateThread
    extends Thread {
        private int state = 1;
        private int updateTimer = 1000;
        private Semaphore semaphore = new Semaphore(0);

        public synchronized int getThreadState() {
            return this.state;
        }

        public synchronized void setThreadState(int newState) {
            if (newState != this.state) {
                if (newState == 0) {
                    this.state = newState;
                    this.interrupt();
                } else if (1 == newState) {
                    this.state = newState;
                } else if (2 == newState) {
                    if (1 == this.state) {
                        this.state = newState;
                        this.semaphore.release();
                    } else {
                        this.state = newState;
                    }
                }
            }
        }

        public synchronized void setUpdateTimer(int value) {
            this.updateTimer = value;
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    int state;
                    if ((state = this.getThreadState()) == 0) {
                        return;
                    }
                    if (1 == state) {
                        this.semaphore.acquire();
                        continue;
                    }
                    if (2 != state) continue;
                    while (true) {
                        if (2 != this.getThreadState()) continue block2;
                        if (!GdbDebugUtil.isNonStop) {
                            LiveVarManager.this.updateExpressionListInNotNOStopMode();
                            this.setThreadState(1);
                            continue block2;
                        }
                        if (LiveVarManager.this.getLiveService() == null) {
                            LiveVarManager.this.updateExpressionListInGDBServerNullMode();
                            Thread.sleep(this.updateTimer);
                            state = 1;
                            continue;
                        }
                        LiveVarManager.this.updateExpressionList();
                        Thread.sleep(this.updateTimer);
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

