/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.liveexpressions;

import com.gigadevice.debug.Activator;
import com.gigadevice.debug.liveexpressions.IGDBVarManagerService;
import com.gigadevice.debug.utils.ToolUtil;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarAssignInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarCreateInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarDeleteInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarEvaluateExpressionInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarListChildrenInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarSetFormatInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarShowAttributesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIVarUpdateInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.model.MemoryByte;
import org.osgi.framework.BundleContext;

public class GDBVarManagerService
extends AbstractDsfService
implements IGDBVarManagerService {
    private IMICommandControl fCommandControl;
    private DsfSession fSession;
    private IExpressions fExpressions;

    public GDBVarManagerService(DsfSession fSession) {
        super(fSession);
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                GDBVarManagerService.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        this.fSession = this.getSession();
        this.fCommandControl = (IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class);
        this.fExpressions = (IExpressions)this.getServicesTracker().getService(IExpressions.class);
        this.register(new String[]{IGDBVarManagerService.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(final RequestMonitor requestMonitor) {
        super.shutdown((RequestMonitor)new ImmediateRequestMonitor(requestMonitor){

            protected void handleSuccess() {
                GDBVarManagerService.this.unregister();
                requestMonitor.done();
            }
        });
    }

    protected BundleContext getBundleContext() {
        return Activator.getBundleContext();
    }

    @Override
    public MIVarCreateInfo createExpVar(String expression, boolean[] success) {
        DsfExecutor executor;
        success[0] = true;
        if (this.fSession != null && this.fCommandControl != null && this.fExpressions != null && expression != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            IExpressions.IExpressionDMContext iexprDmContext = this.fExpressions.createExpression((IDMContext)this.fCommandControl.getContext(), expression);
            final ICommand commandCreate = comFac.createMIVarCreate(iexprDmContext, expression);
            Query query = new Query(){

                protected void execute(DataRequestMonitor rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandCreate, rm);
                }
            };
            executor.execute((Runnable)query);
            try {
                MIVarCreateInfo e = (MIVarCreateInfo)query.get(2000L, TimeUnit.MILLISECONDS);
                if (e != null) {
                    if (!e.isError()) {
                        return e;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
            catch (TimeoutException e1) {
                success[0] = false;
                e1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public MIVarUpdateInfo updateExpVarValue(String varName) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand commandVarUpdate = comFac.createMIVarUpdate(this.fCommandControl.getContext(), varName);
            Query<MIVarUpdateInfo> query = new Query<MIVarUpdateInfo>(){

                protected void execute(DataRequestMonitor<MIVarUpdateInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandVarUpdate, rm);
                }
            };
            executor.execute((Runnable)query);
            try {
                Object obj = query.get(1000L, TimeUnit.MILLISECONDS);
                MIVarUpdateInfo updateInfo = (MIVarUpdateInfo)obj;
                if (updateInfo != null) {
                    if (!updateInfo.isError()) {
                        return updateInfo;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException | TimeoutException exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public MIVarShowAttributesInfo showExpVarAttr(String varName) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand command = comFac.createMIVarShowAttributes(this.fCommandControl.getContext(), varName);
            Query<MIVarShowAttributesInfo> query = new Query<MIVarShowAttributesInfo>(){

                protected void execute(DataRequestMonitor<MIVarShowAttributesInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(command, rm);
                }
            };
            try {
                executor.execute((Runnable)query);
                MIVarShowAttributesInfo info = (MIVarShowAttributesInfo)query.get();
                if (info != null) {
                    if (!info.isError()) {
                        return info;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public MIVarAssignInfo setExpVarValue(String varName, String expression) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && expression != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand command = comFac.createMIVarAssign(this.fCommandControl.getContext(), varName, expression);
            Query<MIVarAssignInfo> query = new Query<MIVarAssignInfo>(){

                protected void execute(DataRequestMonitor<MIVarAssignInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(command, rm);
                }
            };
            try {
                executor.execute((Runnable)query);
                MIVarAssignInfo info = (MIVarAssignInfo)query.get(1000L, TimeUnit.MILLISECONDS);
                if (info != null) {
                    if (!info.isError()) {
                        return info;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public MIVarDeleteInfo deleteExpVar(String varName) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand commandDelete = comFac.createMIVarDelete(this.fCommandControl.getContext(), varName);
            Query<MIVarDeleteInfo> query = new Query<MIVarDeleteInfo>(){

                protected void execute(DataRequestMonitor<MIVarDeleteInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandDelete, rm);
                }
            };
            try {
                executor.execute((Runnable)query);
                MIVarDeleteInfo e = (MIVarDeleteInfo)query.get(1000L, TimeUnit.MILLISECONDS);
                if (e != null) {
                    if (!e.isError()) {
                        return e;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
            catch (TimeoutException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public MIVarListChildrenInfo listExpVarChildren(String varName, int from, int to) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand commandVarListChild = from == 0 && to == 0 ? comFac.createMIVarListChildren(this.fCommandControl.getContext(), varName) : comFac.createMIVarListChildren(this.fCommandControl.getContext(), varName, from, to);
            Query<MIVarListChildrenInfo> listChildQuery = new Query<MIVarListChildrenInfo>(){

                protected void execute(DataRequestMonitor<MIVarListChildrenInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandVarListChild, rm);
                }
            };
            try {
                executor.execute((Runnable)listChildQuery);
                MIVarListChildrenInfo varInfo = (MIVarListChildrenInfo)listChildQuery.get();
                if (varInfo != null) {
                    if (!varInfo.isError()) {
                        return varInfo;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String evaluateVarExpression(String expression) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && expression != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand commandEval = comFac.createMIVarEvaluateExpression(this.fCommandControl.getContext(), expression);
            Query<MIVarEvaluateExpressionInfo> query = new Query<MIVarEvaluateExpressionInfo>(){

                protected void execute(DataRequestMonitor<MIVarEvaluateExpressionInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandEval, rm);
                }
            };
            try {
                executor.execute((Runnable)query);
                MIVarEvaluateExpressionInfo exprInfo = (MIVarEvaluateExpressionInfo)query.get(1000L, TimeUnit.MILLISECONDS);
                if (exprInfo != null) {
                    if (!exprInfo.isError()) {
                        String retVal = exprInfo.getValue();
                        if (retVal != null) {
                            return retVal;
                        }
                        return null;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public String evaluateExpression(String expression) {
        return null;
    }

    @Override
    public MIVarSetFormatInfo setExpVarFormat(String varName, String fmt) {
        DsfExecutor executor;
        if (this.fSession != null && this.fCommandControl != null && varName != null && fmt != null && (executor = this.fSession.getExecutor()) != null) {
            CommandFactory comFac = this.fCommandControl.getCommandFactory();
            final ICommand commandCreate = comFac.createMIVarSetFormat(this.fCommandControl.getContext(), varName, fmt);
            Query<MIVarSetFormatInfo> query = new Query<MIVarSetFormatInfo>(){

                protected void execute(DataRequestMonitor<MIVarSetFormatInfo> rm) {
                    GDBVarManagerService.this.fCommandControl.queueCommand(commandCreate, rm);
                }
            };
            try {
                executor.execute((Runnable)query);
                MIVarSetFormatInfo formatInfo = (MIVarSetFormatInfo)query.get(1000L, TimeUnit.MILLISECONDS);
                if (formatInfo != null) {
                    if (!formatInfo.isError()) {
                        return formatInfo;
                    }
                    return null;
                }
                return null;
            }
            catch (InterruptedException | ExecutionException | RejectedExecutionException exception) {
                return null;
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public long getMemoryValue(String address, int iByteCount, boolean[] success) {
        long ret = 0L;
        success[0] = false;
        if (this.fSession != null && this.fCommandControl != null) {
            DsfExecutor executor = this.fSession.getExecutor();
            if (executor != null) {
                CommandFactory comFac = this.fCommandControl.getCommandFactory();
                IGDBControl fGdb = (IGDBControl)this.getServicesTracker().getService(IGDBControl.class);
                final ICommand commandVarUpdate = comFac.createMIDataReadMemory((IDMContext)fGdb.getContext(), 0L, address, 0, 1, 1, iByteCount, null);
                Query<MIDataReadMemoryInfo> query = new Query<MIDataReadMemoryInfo>(){

                    protected void execute(DataRequestMonitor<MIDataReadMemoryInfo> drm) {
                        GDBVarManagerService.this.fCommandControl.queueCommand(commandVarUpdate, drm);
                    }
                };
                executor.execute((Runnable)query);
                try {
                    Object obj = query.get(1000L, TimeUnit.MILLISECONDS);
                    MIDataReadMemoryInfo updateInfo = (MIDataReadMemoryInfo)obj;
                    MemoryByte[] bytes = updateInfo.getMIMemoryBlock();
                    byte[] arraybytes = new byte[bytes.length];
                    int i = 0;
                    while (i < bytes.length) {
                        arraybytes[i] = bytes[bytes.length - 1 - i].getValue();
                        ++i;
                    }
                    BigInteger big = new BigInteger(1, arraybytes);
                    big = ToolUtil.toUnsigned(big);
                    ret = new Long(big.toString());
                    success[0] = true;
                }
                catch (InterruptedException | ExecutionException | RejectedExecutionException | TimeoutException e) {
                    System.err.println("Failed to read memory at address " + address + ": " + e.getMessage());
                    success[0] = false;
                    return ret;
                }
            }
            return ret;
        }
        return ret;
    }

    @Override
    public int setMemory(String address, String value, int iByteCount) {
        int ret = -1;
        if (this.fSession != null && this.fCommandControl != null) {
            if (!this.fSession.isActive()) {
                return -1;
            }
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSession.getId());
            IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
            if (fGdb == null) {
                return -1;
            }
            BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)fGdb, this.getExecutor(), 2);
            CommandCache fCommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
            fCommandCache.setContextAvailable((IDMContext)fGdb.getContext(), true);
            CommandFactory factory = fGdb.getCommandFactory();
            int format = value.contains("x") ? 0 : 3;
            fCommandCache.execute(factory.createMIDataWriteMemory((IDMContext)fGdb.getContext(), 0L, address, format, iByteCount, value), new DataRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)new DataRequestMonitor(null, null)));
        }
        return ret;
    }
}

