/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.debug.dsf.DSFServicesLaunchSequence;
import com.gigadevice.debug.dsf.DebugServicesFactory;
import com.gigadevice.debug.dsf.GdbExtendedLaunch;
import com.gigadevice.debug.utils.GdbDebugUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.dsf.concurrent.Sequence;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.core.LaunchManager;

public class LaunchConfigurationDelegate
extends GdbLaunchDelegate {
    ILaunchConfiguration fConfig = null;
    public String flashAddressStr;

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        mode.equals("debug");
        GdbDebugUtil.terminateAllLaunches();
        super.launch(configuration, mode, launch, monitor);
        if (mode.equals("run")) {
            this.launchDebuggerDownload(configuration, launch, monitor);
        }
    }

    private void launchDebuggerDownload(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                IProject project = null;
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""));
                if (project != null) {
                    this.download(project, monitor);
                    ((LaunchManager)DebugPlugin.getDefault().getLaunchManager()).removeLaunch(launch);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void download(IProject project, IProgressMonitor monitor) {
        int beginIndex;
        long DownloadAddress = 0L;
        String LdFileName = AdapterUtils.getLdFileName((IProject)project);
        if (LdFileName.contains(File.separator) && (beginIndex = LdFileName.lastIndexOf(File.separator)) > 0) {
            LdFileName = LdFileName.substring(beginIndex + 1, LdFileName.length() - 1);
        }
        String projectPath = project.getLocation().toString();
        File file = new File(projectPath);
        List ldFileLstList = new ArrayList();
        if (!LdFileName.equals("")) {
            ldFileLstList = AdapterUtils.getLdFilePath((File)file, (String)LdFileName, ldFileLstList);
        }
        String flashAddress = null;
        if (!ldFileLstList.isEmpty()) {
            String ldFilePath = (String)ldFileLstList.get(0);
            System.out.println(ldFilePath);
            flashAddress = AdapterUtils.getFlashAddress((String)ldFilePath);
        }
        if (flashAddress != null && flashAddress.startsWith("0x")) {
            flashAddress = flashAddress.substring(2);
            DownloadAddress = Long.parseLong(flashAddress, 16);
        }
        if (DownloadAddress == 0L) {
            TargetAdapter.PrintToConsole((String)"Warning", (String)" Unable to get the download address, please use the Download function in the project menu.");
        } else {
            TargetAdapter.flashAddress = DownloadAddress;
            LaunchConfigurationDelegate.downloadBin(project, monitor);
        }
    }

    public static void downloadBin(IProject project, IProgressMonitor monitor) {
        TargetAdapter.downloadBin((IProject)project);
        monitor.done();
    }

    protected IDsfDebugServicesFactory newServiceFactory(ILaunchConfiguration config, String version) {
        this.fConfig = config;
        return new DebugServicesFactory(version, config);
    }

    protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        return new GdbExtendedLaunch(configuration, mode, locator);
    }

    protected Sequence getServicesSequence(DsfSession session, ILaunch launch, IProgressMonitor rm) {
        if (launch instanceof GdbLaunch) {
            return new DSFServicesLaunchSequence(session, (GdbLaunch)launch, rm);
        }
        return super.getServicesSequence(session, launch, rm);
    }
}

