/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.debug.utils.TreeRegister;
import com.gigadevice.debug.utils.TreeUnit;

public class TreeField
extends TreeUnit
implements Cloneable {
    private int bitOffset;
    private int bitWidth;
    private String access;

    public TreeField(String name, String description) {
        super(name, description);
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public void setBitOffset(int bitOffset) {
        this.bitOffset = bitOffset;
    }

    public int getBitWidth() {
        return this.bitWidth;
    }

    public void setBitWidth(int bitWidth) {
        this.bitWidth = bitWidth;
    }

    @Override
    public String getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(String access) {
        this.access = access;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TreeField o = null;
        o = (TreeField)super.clone();
        return o;
    }

    @Override
    public void setValue(long value) {
        long registerOldVal = ((TreeRegister)this.getParentUnit()).getValue();
        long registerVal = registerOldVal & (long)(~(~(-1 << this.bitOffset + this.bitWidth) & -1 << this.bitOffset)) | value;
        ((TreeRegister)this.getParentUnit()).setValue(registerVal);
    }

    @Override
    public long getValue() {
        long registerVal = ((TreeRegister)this.getParentUnit()).getValue();
        long validFormat = 0L;
        int i = 0;
        while (i < this.bitWidth) {
            validFormat |= (long)(1 << i);
            ++i;
        }
        this.value = (registerVal & validFormat << this.bitOffset) >> this.bitOffset;
        return this.value;
    }

    public long getValidFieldVal(long value) {
        long validFormat = 0L;
        int i = 0;
        while (i < this.bitWidth) {
            validFormat |= (long)(1 << i);
            ++i;
        }
        long validValue = value & validFormat << this.bitOffset;
        return validValue;
    }

    public String getFieldValueinHex(long value) {
        String tmp = Integer.toHexString((int)this.value);
        return "0x " + tmp.toUpperCase();
    }

    public String getFieldValueinBinary(long value) {
        String tmp = new String(this.parseHexStr2Byte(this.value));
        return "0b " + tmp.toUpperCase();
    }

    public String parseHexStr2Byte(long value) {
        String tmp = "";
        tmp = Integer.toBinaryString((int)value);
        String zeros = "";
        int j = 0;
        while (j < this.bitWidth - tmp.length()) {
            zeros = String.valueOf(zeros) + "0";
            ++j;
        }
        tmp = String.valueOf(zeros) + tmp;
        return tmp;
    }
}

