/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.debug.utils.TreeField;
import com.gigadevice.debug.utils.TreePeripheral;
import com.gigadevice.debug.utils.TreePeripheralGroup;
import com.gigadevice.debug.utils.TreeRegister;
import com.gigadevice.debug.utils.TreeUnit;
import java.io.File;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class SVDUtil {
    TreePeripheralGroup peripheralGroup;
    TreePeripheral peri = null;

    public TreePeripheralGroup getPeripheralsTree(String filePath) {
        Element rootElement = null;
        SAXReader reader = new SAXReader();
        File file = new File(filePath);
        Document document = null;
        try {
            document = reader.read(file);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document == null) {
            return null;
        }
        rootElement = document.getRootElement();
        this.peripheralGroup = new TreePeripheralGroup("", "");
        this.peripheralGroup = this.XMLParse(rootElement);
        return this.peripheralGroup;
    }

    public TreePeripheralGroup XMLParse(Element root) {
        Element perisEle = root.element("peripherals");
        Iterator periIt = perisEle.elementIterator();
        while (periIt.hasNext()) {
            Element periEle = (Element)periIt.next();
            this.peri = new TreePeripheral("", "");
            if (periEle.getName().equals("peripheral")) {
                TreeRegister register;
                Attribute derivedFrom = periEle.attribute("derivedFrom");
                String periParent = null;
                if (derivedFrom != null) {
                    periParent = derivedFrom.getStringValue();
                    TreeUnit[] perisList = this.peripheralGroup.getChildUnits();
                    int length = perisList.length;
                    int i = 0;
                    while (i < length) {
                        TreePeripheral periDerived = (TreePeripheral)perisList[i];
                        if (periDerived.getName().equals(periParent)) {
                            try {
                                this.peri = (TreePeripheral)periDerived.clone();
                                this.peri.setName(periEle.element("name").getStringValue());
                                this.peri.setBaseAddress(Long.parseLong(periEle.element("baseAddress").getStringValue().trim().substring(2), 16));
                                TreeUnit[] registerUnits = this.peri.getChildUnits();
                                this.peri.setChildUnits(null);
                                int j = 0;
                                while (j < registerUnits.length) {
                                    register = new TreeRegister("", "");
                                    register = (TreeRegister)((TreeRegister)registerUnits[j]).clone();
                                    register.setRegisterAddr(this.peri.getBaseAddress() + register.getAddressOffset());
                                    TreeUnit[] fieldUnits = register.getChildUnits();
                                    register.setChildUnits(null);
                                    int k = 0;
                                    while (k < fieldUnits.length) {
                                        TreeField field = new TreeField("", "");
                                        field = (TreeField)((TreeField)fieldUnits[k]).clone();
                                        register.addChild(field);
                                        ++k;
                                    }
                                    this.peri.addChild(register);
                                    ++j;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        ++i;
                    }
                } else {
                    Iterator propIt = periEle.elementIterator();
                    while (propIt.hasNext()) {
                        Element child = (Element)propIt.next();
                        String nodeName = child.getName();
                        if (nodeName.equals("name")) {
                            String name = child.getStringValue();
                            this.peri.setName(name);
                            continue;
                        }
                        if (nodeName.equals("description")) {
                            String description = child.getStringValue();
                            this.peri.setDescription(description);
                            continue;
                        }
                        if (nodeName.equals("groupName")) {
                            String groupName = child.getStringValue();
                            this.peri.setGroupName(groupName);
                            continue;
                        }
                        if (nodeName.equals("baseAddress")) {
                            long baseAddress = Long.parseLong(child.getStringValue().trim().substring(2), 16);
                            this.peri.setBaseAddress(baseAddress);
                            continue;
                        }
                        if (nodeName.equals("addressBlock") || !nodeName.equals("registers")) continue;
                        Iterator registerIt = child.elementIterator();
                        while (registerIt.hasNext()) {
                            Element registerEle = (Element)registerIt.next();
                            if (!registerEle.getName().equals("register")) continue;
                            Iterator registerPropIt = registerEle.elementIterator();
                            register = new TreeRegister("", "");
                            while (registerPropIt.hasNext()) {
                                Element registerObj = (Element)registerPropIt.next();
                                String registerNodeName = registerObj.getName();
                                if (registerNodeName.equals("name")) {
                                    String name = registerObj.getStringValue();
                                    register.setName(name);
                                    continue;
                                }
                                if (registerNodeName.equals("displayName")) continue;
                                if (registerNodeName.equals("description")) {
                                    String description = registerObj.getStringValue();
                                    register.setDescription(description);
                                    continue;
                                }
                                if (registerNodeName.equals("addressOffset")) {
                                    long addressOffset = Long.parseLong(registerObj.getStringValue().trim().substring(2), 16);
                                    register.setAddressOffset(addressOffset);
                                    register.setRegisterAddr(this.peri.getBaseAddress() + addressOffset);
                                    continue;
                                }
                                if (registerNodeName.equals("size")) {
                                    int size = Integer.parseInt(registerObj.getStringValue().trim().substring(2), 16);
                                    register.setSize(size);
                                    continue;
                                }
                                if (registerNodeName.equals("access")) {
                                    String access = registerObj.getStringValue();
                                    register.setAccess(access);
                                    continue;
                                }
                                if (registerNodeName.equals("resetValue")) {
                                    long resetValue = Long.parseLong(registerObj.getStringValue().trim().substring(2), 16);
                                    register.setResetValue(resetValue);
                                    continue;
                                }
                                if (!registerNodeName.equals("fields")) continue;
                                Iterator fieldIt = registerObj.elementIterator();
                                while (fieldIt.hasNext()) {
                                    Element fieldEle = (Element)fieldIt.next();
                                    if (!fieldEle.getName().equals("field")) continue;
                                    Iterator fieldPropIt = fieldEle.elementIterator();
                                    TreeField field = new TreeField("", "");
                                    while (fieldPropIt.hasNext()) {
                                        Element fieldObj = (Element)fieldPropIt.next();
                                        String fieldNodeName = fieldObj.getName();
                                        if (fieldNodeName.equals("name")) {
                                            String name = fieldObj.getStringValue();
                                            field.setName(name);
                                            continue;
                                        }
                                        if (fieldNodeName.equals("description")) {
                                            String description = fieldObj.getStringValue();
                                            field.setDescription(description);
                                            continue;
                                        }
                                        if (fieldNodeName.equals("bitOffset")) {
                                            int bitOffset = Integer.valueOf(fieldObj.getStringValue().trim());
                                            field.setBitOffset(bitOffset);
                                            continue;
                                        }
                                        if (!fieldNodeName.equals("bitWidth")) continue;
                                        int bitWidth = Integer.valueOf(fieldObj.getStringValue().trim());
                                        field.setBitWidth(bitWidth);
                                    }
                                    register.addChild(field);
                                }
                            }
                            this.peri.addChild(register);
                        }
                    }
                }
            }
            this.peripheralGroup.addChild(this.peri);
        }
        return this.peripheralGroup;
    }
}

