/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.utils;

import com.gigadevice.debug.utils.ToolUtil;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDataReadMemoryInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;

public class GdbDebugUtil {
    public static boolean fSuspended = true;
    public static boolean fGDBDebug = true;
    public static boolean isNonStop = true;
    public static String topView = "";
    public static IRunControl.IExecutionDMContext executionDMContext;
    public static final int THREAD_DISPOSED = 0;
    public static final int WAIT_UPDATE = 1;
    public static final int REALTIMER_UPDATE = 2;
    public static final int SINGLE_UPDATE = 3;

    public static Object getSession() {
        IAdaptable context = DebugUITools.getDebugContext();
        IAdaptable session = null;
        if (context != null) {
            if (context instanceof DsfSession) {
                session = context;
            }
            if (context instanceof IProcess) {
                context = ((IProcess)context).getLaunch();
            }
            if (context instanceof GdbLaunch) {
                session = ((GdbLaunch)context).getSession();
            } else if (context instanceof IDMVMContext) {
                IDMContext dmContext = ((IDMVMContext)context).getDMContext();
                if (dmContext == null) {
                    return null;
                }
                session = DsfSession.getSession((String)dmContext.getSessionId());
            }
        }
        if (session != null && GdbDebugUtil.isSessionTerminated(session)) {
            return null;
        }
        return session;
    }

    public static boolean isSessionTerminated(Object session) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int i = 0;
        while (i < launches.length) {
            if (launches[i] instanceof GdbLaunch && session == ((GdbLaunch)launches[i]).getSession()) {
                return launches[i].isTerminated();
            }
            ++i;
        }
        return true;
    }

    public static int setMemory(Object sessionObj, String address, String value, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        if (sessionObj == null) {
            return -1;
        }
        if (sessionObj instanceof DsfSession) {
            DsfSession session = (DsfSession)sessionObj;
            if (!session.isActive()) {
                return -1;
            }
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
            IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
            if (fGdb == null) {
                return -1;
            }
            BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)fGdb, GdbDebugUtil.getExecutor(), 2);
            CommandCache fCommandCache = new CommandCache((DsfSession)GdbDebugUtil.getSession(), (ICommandControl)bufferedCommandControl);
            fCommandCache.setContextAvailable((IDMContext)fGdb.getContext(), true);
            CommandFactory factory = fGdb.getCommandFactory();
            int format = value.contains("x") ? 0 : 3;
            fCommandCache.execute(factory.createMIDataWriteMemory((IDMContext)fGdb.getContext(), 0L, address, format, iByteCount, value), new DataRequestMonitor((Executor)GdbDebugUtil.getExecutor(), (RequestMonitor)new DataRequestMonitor(null, null)));
        }
        return 0;
    }

    public static DsfExecutor getExecutor() {
        return ((DsfSession)GdbDebugUtil.getSession()).getExecutor();
    }

    public static long getMemory(Object sessionObj, String address, int iByteCount, int maximumTimeToWait) throws TimeoutException {
        if (sessionObj == null) {
            return -1L;
        }
        if (sessionObj instanceof DsfSession) {
            DsfSession session = (DsfSession)sessionObj;
            if (!session.isActive()) {
                return -1L;
            }
            long ret = -1L;
            DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), session.getId());
            IRunControl rc = (IRunControl)tracker.getService(IRunControl.class);
            IAdaptable context = DebugUITools.getDebugContext();
            if (rc != null && rc instanceof IRunControl && rc.isSuspended((IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)context).getDMContext(), IRunControl.IExecutionDMContext.class))) {
                fSuspended = true;
            } else {
                fSuspended = false;
                if (!isNonStop) {
                    return -19088744L;
                }
            }
            IGDBControl fGdb = (IGDBControl)tracker.getService(IGDBControl.class);
            if (fGdb == null) {
                return -1L;
            }
            DsfExecutor executor = session.getExecutor();
            if (executor != null) {
                final IMICommandControl fCommandControl = (IMICommandControl)tracker.getService(IMICommandControl.class);
                CommandFactory comFac = fCommandControl.getCommandFactory();
                final ICommand commandVarUpdate = comFac.createMIDataReadMemory((IDMContext)fGdb.getContext(), 0L, address, 0, 1, 1, iByteCount, null);
                Query<MIDataReadMemoryInfo> query = new Query<MIDataReadMemoryInfo>(){

                    protected void execute(DataRequestMonitor<MIDataReadMemoryInfo> drm) {
                        fCommandControl.queueCommand(commandVarUpdate, drm);
                    }
                };
                ret = 0L;
                executor.execute((Runnable)query);
                try {
                    Object obj = query.get(2000L, TimeUnit.MILLISECONDS);
                    MIDataReadMemoryInfo updateInfo = (MIDataReadMemoryInfo)obj;
                    MemoryByte[] bytes = updateInfo.getMIMemoryBlock();
                    byte[] arraybytes = new byte[bytes.length];
                    int i = 0;
                    while (i < bytes.length) {
                        arraybytes[i] = bytes[bytes.length - 1 - i].getValue();
                        ++i;
                    }
                    BigInteger big = new BigInteger(1, arraybytes);
                    big = ToolUtil.toUnsigned(big);
                    System.out.println("register value " + big.toString(16) + System.getProperty("line.separator"));
                    ret = new Long(big.toString());
                }
                catch (InterruptedException | ExecutionException | RejectedExecutionException | TimeoutException exception) {
                    return 0L;
                }
            }
            return ret;
        }
        return 0L;
    }

    public static void terminateAllLaunches() {
        ILaunch[] launches;
        ILaunch[] iLaunchArray = launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            try {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }
}

