/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.debug.Activator;
import com.gigadevice.debug.utils.DebugUtil;
import com.gigadevice.utils.ProjectUtils;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SVDTab
extends AbstractLaunchConfigurationTab {
    private Button fBrowse;
    private Text fSVDPath;

    protected SVDTab() {
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        comp.setLayout((Layout)layout);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        Group group = new Group(comp, 0);
        GridLayout layout1 = new GridLayout();
        group.setLayout((Layout)layout1);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setText("SVD Path");
        Composite comp2 = new Composite((Composite)group, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        layout2.marginHeight = 0;
        comp2.setLayout((Layout)layout2);
        GridData gd2 = new GridData(768);
        comp2.setLayoutData((Object)gd2);
        Label label = new Label(comp2, 0);
        label.setText("SVD Path:");
        Composite local = new Composite(comp2, 0);
        GridLayout layout22 = new GridLayout();
        layout22.numColumns = 3;
        layout22.marginHeight = 0;
        layout22.marginWidth = 0;
        local.setLayout((Layout)layout22);
        GridData gd3 = new GridData(768);
        gd3.horizontalSpan = ((GridLayout)comp2.getLayout()).numColumns - 1;
        local.setLayoutData((Object)gd3);
        this.fSVDPath = new Text(local, 2052);
        gd3 = new GridData(768);
        this.fSVDPath.setLayoutData((Object)gd3);
        this.fBrowse = new Button(local, 0);
        this.fBrowse.setText("Browse");
        this.fSVDPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SVDTab.this.scheduleUpdateJob();
            }
        });
        this.fBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVDTab.this.browseButtonSelected("Select SVD File Path", SVDTab.this.fSVDPath);
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        FileDialog dialog = new FileDialog(this.getShell(), 0);
        dialog.setText(title);
        String str = text.getText().trim();
        int lastSeparatorIndex = str.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
        }
        if ((str = dialog.open()) != null) {
            text.setText(str);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String latestSVDFilePath;
        if (DebugUtil.getCurProject(configuration) == null) {
            return;
        }
        String str = "";
        try {
            str = configuration.getAttribute("com.gigadevice.debug.launch.svdpath", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!ProjectUtils.isExistingFilePath((String)str) && !str.equals(latestSVDFilePath = DebugUtil.getSVDFilePath(configuration))) {
            str = latestSVDFilePath;
            ((ILaunchConfigurationWorkingCopy)configuration).setAttribute("com.gigadevice.debug.launch.svdpath", latestSVDFilePath);
        }
        this.fSVDPath.setText(str);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (DebugUtil.getCurProject((ILaunchConfiguration)configuration) == null) {
            return;
        }
        Activator.getInstance().getPreferenceStore().setDefault("com.gigadevice.debug.launch.svdpath", this.fSVDPath.getText().trim());
        configuration.setAttribute("com.gigadevice.debug.launch.svdpath", this.fSVDPath.getText().trim());
    }

    public String getName() {
        return " SVD ";
    }
}

