/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.debug.Activator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class RTTConsoleView
extends ViewPart {
    private StyledText console;
    private Font consoleFont;
    private Color backgroundColor;
    private Color textColor;
    private AtomicBoolean isRTTActive = new AtomicBoolean(false);
    private Thread rttReaderThread;
    private volatile boolean shouldStop = false;
    private Process jlinkProcess = null;
    private DsfSession.SessionStartedListener sessionStartedListener;
    private DsfSession.SessionEndedListener sessionEndedListener;
    private static final int MAX_LINES = 10000;
    private static final String RTT_CONSOLE_NAME = "RTT Console";
    private static String JLINKRTT_PATH = "";

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.console = new StyledText(parent, 778);
        this.setupConsoleAppearance();
        this.initializeDebugSessionListeners();
        this.appendToConsole("RTT Console initialized. Waiting for debug session...\n");
        this.createActions();
    }

    private void setupConsoleAppearance() {
        Display display = Display.getCurrent();
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((String)"Consolas", (int)9, (int)0);
        if (fontDescriptor == null) {
            fontDescriptor = FontDescriptor.createFrom((String)"Courier New", (int)9, (int)0);
        }
        this.consoleFont = fontDescriptor.createFont((Device)display);
        this.console.setFont(this.consoleFont);
        this.backgroundColor = display.getSystemColor(2);
        this.textColor = display.getSystemColor(5);
        this.console.setBackground(this.backgroundColor);
        this.console.setForeground(this.textColor);
        this.console.setMargins(5, 5, 5, 5);
    }

    private void initializeDebugSessionListeners() {
        this.sessionStartedListener = new DsfSession.SessionStartedListener(){

            public void sessionStarted(DsfSession session) {
                Display.getDefault().asyncExec(() -> {
                    RTTConsoleView.this.console.setText("");
                    RTTConsoleView.this.appendToConsole("=== Debug session started: " + session.getId() + " ===\n");
                    RTTConsoleView.this.appendToConsole("RTT Console ready. Click 'Start RTT' to start RTT monitoring.\n");
                });
            }
        };
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this.sessionStartedListener);
        this.sessionEndedListener = new DsfSession.SessionEndedListener(){

            public void sessionEnded(DsfSession session) {
                Display.getDefault().asyncExec(() -> {
                    RTTConsoleView.this.appendToConsole("=== Debug session ended ===\n");
                    if (RTTConsoleView.this.isRTTActive.get()) {
                        RTTConsoleView.this.stopRTT();
                        RTTConsoleView.this.appendToConsole("RTT monitoring stopped automatically.\n");
                    }
                });
            }
        };
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this.sessionEndedListener);
    }

    private synchronized void startRTT() {
        if (this.isRTTActive.get()) {
            return;
        }
        String currentText = this.console.getText();
        String[] lines = currentText.split("\n");
        StringBuilder sessionInfo = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("Debug session started") || line.contains("RTT Console ready") || line.contains("===")) {
                sessionInfo.append(line).append("\n");
            }
            ++n2;
        }
        this.console.setText(sessionInfo.toString());
        this.appendToConsole("Starting RTT monitoring...\n");
        this.isRTTActive.set(true);
        this.shouldStop = false;
        this.rttReaderThread = new Thread(this::rttReaderLoop, "RTT-Reader-Thread");
        this.rttReaderThread.setDaemon(true);
        this.rttReaderThread.start();
        this.appendToConsole("RTT monitoring started successfully.\n");
    }

    private synchronized void stopRTT() {
        if (!this.isRTTActive.get()) {
            return;
        }
        this.appendToConsole("Stopping RTT monitoring...\n");
        this.shouldStop = true;
        this.isRTTActive.set(false);
        this.terminateJLinkProcess();
        if (this.rttReaderThread != null) {
            try {
                this.rttReaderThread.interrupt();
                this.rttReaderThread.join(2000L);
            }
            catch (InterruptedException interruptedException) {}
            this.rttReaderThread = null;
        }
        this.appendToConsole("RTT monitoring stopped.\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void rttReaderLoop() {
        reader = null;
        try {
            RTTConsoleView.JLINKRTT_PATH = AdapterUtils.getJLinkRTTExePath();
            path = Paths.get(RTTConsoleView.JLINKRTT_PATH, new String[0]);
            if (Files.exists(path, new LinkOption[0])) ** GOTO lbl-1000
            Display.getDefault().asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(java.nio.file.Path ), ()V)((RTTConsoleView)this, (Path)path));
            if (reader == null) ** GOTO lbl36
            ** GOTO lbl32
        }
        catch (IOException e) {
            Activator.log((IStatus)new Status(4, "com.gigadevice.debug", "Failed to start JLinkRTTClient: " + e.getMessage(), (Throwable)e));
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException v0) {}
            }
            this.terminateJLinkProcess();
            return;
        }
        catch (Exception e) {
            block31: {
                try {
                    Activator.log((IStatus)new Status(4, "com.gigadevice.debug", "Unexpected error in RTT reader loop: " + e.getMessage(), (Throwable)e));
                    if (reader != null) {
                    }
                    break block31;
                }
                catch (Throwable var7_9) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException v1) {}
                    }
                    this.terminateJLinkProcess();
                    throw var7_9;
                }
lbl32:
                // 1 sources

                try {
                    reader.close();
                }
                catch (IOException v2) {}
lbl36:
                // 3 sources

                this.terminateJLinkProcess();
                return;
lbl-1000:
                // 1 sources

                {
                    processBuilder = new ProcessBuilder(new String[]{RTTConsoleView.JLINKRTT_PATH});
                    var4_6 = this;
                    synchronized (var4_6) {
                        this.jlinkProcess = processBuilder.start();
                    }
                    Display.getDefault().asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$2(), ()V)((RTTConsoleView)this));
                    reader = new BufferedReader(new InputStreamReader(this.jlinkProcess.getInputStream()));
                    block23: while (true) {
                        if (this.jlinkProcess.isAlive() && !this.shouldStop && !Thread.currentThread().isInterrupted()) ** GOTO lbl-1000
                        if (this.jlinkProcess != null && !this.jlinkProcess.isAlive()) {
                            ** try [egrp 6[TRYBLOCK] [5 : 310->321)] { 
lbl52:
                            // 1 sources

                            break;
                        }
lbl-1000:
                        // 1 sources

                        {
                            while (true) {
                                if (!reader.ready() || (line = reader.readLine()) == null) {
                                    Thread.sleep(1000L);
                                    continue block23;
                                }
                                rttData = line;
                                if (rttData.contains("RTT Client:") || (filtered = rttData.replaceAll("[^\\p{Print}\\p{Space}]", "")) == null || filtered.isEmpty()) continue;
                                Display.getDefault().asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$3(java.lang.String ), ()V)((RTTConsoleView)this, (String)filtered));
                            }
                        }
                        break;
                    }
                    {
                        this.jlinkProcess.exitValue();
                    }
lbl65:
                    // 1 sources

                    catch (IllegalThreadStateException v4) {}
                }
                try {
                    reader.close();
                }
                catch (IOException v5) {}
            }
            this.terminateJLinkProcess();
            return;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException v6) {}
        }
        this.terminateJLinkProcess();
    }

    private void appendToConsole(String text) {
        if (this.console == null || this.console.isDisposed()) {
            return;
        }
        String currentText = this.console.getText();
        String[] lines = currentText.split("\n");
        if (lines.length > 10000) {
            int linesToRemove = lines.length - 10000 + 100;
            StringBuilder newText = new StringBuilder();
            int i = linesToRemove;
            while (i < lines.length) {
                newText.append(lines[i]).append("\n");
                ++i;
            }
            this.console.setText(newText.toString());
        }
        this.console.append(text);
        this.console.setTopIndex(this.console.getLineCount() - 1);
    }

    public void clearConsole() {
        if (this.console != null && !this.console.isDisposed()) {
            Display.getDefault().asyncExec(() -> {
                this.console.setText("");
                this.appendToConsole("RTT Console cleared.\n");
            });
        }
    }

    public void setFocus() {
        if (this.console != null && !this.console.isDisposed()) {
            this.console.setFocus();
        }
    }

    public void dispose() {
        this.stopRTT();
        if (this.consoleFont != null) {
            this.consoleFont.dispose();
        }
        if (this.sessionStartedListener != null) {
            DsfSession.removeSessionStartedListener((DsfSession.SessionStartedListener)this.sessionStartedListener);
        }
        if (this.sessionEndedListener != null) {
            DsfSession.removeSessionEndedListener((DsfSession.SessionEndedListener)this.sessionEndedListener);
        }
        super.dispose();
    }

    public boolean isRTTConnected() {
        return this.isRTTActive.get();
    }

    public void reconnectRTT() {
        Display.getDefault().asyncExec(() -> {
            if (this.isRTTActive.get()) {
                this.appendToConsole("Manual RTT reconnection requested...\n");
                this.stopRTT();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.startRTT();
        });
    }

    public void startRTTManually() {
        Display.getDefault().asyncExec(() -> {
            if (!this.isRTTActive.get()) {
                this.appendToConsole("Manual RTT start requested...\n");
                this.startRTT();
            } else {
                this.appendToConsole("RTT monitoring is already running\n");
            }
        });
    }

    public void stopRTTManually() {
        Display.getDefault().asyncExec(() -> {
            if (this.isRTTActive.get()) {
                this.appendToConsole("Manual RTT stop requested...\n");
                this.stopRTT();
            } else {
                this.appendToConsole("RTT monitoring is not running\n");
            }
        });
    }

    public void outputText(String text) {
        if (text != null) {
            Display.getDefault().asyncExec(() -> this.appendToConsole(text));
        }
    }

    public boolean isRTTRunning() {
        return this.isRTTActive.get();
    }

    public boolean shouldStopRTTThread() {
        return this.shouldStop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateJLinkProcess() {
        RTTConsoleView rTTConsoleView = this;
        synchronized (rTTConsoleView) {
            block15: {
                if (this.jlinkProcess != null && this.jlinkProcess.isAlive()) {
                    this.appendToConsole("Terminating JLinkRTTClient process...\n");
                    try {
                        this.jlinkProcess.destroy();
                        if (!this.jlinkProcess.waitFor(3L, TimeUnit.SECONDS)) {
                            this.appendToConsole("Force terminating JLinkRTTClient process...\n");
                            this.jlinkProcess.destroyForcibly();
                            if (!this.jlinkProcess.waitFor(2L, TimeUnit.SECONDS)) {
                                this.appendToConsole("Warning: JLinkRTTClient process may not have terminated completely\n");
                            } else {
                                this.appendToConsole("JLinkRTTClient process forcibly terminated\n");
                            }
                        } else {
                            this.appendToConsole("JLinkRTTClient process terminated gracefully\n");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        this.appendToConsole("Termination interrupted, force killing JLinkRTTClient process...\n");
                        this.jlinkProcess.destroyForcibly();
                        Thread.currentThread().interrupt();
                        this.jlinkProcess = null;
                        break block15;
                    }
                    catch (Exception e) {
                        try {
                            this.appendToConsole("Error terminating JLinkRTTClient process: " + e.getMessage() + "\n");
                            Activator.log((IStatus)new Status(4, "com.gigadevice.debug", "Error terminating JLinkRTTClient process: " + e.getMessage(), (Throwable)e));
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.jlinkProcess = null;
                        }
                    }
                    this.jlinkProcess = null;
                }
            }
        }
    }

    private void createActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        Action startAction = new Action("Start RTT"){

            public void run() {
                RTTConsoleView.this.startRTTManually();
            }
        };
        startAction.setToolTipText("Start RTT Monitoring");
        startAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/elcl16/start.png"));
        Action stopAction = new Action("Stop RTT"){

            public void run() {
                RTTConsoleView.this.stopRTTManually();
            }
        };
        stopAction.setToolTipText("Stop RTT Monitoring");
        stopAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/elcl16/stop.png"));
        Action clearAction = new Action("Clear"){

            public void run() {
                RTTConsoleView.this.clearConsole();
            }
        };
        clearAction.setToolTipText("Clear RTT Console");
        clearAction.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/elcl16/clear.png"));
        toolBarManager.add((IAction)startAction);
        toolBarManager.add((IAction)stopAction);
        toolBarManager.add((IAction)clearAction);
        menuManager.add((IAction)startAction);
        menuManager.add((IAction)stopAction);
        menuManager.add((IAction)clearAction);
    }

    private /* synthetic */ void lambda$1(Path path) {
        this.appendToConsole("JLinkRTTClient not found: " + path + "\n");
    }

    private /* synthetic */ void lambda$2() {
        this.appendToConsole("JLinkRTTClient started successfully\n");
    }

    private /* synthetic */ void lambda$3(String string) {
        this.appendToConsole(String.valueOf(string) + System.lineSeparator());
    }
}

