/*
 * Decompiled with CFR 0.152.
 */
package com.gigadevice.debug.ui;

import com.gigadevice.adapter.AdapterUtils;
import com.gigadevice.adapter.TargetAdapter;
import com.gigadevice.utils.preferences.EclipsePreferences;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.internal.Workbench;

public class DownloadAction
extends Action {
    public String flashAddressStr = "";
    private EclipsePreferences projPreferences;

    public void run() {
        final IProject project = DownloadAction.getCurrentProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)"Please select your target project.");
            return;
        }
        long DownloadAddress = 0L;
        String LdFileName = AdapterUtils.getLdFileName((IProject)project);
        LdFileName = LdFileName.replace("\\", "/");
        int beginIndex = 0;
        beginIndex = LdFileName.lastIndexOf("/");
        if (beginIndex > 0) {
            LdFileName = LdFileName.endsWith("}\"") ? LdFileName.substring(beginIndex + 1, LdFileName.length() - 2) : LdFileName.substring(beginIndex + 1, LdFileName.length() - 1);
        }
        String projectPath = project.getLocation().toString();
        File file = new File(projectPath);
        List ldFileLstList = new ArrayList();
        if (LdFileName.equals("")) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning ", (String)"Failed to obtain the link script file,please config project properties first.");
            return;
        }
        ldFileLstList = AdapterUtils.getLdFilePath((File)file, (String)LdFileName, ldFileLstList);
        String flashAddress = null;
        if (!ldFileLstList.isEmpty()) {
            String ldFilePath = (String)ldFileLstList.get(0);
            flashAddress = AdapterUtils.getFlashAddress((String)ldFilePath);
        }
        if (flashAddress != null && flashAddress.startsWith("0x")) {
            try {
                flashAddress = flashAddress.substring(2);
                DownloadAddress = Long.parseLong(flashAddress, 16);
            }
            catch (Exception exception) {
                DownloadAddress = 0L;
            }
        }
        if (DownloadAddress == 0L) {
            final Shell shell = new Shell(65600);
            shell.setText("Message");
            shell.setBounds(300, 200, 500, 150);
            shell.setFocus();
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            shell.setLayout((Layout)layout);
            GridData layoutData = new GridData(768);
            shell.setLayoutData((Object)layoutData);
            Label label = new Label((Composite)shell, 4);
            label.setText("Flash download address get failed , please input flash download address. \nThe prefix must be \"0x\".");
            label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            final Text flashAddressText = new Text((Composite)shell, 2052);
            layoutData = new GridData(4, 0x1000000, true, false, 2, 1);
            flashAddressText.setLayoutData((Object)layoutData);
            this.projPreferences = new EclipsePreferences("com.gigadevice.utils");
            String InputFlashDownloadAddress = this.projPreferences.getInputFlashDownloadAddress(project);
            if (InputFlashDownloadAddress != "") {
                flashAddressText.setText(InputFlashDownloadAddress);
            }
            Button buttonOK = new Button((Composite)shell, 0);
            buttonOK.setText("OK");
            layoutData = new GridData(131072, 0x1000000, true, false, 1, 1);
            layoutData.widthHint = 60;
            buttonOK.setLayoutData((Object)layoutData);
            Button buttonCancel = new Button((Composite)shell, 0);
            buttonCancel.setText("Cancel");
            layoutData = new GridData(131072, 0x1000000, false, false, 1, 1);
            layoutData.widthHint = 60;
            buttonCancel.setLayoutData((Object)layoutData);
            buttonOK.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    DownloadAction.this.flashAddressStr = flashAddressText.getText().toUpperCase();
                    if (DownloadAction.this.flashAddressStr.equals("") || !DownloadAction.this.flashAddressStr.startsWith("0X")) {
                        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"The entered Flash download address is invalid, please re-enter.");
                    } else {
                        DownloadAction.this.projPreferences.putInputFlashDownloadAddress(DownloadAction.this.flashAddressStr, project);
                        DownloadAction.this.projPreferences.flush(project);
                        long flashAddressLong = 0L;
                        try {
                            DownloadAction.this.flashAddressStr = DownloadAction.this.flashAddressStr.substring(2);
                            flashAddressLong = Long.parseLong(DownloadAction.this.flashAddressStr, 16);
                        }
                        catch (Exception exception) {
                            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Warning", (String)"The entered Flash download address is invalid, please re-enter.");
                            return;
                        }
                        shell.close();
                        TargetAdapter.flashAddress = flashAddressLong;
                        DownloadAction.downloadBin(project);
                    }
                }
            });
            buttonCancel.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    shell.close();
                }
            });
            shell.open();
        } else {
            TargetAdapter.flashAddress = DownloadAddress;
            DownloadAction.downloadBin(project);
        }
    }

    public static void downloadBin(final IProject project) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("downloading...", -1);
                TargetAdapter.downloadBin((IProject)project);
                monitor.done();
            }
        };
        Shell shell = Display.getCurrent().getActiveShell();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static IProject getCurrentProject() {
        ISelectionService selectionService = Workbench.getInstance().getActiveWorkbenchWindow().getSelectionService();
        ISelection selection = selectionService.getSelection();
        IProject project = null;
        Object element = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IResource) {
            project = ((IResource)element).getProject();
        }
        return project;
    }
}

